/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.appengine.api.memcache.ErrorHandler;
import com.google.appengine.api.memcache.ErrorHandlers;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.SessionData;
import com.google.apphosting.runtime.SessionManagerUtil;
import com.google.apphosting.runtime.SessionStore;
import java.util.logging.Level;

public class MemcacheSessionStore
implements SessionStore {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/apphosting/runtime/MemcacheSessionStore");
    private final MemcacheService memcache = MemcacheServiceFactory.getMemcacheService((String)"");

    public MemcacheSessionStore() {
        this.memcache.setErrorHandler((ErrorHandler)ErrorHandlers.getConsistentLogAndContinue((Level)Level.INFO));
    }

    @Override
    public SessionData getSession(String key) {
        byte[] sessionBytes = (byte[])this.memcache.get((Object)key);
        if (sessionBytes != null) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFinest()).withInjectedLogSite("com/google/apphosting/runtime/MemcacheSessionStore", "getSession", 35, "MemcacheSessionStore.java")).log("Loaded session %s from memcache.", key);
            return (SessionData)SessionManagerUtil.deserialize(sessionBytes);
        }
        return null;
    }

    @Override
    public void saveSession(String key, SessionData data) throws SessionStore.Retryable {
        try {
            this.memcache.put((Object)key, (Object)SessionManagerUtil.serialize(data));
        }
        catch (ApiProxy.ApiDeadlineExceededException e) {
            throw new SessionStore.Retryable((RuntimeException)((Object)e));
        }
    }

    @Override
    public void deleteSession(String key) {
        this.memcache.delete((Object)key);
    }
}

