/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.labs.datastore.overlay.QueryResultBatchIterator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class LazyList
extends AbstractList<Entity>
implements QueryResultList<Entity> {
    private final transient QueryResultBatchIterator<Entity> resultIterator;
    final List<Entity> results = new ArrayList<Entity>();
    private boolean endOfData = false;
    private boolean cleared = false;
    private Cursor cursor = null;

    LazyList(QueryResultBatchIterator<Entity> resultIterator) {
        this.resultIterator = resultIterator;
    }

    private void resolveAllData() {
        this.resolveToIndex(-1, true);
    }

    private void resolveToIndex(int index) {
        this.resolveToIndex(index, false);
    }

    private void resolveToIndex(int index, boolean fetchAll) {
        if (this.cleared) {
            return;
        }
        this.forceResolveToIndex(index, fetchAll);
    }

    private void forceResolveToIndex(int index, boolean fetchAll) {
        if (this.endOfData) {
            return;
        }
        if (fetchAll || this.results.size() <= index) {
            int numToFetch = fetchAll ? Integer.MAX_VALUE : index - this.results.size() + 1;
            List<Entity> nextBatch = this.resultIterator.nextList(numToFetch);
            this.results.addAll(nextBatch);
            if (nextBatch.size() < numToFetch) {
                this.endOfData = true;
            }
        }
    }

    @Override
    public Entity get(int i) {
        this.resolveToIndex(i);
        return this.results.get(i);
    }

    @Override
    public int size() {
        this.resolveAllData();
        return this.results.size();
    }

    @Override
    public Entity set(int i, Entity entity) {
        this.resolveToIndex(i);
        return this.results.set(i, entity);
    }

    @Override
    public void add(int i, Entity entity) {
        this.resolveToIndex(i);
        this.results.add(i, entity);
    }

    @Override
    public Entity remove(int i) {
        this.resolveToIndex(i);
        return this.results.remove(i);
    }

    @Override
    public Iterator<Entity> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Entity> listIterator() {
        return new ListIterator<Entity>(){
            int currentIndex = 0;
            int indexOfLastElementReturned = -1;
            boolean elementReturned = false;
            boolean addOrRemoveCalledSinceElementReturned = false;

            @Override
            public boolean hasNext() {
                LazyList.this.resolveToIndex(this.currentIndex);
                return this.currentIndex < LazyList.this.results.size();
            }

            @Override
            public Entity next() {
                if (this.hasNext()) {
                    this.elementReturned = true;
                    this.addOrRemoveCalledSinceElementReturned = false;
                    this.indexOfLastElementReturned = this.currentIndex++;
                    return LazyList.this.results.get(this.indexOfLastElementReturned);
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.currentIndex > 0;
            }

            @Override
            public Entity previous() {
                if (this.hasPrevious()) {
                    this.elementReturned = true;
                    this.addOrRemoveCalledSinceElementReturned = false;
                    this.indexOfLastElementReturned = --this.currentIndex;
                    return LazyList.this.results.get(this.indexOfLastElementReturned);
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.currentIndex;
            }

            @Override
            public int previousIndex() {
                return this.currentIndex - 1;
            }

            @Override
            public void remove() {
                if (!this.elementReturned || this.addOrRemoveCalledSinceElementReturned) {
                    throw new IllegalStateException();
                }
                this.addOrRemoveCalledSinceElementReturned = true;
                if (this.indexOfLastElementReturned < this.currentIndex) {
                    --this.currentIndex;
                }
                LazyList.this.remove(this.indexOfLastElementReturned);
            }

            @Override
            public void set(Entity entity) {
                if (!this.elementReturned || this.addOrRemoveCalledSinceElementReturned) {
                    throw new IllegalStateException();
                }
                LazyList.this.set(this.indexOfLastElementReturned, entity);
            }

            @Override
            public void add(Entity entity) {
                this.addOrRemoveCalledSinceElementReturned = true;
                LazyList.this.add(this.currentIndex++, entity);
            }
        };
    }

    @Override
    public ListIterator<Entity> listIterator(int index) {
        return super.listIterator(index);
    }

    @Override
    public boolean isEmpty() {
        this.resolveToIndex(0);
        return this.results.isEmpty();
    }

    @Override
    public List<Entity> subList(int from, int to) {
        this.resolveToIndex(to - 1);
        return this.results.subList(from, to);
    }

    @Override
    public void clear() {
        this.results.clear();
        this.cleared = true;
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        for (Entity e : this) {
            if (o == null ? e == null : o.equals(e)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public List<Index> getIndexList() {
        List indexList = null;
        if (this.resultIterator != null) {
            indexList = this.resultIterator.getIndexList();
        }
        return indexList;
    }

    public Cursor getCursor() {
        if (this.cursor == null && this.resultIterator != null) {
            this.forceResolveToIndex(-1, true);
            this.cursor = this.resultIterator.getCursor();
        }
        return this.cursor;
    }
}

