/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.config.AppYaml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;

public class AppEngineUtil {
    private static final String APPENGINE_WEB_XML_PATH = "WEB-INF/appengine-web.xml";
    private static final String APP_YAML_PATH = "WEB-INF/app.yaml";

    public static String getApplicationId(String appDir) {
        return AppEngineUtil.getAppProperty(appDir, new AppPropertyReader(){

            @Override
            public String readYaml(AppYaml yaml) {
                return yaml.getApplication();
            }

            @Override
            public String readXml(AppEngineWebXml xml) {
                return xml.getAppId();
            }
        });
    }

    public static String getApplicationVersion(String appDir) {
        return AppEngineUtil.getAppProperty(appDir, new AppPropertyReader(){

            @Override
            public String readYaml(AppYaml yaml) {
                return yaml.getVersion();
            }

            @Override
            public String readXml(AppEngineWebXml xml) {
                return xml.getMajorVersionId();
            }
        });
    }

    private static String getAppProperty(String appDir, AppPropertyReader reader) {
        File appYamlFile = new File(new File(appDir), APP_YAML_PATH);
        try {
            return AppYaml.parse((Reader)new FileReader(appYamlFile)).getApplication();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return reader.readXml(new AppEngineWebXmlReader(appDir, APPENGINE_WEB_XML_PATH).readAppEngineWebXml());
        }
    }

    private static interface AppPropertyReader {
        public String readYaml(AppYaml var1);

        public String readXml(AppEngineWebXml var1);
    }
}

