/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools.devserver;

import com.google.api.server.spi.tools.devserver.ApiConfig;
import com.google.api.server.spi.tools.devserver.DevApiUtil;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RpcMethodDispatcher {
    private final Map<String, ApiConfig.Method> rpcMethods = new HashMap<String, ApiConfig.Method>();

    public RpcMethodDispatcher(List<ApiConfig> apiConfigs) {
        for (ApiConfig apiConfig : apiConfigs) {
            for (Map.Entry<String, ApiConfig.Method> methodEntry : apiConfig.methods.entrySet()) {
                ApiConfig.Method method = methodEntry.getValue();
                method.api = apiConfig;
                String key = DevApiUtil.getMethodKey(methodEntry.getKey(), apiConfig.name, apiConfig.version);
                this.rpcMethods.put(key, method);
            }
        }
    }

    public ApiConfig.Method dispatch(ObjectNode root) {
        String rpcMethodName = root.path("method").asText();
        String apiName = RpcMethodDispatcher.getApiNameFromMethodName(rpcMethodName);
        if (apiName == null || apiName.trim().isEmpty()) {
            return null;
        }
        String apiVersion = root.path("apiVersion").asText();
        return this.rpcMethods.get(DevApiUtil.getMethodKey(rpcMethodName, apiName, apiVersion));
    }

    private static String getApiNameFromMethodName(String methodName) {
        if (methodName == null) {
            return null;
        }
        int firstDot = methodName.indexOf(".");
        if (firstDot < 0) {
            return null;
        }
        return methodName.substring(0, firstDot);
    }
}

