/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue;

import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.taskqueue.InternalFailureException;
import com.google.appengine.api.taskqueue.InvalidQueueModeException;
import com.google.appengine.api.taskqueue.QueueConstants;
import com.google.appengine.api.taskqueue.QueueFailureException;
import com.google.appengine.api.taskqueue.TaskAlreadyExistsException;
import com.google.appengine.api.taskqueue.TaskNotFoundException;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.TransactionalTaskException;
import com.google.appengine.api.taskqueue.TransientFailureException;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class QueueApiHelper {
    static final String PACKAGE = "taskqueue";

    QueueApiHelper() {
    }

    <T extends ProtocolMessage<T>, V extends ProtocolMessage<V>> void makeSyncCall(String method, ProtocolMessage<T> request, ProtocolMessage<V> response) {
        try {
            boolean parsed;
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, method, request.toByteArray());
            if (!(responseBytes == null || (parsed = response.mergeFrom(responseBytes)) && response.isInitialized())) {
                throw new IllegalArgumentException("Could not parse response");
            }
        }
        catch (ApiProxy.ApplicationException exception) {
            throw QueueApiHelper.translateError(exception);
        }
    }

    <T extends ProtocolMessage<T>> Future<T> makeAsyncCall(String method, ProtocolMessage<?> request, final T responseProto, ApiProxy.ApiConfig apiConfig) {
        Future<byte[]> response = ApiProxy.makeAsyncCall(PACKAGE, method, request.toByteArray(), apiConfig);
        return new FutureWrapper<byte[], T>(this, response){

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof ApiProxy.ApplicationException) {
                    return QueueApiHelper.translateError((ApiProxy.ApplicationException)cause);
                }
                return cause;
            }

            @Override
            protected T wrap(byte[] responseBytes) {
                boolean parsed;
                if (!(responseBytes == null || (parsed = responseProto.parseFrom(responseBytes)) && responseProto.isInitialized())) {
                    throw new IllegalArgumentException("Could not parse response");
                }
                return responseProto;
            }
        };
    }

    static <T> T getInternal(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiProxy.ApplicationException(TaskQueuePb.TaskQueueServiceError.ErrorCode.TRANSIENT_ERROR.getValue(), "Interrupted while waiting for RPC response.");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    static RuntimeException translateError(int error, String detail) {
        TaskQueuePb.TaskQueueServiceError.ErrorCode errorCode = TaskQueuePb.TaskQueueServiceError.ErrorCode.valueOf(error);
        int datastoreErrorCode = TaskQueuePb.TaskQueueServiceError.ErrorCode.DATASTORE_ERROR.getValue();
        if (error >= datastoreErrorCode) {
            ApiProxy.ApplicationException datastoreApplicationException = new ApiProxy.ApplicationException(error - datastoreErrorCode, detail);
            TransactionalTaskException taskqueueException = new TransactionalTaskException();
            taskqueueException.initCause(DatastoreApiHelper.translateError(datastoreApplicationException));
            return taskqueueException;
        }
        switch (errorCode) {
            case UNKNOWN_QUEUE: {
                String string = String.valueOf(detail);
                return new IllegalStateException(string.length() != 0 ? "The specified queue is unknown : ".concat(string) : new String("The specified queue is unknown : "));
            }
            case TRANSIENT_ERROR: {
                return new TransientFailureException(detail);
            }
            case INTERNAL_ERROR: {
                return new InternalFailureException(detail);
            }
            case TASK_TOO_LARGE: {
                String string = String.valueOf(detail);
                return new IllegalArgumentException(string.length() != 0 ? "Task size is too large : ".concat(string) : new String("Task size is too large : "));
            }
            case INVALID_TASK_NAME: {
                String string = String.valueOf(detail);
                return new IllegalArgumentException(string.length() != 0 ? "Invalid task name : ".concat(string) : new String("Invalid task name : "));
            }
            case INVALID_QUEUE_NAME: {
                String string = String.valueOf(detail);
                return new IllegalArgumentException(string.length() != 0 ? "Invalid queue name : ".concat(string) : new String("Invalid queue name : "));
            }
            case INVALID_URL: {
                String string = String.valueOf(detail);
                return new IllegalArgumentException(string.length() != 0 ? "Invalid URL : ".concat(string) : new String("Invalid URL : "));
            }
            case INVALID_QUEUE_RATE: {
                String string = String.valueOf(detail);
                return new IllegalArgumentException(string.length() != 0 ? "Invalid queue rate : ".concat(string) : new String("Invalid queue rate : "));
            }
            case PERMISSION_DENIED: {
                String string = String.valueOf(detail);
                return new SecurityException(string.length() != 0 ? "Permission for requested operation is denied : ".concat(string) : new String("Permission for requested operation is denied : "));
            }
            case TASK_ALREADY_EXISTS: {
                String string = String.valueOf(detail);
                return new TaskAlreadyExistsException(string.length() != 0 ? "Task name already exists : ".concat(string) : new String("Task name already exists : "));
            }
            case TOMBSTONED_TASK: {
                String string = String.valueOf(detail);
                return new TaskAlreadyExistsException(string.length() != 0 ? "Task name is tombstoned : ".concat(string) : new String("Task name is tombstoned : "));
            }
            case INVALID_ETA: {
                String string = String.valueOf(detail);
                return new IllegalArgumentException(string.length() != 0 ? "ETA is invalid : ".concat(string) : new String("ETA is invalid : "));
            }
            case INVALID_REQUEST: {
                String string = String.valueOf(detail);
                return new IllegalArgumentException(string.length() != 0 ? "Invalid request : ".concat(string) : new String("Invalid request : "));
            }
            case UNKNOWN_TASK: {
                String string = String.valueOf(detail);
                return new TaskNotFoundException(string.length() != 0 ? "Task does not exist : ".concat(string) : new String("Task does not exist : "));
            }
            case TOMBSTONED_QUEUE: {
                String string = String.valueOf(detail);
                return new IllegalStateException(string.length() != 0 ? "The queue has been marked for deletion and is no longer usable : ".concat(string) : new String("The queue has been marked for deletion and is no longer usable : "));
            }
            case DUPLICATE_TASK_NAME: {
                String string = String.valueOf(detail);
                return new IllegalArgumentException(string.length() != 0 ? "Identical task names in request : ".concat(string) : new String("Identical task names in request : "));
            }
            case TOO_MANY_TASKS: {
                String string = String.valueOf(detail);
                return new IllegalArgumentException(string.length() != 0 ? "Request contains too many tasks : ".concat(string) : new String("Request contains too many tasks : "));
            }
            case INVALID_QUEUE_MODE: {
                String string = String.valueOf(detail);
                return new InvalidQueueModeException(string.length() != 0 ? "Target queue mode does not support this operation : ".concat(string) : new String("Target queue mode does not support this operation : "));
            }
            case TASK_LEASE_EXPIRED: {
                String string = String.valueOf(detail);
                return new IllegalStateException(string.length() != 0 ? "The task lease has expired : ".concat(string) : new String("The task lease has expired : "));
            }
            case QUEUE_PAUSED: {
                String string = String.valueOf(detail);
                return new IllegalStateException(string.length() != 0 ? "The queue is paused and cannot process the request : ".concat(string) : new String("The queue is paused and cannot process the request : "));
            }
        }
        String string = String.valueOf(errorCode);
        return new QueueFailureException(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(detail).length()).append("Unspecified error (").append(string).append(") : ").append(detail).toString());
    }

    static RuntimeException translateError(ApiProxy.ApplicationException exception) {
        return QueueApiHelper.translateError(exception.getApplicationError(), exception.getErrorDetail());
    }

    public static void validateQueueName(String queueName) {
        if (queueName == null || queueName.length() == 0 || !QueueConstants.QUEUE_NAME_PATTERN.matcher(queueName).matches()) {
            String string = QueueConstants.QUEUE_NAME_REGEX;
            throw new IllegalArgumentException(new StringBuilder(47 + String.valueOf(string).length() + String.valueOf(queueName).length()).append("Queue name does not match expression ").append(string).append("; found '").append(queueName).append("'").toString());
        }
    }
}

