/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.PrefixMap;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.Map;

@GoogleInternal
@GwtIncompatible
public class PrefixTrie<T>
implements PrefixMap<T> {
    private final char rangeOffset;
    private final int rangeSize;
    private final Node<T> root;

    public PrefixTrie() {
        this('\u0000', '\u007f');
    }

    public PrefixTrie(char firstCharInRange, char lastCharInRange) {
        Preconditions.checkArgument(firstCharInRange <= lastCharInRange, "Char range must include some chars");
        this.rangeOffset = firstCharInRange;
        this.rangeSize = lastCharInRange - firstCharInRange + 1;
        this.root = new Node("");
    }

    @Override
    @CanIgnoreReturnValue
    public T put(CharSequence prefix, T value) {
        Preconditions.checkNotNull(value);
        return this.putInternal(prefix, value);
    }

    private T putInternal(CharSequence prefix, T value) {
        Node<T> current = this.root;
        int prefixLength = prefix.length();
        int i = 0;
        while (true) {
            int commonLength;
            String commonPrefix;
            if ((commonPrefix = Strings.commonPrefix(prefix.subSequence(i, i + (commonLength = Math.min(current.prefix.length(), prefixLength - i))), current.prefix)).length() != current.prefix.length()) {
                try {
                    current.split(commonPrefix.length(), current.prefix.charAt(commonPrefix.length()) - this.rangeOffset, this.rangeSize);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    char c = current.prefix.charAt(commonPrefix.length());
                    throw new IllegalArgumentException(new StringBuilder(36).append("'").append(c).append("' is not a legal prefix character.").toString());
                }
            }
            if ((i += commonPrefix.length()) == prefixLength) break;
            if (current.next == null) {
                Node[] next = new Node[this.rangeSize];
                current.next = next;
            }
            int nodeIndex = prefix.charAt(i) - this.rangeOffset;
            try {
                Node next = current.next[nodeIndex];
                if (next == null) {
                    current.next[nodeIndex] = new Node(prefix.subSequence(i + 1, prefixLength).toString());
                    current = current.next[nodeIndex];
                    break;
                }
                current = next;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                char c = prefix.charAt(i);
                throw new IllegalArgumentException(new StringBuilder(36).append("'").append(c).append("' is not a legal prefix character.").toString());
            }
            ++i;
        }
        Object oldValue = current.value;
        current.value = value;
        return oldValue;
    }

    @Override
    public T get(CharSequence s) {
        String prefix;
        T deepestValue = null;
        Node<T> current = this.root;
        int sLength = s.length();
        int i = 0;
        while (current != null && i + (prefix = current.prefix).length() <= sLength && prefix.contentEquals(s.subSequence(i, i + prefix.length()))) {
            i += prefix.length();
            if (current.value != null) {
                deepestValue = current.value;
            }
            if (i == sLength || current.next == null) break;
            int nodeIndex = s.charAt(i) - this.rangeOffset;
            if (nodeIndex < 0 || this.rangeSize <= nodeIndex) {
                return null;
            }
            current = current.next[nodeIndex];
            ++i;
        }
        return deepestValue;
    }

    @Override
    @CanIgnoreReturnValue
    public T remove(CharSequence prefix) {
        return this.putInternal(prefix, null);
    }

    public Map<String, T> toMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        this.addEntries(this.root, new StringBuilder(), map);
        return map;
    }

    private void addEntries(Node<T> node, StringBuilder builder, Map<String, T> map) {
        builder.append(node.prefix);
        if (node.value != null) {
            map.put(builder.toString(), node.value);
        }
        if (node.next != null) {
            for (int i = 0; i < node.next.length; ++i) {
                Node next = node.next[i];
                if (next == null) continue;
                builder.append((char)(i + this.rangeOffset));
                this.addEntries(next, builder, map);
                builder.deleteCharAt(builder.length() - 1);
            }
        }
        builder.delete(builder.length() - node.prefix.length(), builder.length());
    }

    private static class Node<T> {
        String prefix;
        T value;
        Node<T>[] next;

        Node(String prefix) {
            this.prefix = prefix;
        }

        void split(int atChar, int nextPos, int totalSize) throws ArrayIndexOutOfBoundsException {
            Node[] newNext = new Node[totalSize];
            Node<T> newNode = newNext[nextPos] = new Node<T>(this.prefix.substring(atChar + 1));
            newNode.value = this.value;
            newNode.next = this.next;
            this.prefix = this.prefix.substring(0, atChar);
            this.value = null;
            this.next = newNext;
        }
    }
}

