/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.Expression;
import com.google.appengine.api.search.dev.NumericExpression;
import com.google.appengine.repackaged.com.google.common.primitives.Doubles;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.document.Field;

class RankExpression
extends NumericExpression {
    RankExpression() {
    }

    @Override
    public double evalDouble(Document doc) throws EvaluationException {
        Double val;
        Field field = doc.getField("_rank");
        if (field != null && (val = Doubles.tryParse((String)field.stringValue())) != null) {
            return val;
        }
        throw new EvaluationException(String.format("Could not determine rank from value %s", field));
    }

    @Override
    public Expression.Sorter getNumericSorter(int sign, double defaultValueNumeric) {
        if (sign >= 0) {
            return super.getNumericSorter(sign, defaultValueNumeric);
        }
        throw new SearchQueryException("Rank can only be used in descending-order searches");
    }
}

