/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.Scorer;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.search.IndexSearcher;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.Sort;
import com.google.appengine.repackaged.org.apache.lucene.search.SortField;
import com.google.appengine.repackaged.org.apache.lucene.search.TopFieldDocs;
import java.io.IOException;

public class SimpleScorer
extends Scorer {
    private final Sort sort;

    public SimpleScorer(Sort sort) {
        this.sort = sort;
    }

    static Sort naturalOrder() {
        return new Sort(new SortField("_rank", 4, true));
    }

    @Override
    public Scorer.SearchResults search(IndexSearcher indexSearcher, Query q, int offset, int limit) throws IOException {
        int docsToFind = offset + limit;
        TopFieldDocs topDocs = indexSearcher.search(q, null, docsToFind, this.sort);
        int max = Math.min(topDocs.scoreDocs.length, docsToFind);
        if (max < offset) {
            return new Scorer.SearchResults(new Result[0], 0);
        }
        Scorer.Result[] resultsArray = new Result[max - offset];
        for (int i = offset; i < max; ++i) {
            resultsArray[i - offset] = new Result(this, indexSearcher.doc(topDocs.scoreDocs[i].doc));
        }
        return new Scorer.SearchResults(resultsArray, topDocs.totalHits);
    }

    public class Result
    extends Scorer.Result {
        public Result(SimpleScorer this$0, Document doc) {
            super(doc);
        }

        @Override
        public void addScores(SearchServicePb.SearchResult.Builder resultBuilder) {
        }
    }
}

