/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.index;

import com.google.appengine.repackaged.org.apache.lucene.index.ByteSliceReader;
import com.google.appengine.repackaged.org.apache.lucene.index.CharBlockPool;
import com.google.appengine.repackaged.org.apache.lucene.index.FreqProxTermsWriter;
import com.google.appengine.repackaged.org.apache.lucene.index.FreqProxTermsWriterPerField;
import com.google.appengine.repackaged.org.apache.lucene.index.RawPostingList;
import java.io.IOException;

final class FreqProxFieldMergeState {
    final FreqProxTermsWriterPerField field;
    final int numPostings;
    final CharBlockPool charPool;
    final RawPostingList[] postings;
    private FreqProxTermsWriter.PostingList p;
    char[] text;
    int textOffset;
    private int postingUpto = -1;
    final ByteSliceReader freq = new ByteSliceReader();
    final ByteSliceReader prox = new ByteSliceReader();
    int docID;
    int termFreq;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FreqProxFieldMergeState(FreqProxTermsWriterPerField field) {
        this.field = field;
        this.charPool = field.perThread.termsHashPerThread.charPool;
        this.numPostings = field.termsHashPerField.numPostings;
        this.postings = field.termsHashPerField.sortPostings();
    }

    boolean nextTerm() throws IOException {
        ++this.postingUpto;
        if (this.postingUpto == this.numPostings) {
            return false;
        }
        this.p = (FreqProxTermsWriter.PostingList)this.postings[this.postingUpto];
        this.docID = 0;
        this.text = this.charPool.buffers[this.p.textStart >> 14];
        this.textOffset = this.p.textStart & 0x3FFF;
        this.field.termsHashPerField.initReader(this.freq, this.p, 0);
        if (!this.field.fieldInfo.omitTermFreqAndPositions) {
            this.field.termsHashPerField.initReader(this.prox, this.p, 1);
        }
        boolean result = this.nextDoc();
        if (!$assertionsDisabled && !result) {
            throw new AssertionError();
        }
        return true;
    }

    public boolean nextDoc() throws IOException {
        if (this.freq.eof()) {
            if (this.p.lastDocCode != -1) {
                this.docID = this.p.lastDocID;
                if (!this.field.omitTermFreqAndPositions) {
                    this.termFreq = this.p.docFreq;
                }
                this.p.lastDocCode = -1;
                return true;
            }
            return false;
        }
        int code = this.freq.readVInt();
        if (this.field.omitTermFreqAndPositions) {
            this.docID += code;
        } else {
            this.docID += code >>> 1;
            this.termFreq = (code & 1) != 0 ? 1 : this.freq.readVInt();
        }
        if (!$assertionsDisabled && this.docID == this.p.lastDocID) {
            throw new AssertionError();
        }
        return true;
    }

    static {
        $assertionsDisabled = !FreqProxFieldMergeState.class.desiredAssertionStatus();
    }
}

