/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.DatastorePb;
import com.google.cloud.datastore.core.appengv3.UserValueObfuscator;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public class CompiledCursorUtil {
    public static final ByteString V1_EMPTY_CURSOR = new DatastorePb.CompiledCursor().setPostfixPosition(OnestoreEntity.IndexPostfix.getDefaultInstance()).toByteString();
    public static final String BAD_CURSOR_MESSAGE = "cursor does not match query";
    public static final String OUT_OF_RANGE_CURSOR_MESSAGE = "cursor position is outside the range of the original query";

    private CompiledCursorUtil() {
    }

    private static void checkModernized(DatastorePb.CompiledCursor cursor) {
        Preconditions.checkArgument((!cursor.hasPosition() ? 1 : 0) != 0, (Object)"Modern cursors cannot specify a position.");
    }

    public static boolean isEmpty(DatastorePb.CompiledCursor cursor) {
        CompiledCursorUtil.checkModernized(cursor);
        return !CompiledCursorUtil.isEncoded(cursor) && !CompiledCursorUtil.isPlannable(cursor);
    }

    public static boolean isEncoded(DatastorePb.CompiledCursor cursor) {
        CompiledCursorUtil.checkModernized(cursor);
        return cursor.hasAbsolutePosition();
    }

    public static boolean isPlannable(DatastorePb.CompiledCursor cursor) {
        CompiledCursorUtil.checkModernized(cursor);
        return cursor.hasPostfixPosition();
    }

    @Nullable
    public static DatastorePb.Query.Order.Direction firstSortDirection(DatastorePb.Query originalQuery) {
        return originalQuery.orderSize() == 0 ? null : originalQuery.getOrder(0).getDirectionEnum();
    }

    public static void modernizeQueryCursors(DatastorePb.Query query) throws InvalidConversionException {
        boolean hasStartCursor = query.hasCompiledCursor();
        boolean hasEndCursor = query.hasEndCompiledCursor();
        if (!hasStartCursor && !hasEndCursor) {
            return;
        }
        DatastorePb.Query.Order.Direction firstSortDirection = CompiledCursorUtil.firstSortDirection(query);
        if (hasStartCursor) {
            CompiledCursorUtil.modernizeCursor(query.getCompiledCursor(), firstSortDirection);
        }
        if (hasEndCursor) {
            CompiledCursorUtil.modernizeCursor(query.getEndCompiledCursor(), firstSortDirection);
        }
    }

    public static void modernizeCursor(DatastorePb.CompiledCursor cursor, @Nullable Direction firstSortDirection) throws InvalidConversionException {
        DatastorePb.Query.Order.Direction v3Direction = null;
        if (firstSortDirection != null) {
            v3Direction = firstSortDirection == Direction.ASCENDING ? DatastorePb.Query.Order.Direction.ASCENDING : DatastorePb.Query.Order.Direction.DESCENDING;
        }
        CompiledCursorUtil.modernizeCursor(cursor, v3Direction);
    }

    private static void modernizeCursor(DatastorePb.CompiledCursor cursor, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) throws InvalidConversionException {
        if (cursor.hasPosition()) {
            InvalidConversionException.checkConversion(!cursor.hasPostfixPosition(), "A cursor cannot specify both position and postfix position.", new Object[0]);
            InvalidConversionException.checkConversion(!cursor.hasAbsolutePosition(), "A cursor cannot specify both position and absolute position.", new Object[0]);
            DatastorePb.CompiledCursor.Position pos = cursor.getPosition();
            if (pos.hasStartKey()) {
                OnestoreEntity.IndexPosition indexPos = cursor.getMutableAbsolutePosition();
                indexPos.setKeyAsBytes(pos.getStartKeyAsBytes());
                if (pos.hasStartInclusive()) {
                    indexPos.setBefore(pos.isStartInclusive());
                }
                if (pos.hasBeforeAscending()) {
                    indexPos.setBeforeAscending(pos.isBeforeAscending());
                }
            } else if (pos.hasKey() || pos.indexValueSize() > 0) {
                OnestoreEntity.IndexPostfix postfixPos = cursor.getMutablePostfixPosition();
                for (DatastorePb.CompiledCursor.PositionIndexValue value : pos.indexValues()) {
                    OnestoreEntity.IndexPostfix_IndexValue indexValue = postfixPos.addIndexValue().setPropertyName(value.getProperty());
                    indexValue.getMutableValue().mergeFrom(value.getValue());
                }
                if (pos.hasKey()) {
                    postfixPos.getMutableKey().mergeFrom(pos.getKey());
                }
                if (pos.hasStartInclusive()) {
                    postfixPos.setBefore(pos.isStartInclusive());
                }
                if (pos.hasBeforeAscending()) {
                    postfixPos.setBeforeAscending(pos.isBeforeAscending());
                }
            }
            cursor.clearPosition();
        }
        if (CompiledCursorUtil.isEmpty(cursor)) {
            return;
        }
        if (cursor.hasAbsolutePosition()) {
            OnestoreEntity.IndexPosition indexPosition = cursor.getAbsolutePosition();
            if (indexPosition.hasBeforeAscending()) {
                CompiledCursorUtil.setBefore(indexPosition, firstSortDirection);
            } else {
                CompiledCursorUtil.setBeforeAscending(indexPosition, firstSortDirection);
            }
        } else if (cursor.hasPostfixPosition()) {
            OnestoreEntity.IndexPostfix indexPostfix = cursor.getPostfixPosition();
            if (indexPostfix.hasBeforeAscending()) {
                CompiledCursorUtil.setBefore(indexPostfix, firstSortDirection);
            } else {
                CompiledCursorUtil.setBeforeAscending(indexPostfix, firstSortDirection);
            }
        }
    }

    public static void unobfuscateQueryCursors(DatastorePb.Query query, UserValueObfuscator obfuscator) throws InvalidConversionException {
        if (query.hasCompiledCursor()) {
            CompiledCursorUtil.unobfuscateCursor(query.getCompiledCursor(), obfuscator);
        }
        if (query.hasEndCompiledCursor()) {
            CompiledCursorUtil.unobfuscateCursor(query.getEndCompiledCursor(), obfuscator);
        }
    }

    private static void unobfuscateCursor(DatastorePb.CompiledCursor cursor, UserValueObfuscator obfuscator) throws InvalidConversionException {
        if (cursor.hasPostfixPosition()) {
            for (OnestoreEntity.IndexPostfix_IndexValue indexValue : cursor.getPostfixPosition().indexValues()) {
                obfuscator.unobfuscatePropertyValue(indexValue.getValue());
            }
        }
    }

    public static void setBefore(OnestoreEntity.IndexPosition position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBefore(CompiledCursorUtil.computeBefore(position.isBeforeAscending(), firstSortDirection));
    }

    public static void setBefore(OnestoreEntity.IndexPostfix position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBefore(CompiledCursorUtil.computeBefore(position.isBeforeAscending(), firstSortDirection));
    }

    @VisibleForTesting
    static void setBeforeAscending(OnestoreEntity.IndexPosition position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBeforeAscending(CompiledCursorUtil.computeBeforeAscending(position.isBefore(), firstSortDirection));
    }

    public static void setBeforeAscending(OnestoreEntity.IndexPostfix position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBeforeAscending(CompiledCursorUtil.computeBeforeAscending(position.isBefore(), firstSortDirection));
    }

    private static boolean computeBefore(boolean isBeforeAscending, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        return isBeforeAscending ^ firstSortDirection == DatastorePb.Query.Order.Direction.DESCENDING;
    }

    private static boolean computeBeforeAscending(boolean isBefore, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        return isBefore ^ firstSortDirection == DatastorePb.Query.Order.Direction.DESCENDING;
    }
}

