/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatch;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.QueryInfo;
import com.google.cloud.datastore.core.rep.ReadResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class QueryResults {
    private final QueryInfo queryInfo;
    private int skippedResults = 0;
    @Nullable
    private Cursor skippedCursor = null;
    private final List<ReadResult> readResults = new ArrayList<ReadResult>();
    @Nullable
    protected Cursor endCursor = null;
    @Nullable
    protected Cursor resultSetCursor = null;
    private QueryResultBatch.MoreResultsType moreResults = QueryResultBatch.MoreResultsType.NOT_FINISHED;
    private boolean progress = false;
    private boolean exhausted = false;

    public QueryResults(QueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    public QueryInfo query() {
        return this.queryInfo;
    }

    @Nullable
    public Cursor skippedCursor() {
        return this.skippedCursor;
    }

    public int skippedResults() {
        return this.skippedResults;
    }

    public List<ReadResult> readResults() {
        return this.readResults;
    }

    @Nullable
    public Cursor resultSetCursor() {
        return this.resultSetCursor;
    }

    @Nullable
    public Cursor endCursor() {
        return this.endCursor;
    }

    public QueryResultBatch.MoreResultsType moreResults() {
        return this.moreResults;
    }

    public boolean madeProgress() {
        return this.progress;
    }

    public boolean madeResultSetProgress() {
        return this.madeProgress() && (this.resultSetCursor() != null || this.moreResults() != QueryResultBatch.MoreResultsType.NOT_FINISHED);
    }

    public void addSkippedResult(ReadResult result) {
        this.progress = true;
        this.resultSetCursor = this.endCursor = result.cursor();
        this.skippedCursor = this.endCursor;
        ++this.skippedResults;
    }

    public void addQueryResult(ReadResult readResult) {
        this.progress = true;
        this.resultSetCursor = this.endCursor = readResult.cursor();
        this.readResults.add(readResult);
    }

    public void setEndCursor(Cursor endCursor) {
        this.endCursor = endCursor;
    }

    public void setMoreResults(QueryResultBatch.MoreResultsType moreResults) {
        this.progress = true;
        this.moreResults = moreResults;
    }

    public boolean exhausted() {
        return this.exhausted;
    }

    public void reportExhaustion() {
        this.exhausted = true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("skippedResults", this.skippedResults).add("skippedCursor", (Object)this.skippedCursor).add("readResults", this.readResults).add("resultSetCursor", (Object)this.resultSetCursor).add("endCursor", (Object)this.endCursor).add("moreResults", (Object)this.moreResults).toString();
    }
}

