/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.labs.command;

import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.labs.command.CapturingOutputStream;
import com.google.appengine.repackaged.com.google.errorprone.annotations.Immutable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@Immutable
public final class CommandResult {
    private final int exitCode;
    private final CapturingOutputStream stdout;
    private final CapturingOutputStream stderr;

    CommandResult(int exitCode, CapturingOutputStream stdout, CapturingOutputStream stderr) {
        this.exitCode = exitCode;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public int exitCode() {
        return this.exitCode;
    }

    public byte[] stdoutBytes() {
        return this.stdout.toByteArray();
    }

    public byte[] stderrBytes() {
        return this.stderr.toByteArray();
    }

    public String stdoutString(Charset cs) {
        return this.stdout.toString(cs);
    }

    public String stderrString(Charset cs) {
        return this.stderr.toString(cs);
    }

    public String stdoutStringUtf8() {
        return this.stdoutString(StandardCharsets.UTF_8);
    }

    public String stderrStringUtf8() {
        return this.stderrString(StandardCharsets.UTF_8);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("exit code", this.exitCode).add("stdout", this.stdoutStringUtf8()).add("stderr", this.stderrStringUtf8()).toString();
    }
}

