/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.labs.command;

import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.appengine.repackaged.com.google.common.labs.command.AsyncCopier;
import com.google.appengine.repackaged.com.google.common.labs.command.Command;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandExecutor;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandProcess;
import com.google.appengine.repackaged.com.google.common.labs.command.CommandStartException;
import com.google.appengine.repackaged.com.google.common.labs.command.InputSource;
import com.google.appengine.repackaged.com.google.common.labs.command.Opener;
import com.google.appengine.repackaged.com.google.common.labs.command.OutputSink;
import com.google.appengine.repackaged.com.google.common.time.Durations;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

final class NativeProcess
extends CommandProcess {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/appengine/repackaged/com/google/common/labs/command/NativeProcess");
    static final CommandExecutor EXECUTOR = new CommandExecutor(){

        @Override
        public CommandProcess start(Command command) throws CommandStartException {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command().add(command.executable());
            processBuilder.command().addAll(command.arguments());
            processBuilder.environment().clear();
            processBuilder.environment().putAll(command.environment());
            if (command.workingDirectory().isPresent()) {
                processBuilder.directory(command.workingDirectory().get().toFile());
            }
            processBuilder.redirectInput(NativeProcess.sourceToRedirect(command.stdinSource()));
            processBuilder.redirectOutput(NativeProcess.sinkToRedirect(command.stdoutSink(), OutputSink.Kind.JVM_OUT));
            if (command.stderrSink().equals(command.stdoutSink())) {
                processBuilder.redirectErrorStream(true);
            } else {
                processBuilder.redirectError(NativeProcess.sinkToRedirect(command.stderrSink(), OutputSink.Kind.JVM_ERR));
            }
            try {
                return new NativeProcess(command, new NativeRawProcess(processBuilder));
            }
            catch (IOException e) {
                throw new CommandStartException(command, e);
            }
        }
    };

    private static ProcessBuilder.Redirect sourceToRedirect(InputSource source) {
        InputSource.Kind kind = source.kind();
        if (kind.equals((Object)InputSource.Kind.JVM)) {
            return ProcessBuilder.Redirect.INHERIT;
        }
        if (kind.equals((Object)InputSource.Kind.FILE)) {
            File file;
            try {
                file = source.file().toFile();
            }
            catch (UnsupportedOperationException e) {
                return ProcessBuilder.Redirect.PIPE;
            }
            return ProcessBuilder.Redirect.from(file);
        }
        return ProcessBuilder.Redirect.PIPE;
    }

    private static ProcessBuilder.Redirect sinkToRedirect(OutputSink sink, OutputSink.Kind inheritKind) {
        OutputSink.Kind kind = sink.kind();
        if (kind.equals((Object)inheritKind)) {
            return ProcessBuilder.Redirect.INHERIT;
        }
        if (kind.equals((Object)OutputSink.Kind.FILE) || kind.equals((Object)OutputSink.Kind.FILE_APPEND)) {
            File file;
            try {
                file = sink.file().toFile();
            }
            catch (UnsupportedOperationException e) {
                return ProcessBuilder.Redirect.PIPE;
            }
            return kind.equals((Object)OutputSink.Kind.FILE) ? ProcessBuilder.Redirect.to(file) : ProcessBuilder.Redirect.appendTo(file);
        }
        return ProcessBuilder.Redirect.PIPE;
    }

    private NativeProcess(Command command, NativeRawProcess rawProcess) throws CommandStartException {
        super(command, rawProcess);
    }

    private static final class NativeRawProcess
    implements CommandProcess.RawProcess {
        private final ProcessBuilder processBuilder;
        private final Process process;
        private volatile boolean killed = false;
        private Optional<AsyncCopier> stdinPump = Optional.empty();
        private Optional<AsyncCopier> stdoutPump = Optional.empty();
        private Optional<AsyncCopier> stderrPump = Optional.empty();

        private NativeRawProcess(ProcessBuilder processBuilder) throws IOException {
            this.processBuilder = processBuilder;
            this.process = processBuilder.start();
        }

        @Override
        public boolean isAlive() {
            return this.process.isAlive();
        }

        @Override
        public int await() throws InterruptedException {
            int exitCode = this.process.waitFor();
            this.closePumps();
            return exitCode;
        }

        @Override
        public boolean await(Duration timeout) throws InterruptedException {
            boolean exited = this.process.waitFor(Durations.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
            if (exited) {
                this.closePumps();
            }
            return exited;
        }

        private void closePumps() throws InterruptedException {
            if (this.stdinPump.isPresent()) {
                this.stdinPump.get().stopUninterruptibly();
            }
            if (this.stdoutPump.isPresent()) {
                this.stdoutPump.get().awaitUninterruptibly();
            }
            if (this.stderrPump.isPresent()) {
                this.stderrPump.get().awaitUninterruptibly();
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }

        @Override
        public void kill() {
            this.killed = true;
            this.process.destroy();
        }

        @Override
        public void killForcibly() {
            this.killed = true;
            this.process.destroyForcibly();
        }

        @Override
        public OutputStream stdinStream() {
            return this.process.getOutputStream();
        }

        @Override
        public void acceptStdinSourceStream(Opener<InputStream> stdinSourceOpener) throws IOException {
            if (this.processBuilder.redirectInput().type().equals((Object)ProcessBuilder.Redirect.Type.PIPE)) {
                this.stdinPump = Optional.of(AsyncCopier.start(stdinSourceOpener.open(), this.process.getOutputStream(), new IOExceptionLogger("to stdin")));
            }
        }

        @Override
        public void acceptStdoutSinkStream(Opener<OutputStream> stdoutSinkOpener) throws IOException {
            if (this.processBuilder.redirectOutput().type().equals((Object)ProcessBuilder.Redirect.Type.PIPE)) {
                this.stdoutPump = Optional.of(AsyncCopier.start(this.process.getInputStream(), stdoutSinkOpener.open(), new IOExceptionLogger("from stdout")));
            }
        }

        @Override
        public void acceptStderrSinkStream(Opener<OutputStream> stderrSinkOpener) throws IOException {
            if (this.processBuilder.redirectError().type().equals((Object)ProcessBuilder.Redirect.Type.PIPE) && !this.processBuilder.redirectErrorStream()) {
                this.stderrPump = Optional.of(AsyncCopier.start(this.process.getErrorStream(), stderrSinkOpener.open(), new IOExceptionLogger("from stderr")));
            }
        }

        private final class IOExceptionLogger
        implements Consumer<IOException> {
            private final String desc;

            private IOExceptionLogger(String desc) {
                this.desc = desc;
            }

            @Override
            public void accept(IOException e) {
                if (NativeRawProcess.this.isAlive() && !NativeRawProcess.this.killed) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).withInjectedLogSite("com/google/appengine/repackaged/com/google/common/labs/command/NativeProcess$NativeRawProcess$IOExceptionLogger", "accept", 230, "NativeProcess.java")).log("Unexpected IO error copying %s of a running process", this.desc);
                } else {
                    ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(e)).withInjectedLogSite("com/google/appengine/repackaged/com/google/common/labs/command/NativeProcess$NativeRawProcess$IOExceptionLogger", "accept", 233, "NativeProcess.java")).log("Benign IO error copying %s of a terminated process", this.desc);
                }
            }
        }
    }
}

