/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.enhancer;

import com.google.appengine.tools.enhancer.EnhancerLoader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Set;

public class Enhancer {
    static final String DEFAULT_ENHANCER_VERSION = "v1";
    private static final String DATANUCLEUS_ENHANCER_CLASS = "org.datanucleus.enhancer.DataNucleusEnhancer";
    private Set<URL> enhanceTargets;
    private String[] args;
    private String datanucleusVersion = "v1";

    public void setTargets(Set<URL> enhanceTargets) {
        this.enhanceTargets = enhanceTargets;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public void setDatanucleusVersion(String datanucleusVersion) {
        if (datanucleusVersion == null) {
            throw new NullPointerException("datanucleusVersion cannot be null");
        }
        this.datanucleusVersion = datanucleusVersion;
    }

    public void execute() {
        if (this.enhanceTargets == null) {
            throw new IllegalArgumentException("Must set the targets for enhancement.");
        }
        if (this.args == null) {
            throw new IllegalArgumentException("Must set the enhancer arguments.");
        }
        EnhancerLoader enhancerLoader = new EnhancerLoader(this.enhanceTargets, this.datanucleusVersion);
        Thread.currentThread().setContextClassLoader(enhancerLoader);
        try {
            Class<?> enhancerClass = enhancerLoader.loadClass(DATANUCLEUS_ENHANCER_CLASS);
            Method main = enhancerClass.getMethod("main", String[].class);
            main.invoke(null, new Object[]{this.args});
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    String getDatanucleusVersion() {
        return this.datanucleusVersion;
    }
}

