/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.enhancer;

import com.google.appengine.tools.info.AppengineSdk;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EnhancerLoader
extends URLClassLoader {
    @Deprecated
    public EnhancerLoader(Set<URL> enhanceTargets) {
        this(enhanceTargets, "v1");
    }

    public EnhancerLoader(Set<URL> enhanceTargets, String datanucleusVersion) {
        super(EnhancerLoader.getClassPath(enhanceTargets, datanucleusVersion), ClassLoaderUtil.getPlatformClassLoader());
    }

    private static URL[] getClassPath(Set<URL> enhanceTargets, String datanucleusVersion) {
        AppengineSdk sdk = AppengineSdk.getSdk();
        List<URL> datanucleusToolLibs = sdk.getDatanucleusLibs(datanucleusVersion);
        Set<URL> newTargets = EnhancerLoader.removeOrmLibs(enhanceTargets, datanucleusToolLibs);
        HashSet<URL> libs = new HashSet<URL>(sdk.getSharedLibs());
        libs.addAll(new HashSet<URL>(datanucleusToolLibs));
        libs.addAll(newTargets);
        URL[] urls = new URL[libs.size()];
        return libs.toArray(urls);
    }

    private static Set<URL> removeOrmLibs(Set<URL> enhanceTargets, List<URL> ormLibs) {
        if (enhanceTargets == null) {
            throw new NullPointerException("enhanceTargets cannot be null");
        }
        if (ormLibs == null) {
            throw new NullPointerException("ormLibs cannot be null");
        }
        HashSet<URL> newTargets = new HashSet<URL>();
        block0: for (URL url : enhanceTargets) {
            String userFileName = EnhancerLoader.getFileName(url);
            for (URL ormUrl : ormLibs) {
                if (!userFileName.equals(EnhancerLoader.getFileName(ormUrl))) continue;
                continue block0;
            }
            newTargets.add(url);
        }
        return newTargets;
    }

    private static String getFileName(URL url) {
        String path = url.getPath();
        int trailingSlash = path.lastIndexOf(47);
        return path.substring(trailingSlash + 1);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("org.apache.log4j.")) {
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }

    static class ClassLoaderUtil {
        public static ClassLoader getPlatformClassLoader() {
            try {
                Method getPlatformClassLoader = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]);
                return (ClassLoader)getPlatformClassLoader.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException ignore) {
                return null;
            }
        }

        private ClassLoaderUtil() {
        }
    }
}

