/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

abstract class AbstractConfigXmlReader<T> {
    final String appDir;
    final boolean required;
    private static final Logger logger = Logger.getLogger(AbstractConfigXmlReader.class.getName());
    private static final CharMatcher INVALID_TAG_CHARS = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.anyOf("_.-")).negate();

    AbstractConfigXmlReader(String appDir, boolean required) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            String string = String.valueOf(appDir);
            char c = File.separatorChar;
            appDir = new StringBuilder(1 + String.valueOf(string).length()).append(string).append(c).toString();
        }
        this.appDir = appDir;
        this.required = required;
    }

    public String getFilename() {
        String string = String.valueOf(this.appDir);
        String string2 = String.valueOf(this.getRelativeFilename());
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    abstract String getRelativeFilename();

    abstract T processXml(InputStream var1);

    T readConfigXml() {
        T configXml;
        if (!this.required && !this.fileExists()) {
            return null;
        }
        try (InputStream is = this.getInputStream();){
            configXml = this.processXml(is);
            String string = String.valueOf(this.getFilename());
            logger.logp(Level.FINE, "com.google.apphosting.utils.config.AbstractConfigXmlReader", "readConfigXml", string.length() != 0 ? "Successfully processed ".concat(string) : new String("Successfully processed "));
        }
        catch (Exception e) {
            String string = String.valueOf(this.getFilename());
            String msg = string.length() != 0 ? "Received exception processing ".concat(string) : new String("Received exception processing ");
            logger.logp(Level.SEVERE, "com.google.apphosting.utils.config.AbstractConfigXmlReader", "readConfigXml", msg, e);
            if (e instanceof AppEngineConfigException) {
                throw (AppEngineConfigException)e;
            }
            throw new AppEngineConfigException(msg, e);
        }
        return configXml;
    }

    boolean fileExists() {
        return new File(this.getFilename()).exists();
    }

    protected InputStream getInputStream() {
        try {
            return new FileInputStream(this.getFilename());
        }
        catch (FileNotFoundException fnfe) {
            String string = String.valueOf(new File(this.getFilename()).getAbsolutePath());
            throw new AppEngineConfigException(string.length() != 0 ? "Could not locate ".concat(string) : new String("Could not locate "), fnfe);
        }
    }

    String stringContents(Element element) {
        String text = XmlUtils.getText(element);
        if (text.isEmpty()) {
            String string = this.getFilename();
            String string2 = AbstractConfigXmlReader.sanitizeTag(element.getTagName());
            throw new AppEngineConfigException(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" has bad contents in <").append(string2).append(">").toString());
        }
        return CharMatcher.whitespace().trimFrom(text);
    }

    static String sanitizeTag(String tag) {
        return INVALID_TAG_CHARS.replaceFrom((CharSequence)tag, '?');
    }
}

