/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.JavaUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class MappedTypeManager {
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected final OMFContext omfCtx;
    Map<String, MappedType> mappedTypes = new HashMap<String, MappedType>();

    public MappedTypeManager(OMFContext omfCtx) {
        this.omfCtx = omfCtx;
        this.loadMappings(omfCtx.getPluginManager(), omfCtx.getClassLoaderResolver(null));
    }

    public boolean isSupportedMappedType(String className) {
        if (className == null) {
            return false;
        }
        MappedType type = this.getMappedType(className);
        if (type == null) {
            try {
                Class cls = this.omfCtx.getClassLoaderResolver(null).classForName(className);
                type = this.findMappedTypeForClass(cls);
                return type != null && type.javaMappingType != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return type != null && type.javaMappingType != null;
    }

    public Class getMappingType(String className) {
        if (className == null) {
            return null;
        }
        MappedType type = this.getMappedType(className);
        if (type == null) {
            TypeManager typeMgr = this.omfCtx.getTypeManager();
            Class cls = typeMgr.getTypeForSecondClassWrapper(className);
            if (cls != null && (type = this.getMappedType(cls.getName())) != null) {
                return type.javaMappingType;
            }
            try {
                cls = this.omfCtx.getClassLoaderResolver(null).classForName(className);
                type = this.findMappedTypeForClass(cls);
                return type.javaMappingType;
            }
            catch (Exception e) {
                return null;
            }
        }
        return type.javaMappingType;
    }

    private void loadMappings(PluginManager mgr, ClassLoaderResolver clr) {
        ExtensionPoint exPoint = mgr.getExtensionPoint("org.datanucleus.store_mapping");
        for (int i = 0; i < exPoint.getExtensions().length; ++i) {
            ConfigurationElement[] elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (int e = 0; e < elms.length; ++e) {
                String javaVersion;
                String javaName = elms[e].getAttribute("java-type").trim();
                String mappingClassName = elms[e].getAttribute("mapping-class");
                String javaVersionRestrict = elms[e].getAttribute("java-version-restricted");
                boolean javaRestricted = false;
                if (javaVersionRestrict != null && javaVersionRestrict.equalsIgnoreCase("true")) {
                    javaRestricted = Boolean.TRUE;
                }
                if (StringUtils.isWhitespace(javaVersion = elms[e].getAttribute("java-version"))) {
                    javaVersion = "1.3";
                }
                this.addMappedType(mgr, elms[e].getExtension().getPlugin().getSymbolicName(), javaName, mappingClassName, javaVersion, javaRestricted, clr);
            }
        }
    }

    private void addMappedType(PluginManager mgr, String pluginId, String className, String mappingClassName, String javaVersion, boolean javaRestricted, ClassLoaderResolver clr) {
        if (className == null) {
            return;
        }
        if (JavaUtils.isGreaterEqualsThan(javaVersion) && !javaRestricted || JavaUtils.isEqualsThan(javaVersion) && javaRestricted) {
            Class mappingType = null;
            if (!StringUtils.isWhitespace(mappingClassName)) {
                try {
                    mappingType = mgr.loadClass(pluginId, mappingClassName);
                }
                catch (NucleusException jpe) {
                    NucleusLogger.PERSISTENCE.error(LOCALISER.msg("016004", (Object)mappingClassName));
                    return;
                }
            }
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cls != null) {
                MappedType type = new MappedType(cls, mappingType);
                this.mappedTypes.put(className, type);
            }
        }
    }

    protected MappedType findMappedTypeForClass(Class cls) {
        MappedType type2 = this.getMappedType(cls.getName());
        if (type2 != null) {
            return type2;
        }
        Class<?> componentCls = cls.isArray() ? cls.getComponentType() : null;
        HashSet<MappedType> supportedTypes = new HashSet<MappedType>(this.mappedTypes.values());
        for (MappedType type2 : supportedTypes) {
            if (type2.cls == cls) {
                return type2;
            }
            if (type2.cls.getName().equals("java.lang.Object") || type2.cls.getName().equals("java.io.Serializable")) continue;
            if (componentCls != null) {
                if (!type2.cls.isArray() || !type2.cls.getComponentType().isAssignableFrom(componentCls)) continue;
                this.mappedTypes.put(cls.getName(), type2);
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016001", (Object)cls.getName(), (Object)type2.cls.getName()));
                }
                return type2;
            }
            if (!type2.cls.isAssignableFrom(cls)) continue;
            this.mappedTypes.put(cls.getName(), type2);
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("016001", (Object)cls.getName(), (Object)type2.cls.getName()));
            }
            return type2;
        }
        return null;
    }

    protected MappedType getMappedType(String className) {
        if (className == null) {
            return null;
        }
        return this.mappedTypes.get(className);
    }

    static class MappedType {
        final Class cls;
        final Class javaMappingType;

        public MappedType(Class cls, Class mappingType) {
            this.cls = cls;
            this.javaMappingType = mappingType;
        }

        public String toString() {
            StringBuffer str = new StringBuffer("MappedType " + this.cls.getName() + " [");
            if (this.javaMappingType != null) {
                str.append(" mapping=" + this.javaMappingType);
            }
            str.append("]");
            return str.toString();
        }
    }
}

