/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.InExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;

public class SubqueryExpression
extends BooleanExpression {
    private final QueryExpression subqueryExpr;

    public SubqueryExpression(QueryExpression qs, QueryExpression expr) {
        super(qs);
        this.subqueryExpr = expr;
        expr.setParent(qs);
        this.st.append("(").append(expr).append(')');
    }

    public QueryExpression getSubquery() {
        return this.subqueryExpr;
    }

    public void all() {
        this.st.clearStatement();
        this.st.append("ALL (").append(this.subqueryExpr).append(")");
    }

    public void any() {
        this.st.clearStatement();
        this.st.append("ANY (").append(this.subqueryExpr).append(")");
    }

    public void exists() {
        this.st.clearStatement();
        this.st.append("EXISTS (").append(this.subqueryExpr).append(")");
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new InExpression(expr, OP_IN, this);
    }

    public BooleanExpression containsMethod(ScalarExpression expr) {
        return this.in(expr);
    }

    public NumericExpression sizeMethod() {
        throw new NucleusUserException("size() is not currently supported on subqueries. Use COUNT(*) in the subquery");
    }

    public BooleanExpression isEmptyMethod() {
        throw new NucleusUserException("isEmpty() is not currently supported on subqueries. Use COUNT(*) in the subquery and compare with 0");
    }
}

