// Copyright 2010 Google Inc. All rights reserved.
package com.google.appengine.api.search;

/**
 * Thrown to indicate that a search service failure occurred.
 *
 */
public class SearchServiceException extends RuntimeException {
  private static final long serialVersionUID = -3400183609064651906L;

  /**
   * Constructs an exception which indicates an internal error
   * occurred in the search service.
   *
   * @param detail the error message detail to associate with the
   * internal error
   */
  public SearchServiceException(String detail) {
    super(detail);
  }

  /**
   * Constructs an exception which indicates an internal error
   * occurred in the search service.
   *
   * @param detail the error message detail to associate with the
   * internal error
   * @param e the causing {@link Exception}
   */
  public SearchServiceException(String detail, Exception e) {
    super(detail, e);
  }
}
