package javax.persistence;

/**
 * Type for query parameters.
 * @param <T> the type of the parameter
 */
public interface Parameter<T>
{
    /**
     * Return the parameter name, or null if the parameter is
     * not a named parameter.
     * @return parameter name
     */
    String getName();

    /**
     * Return the parameter position, or null if the parameter is
     * not a positional parameter.
     * @return position of parameter
     */
    Integer getPosition();
}