! Copyright (C) 2010 Erik Charlebois.
! See http://factorcode.org/license.txt for BSD license.
USING: literals windows.kernel32 math alien.syntax windows.types
classes.struct alien alien.c-types windows.errors windows.ole32
windows.advapi32 alien.libraries ;
IN: windows.ddk.setupapi

<< "setupapi" "setupapi.dll" stdcall add-library >>
LIBRARY: setupapi

TYPEDEF: DWORDLONG SP_LOG_TOKEN
TYPEDEF: DWORDLONG* PSP_LOG_TOKEN

CONSTANT: LOGTOKEN_TYPE_MASK              3
CONSTANT: LOGTOKEN_UNSPECIFIED            0
CONSTANT: LOGTOKEN_NO_LOG                 1
CONSTANT: LOGTOKEN_SETUPAPI_APPLOG        2
CONSTANT: LOGTOKEN_SETUPAPI_DEVLOG        3

CONSTANT: TXTLOG_SETUPAPI_DEVLOG      0x00000001
CONSTANT: TXTLOG_SETUPAPI_CMDLINE     0x00000002
CONSTANT: TXTLOG_SETUPAPI_BITS        0x00000003

CONSTANT: TXTLOG_ERROR                    0x1
CONSTANT: TXTLOG_WARNING                  0x2
CONSTANT: TXTLOG_SYSTEM_STATE_CHANGE      0x3
CONSTANT: TXTLOG_SUMMARY                  0x4
CONSTANT: TXTLOG_DETAILS                  0x5
CONSTANT: TXTLOG_VERBOSE                  0x6
CONSTANT: TXTLOG_VERY_VERBOSE             0x7

CONSTANT: TXTLOG_RESERVED_FLAGS   0x0000FFF0

CONSTANT: TXTLOG_TIMESTAMP        0x00010000
CONSTANT: TXTLOG_DEPTH_INCR       0x00020000
CONSTANT: TXTLOG_DEPTH_DECR       0x00040000
CONSTANT: TXTLOG_TAB_1            0x00080000
CONSTANT: TXTLOG_FLUSH_FILE       0x00100000

: TXTLOG_LEVEL ( flags -- n ) 0xf bitand ; inline

CONSTANT: TXTLOG_DEVINST          0x00000001
CONSTANT: TXTLOG_INF              0x00000002
CONSTANT: TXTLOG_FILEQ            0x00000004
CONSTANT: TXTLOG_COPYFILES        0x00000008
CONSTANT: TXTLOG_SIGVERIF         0x00000020
CONSTANT: TXTLOG_BACKUP           0x00000080
CONSTANT: TXTLOG_UI               0x00000100
CONSTANT: TXTLOG_UTIL             0x00000200
CONSTANT: TXTLOG_INFDB            0x00000400
CONSTANT: TXTLOG_POLICY           0x00800000
CONSTANT: TXTLOG_NEWDEV           0x01000000
CONSTANT: TXTLOG_UMPNPMGR         0x02000000
CONSTANT: TXTLOG_DRIVER_STORE     0x04000000
CONSTANT: TXTLOG_SETUP            0x08000000
CONSTANT: TXTLOG_CMI              0x10000000
CONSTANT: TXTLOG_DEVMGR           0x20000000
CONSTANT: TXTLOG_INSTALLER        0x40000000
CONSTANT: TXTLOG_VENDOR           0x80000000

TYPEDEF: void* HPROPSHEETPAGE
TYPEDEF: void* HIMAGELIST
C-TYPE: DEVPROPKEY
TYPEDEF: ULONG DEVPROPTYPE
TYPEDEF: DEVPROPTYPE* PDEVPROPTYPE
TYPEDEF: void* LPPROPSHEETHEADERA
TYPEDEF: void* LPPROPSHEETHEADERW

CONSTANT: LINE_LEN                     256
CONSTANT: LINE_LEN*2                   512
CONSTANT: MAX_INF_STRING_LENGTH        4096
CONSTANT: MAX_INF_SECTION_NAME_LENGTH  255
CONSTANT: MAX_TITLE_LEN                60
CONSTANT: MAX_INSTRUCTION_LEN          256
CONSTANT: MAX_LABEL_LEN                30
CONSTANT: MAX_SERVICE_NAME_LEN         256
CONSTANT: MAX_SUBTITLE_LEN             256
CONSTANT: SP_MAX_MACHINENAME_LENGTH    $[ MAX_PATH 3 + ]

TYPEDEF: PVOID HINF

STRUCT: INFCONTEXT
    { Inf        PVOID }
    { CurrentInf PVOID }
    { Section    UINT  }
    { Line       UINT  } ;
TYPEDEF: INFCONTEXT* PINFCONTEXT

STRUCT: SP_INF_INFORMATION
    { InfStyle   DWORD               }
    { InfCount   DWORD               }
    { VersionDat BYTE[ANYSIZE_ARRAY] } ;
TYPEDEF: SP_INF_INFORMATION* PSP_INF_INFORMATION

STRUCT: SP_ALTPLATFORM_INFO_V2
    { cbSize                     DWORD }
    { Platform                   DWORD }
    { MajorVersion               DWORD }
    { MinorVersion               DWORD }
    { ProcessorArchitecture      WORD  }
    { Flags                      WORD  }
    { FirstValidatedMajorVersion DWORD }
    { FirstValidatedMinorVersion DWORD } ;
TYPEDEF: SP_ALTPLATFORM_INFO_V2* PSP_ALTPLATFORM_INFO_V2

STRUCT: SP_ALTPLATFORM_INFO_V1
    { cbSize                 DWORD }
    { Platform               DWORD }
    { MajorVersion           DWORD }
    { MinorVersion           DWORD }
    { ProcessorArchitecture  WORD  }
    { Reserved               WORD  } ;
TYPEDEF: SP_ALTPLATFORM_INFO_V1* PSP_ALTPLATFORM_INFO_V1
TYPEDEF: SP_ALTPLATFORM_INFO_V2 SP_ALTPLATFORM_INFO
TYPEDEF: PSP_ALTPLATFORM_INFO_V2 PSP_ALTPLATFORM_INFO

CONSTANT: SP_ALTPLATFORM_FLAGS_VERSION_RANGE 1

STRUCT: SP_ORIGINAL_FILE_INFO_A
    { cbSize              DWORD          }
    { OriginalInfName     CHAR[MAX_PATH] }
    { OriginalCatalogName CHAR[MAX_PATH] } ;
TYPEDEF: SP_ORIGINAL_FILE_INFO_A* PSP_ORIGINAL_FILE_INFO_A
STRUCT: SP_ORIGINAL_FILE_INFO_W
    { cbSize              DWORD           }
    { OriginalInfName     WCHAR[MAX_PATH] }
    { OriginalCatalogName WCHAR[MAX_PATH] } ;
TYPEDEF: SP_ORIGINAL_FILE_INFO_W* PSP_ORIGINAL_FILE_INFO_W
TYPEDEF: SP_ORIGINAL_FILE_INFO_W SP_ORIGINAL_FILE_INFO
TYPEDEF: PSP_ORIGINAL_FILE_INFO_W PSP_ORIGINAL_FILE_INFO

CONSTANT: INF_STYLE_NONE           0x00000000
CONSTANT: INF_STYLE_OLDNT          0x00000001
CONSTANT: INF_STYLE_WIN4           0x00000002
CONSTANT: INF_STYLE_CACHE_ENABLE   0x00000010
CONSTANT: INF_STYLE_CACHE_DISABLE  0x00000020
CONSTANT: INF_STYLE_CACHE_IGNORE   0x00000040
CONSTANT: DIRID_ABSOLUTE          -1
CONSTANT: DIRID_ABSOLUTE_16BIT     0xffff
CONSTANT: DIRID_NULL               0
CONSTANT: DIRID_SRCPATH            1
CONSTANT: DIRID_WINDOWS           10
CONSTANT: DIRID_SYSTEM            11
CONSTANT: DIRID_DRIVERS           12
CONSTANT: DIRID_IOSUBSYS          $ DIRID_DRIVERS
CONSTANT: DIRID_INF               17
CONSTANT: DIRID_HELP              18
CONSTANT: DIRID_FONTS             20
CONSTANT: DIRID_VIEWERS           21
CONSTANT: DIRID_COLOR             23
CONSTANT: DIRID_APPS              24
CONSTANT: DIRID_SHARED            25
CONSTANT: DIRID_BOOT              30
CONSTANT: DIRID_SYSTEM16          50
CONSTANT: DIRID_SPOOL             51
CONSTANT: DIRID_SPOOLDRIVERS      52
CONSTANT: DIRID_USERPROFILE       53
CONSTANT: DIRID_LOADER            54
CONSTANT: DIRID_PRINTPROCESSOR    55
CONSTANT: DIRID_DEFAULT           $ DIRID_SYSTEM
CONSTANT: DIRID_COMMON_STARTMENU        16406
CONSTANT: DIRID_COMMON_PROGRAMS         16407
CONSTANT: DIRID_COMMON_STARTUP          16408
CONSTANT: DIRID_COMMON_DESKTOPDIRECTORY 16409
CONSTANT: DIRID_COMMON_FAVORITES        16415
CONSTANT: DIRID_COMMON_APPDATA          16419
CONSTANT: DIRID_PROGRAM_FILES           16422
CONSTANT: DIRID_SYSTEM_X86              16425
CONSTANT: DIRID_PROGRAM_FILES_X86       16426
CONSTANT: DIRID_PROGRAM_FILES_COMMON    16427
CONSTANT: DIRID_PROGRAM_FILES_COMMONX86 16428
CONSTANT: DIRID_COMMON_TEMPLATES        16429
CONSTANT: DIRID_COMMON_DOCUMENTS        16430
CONSTANT: DIRID_USER              0x8000
CALLBACK: UINT PSP_FILE_CALLBACK_A ( PVOID Context, UINT Notification, UINT_PTR Param1, UINT_PTR Param2 ) ;
CALLBACK: UINT PSP_FILE_CALLBACK_W ( PVOID Context, UINT Notification, UINT_PTR Param1, UINT_PTR Param2 ) ;
TYPEDEF: PSP_FILE_CALLBACK_W PSP_FILE_CALLBACK
CONSTANT: SPFILENOTIFY_STARTQUEUE         0x00000001
CONSTANT: SPFILENOTIFY_ENDQUEUE           0x00000002
CONSTANT: SPFILENOTIFY_STARTSUBQUEUE      0x00000003
CONSTANT: SPFILENOTIFY_ENDSUBQUEUE        0x00000004
CONSTANT: SPFILENOTIFY_STARTDELETE        0x00000005
CONSTANT: SPFILENOTIFY_ENDDELETE          0x00000006
CONSTANT: SPFILENOTIFY_DELETEERROR        0x00000007
CONSTANT: SPFILENOTIFY_STARTRENAME        0x00000008
CONSTANT: SPFILENOTIFY_ENDRENAME          0x00000009
CONSTANT: SPFILENOTIFY_RENAMEERROR        0x0000000a
CONSTANT: SPFILENOTIFY_STARTCOPY          0x0000000b
CONSTANT: SPFILENOTIFY_ENDCOPY            0x0000000c
CONSTANT: SPFILENOTIFY_COPYERROR          0x0000000d
CONSTANT: SPFILENOTIFY_NEEDMEDIA          0x0000000e
CONSTANT: SPFILENOTIFY_QUEUESCAN          0x0000000f
CONSTANT: SPFILENOTIFY_CABINETINFO        0x00000010
CONSTANT: SPFILENOTIFY_FILEINCABINET      0x00000011
CONSTANT: SPFILENOTIFY_NEEDNEWCABINET     0x00000012
CONSTANT: SPFILENOTIFY_FILEEXTRACTED      0x00000013
CONSTANT: SPFILENOTIFY_FILEOPDELAYED      0x00000014
CONSTANT: SPFILENOTIFY_STARTBACKUP        0x00000015
CONSTANT: SPFILENOTIFY_BACKUPERROR        0x00000016
CONSTANT: SPFILENOTIFY_ENDBACKUP          0x00000017
CONSTANT: SPFILENOTIFY_QUEUESCAN_EX       0x00000018
CONSTANT: SPFILENOTIFY_STARTREGISTRATION  0x00000019
CONSTANT: SPFILENOTIFY_ENDREGISTRATION    0x00000020
CONSTANT: SPFILENOTIFY_QUEUESCAN_SIGNERINFO 0x00000040
CONSTANT: SPFILENOTIFY_LANGMISMATCH       0x00010000
CONSTANT: SPFILENOTIFY_TARGETEXISTS       0x00020000
CONSTANT: SPFILENOTIFY_TARGETNEWER        0x00040000
CONSTANT: FILEOP_COPY                     0
CONSTANT: FILEOP_RENAME                   1
CONSTANT: FILEOP_DELETE                   2
CONSTANT: FILEOP_BACKUP                   3
CONSTANT: FILEOP_ABORT                    0
CONSTANT: FILEOP_DOIT                     1
CONSTANT: FILEOP_SKIP                     2
CONSTANT: FILEOP_RETRY                    $ FILEOP_DOIT
CONSTANT: FILEOP_NEWPATH                  4
CONSTANT: COPYFLG_WARN_IF_SKIP            0x00000001
CONSTANT: COPYFLG_NOSKIP                  0x00000002
CONSTANT: COPYFLG_NOVERSIONCHECK          0x00000004
CONSTANT: COPYFLG_FORCE_FILE_IN_USE       0x00000008
CONSTANT: COPYFLG_NO_OVERWRITE            0x00000010
CONSTANT: COPYFLG_NO_VERSION_DIALOG       0x00000020
CONSTANT: COPYFLG_OVERWRITE_OLDER_ONLY    0x00000040
CONSTANT: COPYFLG_PROTECTED_WINDOWS_DRIVER_FILE 0x00000100
CONSTANT: COPYFLG_REPLACEONLY             0x00000400
CONSTANT: COPYFLG_NODECOMP                0x00000800
CONSTANT: COPYFLG_REPLACE_BOOT_FILE       0x00001000
CONSTANT: COPYFLG_NOPRUNE                 0x00002000
CONSTANT: COPYFLG_IN_USE_TRY_RENAME       0x00004000
CONSTANT: DELFLG_IN_USE                   0x00000001
CONSTANT: DELFLG_IN_USE1                  0x00010000
STRUCT: FILEPATHS_A
    { Target       PCSTR }
    { Source       PCSTR }
    { Win32Error   UINT  }
    { Flags        DWORD } ;
TYPEDEF: FILEPATHS_A* PFILEPATHS_A
STRUCT: FILEPATHS_W
    { Target       PCWSTR }
    { Source       PCWSTR }
    { Win32Error   UINT   }
    { Flags        DWORD  } ;
TYPEDEF: FILEPATHS_W* PFILEPATHS_W
TYPEDEF: FILEPATHS_W FILEPATHS
TYPEDEF: PFILEPATHS_W PFILEPATHS
STRUCT: FILEPATHS_SIGNERINFO_A
    { Target         PCSTR }
    { Source         PCSTR }
    { Win32Error     UINT  }
    { Flags          DWORD }
    { DigitalSigner  PCSTR }
    { Version        PCSTR }
    { CatalogFile    PCSTR } ;
TYPEDEF: FILEPATHS_SIGNERINFO_A* PFILEPATHS_SIGNERINFO_A
STRUCT: FILEPATHS_SIGNERINFO_W
    { Target        PCWSTR }
    { Source        PCWSTR }
    { Win32Error    UINT   }
    { Flags         DWORD  }
    { DigitalSigner PCWSTR }
    { Version       PCWSTR }
    { CatalogFile   PCWSTR } ;
TYPEDEF: FILEPATHS_SIGNERINFO_W* PFILEPATHS_SIGNERINFO_W
TYPEDEF: FILEPATHS_SIGNERINFO_W FILEPATHS_SIGNERINFO
TYPEDEF: PFILEPATHS_SIGNERINFO_W PFILEPATHS_SIGNERINFO

STRUCT: SOURCE_MEDIA_A
    { Reserved    PCSTR }
    { Tagfile     PCSTR }
    { Description PCSTR }
    { SourcePath  PCSTR }
    { SourceFile  PCSTR }
    { Flags       DWORD } ;
TYPEDEF: SOURCE_MEDIA_A* PSOURCE_MEDIA_A
STRUCT: SOURCE_MEDIA_W
    { Reserved    PCWSTR }
    { Tagfile     PCWSTR }
    { Description PCWSTR }
    { SourcePath  PCWSTR }
    { SourceFile  PCWSTR }
    { Flags       DWORD  } ;
TYPEDEF: SOURCE_MEDIA_W* PSOURCE_MEDIA_W
TYPEDEF: SOURCE_MEDIA_W SOURCE_MEDIA
TYPEDEF: PSOURCE_MEDIA_W PSOURCE_MEDIA

STRUCT: CABINET_INFO_A
    { CabinetPath   PCSTR  }
    { CabinetFile   PCSTR  }
    { DiskName      PCSTR  }
    { SetId         USHORT }
    { CabinetNumber USHORT } ;
TYPEDEF: CABINET_INFO_A* PCABINET_INFO_A
STRUCT: CABINET_INFO_W
    { CabinetPath   PCWSTR }
    { CabinetFile   PCWSTR }
    { DiskName      PCWSTR }
    { SetId         USHORT }
    { CabinetNumber USHORT } ;
TYPEDEF: CABINET_INFO_W* PCABINET_INFO_W
TYPEDEF: CABINET_INFO_W CABINET_INFO
TYPEDEF: PCABINET_INFO_W PCABINET_INFO

STRUCT: FILE_IN_CABINET_INFO_A
    { NameInCabinet   PCSTR          }
    { FileSize        DWORD          }
    { Win32Error      DWORD          }
    { DosDate         WORD           }
    { DosTime         WORD           }
    { DosAttribs      WORD           }
    { FullTargetName  CHAR[MAX_PATH] } ;
TYPEDEF: FILE_IN_CABINET_INFO_A* PFILE_IN_CABINET_INFO_A
STRUCT: FILE_IN_CABINET_INFO_W
    { NameInCabinet   PCWSTR          }
    { FileSize        DWORD           }
    { Win32Error      DWORD           }
    { DosDate         WORD            }
    { DosTime         WORD            }
    { DosAttribs      WORD            }
    { FullTargetName  WCHAR[MAX_PATH] } ;
TYPEDEF: FILE_IN_CABINET_INFO_W* PFILE_IN_CABINET_INFO_W
TYPEDEF: FILE_IN_CABINET_INFO_W FILE_IN_CABINET_INFO
TYPEDEF: PFILE_IN_CABINET_INFO_W PFILE_IN_CABINET_INFO

STRUCT: SP_REGISTER_CONTROL_STATUSA
    { cbSize         DWORD }
    { FileName       PCSTR }
    { Win32Error     DWORD }
    { FailureCode    DWORD } ;
TYPEDEF: SP_REGISTER_CONTROL_STATUSA* PSP_REGISTER_CONTROL_STATUSA
STRUCT: SP_REGISTER_CONTROL_STATUSW
    { cbSize         DWORD  }
    { FileName       PCWSTR }
    { Win32Error     DWORD  }
    { FailureCode    DWORD  } ;
TYPEDEF: SP_REGISTER_CONTROL_STATUSW* PSP_REGISTER_CONTROL_STATUSW

TYPEDEF: SP_REGISTER_CONTROL_STATUSW SP_REGISTER_CONTROL_STATUS
TYPEDEF: PSP_REGISTER_CONTROL_STATUSW PSP_REGISTER_CONTROL_STATUS

CONSTANT: SPREG_SUCCESS       0x00000000
CONSTANT: SPREG_LOADLIBRARY   0x00000001
CONSTANT: SPREG_GETPROCADDR   0x00000002
CONSTANT: SPREG_REGSVR        0x00000003
CONSTANT: SPREG_DLLINSTALL    0x00000004
CONSTANT: SPREG_TIMEOUT       0x00000005
CONSTANT: SPREG_UNKNOWN       0xFFFFFFFF

TYPEDEF: PVOID HSPFILEQ

STRUCT: SP_FILE_COPY_PARAMS_A
    { cbSize                DWORD    }
    { QueueHandle           HSPFILEQ }
    { SourceRootPath        PCSTR    }
    { SourcePath            PCSTR    }
    { SourceFilename        PCSTR    }
    { SourceDescription     PCSTR    }
    { SourceTagfile         PCSTR    }
    { TargetDirectory       PCSTR    }
    { TargetFilename        PCSTR    }
    { CopyStyle             DWORD    }
    { LayoutInf             HINF     }
    { SecurityDescriptor    PCSTR    } ;
TYPEDEF: SP_FILE_COPY_PARAMS_A* PSP_FILE_COPY_PARAMS_A
STRUCT: SP_FILE_COPY_PARAMS_W
    { cbSize               DWORD    }
    { QueueHandle          HSPFILEQ }
    { SourceRootPath       PCWSTR   }
    { SourcePath           PCWSTR   }
    { SourceFilename       PCWSTR   }
    { SourceDescription    PCWSTR   }
    { SourceTagfile        PCWSTR   }
    { TargetDirectory      PCWSTR   }
    { TargetFilename       PCWSTR   }
    { CopyStyle            DWORD    }
    { LayoutInf            HINF     }
    { SecurityDescriptor   PCWSTR   } ;
TYPEDEF: SP_FILE_COPY_PARAMS_W* PSP_FILE_COPY_PARAMS_W

TYPEDEF: SP_FILE_COPY_PARAMS_W SP_FILE_COPY_PARAMS
TYPEDEF: PSP_FILE_COPY_PARAMS_W PSP_FILE_COPY_PARAMS

TYPEDEF: PVOID HDSKSPC
TYPEDEF: PVOID HDEVINFO

STRUCT: SP_DEVINFO_DATA
    { cbSize     DWORD     }
    { ClassGuid  GUID      }
    { DevInst    DWORD     }
    { Reserved   ULONG_PTR } ;
TYPEDEF: SP_DEVINFO_DATA* PSP_DEVINFO_DATA
STRUCT: SP_DEVICE_INTERFACE_DATA
    { cbSize              DWORD     }
    { InterfaceClassGuid  GUID      }
    { Flags               DWORD     }
    { Reserved            ULONG_PTR } ;
TYPEDEF: SP_DEVICE_INTERFACE_DATA* PSP_DEVICE_INTERFACE_DATA

CONSTANT: SPINT_ACTIVE  0x00000001
CONSTANT: SPINT_DEFAULT 0x00000002
CONSTANT: SPINT_REMOVED 0x00000004
TYPEDEF: SP_DEVICE_INTERFACE_DATA  SP_INTERFACE_DEVICE_DATA
TYPEDEF: PSP_DEVICE_INTERFACE_DATA PSP_INTERFACE_DEVICE_DAT
CONSTANT: SPID_ACTIVE               $ SPINT_ACTIVE
CONSTANT: SPID_DEFAULT              $ SPINT_DEFAULT
CONSTANT: SPID_REMOVED              $ SPINT_REMOVED

PACKED-STRUCT: SP_DEVICE_INTERFACE_DETAIL_DATA_A
    { cbSize     DWORD               }
    { DevicePath CHAR[ANYSIZE_ARRAY] } ;
TYPEDEF: SP_DEVICE_INTERFACE_DETAIL_DATA_A* PSP_DEVICE_INTERFACE_DETAIL_DATA_A
PACKED-STRUCT: SP_DEVICE_INTERFACE_DETAIL_DATA_W
    { cbSize      DWORD                }
    { DevicePath  WCHAR[ANYSIZE_ARRAY] } ;
TYPEDEF: SP_DEVICE_INTERFACE_DETAIL_DATA_W* PSP_DEVICE_INTERFACE_DETAIL_DATA_W
TYPEDEF: SP_DEVICE_INTERFACE_DETAIL_DATA_W SP_DEVICE_INTERFACE_DETAIL_DATA
TYPEDEF: PSP_DEVICE_INTERFACE_DETAIL_DATA_W PSP_DEVICE_INTERFACE_DETAIL_DATA
TYPEDEF: SP_DEVICE_INTERFACE_DETAIL_DATA_W SP_INTERFACE_DEVICE_DETAIL_DATA_W
TYPEDEF: PSP_DEVICE_INTERFACE_DETAIL_DATA_W PSP_INTERFACE_DEVICE_DETAIL_DATA_W
TYPEDEF: SP_DEVICE_INTERFACE_DETAIL_DATA_A SP_INTERFACE_DEVICE_DETAIL_DATA_A
TYPEDEF: PSP_DEVICE_INTERFACE_DETAIL_DATA_A PSP_INTERFACE_DEVICE_DETAIL_DATA_A

TYPEDEF: SP_INTERFACE_DEVICE_DETAIL_DATA_W SP_INTERFACE_DEVICE_DETAIL_DATA
TYPEDEF: PSP_INTERFACE_DEVICE_DETAIL_DATA_W PSP_INTERFACE_DEVICE_DETAIL_DATA

STRUCT: SP_DEVINFO_LIST_DETAIL_DATA_A
    { cbSize              DWORD                           }
    { ClassGuid           GUID                            }
    { RemoteMachineHandle HANDLE                          }
    { RemoteMachineName   CHAR[SP_MAX_MACHINENAME_LENGTH] } ;
TYPEDEF: SP_DEVINFO_LIST_DETAIL_DATA_A* PSP_DEVINFO_LIST_DETAIL_DATA_A
STRUCT: SP_DEVINFO_LIST_DETAIL_DATA_W
    { cbSize              DWORD                            }
    { ClassGuid           GUID                             }
    { RemoteMachineHandle HANDLE                           }
    { RemoteMachineName   WCHAR[SP_MAX_MACHINENAME_LENGTH] } ;
TYPEDEF: SP_DEVINFO_LIST_DETAIL_DATA_W* PSP_DEVINFO_LIST_DETAIL_DATA_W

TYPEDEF: SP_DEVINFO_LIST_DETAIL_DATA_W SP_DEVINFO_LIST_DETAIL_DATA
TYPEDEF: PSP_DEVINFO_LIST_DETAIL_DATA_W PSP_DEVINFO_LIST_DETAIL_DATA

CONSTANT: DIF_SELECTDEVICE                    0x00000001
CONSTANT: DIF_INSTALLDEVICE                   0x00000002
CONSTANT: DIF_ASSIGNRESOURCES                 0x00000003
CONSTANT: DIF_PROPERTIES                      0x00000004
CONSTANT: DIF_REMOVE                          0x00000005
CONSTANT: DIF_FIRSTTIMESETUP                  0x00000006
CONSTANT: DIF_FOUNDDEVICE                     0x00000007
CONSTANT: DIF_SELECTCLASSDRIVERS              0x00000008
CONSTANT: DIF_VALIDATECLASSDRIVERS            0x00000009
CONSTANT: DIF_INSTALLCLASSDRIVERS             0x0000000A
CONSTANT: DIF_CALCDISKSPACE                   0x0000000B
CONSTANT: DIF_DESTROYPRIVATEDATA              0x0000000C
CONSTANT: DIF_VALIDATEDRIVER                  0x0000000D
CONSTANT: DIF_DETECT                          0x0000000F
CONSTANT: DIF_INSTALLWIZARD                   0x00000010
CONSTANT: DIF_DESTROYWIZARDDATA               0x00000011
CONSTANT: DIF_PROPERTYCHANGE                  0x00000012
CONSTANT: DIF_ENABLECLASS                     0x00000013
CONSTANT: DIF_DETECTVERIFY                    0x00000014
CONSTANT: DIF_INSTALLDEVICEFILES              0x00000015
CONSTANT: DIF_UNREMOVE                        0x00000016
CONSTANT: DIF_SELECTBESTCOMPATDRV             0x00000017
CONSTANT: DIF_ALLOW_INSTALL                   0x00000018
CONSTANT: DIF_REGISTERDEVICE                  0x00000019
CONSTANT: DIF_NEWDEVICEWIZARD_PRESELECT       0x0000001A
CONSTANT: DIF_NEWDEVICEWIZARD_SELECT          0x0000001B
CONSTANT: DIF_NEWDEVICEWIZARD_PREANALYZE      0x0000001C
CONSTANT: DIF_NEWDEVICEWIZARD_POSTANALYZE     0x0000001D
CONSTANT: DIF_NEWDEVICEWIZARD_FINISHINSTALL   0x0000001E
CONSTANT: DIF_UNUSED1                         0x0000001F
CONSTANT: DIF_INSTALLINTERFACES               0x00000020
CONSTANT: DIF_DETECTCANCEL                    0x00000021
CONSTANT: DIF_REGISTER_COINSTALLERS           0x00000022
CONSTANT: DIF_ADDPROPERTYPAGE_ADVANCED        0x00000023
CONSTANT: DIF_ADDPROPERTYPAGE_BASIC           0x00000024
CONSTANT: DIF_RESERVED1                       0x00000025
CONSTANT: DIF_TROUBLESHOOTER                  0x00000026
CONSTANT: DIF_POWERMESSAGEWAKE                0x00000027
CONSTANT: DIF_ADDREMOTEPROPERTYPAGE_ADVANCED  0x00000028
CONSTANT: DIF_UPDATEDRIVER_UI                 0x00000029
CONSTANT: DIF_FINISHINSTALL_ACTION            0x0000002A
CONSTANT: DIF_RESERVED2                       0x00000030
CONSTANT: DIF_MOVEDEVICE                      0x0000000E
TYPEDEF: UINT DI_FUNCTION

STRUCT: SP_DEVINSTALL_PARAMS_A
    { cbSize                               DWORD             }
    { Flags                                DWORD             }
    { FlagsEx                              DWORD             }
    { hwndParent                           HWND              }
    { InstallMsgHandler                    PSP_FILE_CALLBACK }
    { InstallMsgHandlerContext             PVOID             }
    { FileQueue                            HSPFILEQ          }
    { ClassInstallReserved                 ULONG_PTR         }
    { Reserved                             DWORD             }
    { DriverPath                           CHAR[MAX_PATH]    } ;
TYPEDEF: SP_DEVINSTALL_PARAMS_A* PSP_DEVINSTALL_PARAMS_A
STRUCT: SP_DEVINSTALL_PARAMS_W
    { cbSize                               DWORD             }
    { Flags                                DWORD             }
    { FlagsEx                              DWORD             }
    { hwndParent                           HWND              }
    { InstallMsgHandler                    PSP_FILE_CALLBACK }
    { InstallMsgHandlerContext             PVOID             }
    { FileQueue                            HSPFILEQ          }
    { ClassInstallReserved                 ULONG_PTR         }
    { Reserved                             DWORD             }
    { DriverPath                           WCHAR[MAX_PATH]   } ;
TYPEDEF: SP_DEVINSTALL_PARAMS_W* PSP_DEVINSTALL_PARAMS_W
TYPEDEF: SP_DEVINSTALL_PARAMS_W SP_DEVINSTALL_PARAMS
TYPEDEF: PSP_DEVINSTALL_PARAMS_W PSP_DEVINSTALL_PARAMS

CONSTANT: DI_SHOWOEM                  0x00000001
CONSTANT: DI_SHOWCOMPAT               0x00000002
CONSTANT: DI_SHOWCLASS                0x00000004
CONSTANT: DI_SHOWALL                  0x00000007
CONSTANT: DI_NOVCP                    0x00000008
CONSTANT: DI_DIDCOMPAT                0x00000010
CONSTANT: DI_DIDCLASS                 0x00000020
CONSTANT: DI_AUTOASSIGNRES            0x00000040
CONSTANT: DI_NEEDRESTART              0x00000080
CONSTANT: DI_NEEDREBOOT               0x00000100
CONSTANT: DI_NOBROWSE                 0x00000200
CONSTANT: DI_MULTMFGS                 0x00000400
CONSTANT: DI_DISABLED                 0x00000800
CONSTANT: DI_GENERALPAGE_ADDED        0x00001000
CONSTANT: DI_RESOURCEPAGE_ADDED       0x00002000
CONSTANT: DI_PROPERTIES_CHANGE        0x00004000
CONSTANT: DI_INF_IS_SORTED            0x00008000
CONSTANT: DI_ENUMSINGLEINF            0x00010000
CONSTANT: DI_DONOTCALLCONFIGMG        0x00020000
CONSTANT: DI_INSTALLDISABLED          0x00040000
CONSTANT: DI_COMPAT_FROM_CLASS        0x00080000
CONSTANT: DI_CLASSINSTALLPARAMS       0x00100000
CONSTANT: DI_NODI_DEFAULTACTION       0x00200000
CONSTANT: DI_QUIETINSTALL             0x00800000
CONSTANT: DI_NOFILECOPY               0x01000000
CONSTANT: DI_FORCECOPY                0x02000000
CONSTANT: DI_DRIVERPAGE_ADDED         0x04000000
CONSTANT: DI_USECI_SELECTSTRINGS      0x08000000
CONSTANT: DI_OVERRIDE_INFFLAGS        0x10000000
CONSTANT: DI_PROPS_NOCHANGEUSAGE      0x20000000
CONSTANT: DI_NOSELECTICONS            0x40000000
CONSTANT: DI_NOWRITE_IDS              0x80000000
CONSTANT: DI_FLAGSEX_RESERVED2                0x00000001
CONSTANT: DI_FLAGSEX_RESERVED3                0x00000002
CONSTANT: DI_FLAGSEX_CI_FAILED                0x00000004
CONSTANT: DI_FLAGSEX_FINISHINSTALL_ACTION     0x00000008
CONSTANT: DI_FLAGSEX_DIDINFOLIST              0x00000010
CONSTANT: DI_FLAGSEX_DIDCOMPATINFO            0x00000020
CONSTANT: DI_FLAGSEX_FILTERCLASSES            0x00000040
CONSTANT: DI_FLAGSEX_SETFAILEDINSTALL         0x00000080
CONSTANT: DI_FLAGSEX_DEVICECHANGE             0x00000100
CONSTANT: DI_FLAGSEX_ALWAYSWRITEIDS           0x00000200
CONSTANT: DI_FLAGSEX_PROPCHANGE_PENDING       0x00000400
CONSTANT: DI_FLAGSEX_ALLOWEXCLUDEDDRVS        0x00000800
CONSTANT: DI_FLAGSEX_NOUIONQUERYREMOVE        0x00001000
CONSTANT: DI_FLAGSEX_USECLASSFORCOMPAT        0x00002000
CONSTANT: DI_FLAGSEX_RESERVED4                0x00004000
CONSTANT: DI_FLAGSEX_NO_DRVREG_MODIFY         0x00008000
CONSTANT: DI_FLAGSEX_IN_SYSTEM_SETUP          0x00010000
CONSTANT: DI_FLAGSEX_INET_DRIVER              0x00020000
CONSTANT: DI_FLAGSEX_APPENDDRIVERLIST         0x00040000
CONSTANT: DI_FLAGSEX_PREINSTALLBACKUP         0x00080000
CONSTANT: DI_FLAGSEX_BACKUPONREPLACE          0x00100000
CONSTANT: DI_FLAGSEX_DRIVERLIST_FROM_URL      0x00200000
CONSTANT: DI_FLAGSEX_RESERVED1                0x00400000
CONSTANT: DI_FLAGSEX_EXCLUDE_OLD_INET_DRIVERS 0x00800000
CONSTANT: DI_FLAGSEX_POWERPAGE_ADDED          0x01000000
CONSTANT: DI_FLAGSEX_FILTERSIMILARDRIVERS     0x02000000
CONSTANT: DI_FLAGSEX_INSTALLEDDRIVER          0x04000000
CONSTANT: DI_FLAGSEX_NO_CLASSLIST_NODE_MERGE  0x08000000
CONSTANT: DI_FLAGSEX_ALTPLATFORM_DRVSEARCH    0x10000000
CONSTANT: DI_FLAGSEX_RESTART_DEVICE_ONLY      0x20000000
CONSTANT: DI_FLAGSEX_RECURSIVESEARCH          0x40000000
CONSTANT: DI_FLAGSEX_SEARCH_PUBLISHED_INFS    0x80000000

STRUCT: SP_CLASSINSTALL_HEADER
    { cbSize          DWORD       }
    { InstallFunction DI_FUNCTION } ;
TYPEDEF: SP_CLASSINSTALL_HEADER* PSP_CLASSINSTALL_HEADER

STRUCT: SP_ENABLECLASS_PARAMS
    { ClassInstallHeader             SP_CLASSINSTALL_HEADER }
    { ClassGuid                      GUID                   }
    { EnableMessage                  DWORD                  } ;
TYPEDEF: SP_ENABLECLASS_PARAMS* PSP_ENABLECLASS_PARAMS

CONSTANT: ENABLECLASS_QUERY   0
CONSTANT: ENABLECLASS_SUCCESS 1
CONSTANT: ENABLECLASS_FAILURE 2
CONSTANT: DICS_ENABLE      0x00000001
CONSTANT: DICS_DISABLE     0x00000002
CONSTANT: DICS_PROPCHANGE  0x00000003
CONSTANT: DICS_START       0x00000004
CONSTANT: DICS_STOP        0x00000005
CONSTANT: DICS_FLAG_GLOBAL         0x00000001
CONSTANT: DICS_FLAG_CONFIGSPECIFIC 0x00000002
CONSTANT: DICS_FLAG_CONFIGGENERAL  0x00000004

STRUCT: SP_PROPCHANGE_PARAMS
    { ClassInstallHeader           SP_CLASSINSTALL_HEADER }
    { StateChange                  DWORD                  }
    { Scope                        DWORD                  }
    { HwProfile                    DWORD                  } ;
TYPEDEF: SP_PROPCHANGE_PARAMS* PSP_PROPCHANGE_PARAMS

STRUCT: SP_REMOVEDEVICE_PARAMS
    { ClassInstallHeader SP_CLASSINSTALL_HEADER }
    { Scope              DWORD                  }
    { HwProfile          DWORD                  } ;
TYPEDEF: SP_REMOVEDEVICE_PARAMS* PSP_REMOVEDEVICE_PARAMS

CONSTANT: DI_REMOVEDEVICE_GLOBAL                  0x00000001
CONSTANT: DI_REMOVEDEVICE_CONFIGSPECIFIC          0x00000002

STRUCT: SP_UNREMOVEDEVICE_PARAMS
    { ClassInstallHeader SP_CLASSINSTALL_HEADER }
    { Scope              DWORD                  }
    { HwProfile          DWORD                  } ;
TYPEDEF: SP_UNREMOVEDEVICE_PARAMS* PSP_UNREMOVEDEVICE_PARAMS

CONSTANT: DI_UNREMOVEDEVICE_CONFIGSPECIFIC        0x00000002

STRUCT: SP_SELECTDEVICE_PARAMS_A
    { ClassInstallHeader             SP_CLASSINSTALL_HEADER    }
    { Title                          CHAR[MAX_TITLE_LEN]       }
    { Instructions                   CHAR[MAX_INSTRUCTION_LEN] }
    { ListLabel                      CHAR[MAX_LABEL_LEN]       }
    { SubTitle                       CHAR[MAX_SUBTITLE_LEN]    }
    { Reserved                       BYTE[2]                   } ;
TYPEDEF: SP_SELECTDEVICE_PARAMS_A* PSP_SELECTDEVICE_PARAMS_A
STRUCT: SP_SELECTDEVICE_PARAMS_W
    { ClassInstallHeader            SP_CLASSINSTALL_HEADER     }
    { Title                         WCHAR[MAX_TITLE_LEN]       }
    { Instructions                  WCHAR[MAX_INSTRUCTION_LEN] }
    { ListLabel                     WCHAR[MAX_LABEL_LEN]       }
    { SubTitle                      WCHAR[MAX_SUBTITLE_LEN]    } ;
TYPEDEF: SP_SELECTDEVICE_PARAMS_W* PSP_SELECTDEVICE_PARAMS_W
TYPEDEF: SP_SELECTDEVICE_PARAMS_W SP_SELECTDEVICE_PARAMS
TYPEDEF: PSP_SELECTDEVICE_PARAMS_W PSP_SELECTDEVICE_PARAMS

CALLBACK: BOOL PDETECT_PROGRESS_NOTIFY ( PVOID ProgressNotifyParam, DWORD DetectComplete ) ;

STRUCT: SP_DETECTDEVICE_PARAMS
    { ClassInstallHeader                    SP_CLASSINSTALL_HEADER  }
    { DetectProgressNotify                  PDETECT_PROGRESS_NOTIFY }
    { ProgressNotifyParam                   PVOID                   } ;
TYPEDEF: SP_DETECTDEVICE_PARAMS* PSP_DETECTDEVICE_PARAMS

CONSTANT: MAX_INSTALLWIZARD_DYNAPAGES 20

STRUCT: SP_INSTALLWIZARD_DATA
    { ClassInstallHeader                SP_CLASSINSTALL_HEADER                      }
    { Flags                             DWORD                                       }
    { DynamicPages                      HPROPSHEETPAGE[MAX_INSTALLWIZARD_DYNAPAGES] }
    { NumDynamicPages                   DWORD                                       }
    { DynamicPageFlags                  DWORD                                       }
    { PrivateFlags                      DWORD                                       }
    { PrivateData                       LPARAM                                      }
    { hwndWizardDlg                     HWND                                        } ;
TYPEDEF: SP_INSTALLWIZARD_DATA* PSP_INSTALLWIZARD_DATA

CONSTANT: NDW_INSTALLFLAG_DIDFACTDEFS         0x00000001
CONSTANT: NDW_INSTALLFLAG_HARDWAREALLREADYIN  0x00000002
CONSTANT: NDW_INSTALLFLAG_NEEDRESTART         $ DI_NEEDRESTART
CONSTANT: NDW_INSTALLFLAG_NEEDREBOOT          $ DI_NEEDREBOOT
CONSTANT: NDW_INSTALLFLAG_NEEDSHUTDOWN        0x00000200
CONSTANT: NDW_INSTALLFLAG_EXPRESSINTRO        0x00000400
CONSTANT: NDW_INSTALLFLAG_SKIPISDEVINSTALLED  0x00000800
CONSTANT: NDW_INSTALLFLAG_NODETECTEDDEVS      0x00001000
CONSTANT: NDW_INSTALLFLAG_INSTALLSPECIFIC     0x00002000
CONSTANT: NDW_INSTALLFLAG_SKIPCLASSLIST       0x00004000
CONSTANT: NDW_INSTALLFLAG_CI_PICKED_OEM       0x00008000
CONSTANT: NDW_INSTALLFLAG_PCMCIAMODE          0x00010000
CONSTANT: NDW_INSTALLFLAG_PCMCIADEVICE        0x00020000
CONSTANT: NDW_INSTALLFLAG_USERCANCEL          0x00040000
CONSTANT: NDW_INSTALLFLAG_KNOWNCLASS          0x00080000
CONSTANT: DYNAWIZ_FLAG_PAGESADDED             0x00000001
CONSTANT: DYNAWIZ_FLAG_ANALYZE_HANDLECONFLICT 0x00000008
CONSTANT: DYNAWIZ_FLAG_INSTALLDET_NEXT        0x00000002
CONSTANT: DYNAWIZ_FLAG_INSTALLDET_PREV        0x00000004
CONSTANT: MIN_IDD_DYNAWIZ_RESOURCE_ID             10000
CONSTANT: MAX_IDD_DYNAWIZ_RESOURCE_ID             11000
CONSTANT: IDD_DYNAWIZ_FIRSTPAGE                   10000
CONSTANT: IDD_DYNAWIZ_SELECT_PREVPAGE             10001
CONSTANT: IDD_DYNAWIZ_SELECT_NEXTPAGE             10002
CONSTANT: IDD_DYNAWIZ_ANALYZE_PREVPAGE            10003
CONSTANT: IDD_DYNAWIZ_ANALYZE_NEXTPAGE            10004
CONSTANT: IDD_DYNAWIZ_SELECTDEV_PAGE              10009
CONSTANT: IDD_DYNAWIZ_ANALYZEDEV_PAGE             10010
CONSTANT: IDD_DYNAWIZ_INSTALLDETECTEDDEVS_PAGE    10011
CONSTANT: IDD_DYNAWIZ_SELECTCLASS_PAGE            10012
CONSTANT: IDD_DYNAWIZ_INSTALLDETECTED_PREVPAGE    10006
CONSTANT: IDD_DYNAWIZ_INSTALLDETECTED_NEXTPAGE    10007
CONSTANT: IDD_DYNAWIZ_INSTALLDETECTED_NODEVS      10008

STRUCT: SP_NEWDEVICEWIZARD_DATA
    { ClassInstallHeader SP_CLASSINSTALL_HEADER                      }
    { Flags              DWORD                                       }
    { DynamicPages       HPROPSHEETPAGE[MAX_INSTALLWIZARD_DYNAPAGES] }
    { NumDynamicPages    DWORD                                       }
    { hwndWizardDlg      HWND                                        } ;
TYPEDEF: SP_NEWDEVICEWIZARD_DATA* PSP_NEWDEVICEWIZARD_DATA
TYPEDEF: SP_NEWDEVICEWIZARD_DATA SP_ADDPROPERTYPAGE_DATA
TYPEDEF: PSP_NEWDEVICEWIZARD_DATA PSP_ADDPROPERTYPAGE_DATA

STRUCT: SP_TROUBLESHOOTER_PARAMS_A
    { ClassInstallHeader SP_CLASSINSTALL_HEADER }
    { ChmFile            CHAR[MAX_PATH]         }
    { HtmlTroubleShooter CHAR[MAX_PATH]         } ;
TYPEDEF: SP_TROUBLESHOOTER_PARAMS_A* PSP_TROUBLESHOOTER_PARAMS_A
STRUCT: SP_TROUBLESHOOTER_PARAMS_W
    { ClassInstallHeader SP_CLASSINSTALL_HEADER }
    { ChmFile            WCHAR[MAX_PATH]        }
    { HtmlTroubleShooter WCHAR[MAX_PATH]        } ;
TYPEDEF: SP_TROUBLESHOOTER_PARAMS_W* PSP_TROUBLESHOOTER_PARAMS_W
TYPEDEF: SP_TROUBLESHOOTER_PARAMS_W SP_TROUBLESHOOTER_PARAMS
TYPEDEF: PSP_TROUBLESHOOTER_PARAMS_W PSP_TROUBLESHOOTER_PARAMS

STRUCT: SP_POWERMESSAGEWAKE_PARAMS_A
    { ClassInstallHeader     SP_CLASSINSTALL_HEADER }
    { PowerMessageWake       CHAR[LINE_LEN*2]       } ;
TYPEDEF: SP_POWERMESSAGEWAKE_PARAMS_A* PSP_POWERMESSAGEWAKE_PARAMS_A
STRUCT: SP_POWERMESSAGEWAKE_PARAMS_W
    { ClassInstallHeader    SP_CLASSINSTALL_HEADER }
    { PowerMessageWake      WCHAR[LINE_LEN*2]      } ;
TYPEDEF: SP_POWERMESSAGEWAKE_PARAMS_W* PSP_POWERMESSAGEWAKE_PARAMS_W
TYPEDEF: SP_POWERMESSAGEWAKE_PARAMS_W SP_POWERMESSAGEWAKE_PARAMS
TYPEDEF: PSP_POWERMESSAGEWAKE_PARAMS_W PSP_POWERMESSAGEWAKE_PARAMS

STRUCT: SP_DRVINFO_DATA_V2_A
    { cbSize         DWORD          }
    { DriverType     DWORD          }
    { Reserved       ULONG_PTR      }
    { Description    CHAR[LINE_LEN] }
    { MfgName        CHAR[LINE_LEN] }
    { ProviderName   CHAR[LINE_LEN] }
    { DriverDate     FILETIME       }
    { DriverVersion  DWORDLONG      } ;
TYPEDEF: SP_DRVINFO_DATA_V2_A* PSP_DRVINFO_DATA_V2_A
STRUCT: SP_DRVINFO_DATA_V2_W
    { cbSize         DWORD           }
    { DriverType     DWORD           }
    { Reserved       ULONG_PTR       }
    { Description    WCHAR[LINE_LEN] }
    { MfgName        WCHAR[LINE_LEN] }
    { ProviderName   WCHAR[LINE_LEN] }
    { DriverDate     FILETIME        }
    { DriverVersion  DWORDLONG       } ;
TYPEDEF: SP_DRVINFO_DATA_V2_W* PSP_DRVINFO_DATA_V2_W
STRUCT: SP_DRVINFO_DATA_V1_A
    { cbSize         DWORD          }
    { DriverType     DWORD          }
    { Reserved       ULONG_PTR      }
    { Description    CHAR[LINE_LEN] }
    { MfgName        CHAR[LINE_LEN] }
    { ProviderName   CHAR[LINE_LEN] } ;
TYPEDEF: SP_DRVINFO_DATA_V1_A* PSP_DRVINFO_DATA_V1_A
STRUCT: SP_DRVINFO_DATA_V1_W
    { cbSize         DWORD           }
    { DriverType     DWORD           }
    { Reserved       ULONG_PTR       }
    { Description    WCHAR[LINE_LEN] }
    { MfgName        WCHAR[LINE_LEN] }
    { ProviderName   WCHAR[LINE_LEN] } ;
TYPEDEF: SP_DRVINFO_DATA_V1_W* PSP_DRVINFO_DATA_V1_W
TYPEDEF: SP_DRVINFO_DATA_V1_W SP_DRVINFO_DATA_V1
TYPEDEF: PSP_DRVINFO_DATA_V1_W PSP_DRVINFO_DATA_V1
TYPEDEF: SP_DRVINFO_DATA_V2_W SP_DRVINFO_DATA_V2
TYPEDEF: PSP_DRVINFO_DATA_V2_W PSP_DRVINFO_DATA_V2
TYPEDEF: SP_DRVINFO_DATA_V2_A SP_DRVINFO_DATA_A
TYPEDEF: PSP_DRVINFO_DATA_V2_A PSP_DRVINFO_DATA_A
TYPEDEF: SP_DRVINFO_DATA_V2_W SP_DRVINFO_DATA_W
TYPEDEF: PSP_DRVINFO_DATA_V2_W PSP_DRVINFO_DATA_W
TYPEDEF: SP_DRVINFO_DATA_V2 SP_DRVINFO_DATA
TYPEDEF: PSP_DRVINFO_DATA_V2 PSP_DRVINFO_DATA

STRUCT: SP_DRVINFO_DETAIL_DATA_A
    { cbSize             DWORD               }
    { InfDate            FILETIME            }
    { CompatIDsOffset    DWORD               }
    { CompatIDsLength    DWORD               }
    { Reserved           ULONG_PTR           }
    { SectionName        CHAR[LINE_LEN]      }
    { InfFileName        CHAR[MAX_PATH]      }
    { DrvDescription     CHAR[LINE_LEN]      }
    { HardwareID         CHAR[ANYSIZE_ARRAY] } ;
TYPEDEF: SP_DRVINFO_DETAIL_DATA_A* PSP_DRVINFO_DETAIL_DATA_A
STRUCT: SP_DRVINFO_DETAIL_DATA_W
    { cbSize             DWORD                }
    { InfDate            FILETIME             }
    { CompatIDsOffset    DWORD                }
    { CompatIDsLength    DWORD                }
    { Reserved           ULONG_PTR            }
    { SectionName        WCHAR[LINE_LEN]      }
    { InfFileName        WCHAR[MAX_PATH]      }
    { DrvDescription     WCHAR[LINE_LEN]      }
    { HardwareID         WCHAR[ANYSIZE_ARRAY] } ;
TYPEDEF: SP_DRVINFO_DETAIL_DATA_W* PSP_DRVINFO_DETAIL_DATA_W

TYPEDEF: SP_DRVINFO_DETAIL_DATA_W SP_DRVINFO_DETAIL_DATA
TYPEDEF: PSP_DRVINFO_DETAIL_DATA_W PSP_DRVINFO_DETAIL_DATA

STRUCT: SP_DRVINSTALL_PARAMS
    { cbSize      DWORD     }
    { Rank        DWORD     }
    { Flags       DWORD     }
    { PrivateData DWORD_PTR }
    { Reserved    DWORD     } ;
TYPEDEF: SP_DRVINSTALL_PARAMS* PSP_DRVINSTALL_PARAMS

CONSTANT: DNF_DUPDESC             0x00000001
CONSTANT: DNF_OLDDRIVER           0x00000002
CONSTANT: DNF_EXCLUDEFROMLIST     0x00000004
CONSTANT: DNF_NODRIVER            0x00000008
CONSTANT: DNF_LEGACYINF           0x00000010
CONSTANT: DNF_CLASS_DRIVER        0x00000020
CONSTANT: DNF_COMPATIBLE_DRIVER   0x00000040
CONSTANT: DNF_INET_DRIVER         0x00000080
CONSTANT: DNF_UNUSED1             0x00000100
CONSTANT: DNF_UNUSED2             0x00000200
CONSTANT: DNF_OLD_INET_DRIVER     0x00000400
CONSTANT: DNF_BAD_DRIVER          0x00000800
CONSTANT: DNF_DUPPROVIDER         0x00001000
CONSTANT: DNF_INF_IS_SIGNED         0x00002000
CONSTANT: DNF_OEM_F6_INF            0x00004000
CONSTANT: DNF_DUPDRIVERVER          0x00008000
CONSTANT: DNF_BASIC_DRIVER          0x00010000
CONSTANT: DNF_AUTHENTICODE_SIGNED   0x00020000
CONSTANT: DNF_INSTALLEDDRIVER       0x00040000
CONSTANT: DNF_ALWAYSEXCLUDEFROMLIST 0x00080000
CONSTANT: DNF_INBOX_DRIVER          0x00100000
CONSTANT: DNF_REQUESTADDITIONALSOFTWARE   0x00200000
CONSTANT: DNF_UNUSED_22             0x00400000
CONSTANT: DNF_UNUSED_23             0x00800000
CONSTANT: DNF_UNUSED_24             0x01000000
CONSTANT: DNF_UNUSED_25             0x02000000
CONSTANT: DNF_UNUSED_26             0x04000000
CONSTANT: DNF_UNUSED_27             0x08000000
CONSTANT: DNF_UNUSED_28             0x10000000
CONSTANT: DNF_UNUSED_29             0x20000000
CONSTANT: DNF_UNUSED_30             0x40000000
CONSTANT: DNF_UNUSED_31             0x80000000
CONSTANT: DRIVER_HARDWAREID_RANK  0x00000FFF
CONSTANT: DRIVER_HARDWAREID_MASK  0x80000FFF
CONSTANT: DRIVER_UNTRUSTED_RANK   0x80000000
CONSTANT: DRIVER_W9X_SUSPECT_RANK 0xC0000000

CALLBACK: DWORD PSP_DETSIG_CMPPROC ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA NewDeviceData, PSP_DEVINFO_DATA ExistingDeviceData, PVOID CompareContext ) ;

STRUCT: COINSTALLER_CONTEXT_DATA
    { PostProcessing  BOOL  }
    { InstallResult   DWORD }
    { PrivateData     PVOID } ;
TYPEDEF: COINSTALLER_CONTEXT_DATA* PCOINSTALLER_CONTEXT_DATA

STRUCT: SP_CLASSIMAGELIST_DATA
    { cbSize      DWORD      }
    { ImageList   HIMAGELIST }
    { Reserved    ULONG_PTR  } ;
TYPEDEF: SP_CLASSIMAGELIST_DATA* PSP_CLASSIMAGELIST_DATA

STRUCT: SP_PROPSHEETPAGE_REQUEST
    { cbSize                   DWORD            }
    { PageRequested            DWORD            }
    { DeviceInfoSet            HDEVINFO         }
    { DeviceInfoData           PSP_DEVINFO_DATA } ;
TYPEDEF: SP_PROPSHEETPAGE_REQUEST* PSP_PROPSHEETPAGE_REQUEST

CONSTANT: SPPSR_SELECT_DEVICE_RESOURCES      1
CONSTANT: SPPSR_ENUM_BASIC_DEVICE_PROPERTIES 2
CONSTANT: SPPSR_ENUM_ADV_DEVICE_PROPERTIES   3

STRUCT: SP_BACKUP_QUEUE_PARAMS_V2_A
    { cbSize              DWORD          }
    { FullInfPath         CHAR[MAX_PATH] }
    { FilenameOffset      INT            }
    { ReinstallInstance   CHAR[MAX_PATH] } ;
TYPEDEF: SP_BACKUP_QUEUE_PARAMS_V2_A* PSP_BACKUP_QUEUE_PARAMS_V2_A

STRUCT: SP_BACKUP_QUEUE_PARAMS_V2_W
    { cbSize              DWORD           }
    { FullInfPath         WCHAR[MAX_PATH] }
    { FilenameOffset      INT             }
    { ReinstallInstance   WCHAR[MAX_PATH] } ;
TYPEDEF: SP_BACKUP_QUEUE_PARAMS_V2_W* PSP_BACKUP_QUEUE_PARAMS_V2_W

STRUCT: SP_BACKUP_QUEUE_PARAMS_V1_A
    { cbSize              DWORD          }
    { FullInfPath         CHAR[MAX_PATH] }
    { FilenameOffset      INT            } ;
TYPEDEF: SP_BACKUP_QUEUE_PARAMS_V1_A* PSP_BACKUP_QUEUE_PARAMS_V1_A

STRUCT: SP_BACKUP_QUEUE_PARAMS_V1_W
    { cbSize              DWORD           }
    { FullInfPath         WCHAR[MAX_PATH] }
    { FilenameOffset      INT             } ;
TYPEDEF: SP_BACKUP_QUEUE_PARAMS_V1_W* PSP_BACKUP_QUEUE_PARAMS_V1_W

TYPEDEF: SP_BACKUP_QUEUE_PARAMS_V1_W SP_BACKUP_QUEUE_PARAMS_V1
TYPEDEF: PSP_BACKUP_QUEUE_PARAMS_V1_W PSP_BACKUP_QUEUE_PARAMS_V1
TYPEDEF: SP_BACKUP_QUEUE_PARAMS_V2_W SP_BACKUP_QUEUE_PARAMS_V2
TYPEDEF: PSP_BACKUP_QUEUE_PARAMS_V2_W PSP_BACKUP_QUEUE_PARAMS_V2
TYPEDEF: SP_BACKUP_QUEUE_PARAMS_V2_A SP_BACKUP_QUEUE_PARAMS_A
TYPEDEF: PSP_BACKUP_QUEUE_PARAMS_V2_A PSP_BACKUP_QUEUE_PARAMS_A
TYPEDEF: SP_BACKUP_QUEUE_PARAMS_V2_W SP_BACKUP_QUEUE_PARAMS_W
TYPEDEF: PSP_BACKUP_QUEUE_PARAMS_V2_W PSP_BACKUP_QUEUE_PARAMS_W
TYPEDEF: SP_BACKUP_QUEUE_PARAMS_V2 SP_BACKUP_QUEUE_PARAMS
TYPEDEF: PSP_BACKUP_QUEUE_PARAMS_V2 PSP_BACKUP_QUEUE_PARAMS

CONSTANT: ERROR_EXPECTED_SECTION_NAME  $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0 bitor bitor ]
CONSTANT: ERROR_BAD_SECTION_NAME_LINE  $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 1 bitor bitor ]
CONSTANT: ERROR_SECTION_NAME_TOO_LONG  $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 2 bitor bitor ]
CONSTANT: ERROR_GENERAL_SYNTAX         $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 3 bitor bitor ]
CONSTANT: ERROR_WRONG_INF_STYLE        $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x100 bitor bitor ]
CONSTANT: ERROR_SECTION_NOT_FOUND      $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x101 bitor bitor ]
CONSTANT: ERROR_LINE_NOT_FOUND         $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x102 bitor bitor ]
CONSTANT: ERROR_NO_BACKUP              $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x103 bitor bitor ]
CONSTANT: ERROR_NO_ASSOCIATED_CLASS                $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x200 bitor bitor ]
CONSTANT: ERROR_CLASS_MISMATCH                     $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x201 bitor bitor ]
CONSTANT: ERROR_DUPLICATE_FOUND                    $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x202 bitor bitor ]
CONSTANT: ERROR_NO_DRIVER_SELECTED                 $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x203 bitor bitor ]
CONSTANT: ERROR_KEY_DOES_NOT_EXIST                 $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x204 bitor bitor ]
CONSTANT: ERROR_INVALID_DEVINST_NAME               $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x205 bitor bitor ]
CONSTANT: ERROR_INVALID_CLASS                      $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x206 bitor bitor ]
CONSTANT: ERROR_DEVINST_ALREADY_EXISTS             $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x207 bitor bitor ]
CONSTANT: ERROR_DEVINFO_NOT_REGISTERED             $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x208 bitor bitor ]
CONSTANT: ERROR_INVALID_REG_PROPERTY               $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x209 bitor bitor ]
CONSTANT: ERROR_NO_INF                             $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x20A bitor bitor ]
CONSTANT: ERROR_NO_SUCH_DEVINST                    $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x20B bitor bitor ]
CONSTANT: ERROR_CANT_LOAD_CLASS_ICON               $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x20C bitor bitor ]
CONSTANT: ERROR_INVALID_CLASS_INSTALLER            $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x20D bitor bitor ]
CONSTANT: ERROR_DI_DO_DEFAULT                      $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x20E bitor bitor ]
CONSTANT: ERROR_DI_NOFILECOPY                      $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x20F bitor bitor ]
CONSTANT: ERROR_INVALID_HWPROFILE                  $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x210 bitor bitor ]
CONSTANT: ERROR_NO_DEVICE_SELECTED                 $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x211 bitor bitor ]
CONSTANT: ERROR_DEVINFO_LIST_LOCKED                $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x212 bitor bitor ]
CONSTANT: ERROR_DEVINFO_DATA_LOCKED                $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x213 bitor bitor ]
CONSTANT: ERROR_DI_BAD_PATH                        $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x214 bitor bitor ]
CONSTANT: ERROR_NO_CLASSINSTALL_PARAMS             $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x215 bitor bitor ]
CONSTANT: ERROR_FILEQUEUE_LOCKED                   $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x216 bitor bitor ]
CONSTANT: ERROR_BAD_SERVICE_INSTALLSECT            $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x217 bitor bitor ]
CONSTANT: ERROR_NO_CLASS_DRIVER_LIST               $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x218 bitor bitor ]
CONSTANT: ERROR_NO_ASSOCIATED_SERVICE              $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x219 bitor bitor ]
CONSTANT: ERROR_NO_DEFAULT_DEVICE_INTERFACE        $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x21A bitor bitor ]
CONSTANT: ERROR_DEVICE_INTERFACE_ACTIVE            $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x21B bitor bitor ]
CONSTANT: ERROR_DEVICE_INTERFACE_REMOVED           $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x21C bitor bitor ]
CONSTANT: ERROR_BAD_INTERFACE_INSTALLSECT          $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x21D bitor bitor ]
CONSTANT: ERROR_NO_SUCH_INTERFACE_CLASS            $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x21E bitor bitor ]
CONSTANT: ERROR_INVALID_REFERENCE_STRING           $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x21F bitor bitor ]
CONSTANT: ERROR_INVALID_MACHINENAME                $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x220 bitor bitor ]
CONSTANT: ERROR_REMOTE_COMM_FAILURE                $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x221 bitor bitor ]
CONSTANT: ERROR_MACHINE_UNAVAILABLE                $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x222 bitor bitor ]
CONSTANT: ERROR_NO_CONFIGMGR_SERVICES              $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x223 bitor bitor ]
CONSTANT: ERROR_INVALID_PROPPAGE_PROVIDER          $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x224 bitor bitor ]
CONSTANT: ERROR_NO_SUCH_DEVICE_INTERFACE           $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x225 bitor bitor ]
CONSTANT: ERROR_DI_POSTPROCESSING_REQUIRED         $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x226 bitor bitor ]
CONSTANT: ERROR_INVALID_COINSTALLER                $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x227 bitor bitor ]
CONSTANT: ERROR_NO_COMPAT_DRIVERS                  $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x228 bitor bitor ]
CONSTANT: ERROR_NO_DEVICE_ICON                     $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x229 bitor bitor ]
CONSTANT: ERROR_INVALID_INF_LOGCONFIG              $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x22A bitor bitor ]
CONSTANT: ERROR_DI_DONT_INSTALL                    $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x22B bitor bitor ]
CONSTANT: ERROR_INVALID_FILTER_DRIVER              $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x22C bitor bitor ]
CONSTANT: ERROR_NON_WINDOWS_NT_DRIVER              $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x22D bitor bitor ]
CONSTANT: ERROR_NON_WINDOWS_DRIVER                 $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x22E bitor bitor ]
CONSTANT: ERROR_NO_CATALOG_FOR_OEM_INF             $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x22F bitor bitor ]
CONSTANT: ERROR_DEVINSTALL_QUEUE_NONNATIVE         $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x230 bitor bitor ]
CONSTANT: ERROR_NOT_DISABLEABLE                    $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x231 bitor bitor ]
CONSTANT: ERROR_CANT_REMOVE_DEVINST                $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x232 bitor bitor ]
CONSTANT: ERROR_INVALID_TARGET                     $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x233 bitor bitor ]
CONSTANT: ERROR_DRIVER_NONNATIVE                   $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x234 bitor bitor ]
CONSTANT: ERROR_IN_WOW64                           $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x235 bitor bitor ]
CONSTANT: ERROR_SET_SYSTEM_RESTORE_POINT           $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x236 bitor bitor ]
CONSTANT: ERROR_SCE_DISABLED                       $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x238 bitor bitor ]
CONSTANT: ERROR_UNKNOWN_EXCEPTION                  $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x239 bitor bitor ]
CONSTANT: ERROR_PNP_REGISTRY_ERROR                 $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x23A bitor bitor ]
CONSTANT: ERROR_REMOTE_REQUEST_UNSUPPORTED         $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x23B bitor bitor ]
CONSTANT: ERROR_NOT_AN_INSTALLED_OEM_INF           $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x23C bitor bitor ]
CONSTANT: ERROR_INF_IN_USE_BY_DEVICES              $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x23D bitor bitor ]
CONSTANT: ERROR_DI_FUNCTION_OBSOLETE               $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x23E bitor bitor ]
CONSTANT: ERROR_NO_AUTHENTICODE_CATALOG            $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x23F bitor bitor ]
CONSTANT: ERROR_AUTHENTICODE_DISALLOWED            $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x240 bitor bitor ]
CONSTANT: ERROR_AUTHENTICODE_TRUSTED_PUBLISHER     $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x241 bitor bitor ]
CONSTANT: ERROR_AUTHENTICODE_TRUST_NOT_ESTABLISHED $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x242 bitor bitor ]
CONSTANT: ERROR_AUTHENTICODE_PUBLISHER_NOT_TRUSTED $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x243 bitor bitor ]
CONSTANT: ERROR_SIGNATURE_OSATTRIBUTE_MISMATCH     $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x244 bitor bitor ]
CONSTANT: ERROR_ONLY_VALIDATE_VIA_AUTHENTICODE     $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x245 bitor bitor ]
CONSTANT: ERROR_DEVICE_INSTALLER_NOT_READY         $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x246 bitor bitor ]
CONSTANT: ERROR_DRIVER_STORE_ADD_FAILED            $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x247 bitor bitor ]
CONSTANT: ERROR_DEVICE_INSTALL_BLOCKED             $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x248 bitor bitor ]
CONSTANT: ERROR_DRIVER_INSTALL_BLOCKED             $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x249 bitor bitor ]
CONSTANT: ERROR_WRONG_INF_TYPE                     $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x24A bitor bitor ]
CONSTANT: ERROR_FILE_HASH_NOT_IN_CATALOG           $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x24B bitor bitor ]
CONSTANT: ERROR_DRIVER_STORE_DELETE_FAILED         $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x24C bitor bitor ]
CONSTANT: ERROR_UNRECOVERABLE_STACK_OVERFLOW $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x300 bitor bitor ]
CONSTANT: EXCEPTION_SPAPI_UNRECOVERABLE_STACK_OVERFLOW $ ERROR_UNRECOVERABLE_STACK_OVERFLOW
CONSTANT: ERROR_NO_DEFAULT_INTERFACE_DEVICE $ ERROR_NO_DEFAULT_DEVICE_INTERFACE
CONSTANT: ERROR_INTERFACE_DEVICE_ACTIVE     $ ERROR_DEVICE_INTERFACE_ACTIVE
CONSTANT: ERROR_INTERFACE_DEVICE_REMOVED    $ ERROR_DEVICE_INTERFACE_REMOVED
CONSTANT: ERROR_NO_SUCH_INTERFACE_DEVICE    $ ERROR_NO_SUCH_DEVICE_INTERFACE
CONSTANT: ERROR_NOT_INSTALLED $[ APPLICATION_ERROR_MASK ERROR_SEVERITY_ERROR 0x1000 bitor bitor ]

FUNCTION: BOOL SetupGetInfInformationA ( LPCVOID InfSpec, DWORD SearchControl, PSP_INF_INFORMATION ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupGetInfInformationW ( LPCVOID InfSpec, DWORD SearchControl, PSP_INF_INFORMATION ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
CONSTANT: INFINFO_INF_SPEC_IS_HINF        1
CONSTANT: INFINFO_INF_NAME_IS_ABSOLUTE    2
CONSTANT: INFINFO_DEFAULT_SEARCH          3
CONSTANT: INFINFO_REVERSE_DEFAULT_SEARCH  4
CONSTANT: INFINFO_INF_PATH_LIST_SEARCH    5
ALIAS: SetupGetInfInformation SetupGetInfInformationW

FUNCTION: BOOL SetupQueryInfFileInformationA ( PSP_INF_INFORMATION InfInformation, UINT InfIndex, PSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupQueryInfFileInformationW ( PSP_INF_INFORMATION InfInformation, UINT InfIndex, PWSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupQueryInfFileInformation SetupQueryInfFileInformationW

FUNCTION: BOOL SetupQueryInfOriginalFileInformationA ( PSP_INF_INFORMATION InfInformation, UINT InfIndex, PSP_ALTPLATFORM_INFO AlternatePlatformInfo, PSP_ORIGINAL_FILE_INFO_A OriginalFileInfo ) ;
FUNCTION: BOOL SetupQueryInfOriginalFileInformationW ( PSP_INF_INFORMATION InfInformation, UINT InfIndex, PSP_ALTPLATFORM_INFO AlternatePlatformInfo, PSP_ORIGINAL_FILE_INFO_W OriginalFileInfo ) ;
ALIAS: SetupQueryInfOriginalFileInformation SetupQueryInfOriginalFileInformationW

FUNCTION: BOOL SetupQueryInfVersionInformationA ( PSP_INF_INFORMATION InfInformation, UINT InfIndex, PCSTR Key, PSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupQueryInfVersionInformationW ( PSP_INF_INFORMATION InfInformation, UINT InfIndex, PCWSTR Key, PWSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupQueryInfVersionInformation SetupQueryInfVersionInformationW

FUNCTION: BOOL SetupGetInfDriverStoreLocationA ( PCSTR FileName, PSP_ALTPLATFORM_INFO AlternatePlatformInfo, PCSTR LocaleName, PSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupGetInfDriverStoreLocationW ( PCWSTR FileName, PSP_ALTPLATFORM_INFO AlternatePlatformInfo, PCWSTR LocaleName, PWSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupGetInfDriverStoreLocation SetupGetInfDriverStoreLocationW

FUNCTION: BOOL SetupGetInfPublishedNameA ( PCSTR DriverStoreLocation, PSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupGetInfPublishedNameW ( PCWSTR DriverStoreLocation, PWSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupGetInfPublishedName SetupGetInfPublishedNameW

FUNCTION: BOOL SetupGetInfFileListA ( PCSTR DirectoryPath, DWORD InfStyle, PSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupGetInfFileListW ( PCWSTR DirectoryPath, DWORD InfStyle, PWSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupGetInfFileList SetupGetInfFileListW

FUNCTION: HINF SetupOpenInfFileW ( PCWSTR FileName, PCWSTR InfClass, DWORD InfStyle, PUINT ErrorLine ) ;
FUNCTION: HINF SetupOpenInfFileA ( PCSTR FileName, PCSTR InfClass, DWORD InfStyle, PUINT ErrorLine ) ;
ALIAS: SetupOpenInfFile SetupOpenInfFileW

FUNCTION: HINF SetupOpenMasterInf ( ) ;

FUNCTION: BOOL SetupOpenAppendInfFileW ( PCWSTR FileName, HINF InfHandle, PUINT ErrorLine ) ;
FUNCTION: BOOL SetupOpenAppendInfFileA ( PCSTR FileName, HINF InfHandle, PUINT ErrorLine ) ;
ALIAS: SetupOpenAppendInfFile SetupOpenAppendInfFileW

FUNCTION: void SetupCloseInfFile ( HINF InfHandle ) ;
FUNCTION: BOOL SetupFindFirstLineA ( HINF InfHandle, PCSTR Section, PCSTR Key, PINFCONTEXT Context ) ;
FUNCTION: BOOL SetupFindFirstLineW ( HINF InfHandle, PCWSTR Section, PCWSTR Key, PINFCONTEXT Context ) ;
ALIAS: SetupFindFirstLine SetupFindFirstLineW

FUNCTION: BOOL SetupFindNextLine ( PINFCONTEXT ContextIn, PINFCONTEXT ContextOut ) ;
FUNCTION: BOOL SetupFindNextMatchLineA ( PINFCONTEXT ContextIn, PCSTR Key, PINFCONTEXT ContextOut ) ;
FUNCTION: BOOL SetupFindNextMatchLineW ( PINFCONTEXT ContextIn, PCWSTR Key, PINFCONTEXT ContextOut ) ;
ALIAS: SetupFindNextMatchLine SetupFindNextMatchLineW

FUNCTION: BOOL SetupGetLineByIndexA ( HINF InfHandle, PCSTR Section, DWORD Index, PINFCONTEXT Context ) ;
FUNCTION: BOOL SetupGetLineByIndexW ( HINF InfHandle, PCWSTR Section, DWORD Index, PINFCONTEXT Context ) ;
ALIAS: SetupGetLineByIndex SetupGetLineByIndexW

FUNCTION: LONG SetupGetLineCountA ( HINF InfHandle, PCSTR Section ) ;
FUNCTION: LONG SetupGetLineCountW ( HINF InfHandle, PCWSTR Section ) ;
ALIAS: SetupGetLineCount SetupGetLineCountW

FUNCTION: BOOL SetupGetLineTextA ( PINFCONTEXT Context, HINF InfHandle, PCSTR Section, PCSTR Key, PSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupGetLineTextW ( PINFCONTEXT Context, HINF InfHandle, PCWSTR Section, PCWSTR Key, PWSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupGetLineText SetupGetLineTextW

FUNCTION: DWORD SetupGetFieldCount ( PINFCONTEXT Context ) ;
FUNCTION: BOOL SetupGetStringFieldA ( PINFCONTEXT Context, DWORD FieldIndex, PSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupGetStringFieldW ( PINFCONTEXT Context, DWORD FieldIndex, PWSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupGetStringField SetupGetStringFieldW

FUNCTION: BOOL SetupGetIntField ( PINFCONTEXT Context, DWORD FieldIndex, PINT IntegerValue ) ;
FUNCTION: BOOL SetupGetMultiSzFieldA ( PINFCONTEXT Context, DWORD FieldIndex, PSTR ReturnBuffer, DWORD ReturnBufferSize, LPDWORD RequiredSize ) ;
FUNCTION: BOOL SetupGetMultiSzFieldW ( PINFCONTEXT Context, DWORD FieldIndex, PWSTR ReturnBuffer, DWORD ReturnBufferSize, LPDWORD RequiredSize ) ;
ALIAS: SetupGetMultiSzField SetupGetMultiSzFieldW

FUNCTION: BOOL SetupGetBinaryField ( PINFCONTEXT Context, DWORD FieldIndex, PBYTE ReturnBuffer, DWORD ReturnBufferSize, LPDWORD RequiredSize ) ;
FUNCTION: DWORD SetupGetFileCompressionInfoA ( PCSTR SourceFileName, PSTR* ActualSourceFileName, PDWORD SourceFileSize, PDWORD TargetFileSize, PUINT CompressionType ) ;
FUNCTION: DWORD SetupGetFileCompressionInfoW ( PCWSTR SourceFileName, PWSTR* ActualSourceFileName, PDWORD SourceFileSize, PDWORD TargetFileSize, PUINT CompressionType ) ;
ALIAS: SetupGetFileCompressionInfo SetupGetFileCompressionInfoW

FUNCTION: BOOL SetupGetFileCompressionInfoExA ( PCSTR SourceFileName, PSTR ActualSourceFileNameBuffer, DWORD ActualSourceFileNameBufferLen, PDWORD RequiredBufferLen, PDWORD SourceFileSize, PDWORD TargetFileSize, PUINT CompressionType ) ;
FUNCTION: BOOL SetupGetFileCompressionInfoExW ( PCWSTR SourceFileName, PWSTR ActualSourceFileNameBuffer, DWORD ActualSourceFileNameBufferLen, PDWORD RequiredBufferLen, PDWORD SourceFileSize, PDWORD TargetFileSize, PUINT CompressionType ) ;
ALIAS: SetupGetFileCompressionInfoEx SetupGetFileCompressionInfoExW

CONSTANT: FILE_COMPRESSION_NONE       0
CONSTANT: FILE_COMPRESSION_WINLZA     1
CONSTANT: FILE_COMPRESSION_MSZIP      2
CONSTANT: FILE_COMPRESSION_NTCAB      3

FUNCTION: DWORD SetupDecompressOrCopyFileA ( PCSTR SourceFileName, PCSTR TargetFileName, PUINT CompressionType ) ;
FUNCTION: DWORD SetupDecompressOrCopyFileW ( PCWSTR SourceFileName, PCWSTR TargetFileName, PUINT CompressionType ) ;
ALIAS: SetupDecompressOrCopyFile SetupDecompressOrCopyFileW

FUNCTION: BOOL SetupGetSourceFileLocationA ( HINF InfHandle, PINFCONTEXT InfContext, PCSTR FileName, PUINT SourceId, PSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupGetSourceFileLocationW ( HINF InfHandle, PINFCONTEXT InfContext, PCWSTR FileName, PUINT SourceId, PWSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupGetSourceFileLocation SetupGetSourceFileLocationW

FUNCTION: BOOL SetupGetSourceFileSizeA ( HINF InfHandle, PINFCONTEXT InfContext, PCSTR FileName, PCSTR Section, PDWORD FileSize, UINT RoundingFactor ) ;
FUNCTION: BOOL SetupGetSourceFileSizeW ( HINF InfHandle, PINFCONTEXT InfContext, PCWSTR FileName, PCWSTR Section, PDWORD FileSize, UINT RoundingFactor ) ;
ALIAS: SetupGetSourceFileSize SetupGetSourceFileSizeW

FUNCTION: BOOL SetupGetTargetPathA ( HINF InfHandle, PINFCONTEXT InfContext, PCSTR Section, PSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupGetTargetPathW ( HINF InfHandle, PINFCONTEXT InfContext, PCWSTR Section, PWSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupGetTargetPath SetupGetTargetPathW

CONSTANT: SRCLIST_TEMPORARY       0x00000001
CONSTANT: SRCLIST_NOBROWSE        0x00000002
CONSTANT: SRCLIST_SYSTEM          0x00000010
CONSTANT: SRCLIST_USER            0x00000020
CONSTANT: SRCLIST_SYSIFADMIN      0x00000040
CONSTANT: SRCLIST_SUBDIRS         0x00000100
CONSTANT: SRCLIST_APPEND          0x00000200
CONSTANT: SRCLIST_NOSTRIPPLATFORM 0x00000400

FUNCTION: BOOL SetupSetSourceListA ( DWORD Flags, PCSTR* SourceList, UINT SourceCount ) ;
FUNCTION: BOOL SetupSetSourceListW ( DWORD Flags, PCWSTR* SourceList, UINT SourceCount ) ;
ALIAS: SetupSetSourceList SetupSetSourceListW

FUNCTION: BOOL SetupCancelTemporarySourceList( ) ;
FUNCTION: BOOL SetupAddToSourceListA ( DWORD Flags, PCSTR Source ) ;
FUNCTION: BOOL SetupAddToSourceListW ( DWORD Flags, PCWSTR Source ) ;
ALIAS: SetupAddToSourceList SetupAddToSourceListW

FUNCTION: BOOL SetupRemoveFromSourceListA ( DWORD Flags, PCSTR Source ) ;
FUNCTION: BOOL SetupRemoveFromSourceListW ( DWORD Flags, PCWSTR Source ) ;
ALIAS: SetupRemoveFromSourceList SetupRemoveFromSourceListW

FUNCTION: BOOL SetupQuerySourceListA ( DWORD Flags, PCSTR** List, PUINT Count ) ;
FUNCTION: BOOL SetupQuerySourceListW ( DWORD Flags, PCWSTR** List, PUINT Count ) ;
ALIAS: SetupQuerySourceList SetupQuerySourceListW

FUNCTION: BOOL SetupFreeSourceListA ( PCSTR** List, UINT Count ) ;
FUNCTION: BOOL SetupFreeSourceListW ( PCWSTR** List, UINT Count ) ;
ALIAS: SetupFreeSourceList SetupFreeSourceListW

FUNCTION: UINT SetupPromptForDiskA ( HWND hwndParent, PCSTR DialogTitle, PCSTR DiskName, PCSTR PathToSource, PCSTR FileSought, PCSTR TagFile, DWORD DiskPromptStyle, PSTR PathBuffer, DWORD PathBufferSize, PDWORD PathRequiredSize ) ;
FUNCTION: UINT SetupPromptForDiskW ( HWND hwndParent, PCWSTR DialogTitle, PCWSTR DiskName, PCWSTR PathToSource, PCWSTR FileSought, PCWSTR TagFile, DWORD DiskPromptStyle, PWSTR PathBuffer, DWORD PathBufferSize, PDWORD PathRequiredSize ) ;
ALIAS: SetupPromptForDisk SetupPromptForDiskW

FUNCTION: UINT SetupCopyErrorA ( HWND hwndParent, PCSTR DialogTitle, PCSTR DiskName, PCSTR PathToSource, PCSTR SourceFile, PCSTR TargetPathFile, UINT Win32ErrorCode, DWORD Style, PSTR PathBuffer, DWORD PathBufferSize, PDWORD PathRequiredSize ) ;
FUNCTION: UINT SetupCopyErrorW ( HWND hwndParent, PCWSTR DialogTitle, PCWSTR DiskName, PCWSTR PathToSource, PCWSTR SourceFile, PCWSTR TargetPathFile, UINT Win32ErrorCode, DWORD Style, PWSTR PathBuffer, DWORD PathBufferSize, PDWORD PathRequiredSize ) ;
ALIAS: SetupCopyError SetupCopyErrorW

FUNCTION: UINT SetupRenameErrorA ( HWND hwndParent, PCSTR DialogTitle, PCSTR SourceFile, PCSTR TargetFile, UINT Win32ErrorCode, DWORD Style ) ;
FUNCTION: UINT SetupRenameErrorW ( HWND hwndParent, PCWSTR DialogTitle, PCWSTR SourceFile, PCWSTR TargetFile, UINT Win32ErrorCode, DWORD Style ) ;
ALIAS: SetupRenameError SetupRenameErrorW

FUNCTION: UINT SetupDeleteErrorA ( HWND hwndParent, PCSTR DialogTitle, PCSTR File, UINT Win32ErrorCode, DWORD Style ) ;
FUNCTION: UINT SetupDeleteErrorW ( HWND hwndParent, PCWSTR DialogTitle, PCWSTR File, UINT Win32ErrorCode, DWORD Style ) ;
ALIAS: SetupDeleteError SetupDeleteErrorW

FUNCTION: UINT SetupBackupErrorA ( HWND hwndParent, PCSTR DialogTitle, PCSTR SourceFile, PCSTR TargetFile, UINT Win32ErrorCode, DWORD Style ) ;
FUNCTION: UINT SetupBackupErrorW ( HWND hwndParent, PCWSTR DialogTitle, PCWSTR SourceFile, PCWSTR TargetFile, UINT Win32ErrorCode, DWORD Style ) ;
ALIAS: SetupBackupError SetupBackupErrorW

CONSTANT: IDF_NOBROWSE                    0x00000001
CONSTANT: IDF_NOSKIP                      0x00000002
CONSTANT: IDF_NODETAILS                   0x00000004
CONSTANT: IDF_NOCOMPRESSED                0x00000008
CONSTANT: IDF_CHECKFIRST                  0x00000100
CONSTANT: IDF_NOBEEP                      0x00000200
CONSTANT: IDF_NOFOREGROUND                0x00000400
CONSTANT: IDF_WARNIFSKIP                  0x00000800
CONSTANT: IDF_NOREMOVABLEMEDIAPROMPT      0x00001000
CONSTANT: IDF_USEDISKNAMEASPROMPT         0x00002000
CONSTANT: IDF_OEMDISK                     0x80000000

CONSTANT: DPROMPT_SUCCESS         0
CONSTANT: DPROMPT_CANCEL          1
CONSTANT: DPROMPT_SKIPFILE        2
CONSTANT: DPROMPT_BUFFERTOOSMALL  3
CONSTANT: DPROMPT_OUTOFMEMORY     4

FUNCTION: BOOL SetupSetDirectoryIdA ( HINF InfHandle, DWORD Id, PCSTR Directory ) ;
FUNCTION: BOOL SetupSetDirectoryIdW ( HINF InfHandle, DWORD Id, PCWSTR Directory ) ;
ALIAS: SetupSetDirectoryId SetupSetDirectoryIdW

FUNCTION: BOOL SetupSetDirectoryIdExA ( HINF InfHandle, DWORD Id, PCSTR Directory, DWORD Flags, DWORD Reserved1, PVOID Reserved2 ) ;
FUNCTION: BOOL SetupSetDirectoryIdExW ( HINF InfHandle, DWORD Id, PCWSTR Directory, DWORD Flags, DWORD Reserved1, PVOID Reserved2 ) ;
ALIAS: SetupSetDirectoryIdEx SetupSetDirectoryIdExW

CONSTANT: SETDIRID_NOT_FULL_PATH      0x00000001

FUNCTION: BOOL SetupGetSourceInfoA ( HINF InfHandle, UINT SourceId, UINT InfoDesired, PSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupGetSourceInfoW ( HINF InfHandle, UINT SourceId, UINT InfoDesired, PWSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupGetSourceInfo SetupGetSourceInfoW

CONSTANT: SRCINFO_PATH            1
CONSTANT: SRCINFO_TAGFILE         2
CONSTANT: SRCINFO_DESCRIPTION     3
CONSTANT: SRCINFO_FLAGS           4
CONSTANT: SRCINFO_TAGFILE2        5
CONSTANT: SRC_FLAGS_CABFILE       0x0010

FUNCTION: BOOL SetupInstallFileA ( HINF InfHandle, PINFCONTEXT InfContext, PCSTR SourceFile, PCSTR SourcePathRoot, PCSTR DestinationName, DWORD CopyStyle, PSP_FILE_CALLBACK_A CopyMsgHandler, PVOID Context ) ;
FUNCTION: BOOL SetupInstallFileW ( HINF InfHandle, PINFCONTEXT InfContext, PCWSTR SourceFile, PCWSTR SourcePathRoot, PCWSTR DestinationName, DWORD CopyStyle, PSP_FILE_CALLBACK_W CopyMsgHandler, PVOID Context ) ;
ALIAS: SetupInstallFile SetupInstallFileW

FUNCTION: BOOL SetupInstallFileExA ( HINF InfHandle, PINFCONTEXT InfContext, PCSTR SourceFile, PCSTR SourcePathRoot, PCSTR DestinationName, DWORD CopyStyle, PSP_FILE_CALLBACK_A CopyMsgHandler, PVOID Context, PBOOL FileWasInUse ) ;
FUNCTION: BOOL SetupInstallFileExW ( HINF InfHandle, PINFCONTEXT InfContext, PCWSTR SourceFile, PCWSTR SourcePathRoot, PCWSTR DestinationName, DWORD CopyStyle, PSP_FILE_CALLBACK_W CopyMsgHandler, PVOID Context, PBOOL FileWasInUse ) ;
ALIAS: SetupInstallFileEx SetupInstallFileExW

CONSTANT: SP_COPY_DELETESOURCE        0x0000001
CONSTANT: SP_COPY_REPLACEONLY         0x0000002
CONSTANT: SP_COPY_NEWER               0x0000004
CONSTANT: SP_COPY_NEWER_OR_SAME       $ SP_COPY_NEWER
CONSTANT: SP_COPY_NOOVERWRITE         0x0000008
CONSTANT: SP_COPY_NODECOMP            0x0000010
CONSTANT: SP_COPY_LANGUAGEAWARE       0x0000020
CONSTANT: SP_COPY_SOURCE_ABSOLUTE     0x0000040
CONSTANT: SP_COPY_SOURCEPATH_ABSOLUTE 0x0000080
CONSTANT: SP_COPY_IN_USE_NEEDS_REBOOT 0x0000100
CONSTANT: SP_COPY_FORCE_IN_USE        0x0000200
CONSTANT: SP_COPY_NOSKIP              0x0000400
CONSTANT: SP_FLAG_CABINETCONTINUATION 0x0000800
CONSTANT: SP_COPY_FORCE_NOOVERWRITE   0x0001000
CONSTANT: SP_COPY_FORCE_NEWER         0x0002000
CONSTANT: SP_COPY_WARNIFSKIP          0x0004000
CONSTANT: SP_COPY_NOBROWSE            0x0008000
CONSTANT: SP_COPY_NEWER_ONLY          0x0010000
CONSTANT: SP_COPY_RESERVED            0x0020000
CONSTANT: SP_COPY_OEMINF_CATALOG_ONLY 0x0040000
CONSTANT: SP_COPY_REPLACE_BOOT_FILE   0x0080000
CONSTANT: SP_COPY_NOPRUNE             0x0100000
CONSTANT: SP_COPY_OEM_F6_INF          0x0200000
CONSTANT: SP_COPY_ALREADYDECOMP       0x0400000
CONSTANT: SP_COPY_WINDOWS_SIGNED      0x1000000
CONSTANT: SP_COPY_PNPLOCKED           0x2000000
CONSTANT: SP_COPY_IN_USE_TRY_RENAME   0x4000000
CONSTANT: SP_COPY_INBOX_INF           0x8000000
CONSTANT: SP_COPY_HARDLINK            0x10000000

CONSTANT: SP_BACKUP_BACKUPPASS        0x00000001
CONSTANT: SP_BACKUP_DEMANDPASS        0x00000002
CONSTANT: SP_BACKUP_SPECIAL           0x00000004
CONSTANT: SP_BACKUP_BOOTFILE          0x00000008

FUNCTION: HSPFILEQ SetupOpenFileQueue ( ) ;
FUNCTION: BOOL SetupCloseFileQueue ( HSPFILEQ QueueHandle ) ;
FUNCTION: BOOL SetupSetFileQueueAlternatePlatformA ( HSPFILEQ QueueHandle, PSP_ALTPLATFORM_INFO AlternatePlatformInfo, PCSTR AlternateDefaultCatalogFile ) ;
FUNCTION: BOOL SetupSetFileQueueAlternatePlatformW ( HSPFILEQ QueueHandle, PSP_ALTPLATFORM_INFO AlternatePlatformInfo, PCWSTR AlternateDefaultCatalogFile ) ;
ALIAS: SetupSetFileQueueAlternatePlatform SetupSetFileQueueAlternatePlatformW

FUNCTION: BOOL SetupSetPlatformPathOverrideA ( PCSTR Override ) ;
FUNCTION: BOOL SetupSetPlatformPathOverrideW ( PCWSTR Override ) ;
ALIAS: SetupSetPlatformPathOverride SetupSetPlatformPathOverrideW

FUNCTION: BOOL SetupQueueCopyA ( HSPFILEQ QueueHandle, PCSTR SourceRootPath, PCSTR SourcePath, PCSTR SourceFilename, PCSTR SourceDescription, PCSTR SourceTagfile, PCSTR TargetDirectory, PCSTR TargetFilename, DWORD CopyStyle ) ;
FUNCTION: BOOL SetupQueueCopyW ( HSPFILEQ QueueHandle, PCWSTR SourceRootPath, PCWSTR SourcePath, PCWSTR SourceFilename, PCWSTR SourceDescription, PCWSTR SourceTagfile, PCWSTR TargetDirectory, PCWSTR TargetFilename, DWORD CopyStyle ) ;
ALIAS: SetupQueueCopy SetupQueueCopyW

FUNCTION: BOOL SetupQueueCopyIndirectA ( PSP_FILE_COPY_PARAMS_A CopyParams ) ;
FUNCTION: BOOL SetupQueueCopyIndirectW ( PSP_FILE_COPY_PARAMS_W CopyParams ) ;
ALIAS: SetupQueueCopyIndirect SetupQueueCopyIndirectW

FUNCTION: BOOL SetupQueueDefaultCopyA ( HSPFILEQ QueueHandle, HINF InfHandle, PCSTR SourceRootPath, PCSTR SourceFilename, PCSTR TargetFilename, DWORD CopyStyle ) ;
FUNCTION: BOOL SetupQueueDefaultCopyW ( HSPFILEQ QueueHandle, HINF InfHandle, PCWSTR SourceRootPath, PCWSTR SourceFilename, PCWSTR TargetFilename, DWORD CopyStyle ) ;
ALIAS: SetupQueueDefaultCopy SetupQueueDefaultCopyW

FUNCTION: BOOL SetupQueueCopySectionA ( HSPFILEQ QueueHandle, PCSTR SourceRootPath, HINF InfHandle, HINF ListInfHandle, PCSTR Section, DWORD CopyStyle ) ;
FUNCTION: BOOL SetupQueueCopySectionW ( HSPFILEQ QueueHandle, PCWSTR SourceRootPath, HINF InfHandle, HINF ListInfHandle, PCWSTR Section, DWORD CopyStyle ) ;
ALIAS: SetupQueueCopySection SetupQueueCopySectionW

FUNCTION: BOOL SetupQueueDeleteA ( HSPFILEQ QueueHandle, PCSTR PathPart1, PCSTR PathPart2 ) ;
FUNCTION: BOOL SetupQueueDeleteW ( HSPFILEQ QueueHandle, PCWSTR PathPart1, PCWSTR PathPart2 ) ;
ALIAS: SetupQueueDelete SetupQueueDeleteW

FUNCTION: BOOL SetupQueueDeleteSectionA ( HSPFILEQ QueueHandle, HINF InfHandle, HINF ListInfHandle, PCSTR Section ) ;
FUNCTION: BOOL SetupQueueDeleteSectionW ( HSPFILEQ QueueHandle, HINF InfHandle, HINF ListInfHandle, PCWSTR Section ) ;
ALIAS: SetupQueueDeleteSection SetupQueueDeleteSectionW

FUNCTION: BOOL SetupQueueRenameA ( HSPFILEQ QueueHandle, PCSTR SourcePath, PCSTR SourceFilename, PCSTR TargetPath, PCSTR TargetFilename ) ;
FUNCTION: BOOL SetupQueueRenameW ( HSPFILEQ QueueHandle, PCWSTR SourcePath, PCWSTR SourceFilename, PCWSTR TargetPath, PCWSTR TargetFilename ) ;
ALIAS: SetupQueueRename SetupQueueRenameW

FUNCTION: BOOL SetupQueueRenameSectionA ( HSPFILEQ QueueHandle, HINF InfHandle, HINF ListInfHandle, PCSTR Section ) ;
FUNCTION: BOOL SetupQueueRenameSectionW ( HSPFILEQ QueueHandle, HINF InfHandle, HINF ListInfHandle, PCWSTR Section ) ;
ALIAS: SetupQueueRenameSection SetupQueueRenameSectionW

FUNCTION: BOOL SetupCommitFileQueueA ( HWND Owner, HSPFILEQ QueueHandle, PSP_FILE_CALLBACK_A MsgHandler, PVOID Context ) ;
FUNCTION: BOOL SetupCommitFileQueueW ( HWND Owner, HSPFILEQ QueueHandle, PSP_FILE_CALLBACK_W MsgHandler, PVOID Context ) ;
ALIAS: SetupCommitFileQueue SetupCommitFileQueueW

FUNCTION: BOOL SetupScanFileQueueA ( HSPFILEQ FileQueue, DWORD Flags, HWND Window, PSP_FILE_CALLBACK_A CallbackRoutine, PVOID CallbackContext, PDWORD Result ) ;
FUNCTION: BOOL SetupScanFileQueueW ( HSPFILEQ FileQueue, DWORD Flags, HWND Window, PSP_FILE_CALLBACK_W CallbackRoutine, PVOID CallbackContext, PDWORD Result ) ;
ALIAS: SetupScanFileQueue SetupScanFileQueueW

CONSTANT: SPQ_SCAN_FILE_PRESENCE                  0x00000001
CONSTANT: SPQ_SCAN_FILE_VALIDITY                  0x00000002
CONSTANT: SPQ_SCAN_USE_CALLBACK                   0x00000004
CONSTANT: SPQ_SCAN_USE_CALLBACKEX                 0x00000008
CONSTANT: SPQ_SCAN_INFORM_USER                    0x00000010
CONSTANT: SPQ_SCAN_PRUNE_COPY_QUEUE               0x00000020
CONSTANT: SPQ_SCAN_USE_CALLBACK_SIGNERINFO        0x00000040
CONSTANT: SPQ_SCAN_PRUNE_DELREN                   0x00000080
CONSTANT: SPQ_SCAN_FILE_PRESENCE_WITHOUT_SOURCE   0x00000100
CONSTANT: SPQ_SCAN_FILE_COMPARISON                0x00000200
CONSTANT: SPQ_SCAN_ACTIVATE_DRP                   0x00000400
CONSTANT: SPQ_DELAYED_COPY                        0x00000001

FUNCTION: BOOL SetupGetFileQueueCount ( HSPFILEQ FileQueue, UINT SubQueueFileOp, PUINT NumOperations ) ;
FUNCTION: BOOL SetupGetFileQueueFlags ( HSPFILEQ FileQueue, PDWORD Flags ) ;
FUNCTION: BOOL SetupSetFileQueueFlags ( HSPFILEQ FileQueue, DWORD FlagMask, DWORD Flags ) ;

CONSTANT: SPQ_FLAG_BACKUP_AWARE      0x00000001
CONSTANT: SPQ_FLAG_ABORT_IF_UNSIGNED 0x00000002
CONSTANT: SPQ_FLAG_FILES_MODIFIED    0x00000004
CONSTANT: SPQ_FLAG_DO_SHUFFLEMOVE    0x00000008
CONSTANT: SPQ_FLAG_VALID             0x0000000F

CONSTANT: SPOST_NONE  0
CONSTANT: SPOST_PATH  1
CONSTANT: SPOST_URL   2
CONSTANT: SPOST_MAX   3

FUNCTION: BOOL SetupCopyOEMInfA ( PCSTR SourceInfFileName, PCSTR OEMSourceMediaLocation, DWORD OEMSourceMediaType, DWORD CopyStyle, PSTR DestinationInfFileName, DWORD DestinationInfFileNameSize, PDWORD RequiredSize, PSTR* DestinationInfFileNameComponent ) ;
FUNCTION: BOOL SetupCopyOEMInfW ( PCWSTR SourceInfFileName, PCWSTR OEMSourceMediaLocation, DWORD OEMSourceMediaType, DWORD CopyStyle, PWSTR DestinationInfFileName, DWORD DestinationInfFileNameSize, PDWORD RequiredSize, PWSTR* DestinationInfFileNameComponent ) ;
ALIAS: SetupCopyOEMInf SetupCopyOEMInfW

CONSTANT: SUOI_FORCEDELETE   0x00000001
CONSTANT: SUOI_INTERNAL1     0x00000002

FUNCTION: BOOL SetupUninstallOEMInfA ( PCSTR InfFileName, DWORD Flags, PVOID Reserved ) ;
FUNCTION: BOOL SetupUninstallOEMInfW ( PCWSTR InfFileName, DWORD Flags, PVOID Reserved ) ;
ALIAS: SetupUninstallOEMInf SetupUninstallOEMInfW

FUNCTION: BOOL SetupUninstallNewlyCopiedInfs( HSPFILEQ FileQueue, DWORD Flags, PVOID Reserved ) ;

FUNCTION: HDSKSPC SetupCreateDiskSpaceListA ( PVOID Reserved1, DWORD Reserved2, UINT Flags ) ;
FUNCTION: HDSKSPC SetupCreateDiskSpaceListW ( PVOID Reserved1, DWORD Reserved2, UINT Flags ) ;
ALIAS: SetupCreateDiskSpaceList SetupCreateDiskSpaceListW

CONSTANT: SPDSL_IGNORE_DISK              0x00000001
CONSTANT: SPDSL_DISALLOW_NEGATIVE_ADJUST 0x00000002

FUNCTION: HDSKSPC SetupDuplicateDiskSpaceListA ( HDSKSPC DiskSpace, PVOID Reserved1, DWORD Reserved2, UINT Flags ) ;
FUNCTION: HDSKSPC SetupDuplicateDiskSpaceListW ( HDSKSPC DiskSpace, PVOID Reserved1, DWORD Reserved2, UINT Flags ) ;
ALIAS: SetupDuplicateDiskSpaceList SetupDuplicateDiskSpaceListW

FUNCTION: BOOL SetupDestroyDiskSpaceList( HDSKSPC DiskSpace ) ;
FUNCTION: BOOL SetupQueryDrivesInDiskSpaceListA ( HDSKSPC DiskSpace, PSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupQueryDrivesInDiskSpaceListW ( HDSKSPC DiskSpace, PWSTR ReturnBuffer, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupQueryDrivesInDiskSpaceList SetupQueryDrivesInDiskSpaceListW

FUNCTION: BOOL SetupQuerySpaceRequiredOnDriveA ( HDSKSPC DiskSpace, PCSTR DriveSpec, LONGLONG* SpaceRequired, PVOID Reserved1, UINT Reserved2 ) ;
FUNCTION: BOOL SetupQuerySpaceRequiredOnDriveW ( HDSKSPC DiskSpace, PCWSTR DriveSpec, LONGLONG* SpaceRequired, PVOID Reserved1, UINT Reserved2 ) ;
ALIAS: SetupQuerySpaceRequiredOnDrive SetupQuerySpaceRequiredOnDriveW

FUNCTION: BOOL SetupAdjustDiskSpaceListA ( HDSKSPC DiskSpace, LPCSTR DriveRoot, LONGLONG Amount, PVOID Reserved1, UINT Reserved2 ) ;
FUNCTION: BOOL SetupAdjustDiskSpaceListW ( HDSKSPC DiskSpace, LPCWSTR DriveRoot, LONGLONG Amount, PVOID Reserved1, UINT Reserved2 ) ;
ALIAS: SetupAdjustDiskSpaceList SetupAdjustDiskSpaceListW

FUNCTION: BOOL SetupAddToDiskSpaceListA ( HDSKSPC DiskSpace, PCSTR TargetFilespec, LONGLONG FileSize, UINT Operation, PVOID Reserved1, UINT Reserved2 ) ;
FUNCTION: BOOL SetupAddToDiskSpaceListW ( HDSKSPC DiskSpace, PCWSTR TargetFilespec, LONGLONG FileSize, UINT Operation, PVOID Reserved1, UINT Reserved2 ) ;
ALIAS: SetupAddToDiskSpaceList SetupAddToDiskSpaceListW

FUNCTION: BOOL SetupAddSectionToDiskSpaceListA ( HDSKSPC DiskSpace, HINF InfHandle, HINF ListInfHandle, PCSTR SectionName, UINT Operation, PVOID Reserved1, UINT Reserved2 ) ;
FUNCTION: BOOL SetupAddSectionToDiskSpaceListW ( HDSKSPC DiskSpace, HINF InfHandle, HINF ListInfHandle, PCWSTR SectionName, UINT Operation, PVOID Reserved1, UINT Reserved2 ) ;
ALIAS: SetupAddSectionToDiskSpaceList SetupAddSectionToDiskSpaceListW

FUNCTION: BOOL SetupAddInstallSectionToDiskSpaceListA ( HDSKSPC DiskSpace, HINF InfHandle, HINF LayoutInfHandle, PCSTR SectionName, PVOID Reserved1, UINT Reserved2 ) ;
FUNCTION: BOOL SetupAddInstallSectionToDiskSpaceListW ( HDSKSPC DiskSpace, HINF InfHandle, HINF LayoutInfHandle, PCWSTR SectionName, PVOID Reserved1, UINT Reserved2 ) ;
ALIAS: SetupAddInstallSectionToDiskSpaceList SetupAddInstallSectionToDiskSpaceListW

FUNCTION: BOOL SetupRemoveFromDiskSpaceListA ( HDSKSPC DiskSpace, PCSTR TargetFilespec, UINT Operation, PVOID Reserved1, UINT Reserved2 ) ;
FUNCTION: BOOL SetupRemoveFromDiskSpaceListW ( HDSKSPC DiskSpace, PCWSTR TargetFilespec, UINT Operation, PVOID Reserved1, UINT Reserved2 ) ;
ALIAS: SetupRemoveFromDiskSpaceList SetupRemoveFromDiskSpaceListW

FUNCTION: BOOL SetupRemoveSectionFromDiskSpaceListA ( HDSKSPC DiskSpace, HINF InfHandle, HINF ListInfHandle, PCSTR SectionName, UINT Operation, PVOID Reserved1, UINT Reserved2 ) ;
FUNCTION: BOOL SetupRemoveSectionFromDiskSpaceListW ( HDSKSPC DiskSpace, HINF InfHandle, HINF ListInfHandle, PCWSTR SectionName, UINT Operation, PVOID Reserved1, UINT Reserved2 ) ;
ALIAS: SetupRemoveSectionFromDiskSpaceList SetupRemoveSectionFromDiskSpaceListW

FUNCTION: BOOL SetupRemoveInstallSectionFromDiskSpaceListA ( HDSKSPC DiskSpace, HINF InfHandle, HINF LayoutInfHandle, PCSTR SectionName, PVOID Reserved1, UINT Reserved2 ) ;
FUNCTION: BOOL SetupRemoveInstallSectionFromDiskSpaceListW ( HDSKSPC DiskSpace, HINF InfHandle, HINF LayoutInfHandle, PCWSTR SectionName, PVOID Reserved1, UINT Reserved2 ) ;
ALIAS: SetupRemoveInstallSectionFromDiskSpaceList SetupRemoveInstallSectionFromDiskSpaceListW

FUNCTION: BOOL SetupIterateCabinetA ( PCSTR CabinetFile, DWORD Reserved, PSP_FILE_CALLBACK_A MsgHandler, PVOID Context ) ;
FUNCTION: BOOL SetupIterateCabinetW ( PCWSTR CabinetFile, DWORD Reserved, PSP_FILE_CALLBACK_W MsgHandler, PVOID Context ) ;
ALIAS: SetupIterateCabinet SetupIterateCabinetW

FUNCTION: INT SetupPromptReboot ( HSPFILEQ FileQueue, HWND Owner, BOOL ScanOnly ) ;

CONSTANT: SPFILEQ_FILE_IN_USE         0x00000001
CONSTANT: SPFILEQ_REBOOT_RECOMMENDED  0x00000002
CONSTANT: SPFILEQ_REBOOT_IN_PROGRESS  0x00000004

FUNCTION: PVOID SetupInitDefaultQueueCallback ( HWND OwnerWindow ) ;
FUNCTION: PVOID SetupInitDefaultQueueCallbackEx ( HWND OwnerWindow, HWND AlternateProgressWindow, UINT ProgressMessage, DWORD Reserved1, PVOID Reserved2 ) ;
FUNCTION: void SetupTermDefaultQueueCallback ( PVOID Context ) ;

FUNCTION: UINT SetupDefaultQueueCallbackA ( PVOID Context, UINT Notification, UINT_PTR Param1, UINT_PTR Param2 ) ;
FUNCTION: UINT SetupDefaultQueueCallbackW ( PVOID Context, UINT Notification, UINT_PTR Param1, UINT_PTR Param2 ) ;
ALIAS: SetupDefaultQueueCallback SetupDefaultQueueCallbackW

CONSTANT: FLG_ADDREG_DELREG_BIT       0x00008000
CONSTANT: FLG_ADDREG_BINVALUETYPE     0x00000001
CONSTANT: FLG_ADDREG_NOCLOBBER        0x00000002
CONSTANT: FLG_ADDREG_DELVAL           0x00000004
CONSTANT: FLG_ADDREG_APPEND           0x00000008
CONSTANT: FLG_ADDREG_KEYONLY          0x00000010
CONSTANT: FLG_ADDREG_OVERWRITEONLY    0x00000020
CONSTANT: FLG_ADDREG_64BITKEY         0x00001000
CONSTANT: FLG_ADDREG_KEYONLY_COMMON   0x00002000
CONSTANT: FLG_ADDREG_32BITKEY         0x00004000
CONSTANT: FLG_ADDREG_TYPE_MASK        0xFFFF0001
CONSTANT: FLG_ADDREG_TYPE_SZ          0x00000000
CONSTANT: FLG_ADDREG_TYPE_MULTI_SZ    0x00010000
CONSTANT: FLG_ADDREG_TYPE_EXPAND_SZ   0x00020000
CONSTANT: FLG_ADDREG_TYPE_BINARY      0x00000001
CONSTANT: FLG_ADDREG_TYPE_DWORD       0x00010001
CONSTANT: FLG_ADDREG_TYPE_NONE        0x00020001
CONSTANT: FLG_DELREG_VALUE            0x00000000
CONSTANT: FLG_DELREG_TYPE_MASK        $ FLG_ADDREG_TYPE_MASK
CONSTANT: FLG_DELREG_TYPE_SZ          $ FLG_ADDREG_TYPE_SZ
CONSTANT: FLG_DELREG_TYPE_MULTI_SZ    $ FLG_ADDREG_TYPE_MULTI_SZ
CONSTANT: FLG_DELREG_TYPE_EXPAND_SZ   $ FLG_ADDREG_TYPE_EXPAND_SZ
CONSTANT: FLG_DELREG_TYPE_BINARY      $ FLG_ADDREG_TYPE_BINARY
CONSTANT: FLG_DELREG_TYPE_DWORD       $ FLG_ADDREG_TYPE_DWORD
CONSTANT: FLG_DELREG_TYPE_NONE        $ FLG_ADDREG_TYPE_NONE
CONSTANT: FLG_DELREG_64BITKEY         $ FLG_ADDREG_64BITKEY
CONSTANT: FLG_DELREG_KEYONLY_COMMON   $ FLG_ADDREG_KEYONLY_COMMON
CONSTANT: FLG_DELREG_32BITKEY         $ FLG_ADDREG_32BITKEY
CONSTANT: FLG_DELREG_OPERATION_MASK   0x000000FE
CONSTANT: FLG_DELREG_MULTI_SZ_DELSTRING 0x00018002
CONSTANT: FLG_BITREG_CLEARBITS        0x00000000
CONSTANT: FLG_BITREG_SETBITS          0x00000001
CONSTANT: FLG_BITREG_64BITKEY         0x00001000
CONSTANT: FLG_BITREG_32BITKEY         0x00004000
CONSTANT: FLG_INI2REG_64BITKEY        0x00001000
CONSTANT: FLG_INI2REG_32BITKEY        0x00004000
CONSTANT: FLG_REGSVR_DLLREGISTER      0x00000001
CONSTANT: FLG_REGSVR_DLLINSTALL       0x00000002
CONSTANT: FLG_PROFITEM_CURRENTUSER    0x00000001
CONSTANT: FLG_PROFITEM_DELETE         0x00000002
CONSTANT: FLG_PROFITEM_GROUP          0x00000004
CONSTANT: FLG_PROFITEM_CSIDL          0x00000008
CONSTANT: FLG_ADDPROPERTY_NOCLOBBER       0x00000001
CONSTANT: FLG_ADDPROPERTY_OVERWRITEONLY   0x00000002
CONSTANT: FLG_ADDPROPERTY_APPEND          0x00000004
CONSTANT: FLG_ADDPROPERTY_OR              0x00000008
CONSTANT: FLG_ADDPROPERTY_AND             0x00000010
CONSTANT: FLG_DELPROPERTY_MULTI_SZ_DELSTRING  0x00000001

FUNCTION: BOOL SetupInstallFromInfSectionA ( HWND Owner, HINF InfHandle, PCSTR SectionName, UINT Flags, HKEY RelativeKeyRoot, PCSTR SourceRootPath, UINT CopyFlags, PSP_FILE_CALLBACK_A MsgHandler, PVOID Context, HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupInstallFromInfSectionW ( HWND Owner, HINF InfHandle, PCWSTR SectionName, UINT Flags, HKEY RelativeKeyRoot, PCWSTR SourceRootPath, UINT CopyFlags, PSP_FILE_CALLBACK_W MsgHandler, PVOID Context, HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
ALIAS: SetupInstallFromInfSection SetupInstallFromInfSectionW

CONSTANT: SPINST_LOGCONFIG                0x00000001
CONSTANT: SPINST_INIFILES                 0x00000002
CONSTANT: SPINST_REGISTRY                 0x00000004
CONSTANT: SPINST_INI2REG                  0x00000008
CONSTANT: SPINST_FILES                    0x00000010
CONSTANT: SPINST_BITREG                   0x00000020
CONSTANT: SPINST_REGSVR                   0x00000040
CONSTANT: SPINST_UNREGSVR                 0x00000080
CONSTANT: SPINST_PROFILEITEMS             0x00000100
CONSTANT: SPINST_COPYINF                  0x00000200
CONSTANT: SPINST_PROPERTIES               0x00000400
CONSTANT: SPINST_ALL                      0x000007ff
CONSTANT: SPINST_SINGLESECTION            0x00010000
CONSTANT: SPINST_LOGCONFIG_IS_FORCED      0x00020000
CONSTANT: SPINST_LOGCONFIGS_ARE_OVERRIDES 0x00040000
CONSTANT: SPINST_REGISTERCALLBACKAWARE    0x00080000
CONSTANT: SPINST_DEVICEINSTALL            0x00100000

FUNCTION: BOOL SetupInstallFilesFromInfSectionA ( HINF InfHandle, HINF LayoutInfHandle, HSPFILEQ FileQueue, PCSTR SectionName, PCSTR SourceRootPath, UINT CopyFlags ) ;
FUNCTION: BOOL SetupInstallFilesFromInfSectionW ( HINF InfHandle, HINF LayoutInfHandle, HSPFILEQ FileQueue, PCWSTR SectionName, PCWSTR SourceRootPath, UINT CopyFlags ) ;
ALIAS: SetupInstallFilesFromInfSection SetupInstallFilesFromInfSectionW

CONSTANT: SPSVCINST_TAGTOFRONT                   0x00000001
CONSTANT: SPSVCINST_ASSOCSERVICE                 0x00000002
CONSTANT: SPSVCINST_DELETEEVENTLOGENTRY          0x00000004
CONSTANT: SPSVCINST_NOCLOBBER_DISPLAYNAME        0x00000008
CONSTANT: SPSVCINST_NOCLOBBER_STARTTYPE          0x00000010
CONSTANT: SPSVCINST_NOCLOBBER_ERRORCONTROL       0x00000020
CONSTANT: SPSVCINST_NOCLOBBER_LOADORDERGROUP     0x00000040
CONSTANT: SPSVCINST_NOCLOBBER_DEPENDENCIES       0x00000080
CONSTANT: SPSVCINST_NOCLOBBER_DESCRIPTION        0x00000100
CONSTANT: SPSVCINST_STOPSERVICE                  0x00000200
CONSTANT: SPSVCINST_CLOBBER_SECURITY             0x00000400
CONSTANT: SPSVCINST_STARTSERVICE                 0x00000800
CONSTANT: SPSVCINST_NOCLOBBER_REQUIREDPRIVILEGES 0x00001000

FUNCTION: BOOL SetupInstallServicesFromInfSectionA ( HINF InfHandle, PCSTR SectionName, DWORD Flags ) ;
FUNCTION: BOOL SetupInstallServicesFromInfSectionW ( HINF InfHandle, PCWSTR SectionName, DWORD Flags ) ;
ALIAS: SetupInstallServicesFromInfSection SetupInstallServicesFromInfSectionW

FUNCTION: BOOL SetupInstallServicesFromInfSectionExA ( HINF InfHandle, PCSTR SectionName, DWORD Flags, HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PVOID Reserved1, PVOID Reserved2 ) ;
FUNCTION: BOOL SetupInstallServicesFromInfSectionExW ( HINF InfHandle, PCWSTR SectionName, DWORD Flags, HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PVOID Reserved1, PVOID Reserved2 ) ;
ALIAS: SetupInstallServicesFromInfSectionEx SetupInstallServicesFromInfSectionExW

FUNCTION: void InstallHinfSectionA ( HWND Window, HINSTANCE ModuleHandle, PCSTR CommandLine, INT ShowCommand ) ;
FUNCTION: void InstallHinfSectionW ( HWND Window, HINSTANCE ModuleHandle, PCWSTR CommandLine, INT ShowCommand ) ;
ALIAS: InstallHinfSection InstallHinfSectionW

TYPEDEF: PVOID HSPFILELOG

FUNCTION: HSPFILELOG SetupInitializeFileLogA ( PCSTR LogFileName, DWORD Flags ) ;
FUNCTION: HSPFILELOG SetupInitializeFileLogW ( PCWSTR LogFileName, DWORD Flags ) ;
ALIAS: SetupInitializeFileLog SetupInitializeFileLogW

CONSTANT: SPFILELOG_SYSTEMLOG     0x00000001
CONSTANT: SPFILELOG_FORCENEW      0x00000002
CONSTANT: SPFILELOG_QUERYONLY     0x00000004

FUNCTION: BOOL SetupTerminateFileLog ( HSPFILELOG FileLogHandle ) ;
FUNCTION: BOOL SetupLogFileA ( HSPFILELOG FileLogHandle, PCSTR LogSectionName, PCSTR SourceFilename, PCSTR TargetFilename, DWORD Checksum, PCSTR DiskTagfile, PCSTR DiskDescription, PCSTR OtherInfo, DWORD Flags ) ;
FUNCTION: BOOL SetupLogFileW ( HSPFILELOG FileLogHandle, PCWSTR LogSectionName, PCWSTR SourceFilename, PCWSTR TargetFilename, DWORD Checksum, PCWSTR DiskTagfile, PCWSTR DiskDescription, PCWSTR OtherInfo, DWORD Flags ) ;
ALIAS: SetupLogFile SetupLogFileW

CONSTANT: SPFILELOG_OEMFILE   0x00000001
FUNCTION: BOOL SetupRemoveFileLogEntryA ( HSPFILELOG FileLogHandle, PCSTR LogSectionName, PCSTR TargetFilename ) ;
FUNCTION: BOOL SetupRemoveFileLogEntryW ( HSPFILELOG FileLogHandle, PCWSTR LogSectionName, PCWSTR TargetFilename ) ;
ALIAS: SetupRemoveFileLogEntry SetupRemoveFileLogEntryW

ENUM: SetupFileLogInfo
    SetupFileLogSourceFilename
    SetupFileLogChecksum
    SetupFileLogDiskTagfile
    SetupFileLogDiskDescription
    SetupFileLogOtherInfo
    SetupFileLogMax ;

FUNCTION: BOOL SetupQueryFileLogA ( HSPFILELOG FileLogHandle, PCSTR LogSectionName, PCSTR TargetFilename, SetupFileLogInfo DesiredInfo, PSTR DataOut, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupQueryFileLogW ( HSPFILELOG FileLogHandle, PCWSTR LogSectionName, PCWSTR TargetFilename, SetupFileLogInfo DesiredInfo, PWSTR DataOut, DWORD ReturnBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupQueryFileLog SetupQueryFileLogW

TYPEDEF: DWORD LogSeverity
CONSTANT: LogSevInformation           0x00000000
CONSTANT: LogSevWarning               0x00000001
CONSTANT: LogSevError                 0x00000002
CONSTANT: LogSevFatalError            0x00000003
CONSTANT: LogSevMaximum               0x00000004

FUNCTION: BOOL SetupOpenLog ( BOOL Erase ) ;
FUNCTION: BOOL SetupLogErrorA ( LPCSTR MessageString, LogSeverity Severity ) ;
FUNCTION: BOOL SetupLogErrorW ( LPCWSTR MessageString, LogSeverity Severity ) ;
ALIAS: SetupLogError SetupLogErrorW

FUNCTION: void SetupCloseLog ( ) ;
FUNCTION: SP_LOG_TOKEN SetupGetThreadLogToken ( ) ;
FUNCTION: void SetupSetThreadLogToken ( SP_LOG_TOKEN LogToken ) ;
! Unavailable until FFI to vargargs is supported.
! FUNCTION: void SetupWriteTextLog ( SP_LOG_TOKEN LogToken, DWORD Category, DWORD Flags, PCSTR MessageStr, ... ) ;
! FUNCTION: void SetupWriteTextLogError ( SP_LOG_TOKEN LogToken, DWORD Category, DWORD LogFlags, DWORD Error, PCSTR MessageStr, ... ) ;
FUNCTION: void SetupWriteTextLogInfLine ( SP_LOG_TOKEN LogToken, DWORD Flags, HINF InfHandle, PINFCONTEXT Context ) ;

FUNCTION: BOOL SetupGetBackupInformationA ( HSPFILEQ QueueHandle, PSP_BACKUP_QUEUE_PARAMS_A BackupParams ) ;
FUNCTION: BOOL SetupGetBackupInformationW ( HSPFILEQ QueueHandle, PSP_BACKUP_QUEUE_PARAMS_W BackupParams ) ;
ALIAS: SetupGetBackupInformation SetupGetBackupInformationW

FUNCTION: BOOL SetupPrepareQueueForRestoreA ( HSPFILEQ QueueHandle, PCSTR BackupPath, DWORD RestoreFlags ) ;
FUNCTION: BOOL SetupPrepareQueueForRestoreW ( HSPFILEQ QueueHandle, PCWSTR BackupPath, DWORD RestoreFlags ) ;
ALIAS: SetupPrepareQueueForRestore SetupPrepareQueueForRestoreW

FUNCTION: BOOL SetupSetNonInteractiveMode ( BOOL NonInteractiveFlag ) ;
FUNCTION: BOOL SetupGetNonInteractiveMode ( ) ;

FUNCTION: HDEVINFO SetupDiCreateDeviceInfoList ( GUID* ClassGuid, HWND hwndParent ) ;
FUNCTION: HDEVINFO SetupDiCreateDeviceInfoListExA ( GUID* ClassGuid, HWND hwndParent, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: HDEVINFO SetupDiCreateDeviceInfoListExW ( GUID* ClassGuid, HWND hwndParent, PCWSTR MachineName, PVOID Reserved ) ;

ALIAS: SetupDiCreateDeviceInfoListEx SetupDiCreateDeviceInfoListExW

FUNCTION: BOOL SetupDiGetDeviceInfoListClass( HDEVINFO DeviceInfoSet, LPGUID ClassGuid ) ;
FUNCTION: BOOL SetupDiGetDeviceInfoListDetailA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_LIST_DETAIL_DATA_A DeviceInfoSetDetailData ) ;
FUNCTION: BOOL SetupDiGetDeviceInfoListDetailW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_LIST_DETAIL_DATA_W DeviceInfoSetDetailData ) ;
ALIAS: SetupDiGetDeviceInfoListDetail SetupDiGetDeviceInfoListDetailW

CONSTANT: DICD_GENERATE_ID        0x00000001
CONSTANT: DICD_INHERIT_CLASSDRVS  0x00000002

FUNCTION: BOOL SetupDiCreateDeviceInfoA ( HDEVINFO DeviceInfoSet, PCSTR DeviceName, GUID* ClassGuid, PCSTR DeviceDescription, HWND hwndParent, DWORD CreationFlags, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiCreateDeviceInfoW ( HDEVINFO DeviceInfoSet, PCWSTR DeviceName, GUID* ClassGuid, PCWSTR DeviceDescription, HWND hwndParent, DWORD CreationFlags, PSP_DEVINFO_DATA DeviceInfoData ) ;
ALIAS: SetupDiCreateDeviceInfo SetupDiCreateDeviceInfoW

CONSTANT: DIOD_INHERIT_CLASSDRVS  0x00000002
CONSTANT: DIOD_CANCEL_REMOVE      0x00000004

FUNCTION: BOOL SetupDiOpenDeviceInfoA ( HDEVINFO DeviceInfoSet, PCSTR DeviceInstanceId, HWND hwndParent, DWORD OpenFlags, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiOpenDeviceInfoW ( HDEVINFO DeviceInfoSet, PCWSTR DeviceInstanceId, HWND hwndParent, DWORD OpenFlags, PSP_DEVINFO_DATA DeviceInfoData ) ;
ALIAS: SetupDiOpenDeviceInfo SetupDiOpenDeviceInfoW

FUNCTION: BOOL SetupDiGetDeviceInstanceIdA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSTR DeviceInstanceId, DWORD DeviceInstanceIdSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupDiGetDeviceInstanceIdW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PWSTR DeviceInstanceId, DWORD DeviceInstanceIdSize, PDWORD RequiredSize ) ;
ALIAS: SetupDiGetDeviceInstanceId SetupDiGetDeviceInstanceIdW

FUNCTION: BOOL SetupDiDeleteDeviceInfo ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiEnumDeviceInfo ( HDEVINFO DeviceInfoSet, DWORD MemberIndex, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiDestroyDeviceInfoList ( HDEVINFO DeviceInfoSet ) ;
FUNCTION: BOOL SetupDiEnumDeviceInterfaces ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, GUID* InterfaceClassGuid, DWORD MemberIndex, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData ) ;
ALIAS: SetupDiEnumInterfaceDevice SetupDiEnumDeviceInterfaces

FUNCTION: BOOL SetupDiCreateDeviceInterfaceA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, GUID* InterfaceClassGuid, PCSTR ReferenceString, DWORD CreationFlags, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData ) ;
FUNCTION: BOOL SetupDiCreateDeviceInterfaceW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, GUID* InterfaceClassGuid, PCWSTR ReferenceString, DWORD CreationFlags, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData ) ;
ALIAS: SetupDiCreateDeviceInterface SetupDiCreateDeviceInterfaceW

ALIAS: SetupDiCreateInterfaceDeviceW SetupDiCreateDeviceInterfaceW
ALIAS: SetupDiCreateInterfaceDeviceA SetupDiCreateDeviceInterfaceA

ALIAS: SetupDiCreateInterfaceDevice SetupDiCreateDeviceInterfaceW

CONSTANT: DIODI_NO_ADD    0x00000001

FUNCTION: BOOL SetupDiOpenDeviceInterfaceA ( HDEVINFO DeviceInfoSet, PCSTR DevicePath, DWORD OpenFlags, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData ) ;
FUNCTION: BOOL SetupDiOpenDeviceInterfaceW ( HDEVINFO DeviceInfoSet, PCWSTR DevicePath, DWORD OpenFlags, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData ) ;
ALIAS: SetupDiOpenDeviceInterface SetupDiOpenDeviceInterfaceW

ALIAS: SetupDiOpenInterfaceDeviceW SetupDiOpenDeviceInterfaceW
ALIAS: SetupDiOpenInterfaceDeviceA SetupDiOpenDeviceInterfaceA

ALIAS: SetupDiOpenInterfaceDevice SetupDiOpenDeviceInterfaceW

FUNCTION: BOOL SetupDiGetDeviceInterfaceAlias ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData, GUID* AliasInterfaceClassGuid, PSP_DEVICE_INTERFACE_DATA AliasDeviceInterfaceData ) ;
ALIAS: SetupDiGetInterfaceDeviceAlias SetupDiGetDeviceInterfaceAlias

FUNCTION: BOOL SetupDiDeleteDeviceInterfaceData ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData ) ;
ALIAS: SetupDiDeleteInterfaceDeviceData SetupDiDeleteDeviceInterfaceData

FUNCTION: BOOL SetupDiRemoveDeviceInterface ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData ) ;
ALIAS: SetupDiRemoveInterfaceDevice SetupDiRemoveDeviceInterface

FUNCTION: BOOL SetupDiGetDeviceInterfaceDetailA ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData, PSP_DEVICE_INTERFACE_DETAIL_DATA_A DeviceInterfaceDetailData, DWORD DeviceInterfaceDetailDataSize, PDWORD RequiredSize, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiGetDeviceInterfaceDetailW ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData, PSP_DEVICE_INTERFACE_DETAIL_DATA_W DeviceInterfaceDetailData, DWORD DeviceInterfaceDetailDataSize, PDWORD RequiredSize, PSP_DEVINFO_DATA DeviceInfoData ) ;
ALIAS: SetupDiGetDeviceInterfaceDetail SetupDiGetDeviceInterfaceDetailW

ALIAS: SetupDiGetInterfaceDeviceDetailW SetupDiGetDeviceInterfaceDetailW
ALIAS: SetupDiGetInterfaceDeviceDetailA SetupDiGetDeviceInterfaceDetailA

ALIAS: SetupDiGetInterfaceDeviceDetail SetupDiGetDeviceInterfaceDetailW

FUNCTION: BOOL SetupDiInstallDeviceInterfaces ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
ALIAS: SetupDiInstallInterfaceDevices SetupDiInstallDeviceInterfaces

FUNCTION: BOOL SetupDiSetDeviceInterfaceDefault ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData, DWORD Flags, PVOID Reserved ) ;

CONSTANT: SPRDI_FIND_DUPS        0x00000001

FUNCTION: BOOL SetupDiRegisterDeviceInfo ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD Flags, PSP_DETSIG_CMPPROC CompareProc, PVOID CompareContext, PSP_DEVINFO_DATA DupDeviceInfoData ) ;

CONSTANT: SPDIT_NODRIVER           0x00000000
CONSTANT: SPDIT_CLASSDRIVER        0x00000001
CONSTANT: SPDIT_COMPATDRIVER       0x00000002

FUNCTION: BOOL SetupDiBuildDriverInfoList ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD DriverType ) ;
FUNCTION: BOOL SetupDiCancelDriverInfoSearch ( HDEVINFO DeviceInfoSet ) ;
FUNCTION: BOOL SetupDiEnumDriverInfoA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD DriverType, DWORD MemberIndex, PSP_DRVINFO_DATA_A DriverInfoData ) ;
FUNCTION: BOOL SetupDiEnumDriverInfoW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD DriverType, DWORD MemberIndex, PSP_DRVINFO_DATA_W DriverInfoData ) ;
ALIAS: SetupDiEnumDriverInfo SetupDiEnumDriverInfoW

FUNCTION: BOOL SetupDiGetSelectedDriverA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DRVINFO_DATA_A DriverInfoData ) ;
FUNCTION: BOOL SetupDiGetSelectedDriverW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DRVINFO_DATA_W DriverInfoData ) ;
ALIAS: SetupDiGetSelectedDriver SetupDiGetSelectedDriverW

FUNCTION: BOOL SetupDiSetSelectedDriverA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DRVINFO_DATA_A DriverInfoData ) ;
FUNCTION: BOOL SetupDiSetSelectedDriverW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DRVINFO_DATA_W DriverInfoData ) ;
ALIAS: SetupDiSetSelectedDriver SetupDiSetSelectedDriverW

FUNCTION: BOOL SetupDiGetDriverInfoDetailA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DRVINFO_DATA_A DriverInfoData, PSP_DRVINFO_DETAIL_DATA_A DriverInfoDetailData, DWORD DriverInfoDetailDataSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupDiGetDriverInfoDetailW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DRVINFO_DATA_W DriverInfoData, PSP_DRVINFO_DETAIL_DATA_W DriverInfoDetailData, DWORD DriverInfoDetailDataSize, PDWORD RequiredSize ) ;
ALIAS: SetupDiGetDriverInfoDetail SetupDiGetDriverInfoDetailW

FUNCTION: BOOL SetupDiDestroyDriverInfoList ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD DriverType ) ;

CONSTANT: DIGCF_DEFAULT           0x00000001
CONSTANT: DIGCF_PRESENT           0x00000002
CONSTANT: DIGCF_ALLCLASSES        0x00000004
CONSTANT: DIGCF_PROFILE           0x00000008
CONSTANT: DIGCF_DEVICEINTERFACE   0x00000010
CONSTANT: DIGCF_INTERFACEDEVICE   $ DIGCF_DEVICEINTERFACE

FUNCTION: HDEVINFO SetupDiGetClassDevsA ( GUID* ClassGuid, PCSTR Enumerator, HWND hwndParent, DWORD Flags ) ;
FUNCTION: HDEVINFO SetupDiGetClassDevsW ( GUID* ClassGuid, PCWSTR Enumerator, HWND hwndParent, DWORD Flags ) ;
ALIAS: SetupDiGetClassDevs SetupDiGetClassDevsW

FUNCTION: HDEVINFO SetupDiGetClassDevsExA ( GUID* ClassGuid, PCSTR Enumerator, HWND hwndParent, DWORD Flags, HDEVINFO DeviceInfoSet, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: HDEVINFO SetupDiGetClassDevsExW ( GUID* ClassGuid, PCWSTR Enumerator, HWND hwndParent, DWORD Flags, HDEVINFO DeviceInfoSet, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiGetClassDevsEx SetupDiGetClassDevsExW

FUNCTION: BOOL SetupDiGetINFClassA ( PCSTR InfName, LPGUID ClassGuid, PSTR ClassName, DWORD ClassNameSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupDiGetINFClassW ( PCWSTR InfName, LPGUID ClassGuid, PWSTR ClassName, DWORD ClassNameSize, PDWORD RequiredSize ) ;
ALIAS: SetupDiGetINFClass SetupDiGetINFClassW

CONSTANT: DIBCI_NOINSTALLCLASS   0x00000001
CONSTANT: DIBCI_NODISPLAYCLASS   0x00000002

FUNCTION: BOOL SetupDiBuildClassInfoList ( DWORD Flags, LPGUID ClassGuidList, DWORD ClassGuidListSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupDiBuildClassInfoListExA ( DWORD Flags, LPGUID ClassGuidList, DWORD ClassGuidListSize, PDWORD RequiredSize, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: BOOL SetupDiBuildClassInfoListExW ( DWORD Flags, LPGUID ClassGuidList, DWORD ClassGuidListSize, PDWORD RequiredSize, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiBuildClassInfoListEx SetupDiBuildClassInfoListExW

FUNCTION: BOOL SetupDiGetClassDescriptionA ( GUID* ClassGuid, PSTR ClassDescription, DWORD ClassDescriptionSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupDiGetClassDescriptionW ( GUID* ClassGuid, PWSTR ClassDescription, DWORD ClassDescriptionSize, PDWORD RequiredSize ) ;
ALIAS: SetupDiGetClassDescription SetupDiGetClassDescriptionW

FUNCTION: BOOL SetupDiGetClassDescriptionExA ( GUID* ClassGuid, PSTR ClassDescription, DWORD ClassDescriptionSize, PDWORD RequiredSize, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: BOOL SetupDiGetClassDescriptionExW ( GUID* ClassGuid, PWSTR ClassDescription, DWORD ClassDescriptionSize, PDWORD RequiredSize, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiGetClassDescriptionEx SetupDiGetClassDescriptionExW

FUNCTION: BOOL SetupDiCallClassInstaller ( DI_FUNCTION InstallFunction, HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiSelectDevice ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiSelectBestCompatDrv ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiInstallDevice ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiInstallDriverFiles ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiRegisterCoDeviceInstallers( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiRemoveDevice ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiUnremoveDevice ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiRestartDevices ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiChangeState ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiFinishInstallAction ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;

FUNCTION: BOOL SetupDiInstallClassA ( HWND hwndParent, PCSTR InfFileName, DWORD Flags, HSPFILEQ FileQueue ) ;
FUNCTION: BOOL SetupDiInstallClassW ( HWND hwndParent, PCWSTR InfFileName, DWORD Flags, HSPFILEQ FileQueue ) ;
ALIAS: SetupDiInstallClass SetupDiInstallClassW

FUNCTION: BOOL SetupDiInstallClassExA ( HWND hwndParent, PCSTR InfFileName, DWORD Flags, HSPFILEQ FileQueue, GUID* InterfaceClassGuid, PVOID Reserved1, PVOID Reserved2 ) ;
FUNCTION: BOOL SetupDiInstallClassExW ( HWND hwndParent, PCWSTR InfFileName, DWORD Flags, HSPFILEQ FileQueue, GUID* InterfaceClassGuid, PVOID Reserved1, PVOID Reserved2 ) ;
ALIAS: SetupDiInstallClassEx SetupDiInstallClassExW

FUNCTION: HKEY SetupDiOpenClassRegKey ( GUID* ClassGuid, REGSAM samDesired ) ;

CONSTANT: DIOCR_INSTALLER   0x00000001
CONSTANT: DIOCR_INTERFACE   0x00000002

FUNCTION: HKEY SetupDiOpenClassRegKeyExA ( GUID* ClassGuid, REGSAM samDesired, DWORD Flags, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: HKEY SetupDiOpenClassRegKeyExW ( GUID* ClassGuid, REGSAM samDesired, DWORD Flags, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiOpenClassRegKeyEx SetupDiOpenClassRegKeyExW

FUNCTION: HKEY SetupDiCreateDeviceInterfaceRegKeyA ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData, DWORD Reserved, REGSAM samDesired, HINF InfHandle, PCSTR InfSectionName ) ;
FUNCTION: HKEY SetupDiCreateDeviceInterfaceRegKeyW ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData, DWORD Reserved, REGSAM samDesired, HINF InfHandle, PCWSTR InfSectionName ) ;
ALIAS: SetupDiCreateDeviceInterfaceRegKey SetupDiCreateDeviceInterfaceRegKeyW
ALIAS: SetupDiCreateInterfaceDeviceRegKeyW SetupDiCreateDeviceInterfaceRegKeyW
ALIAS: SetupDiCreateInterfaceDeviceRegKeyA SetupDiCreateDeviceInterfaceRegKeyA
ALIAS: SetupDiCreateInterfaceDeviceRegKey SetupDiCreateDeviceInterfaceRegKeyW

FUNCTION: HKEY SetupDiOpenDeviceInterfaceRegKey ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData, DWORD Reserved, REGSAM samDesired ) ;
ALIAS: SetupDiOpenInterfaceDeviceRegKey SetupDiOpenDeviceInterfaceRegKey

FUNCTION: BOOL SetupDiDeleteDeviceInterfaceRegKey ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData, DWORD Reserved ) ;
ALIAS: SetupDiDeleteInterfaceDeviceRegKey SetupDiDeleteDeviceInterfaceRegKey

CONSTANT: DIREG_DEV       0x00000001
CONSTANT: DIREG_DRV       0x00000002
CONSTANT: DIREG_BOTH      0x00000004

FUNCTION: HKEY SetupDiCreateDevRegKeyA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD Scope, DWORD HwProfile, DWORD KeyType, HINF InfHandle, PCSTR InfSectionName ) ;
FUNCTION: HKEY SetupDiCreateDevRegKeyW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD Scope, DWORD HwProfile, DWORD KeyType, HINF InfHandle, PCWSTR InfSectionName ) ;
ALIAS: SetupDiCreateDevRegKey SetupDiCreateDevRegKeyW

FUNCTION: HKEY SetupDiOpenDevRegKey ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD Scope, DWORD HwProfile, DWORD KeyType, REGSAM samDesired ) ;
FUNCTION: BOOL SetupDiDeleteDevRegKey ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD Scope, DWORD HwProfile, DWORD KeyType ) ;
FUNCTION: BOOL SetupDiGetHwProfileList ( PDWORD HwProfileList, DWORD HwProfileListSize, PDWORD RequiredSize, PDWORD CurrentlyActiveIndex ) ;
FUNCTION: BOOL SetupDiGetHwProfileListExA ( PDWORD HwProfileList, DWORD HwProfileListSize, PDWORD RequiredSize, PDWORD CurrentlyActiveIndex, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: BOOL SetupDiGetHwProfileListExW ( PDWORD HwProfileList, DWORD HwProfileListSize, PDWORD RequiredSize, PDWORD CurrentlyActiveIndex, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiGetHwProfileListEx SetupDiGetHwProfileListExW

FUNCTION: BOOL SetupDiGetDevicePropertyKeys ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DEVPROPKEY* PropertyKeyArray, DWORD PropertyKeyCount, PDWORD RequiredPropertyKeyCount, DWORD Flags ) ;
FUNCTION: BOOL SetupDiGetDevicePropertyW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DEVPROPKEY* PropertyKey, DEVPROPTYPE* PropertyType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, PDWORD RequiredSize, DWORD Flags ) ;
ALIAS: SetupDiGetDeviceProperty SetupDiGetDevicePropertyW

FUNCTION: BOOL SetupDiSetDevicePropertyW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DEVPROPKEY* PropertyKey, DEVPROPTYPE PropertyType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, DWORD Flags ) ;
ALIAS: SetupDiSetDeviceProperty SetupDiSetDevicePropertyW

FUNCTION: BOOL SetupDiGetDeviceInterfacePropertyKeys ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData, DEVPROPKEY* PropertyKeyArray, DWORD PropertyKeyCount, PDWORD RequiredPropertyKeyCount, DWORD Flags ) ;
FUNCTION: BOOL SetupDiGetDeviceInterfacePropertyW ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData, DEVPROPKEY* PropertyKey, DEVPROPTYPE* PropertyType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, PDWORD RequiredSize, DWORD Flags ) ;
ALIAS: SetupDiGetDeviceInterfaceProperty SetupDiGetDeviceInterfacePropertyW

FUNCTION: BOOL SetupDiSetDeviceInterfacePropertyW ( HDEVINFO DeviceInfoSet, PSP_DEVICE_INTERFACE_DATA DeviceInterfaceData, DEVPROPKEY* PropertyKey, DEVPROPTYPE PropertyType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, DWORD Flags ) ;
ALIAS: SetupDiSetDeviceInterfaceProperty SetupDiSetDeviceInterfacePropertyW

CONSTANT: DICLASSPROP_INSTALLER   0x00000001
CONSTANT: DICLASSPROP_INTERFACE   0x00000002

FUNCTION: BOOL SetupDiGetClassPropertyKeys ( GUID* ClassGuid, DEVPROPKEY* PropertyKeyArray, DWORD PropertyKeyCount, PDWORD RequiredPropertyKeyCount, DWORD Flags ) ;
FUNCTION: BOOL SetupDiGetClassPropertyKeysExW ( GUID* ClassGuid, DEVPROPKEY* PropertyKeyArray, DWORD PropertyKeyCount, PDWORD RequiredPropertyKeyCount, DWORD Flags, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiGetClassPropertyKeysEx SetupDiGetClassPropertyKeysExW

FUNCTION: BOOL SetupDiGetClassPropertyW ( GUID* ClassGuid, DEVPROPKEY* PropertyKey, DEVPROPTYPE* PropertyType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, PDWORD RequiredSize, DWORD Flags ) ;
ALIAS: SetupDiGetClassProperty SetupDiGetClassPropertyW

FUNCTION: BOOL SetupDiGetClassPropertyExW ( GUID* ClassGuid, DEVPROPKEY* PropertyKey, DEVPROPTYPE* PropertyType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, PDWORD RequiredSize, DWORD Flags, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiGetClassPropertyEx SetupDiGetClassPropertyExW

FUNCTION: BOOL SetupDiSetClassPropertyW ( GUID* ClassGuid, DEVPROPKEY* PropertyKey, DEVPROPTYPE PropertyType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, DWORD Flags ) ;
ALIAS: SetupDiSetClassProperty SetupDiSetClassPropertyW

FUNCTION: BOOL SetupDiSetClassPropertyExW ( GUID* ClassGuid, DEVPROPKEY* PropertyKey, DEVPROPTYPE PropertyType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, DWORD Flags, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiSetClassPropertyEx SetupDiSetClassPropertyExW

CONSTANT: SPDRP_DEVICEDESC                  0x00000000
CONSTANT: SPDRP_HARDWAREID                  0x00000001
CONSTANT: SPDRP_COMPATIBLEIDS               0x00000002
CONSTANT: SPDRP_UNUSED0                     0x00000003
CONSTANT: SPDRP_SERVICE                     0x00000004
CONSTANT: SPDRP_UNUSED1                     0x00000005
CONSTANT: SPDRP_UNUSED2                     0x00000006
CONSTANT: SPDRP_CLASS                       0x00000007
CONSTANT: SPDRP_CLASSGUID                   0x00000008
CONSTANT: SPDRP_DRIVER                      0x00000009
CONSTANT: SPDRP_CONFIGFLAGS                 0x0000000A
CONSTANT: SPDRP_MFG                         0x0000000B
CONSTANT: SPDRP_FRIENDLYNAME                0x0000000C
CONSTANT: SPDRP_LOCATION_INFORMATION        0x0000000D
CONSTANT: SPDRP_PHYSICAL_DEVICE_OBJECT_NAME 0x0000000E
CONSTANT: SPDRP_CAPABILITIES                0x0000000F
CONSTANT: SPDRP_UI_NUMBER                   0x00000010
CONSTANT: SPDRP_UPPERFILTERS                0x00000011
CONSTANT: SPDRP_LOWERFILTERS                0x00000012
CONSTANT: SPDRP_BUSTYPEGUID                 0x00000013
CONSTANT: SPDRP_LEGACYBUSTYPE               0x00000014
CONSTANT: SPDRP_BUSNUMBER                   0x00000015
CONSTANT: SPDRP_ENUMERATOR_NAME             0x00000016
CONSTANT: SPDRP_SECURITY                    0x00000017
CONSTANT: SPDRP_SECURITY_SDS                0x00000018
CONSTANT: SPDRP_DEVTYPE                     0x00000019
CONSTANT: SPDRP_EXCLUSIVE                   0x0000001A
CONSTANT: SPDRP_CHARACTERISTICS             0x0000001B
CONSTANT: SPDRP_ADDRESS                     0x0000001C
CONSTANT: SPDRP_UI_NUMBER_DESC_FORMAT       0x0000001D
CONSTANT: SPDRP_DEVICE_POWER_DATA           0x0000001E
CONSTANT: SPDRP_REMOVAL_POLICY              0x0000001F
CONSTANT: SPDRP_REMOVAL_POLICY_HW_DEFAULT   0x00000020
CONSTANT: SPDRP_REMOVAL_POLICY_OVERRIDE     0x00000021
CONSTANT: SPDRP_INSTALL_STATE               0x00000022
CONSTANT: SPDRP_LOCATION_PATHS              0x00000023
CONSTANT: SPDRP_BASE_CONTAINERID            0x00000024
CONSTANT: SPDRP_MAXIMUM_PROPERTY            0x00000025
CONSTANT: SPCRP_UPPERFILTERS                0x00000011
CONSTANT: SPCRP_LOWERFILTERS                0x00000012
CONSTANT: SPCRP_SECURITY                    0x00000017
CONSTANT: SPCRP_SECURITY_SDS                0x00000018
CONSTANT: SPCRP_DEVTYPE                     0x00000019
CONSTANT: SPCRP_EXCLUSIVE                   0x0000001A
CONSTANT: SPCRP_CHARACTERISTICS             0x0000001B
CONSTANT: SPCRP_MAXIMUM_PROPERTY            0x0000001C

FUNCTION: BOOL SetupDiGetDeviceRegistryPropertyA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD Property, PDWORD PropertyRegDataType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupDiGetDeviceRegistryPropertyW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD Property, PDWORD PropertyRegDataType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupDiGetDeviceRegistryProperty SetupDiGetDeviceRegistryPropertyW

FUNCTION: BOOL SetupDiGetClassRegistryPropertyA ( GUID* ClassGuid, DWORD Property, PDWORD PropertyRegDataType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, PDWORD RequiredSize, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: BOOL SetupDiGetClassRegistryPropertyW ( GUID* ClassGuid, DWORD Property, PDWORD PropertyRegDataType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, PDWORD RequiredSize, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiGetClassRegistryProperty SetupDiGetClassRegistryPropertyW

FUNCTION: BOOL SetupDiSetDeviceRegistryPropertyA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD Property, BYTE* PropertyBuffer, DWORD PropertyBufferSize ) ;
FUNCTION: BOOL SetupDiSetDeviceRegistryPropertyW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, DWORD Property, BYTE* PropertyBuffer, DWORD PropertyBufferSize ) ;
ALIAS: SetupDiSetDeviceRegistryProperty SetupDiSetDeviceRegistryPropertyW

FUNCTION: BOOL SetupDiSetClassRegistryPropertyA ( GUID* ClassGuid, DWORD Property, BYTE* PropertyBuffer, DWORD PropertyBufferSize, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: BOOL SetupDiSetClassRegistryPropertyW ( GUID* ClassGuid, DWORD Property, BYTE* PropertyBuffer, DWORD PropertyBufferSize, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiSetClassRegistryProperty SetupDiSetClassRegistryPropertyW

FUNCTION: BOOL SetupDiGetDeviceInstallParamsA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DEVINSTALL_PARAMS_A DeviceInstallParams ) ;
FUNCTION: BOOL SetupDiGetDeviceInstallParamsW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DEVINSTALL_PARAMS_W DeviceInstallParams ) ;
ALIAS: SetupDiGetDeviceInstallParams SetupDiGetDeviceInstallParamsW

FUNCTION: BOOL SetupDiGetClassInstallParamsA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_CLASSINSTALL_HEADER ClassInstallParams, DWORD ClassInstallParamsSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupDiGetClassInstallParamsW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_CLASSINSTALL_HEADER ClassInstallParams, DWORD ClassInstallParamsSize, PDWORD RequiredSize ) ;
ALIAS: SetupDiGetClassInstallParams SetupDiGetClassInstallParamsW

FUNCTION: BOOL SetupDiSetDeviceInstallParamsA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DEVINSTALL_PARAMS_A DeviceInstallParams ) ;
FUNCTION: BOOL SetupDiSetDeviceInstallParamsW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DEVINSTALL_PARAMS_W DeviceInstallParams ) ;
ALIAS: SetupDiSetDeviceInstallParams SetupDiSetDeviceInstallParamsW

FUNCTION: BOOL SetupDiSetClassInstallParamsA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_CLASSINSTALL_HEADER ClassInstallParams, DWORD ClassInstallParamsSize ) ;
FUNCTION: BOOL SetupDiSetClassInstallParamsW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_CLASSINSTALL_HEADER ClassInstallParams, DWORD ClassInstallParamsSize ) ;
ALIAS: SetupDiSetClassInstallParams SetupDiSetClassInstallParamsW

FUNCTION: BOOL SetupDiGetDriverInstallParamsA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DRVINFO_DATA_A DriverInfoData, PSP_DRVINSTALL_PARAMS DriverInstallParams ) ;
FUNCTION: BOOL SetupDiGetDriverInstallParamsW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DRVINFO_DATA_W DriverInfoData, PSP_DRVINSTALL_PARAMS DriverInstallParams ) ;
ALIAS: SetupDiGetDriverInstallParams SetupDiGetDriverInstallParamsW

FUNCTION: BOOL SetupDiSetDriverInstallParamsA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DRVINFO_DATA_A DriverInfoData, PSP_DRVINSTALL_PARAMS DriverInstallParams ) ;
FUNCTION: BOOL SetupDiSetDriverInstallParamsW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_DRVINFO_DATA_W DriverInfoData, PSP_DRVINSTALL_PARAMS DriverInstallParams ) ;
ALIAS: SetupDiSetDriverInstallParams SetupDiSetDriverInstallParamsW

FUNCTION: BOOL SetupDiLoadClassIcon ( GUID* ClassGuid, HICON* LargeIcon, PINT MiniIconIndex ) ;
FUNCTION: BOOL SetupDiLoadDeviceIcon ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, UINT cxIcon, UINT cyIcon, DWORD Flags, HICON* hIcon ) ;

CONSTANT: DMI_MASK      0x00000001
CONSTANT: DMI_BKCOLOR   0x00000002
CONSTANT: DMI_USERECT   0x00000004

FUNCTION: INT SetupDiDrawMiniIcon ( HDC hdc, RECT rc, INT MiniIconIndex, DWORD Flags ) ;
FUNCTION: BOOL SetupDiGetClassBitmapIndex ( GUID* ClassGuid, PINT MiniIconIndex ) ;
FUNCTION: BOOL SetupDiGetClassImageList ( PSP_CLASSIMAGELIST_DATA ClassImageListData ) ;
FUNCTION: BOOL SetupDiGetClassImageListExA ( PSP_CLASSIMAGELIST_DATA ClassImageListData, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: BOOL SetupDiGetClassImageListExW ( PSP_CLASSIMAGELIST_DATA ClassImageListData, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiGetClassImageListEx SetupDiGetClassImageListExW

FUNCTION: BOOL SetupDiGetClassImageIndex ( PSP_CLASSIMAGELIST_DATA ClassImageListData, GUID* ClassGuid, PINT ImageIndex ) ;
FUNCTION: BOOL SetupDiDestroyClassImageList ( PSP_CLASSIMAGELIST_DATA ClassImageListData ) ;

CONSTANT: DIGCDP_FLAG_BASIC           0x00000001
CONSTANT: DIGCDP_FLAG_ADVANCED        0x00000002
CONSTANT: DIGCDP_FLAG_REMOTE_BASIC    0x00000003
CONSTANT: DIGCDP_FLAG_REMOTE_ADVANCED 0x00000004

FUNCTION: BOOL SetupDiGetClassDevPropertySheetsA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, LPPROPSHEETHEADERA PropertySheetHeader, DWORD PropertySheetHeaderPageListSize, PDWORD RequiredSize, DWORD PropertySheetType ) ;
FUNCTION: BOOL SetupDiGetClassDevPropertySheetsW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, LPPROPSHEETHEADERW PropertySheetHeader, DWORD PropertySheetHeaderPageListSize, PDWORD RequiredSize, DWORD PropertySheetType ) ;
ALIAS: SetupDiGetClassDevPropertySheets SetupDiGetClassDevPropertySheetsW

CONSTANT: IDI_RESOURCEFIRST           159
CONSTANT: IDI_RESOURCE                159
CONSTANT: IDI_RESOURCELAST            161
CONSTANT: IDI_RESOURCEOVERLAYFIRST    161
CONSTANT: IDI_RESOURCEOVERLAYLAST     161
CONSTANT: IDI_CONFLICT                161
CONSTANT: IDI_CLASSICON_OVERLAYFIRST  500
CONSTANT: IDI_CLASSICON_OVERLAYLAST   502
CONSTANT: IDI_PROBLEM_OVL             500
CONSTANT: IDI_DISABLED_OVL            501
CONSTANT: IDI_FORCED_OVL              502

FUNCTION: BOOL SetupDiAskForOEMDisk ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiSelectOEMDrv ( HWND hwndParent, HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiClassNameFromGuidA ( GUID* ClassGuid, PSTR ClassName, DWORD ClassNameSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupDiClassNameFromGuidW ( GUID* ClassGuid, PWSTR ClassName, DWORD ClassNameSize, PDWORD RequiredSize ) ;
ALIAS: SetupDiClassNameFromGuid SetupDiClassNameFromGuidW

FUNCTION: BOOL SetupDiClassNameFromGuidExA ( GUID* ClassGuid, PSTR ClassName, DWORD ClassNameSize, PDWORD RequiredSize, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: BOOL SetupDiClassNameFromGuidExW ( GUID* ClassGuid, PWSTR ClassName, DWORD ClassNameSize, PDWORD RequiredSize, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiClassNameFromGuidEx SetupDiClassNameFromGuidExW

FUNCTION: BOOL SetupDiClassGuidsFromNameA ( PCSTR ClassName, LPGUID ClassGuidList, DWORD ClassGuidListSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupDiClassGuidsFromNameW ( PCWSTR ClassName, LPGUID ClassGuidList, DWORD ClassGuidListSize, PDWORD RequiredSize ) ;
ALIAS: SetupDiClassGuidsFromName SetupDiClassGuidsFromNameW

FUNCTION: BOOL SetupDiClassGuidsFromNameExA ( PCSTR ClassName, LPGUID ClassGuidList, DWORD ClassGuidListSize, PDWORD RequiredSize, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: BOOL SetupDiClassGuidsFromNameExW ( PCWSTR ClassName, LPGUID ClassGuidList, DWORD ClassGuidListSize, PDWORD RequiredSize, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiClassGuidsFromNameEx SetupDiClassGuidsFromNameExW

FUNCTION: BOOL SetupDiGetHwProfileFriendlyNameA ( DWORD HwProfile, PSTR FriendlyName, DWORD FriendlyNameSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupDiGetHwProfileFriendlyNameW ( DWORD HwProfile, PWSTR FriendlyName, DWORD FriendlyNameSize, PDWORD RequiredSize ) ;
ALIAS: SetupDiGetHwProfileFriendlyName SetupDiGetHwProfileFriendlyNameW

FUNCTION: BOOL SetupDiGetHwProfileFriendlyNameExA ( DWORD HwProfile, PSTR FriendlyName, DWORD FriendlyNameSize, PDWORD RequiredSize, PCSTR MachineName, PVOID Reserved ) ;
FUNCTION: BOOL SetupDiGetHwProfileFriendlyNameExW ( DWORD HwProfile, PWSTR FriendlyName, DWORD FriendlyNameSize, PDWORD RequiredSize, PCWSTR MachineName, PVOID Reserved ) ;
ALIAS: SetupDiGetHwProfileFriendlyNameEx SetupDiGetHwProfileFriendlyNameExW

CONSTANT: SPWPT_SELECTDEVICE      0x00000001
CONSTANT: SPWP_USE_DEVINFO_DATA   0x00000001

FUNCTION: HPROPSHEETPAGE SetupDiGetWizardPage ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PSP_INSTALLWIZARD_DATA InstallWizardData, DWORD PageType, DWORD Flags ) ;
FUNCTION: BOOL SetupDiGetSelectedDevice ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;
FUNCTION: BOOL SetupDiSetSelectedDevice ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData ) ;

FUNCTION: BOOL SetupDiGetActualModelsSectionA ( PINFCONTEXT Context, PSP_ALTPLATFORM_INFO AlternatePlatformInfo, PSTR InfSectionWithExt, DWORD InfSectionWithExtSize, PDWORD RequiredSize, PVOID Reserved ) ;
FUNCTION: BOOL SetupDiGetActualModelsSectionW ( PINFCONTEXT Context, PSP_ALTPLATFORM_INFO AlternatePlatformInfo, PWSTR InfSectionWithExt, DWORD InfSectionWithExtSize, PDWORD RequiredSize, PVOID Reserved ) ;

ALIAS: SetupDiGetActualModelsSection SetupDiGetActualModelsSectionW

FUNCTION: BOOL SetupDiGetActualSectionToInstallA ( HINF InfHandle, PCSTR InfSectionName, PSTR InfSectionWithExt, DWORD InfSectionWithExtSize, PDWORD RequiredSize, PSTR* Extension ) ;
FUNCTION: BOOL SetupDiGetActualSectionToInstallW ( HINF InfHandle, PCWSTR InfSectionName, PWSTR InfSectionWithExt, DWORD InfSectionWithExtSize, PDWORD RequiredSize, PWSTR* Extension ) ;
ALIAS: SetupDiGetActualSectionToInstall SetupDiGetActualSectionToInstallW

FUNCTION: BOOL SetupDiGetActualSectionToInstallExA ( HINF InfHandle, PCSTR InfSectionName, PSP_ALTPLATFORM_INFO AlternatePlatformInfo, PSTR InfSectionWithExt, DWORD InfSectionWithExtSize, PDWORD RequiredSize, PSTR* Extension, PVOID Reserved ) ;
FUNCTION: BOOL SetupDiGetActualSectionToInstallExW ( HINF InfHandle, PCWSTR InfSectionName, PSP_ALTPLATFORM_INFO AlternatePlatformInfo, PWSTR InfSectionWithExt, DWORD InfSectionWithExtSize, PDWORD RequiredSize, PWSTR* Extension, PVOID Reserved ) ;
ALIAS: SetupDiGetActualSectionToInstallEx SetupDiGetActualSectionToInstallExW

FUNCTION: BOOL SetupEnumInfSectionsA ( HINF InfHandle, UINT Index, PSTR Buffer, UINT Size, UINT* SizeNeeded ) ;
FUNCTION: BOOL SetupEnumInfSectionsW ( HINF InfHandle, UINT Index, PWSTR Buffer, UINT Size, UINT* SizeNeeded ) ;
ALIAS: SetupEnumInfSections SetupEnumInfSectionsW

STRUCT: SP_INF_SIGNER_INFO_V1_A
    { cbSize               DWORD          }
    { CatalogFile          CHAR[MAX_PATH] }
    { DigitalSigner        CHAR[MAX_PATH] }
    { DigitalSignerVersion CHAR[MAX_PATH] } ;
TYPEDEF: SP_INF_SIGNER_INFO_V1_A* PSP_INF_SIGNER_INFO_V1_A
STRUCT: SP_INF_SIGNER_INFO_V1_W
    { cbSize                DWORD           }
    { CatalogFile           WCHAR[MAX_PATH] }
    { DigitalSigner         WCHAR[MAX_PATH] }
    { DigitalSignerVersion  WCHAR[MAX_PATH] } ;
TYPEDEF: SP_INF_SIGNER_INFO_V1_W* PSP_INF_SIGNER_INFO_V1_W
TYPEDEF: SP_INF_SIGNER_INFO_V1_W SP_INF_SIGNER_INFO_V1
TYPEDEF: PSP_INF_SIGNER_INFO_V1_W PSP_INF_SIGNER_INFO_V1

STRUCT: SP_INF_SIGNER_INFO_V2_A
    { cbSize                 DWORD          }
    { CatalogFile            CHAR[MAX_PATH] }
    { DigitalSigner          CHAR[MAX_PATH] }
    { DigitalSignerVersion   CHAR[MAX_PATH] }
    { SignerScore            DWORD          } ;
TYPEDEF: SP_INF_SIGNER_INFO_V2_A* PSP_INF_SIGNER_INFO_V2_A
STRUCT: SP_INF_SIGNER_INFO_V2_W
    { cbSize                DWORD           }
    { CatalogFile           WCHAR[MAX_PATH] }
    { DigitalSigner         WCHAR[MAX_PATH] }
    { DigitalSignerVersion  WCHAR[MAX_PATH] }
    { SignerScore           DWORD           } ;
TYPEDEF: SP_INF_SIGNER_INFO_V2_W* PSP_INF_SIGNER_INFO_V2_W

TYPEDEF: SP_INF_SIGNER_INFO_V2_W SP_INF_SIGNER_INFO_V2
TYPEDEF: PSP_INF_SIGNER_INFO_V2_W PSP_INF_SIGNER_INFO_V2

CONSTANT: SIGNERSCORE_UNKNOWN         0xFF000000
CONSTANT: SIGNERSCORE_W9X_SUSPECT     0xC0000000
CONSTANT: SIGNERSCORE_UNSIGNED        0x80000000
CONSTANT: SIGNERSCORE_AUTHENTICODE    0x0F000000
CONSTANT: SIGNERSCORE_WHQL            0x0D000005
CONSTANT: SIGNERSCORE_UNCLASSIFIED    0x0D000004
CONSTANT: SIGNERSCORE_INBOX           0x0D000003
CONSTANT: SIGNERSCORE_LOGO_STANDARD   0x0D000002
CONSTANT: SIGNERSCORE_LOGO_PREMIUM    0x0D000001
CONSTANT: SIGNERSCORE_MASK            0xFF000000
CONSTANT: SIGNERSCORE_SIGNED_MASK     0xF0000000

TYPEDEF: SP_INF_SIGNER_INFO_V2_A  SP_INF_SIGNER_INFO_A
TYPEDEF: PSP_INF_SIGNER_INFO_V2_A PSP_INF_SIGNER_INFO_A
TYPEDEF: SP_INF_SIGNER_INFO_V2_W  SP_INF_SIGNER_INFO_W
TYPEDEF: PSP_INF_SIGNER_INFO_V2_W PSP_INF_SIGNER_INFO_W
TYPEDEF: SP_INF_SIGNER_INFO_V2    SP_INF_SIGNER_INFO
TYPEDEF: PSP_INF_SIGNER_INFO_V2   PSP_INF_SIGNER_INFO

FUNCTION: BOOL SetupVerifyInfFileA ( PCSTR InfName, PSP_ALTPLATFORM_INFO AltPlatformInfo, PSP_INF_SIGNER_INFO_A InfSignerInfo ) ;
FUNCTION: BOOL SetupVerifyInfFileW ( PCWSTR InfName, PSP_ALTPLATFORM_INFO AltPlatformInfo, PSP_INF_SIGNER_INFO_W InfSignerInfo ) ;
ALIAS: SetupVerifyInfFile SetupVerifyInfFileW

CONSTANT: DICUSTOMDEVPROP_MERGE_MULTISZ    0x00000001
FUNCTION: BOOL SetupDiGetCustomDevicePropertyA ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PCSTR CustomPropertyName, DWORD Flags, PDWORD PropertyRegDataType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, PDWORD RequiredSize ) ;
FUNCTION: BOOL SetupDiGetCustomDevicePropertyW ( HDEVINFO DeviceInfoSet, PSP_DEVINFO_DATA DeviceInfoData, PCWSTR CustomPropertyName, DWORD Flags, PDWORD PropertyRegDataType, PBYTE PropertyBuffer, DWORD PropertyBufferSize, PDWORD RequiredSize ) ;
ALIAS: SetupDiGetCustomDeviceProperty SetupDiGetCustomDevicePropertyW

CONSTANT: SCWMI_CLOBBER_SECURITY  0x00000001
FUNCTION: BOOL SetupConfigureWmiFromInfSectionA ( HINF InfHandle, PCSTR SectionName, DWORD Flags ) ;
FUNCTION: BOOL SetupConfigureWmiFromInfSectionW ( HINF InfHandle, PCWSTR SectionName, DWORD Flags ) ;
ALIAS: SetupConfigureWmiFromInfSection SetupConfigureWmiFromInfSectionW

