USING: alien.syntax alien.c-types classes.struct windows.types
windows.directx windows.directx.dxgiformat windows.com.syntax
windows.com windows.ole32 windows.directx.dxgitype ;
IN: windows.directx.d3d10

LIBRARY: d3d10

CONSTANT: D3D10_16BIT_INDEX_STRIP_CUT_VALUE                                    0xffff
CONSTANT: D3D10_32BIT_INDEX_STRIP_CUT_VALUE                                    0xffffffff
CONSTANT: D3D10_8BIT_INDEX_STRIP_CUT_VALUE                                     0xff
CONSTANT: D3D10_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT                             9
CONSTANT: D3D10_CLIP_OR_CULL_DISTANCE_COUNT                                    8
CONSTANT: D3D10_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT                            2
CONSTANT: D3D10_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT                    14
CONSTANT: D3D10_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS                        4
CONSTANT: D3D10_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT               32
CONSTANT: D3D10_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT                     15
CONSTANT: D3D10_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS               4
CONSTANT: D3D10_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT                    15
CONSTANT: D3D10_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST           1
CONSTANT: D3D10_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS               1
CONSTANT: D3D10_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT                         64
CONSTANT: D3D10_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS     4
CONSTANT: D3D10_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT          1
CONSTANT: D3D10_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST 1
CONSTANT: D3D10_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS     1
CONSTANT: D3D10_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT               32
CONSTANT: D3D10_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS                1
CONSTANT: D3D10_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT                     128
CONSTANT: D3D10_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST            1
CONSTANT: D3D10_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS                1
CONSTANT: D3D10_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT                         128
CONSTANT: D3D10_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS                       1
CONSTANT: D3D10_COMMONSHADER_SAMPLER_REGISTER_COUNT                            16
CONSTANT: D3D10_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST                   1
CONSTANT: D3D10_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS                       1
CONSTANT: D3D10_COMMONSHADER_SAMPLER_SLOT_COUNT                                16
CONSTANT: D3D10_COMMONSHADER_SUBROUTINE_NESTING_LIMIT                          32
CONSTANT: D3D10_COMMONSHADER_TEMP_REGISTER_COMPONENTS                          4
CONSTANT: D3D10_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT                 32
CONSTANT: D3D10_COMMONSHADER_TEMP_REGISTER_COUNT                               4096
CONSTANT: D3D10_COMMONSHADER_TEMP_REGISTER_READS_PER_INST                      3
CONSTANT: D3D10_COMMONSHADER_TEMP_REGISTER_READ_PORTS                          3
CONSTANT: D3D10_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX                      10
CONSTANT: D3D10_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN                      -10
CONSTANT: D3D10_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE                         -8
CONSTANT: D3D10_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE                         7
CONSTANT: D3D10_DEFAULT_BLEND_FACTOR_ALPHA                                     1.0
CONSTANT: D3D10_DEFAULT_BLEND_FACTOR_BLUE                                      1.0
CONSTANT: D3D10_DEFAULT_BLEND_FACTOR_GREEN                                     1.0
CONSTANT: D3D10_DEFAULT_BLEND_FACTOR_RED                                       1.0
CONSTANT: D3D10_DEFAULT_BORDER_COLOR_COMPONENT                                 0.0
CONSTANT: D3D10_DEFAULT_DEPTH_BIAS                                             0
CONSTANT: D3D10_DEFAULT_DEPTH_BIAS_CLAMP                                       0.0
CONSTANT: D3D10_DEFAULT_MAX_ANISOTROPY                                         16.0
CONSTANT: D3D10_DEFAULT_MIP_LOD_BIAS                                           0.0
CONSTANT: D3D10_DEFAULT_RENDER_TARGET_ARRAY_INDEX                              0
CONSTANT: D3D10_DEFAULT_SAMPLE_MASK                                            0xffffffff
CONSTANT: D3D10_DEFAULT_SCISSOR_ENDX                                           0
CONSTANT: D3D10_DEFAULT_SCISSOR_ENDY                                           0
CONSTANT: D3D10_DEFAULT_SCISSOR_STARTX                                         0
CONSTANT: D3D10_DEFAULT_SCISSOR_STARTY                                         0
CONSTANT: D3D10_DEFAULT_SLOPE_SCALED_DEPTH_BIAS                                0.0
CONSTANT: D3D10_DEFAULT_STENCIL_READ_MASK                                      0xff
CONSTANT: D3D10_DEFAULT_STENCIL_REFERENCE                                      0
CONSTANT: D3D10_DEFAULT_STENCIL_WRITE_MASK                                     0xff
CONSTANT: D3D10_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX                         0
CONSTANT: D3D10_DEFAULT_VIEWPORT_HEIGHT                                        0
CONSTANT: D3D10_DEFAULT_VIEWPORT_MAX_DEPTH                                     0.0
CONSTANT: D3D10_DEFAULT_VIEWPORT_MIN_DEPTH                                     0.0
CONSTANT: D3D10_DEFAULT_VIEWPORT_TOPLEFTX                                      0
CONSTANT: D3D10_DEFAULT_VIEWPORT_TOPLEFTY                                      0
CONSTANT: D3D10_DEFAULT_VIEWPORT_WIDTH                                         0
CONSTANT: D3D10_FLOAT16_FUSED_TOLERANCE_IN_ULP                                 0.6
CONSTANT: D3D10_FLOAT32_MAX                                                    3.402823466e+38
CONSTANT: D3D10_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP                            0.6
CONSTANT: D3D10_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR                             2.4
CONSTANT: D3D10_FLOAT_TO_SRGB_EXPONENT_NUMERATOR                               1.0
CONSTANT: D3D10_FLOAT_TO_SRGB_OFFSET                                           0.055
CONSTANT: D3D10_FLOAT_TO_SRGB_SCALE_1                                          12.92
CONSTANT: D3D10_FLOAT_TO_SRGB_SCALE_2                                          1.055
CONSTANT: D3D10_FLOAT_TO_SRGB_THRESHOLD                                        0.0031308
CONSTANT: D3D10_FTOI_INSTRUCTION_MAX_INPUT                                     2147483647.999
CONSTANT: D3D10_FTOI_INSTRUCTION_MIN_INPUT                                     -2147483648.999
CONSTANT: D3D10_FTOU_INSTRUCTION_MAX_INPUT                                     4294967295.999
CONSTANT: D3D10_FTOU_INSTRUCTION_MIN_INPUT                                     0.0
CONSTANT: D3D10_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS                        1
CONSTANT: D3D10_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT               32
CONSTANT: D3D10_GS_INPUT_PRIM_CONST_REGISTER_COUNT                             1
CONSTANT: D3D10_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST                    2
CONSTANT: D3D10_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS                        1
CONSTANT: D3D10_GS_INPUT_REGISTER_COMPONENTS                                   4
CONSTANT: D3D10_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT                          32
CONSTANT: D3D10_GS_INPUT_REGISTER_COUNT                                        16
CONSTANT: D3D10_GS_INPUT_REGISTER_READS_PER_INST                               2
CONSTANT: D3D10_GS_INPUT_REGISTER_READ_PORTS                                   1
CONSTANT: D3D10_GS_INPUT_REGISTER_VERTICES                                     6
CONSTANT: D3D10_GS_OUTPUT_ELEMENTS                                             32
CONSTANT: D3D10_GS_OUTPUT_REGISTER_COMPONENTS                                  4
CONSTANT: D3D10_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT                         32
CONSTANT: D3D10_GS_OUTPUT_REGISTER_COUNT                                       32
CONSTANT: D3D10_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES                        0
CONSTANT: D3D10_IA_DEFAULT_PRIMITIVE_TOPOLOGY                                  0
CONSTANT: D3D10_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES                       0
CONSTANT: D3D10_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT                             1
CONSTANT: D3D10_IA_INSTANCE_ID_BIT_COUNT                                       32
CONSTANT: D3D10_IA_INTEGER_ARITHMETIC_BIT_COUNT                                32
CONSTANT: D3D10_IA_PRIMITIVE_ID_BIT_COUNT                                      32
CONSTANT: D3D10_IA_VERTEX_ID_BIT_COUNT                                         32
CONSTANT: D3D10_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT                            16
CONSTANT: D3D10_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS                  64
CONSTANT: D3D10_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT                        16
CONSTANT: D3D10_INTEGER_DIVIDE_BY_ZERO_QUOTIENT                                0xffffffff
CONSTANT: D3D10_INTEGER_DIVIDE_BY_ZERO_REMAINDER                               0xffffffff
CONSTANT: D3D10_LINEAR_GAMMA                                                   1.0
CONSTANT: D3D10_MAX_BORDER_COLOR_COMPONENT                                     1.0
CONSTANT: D3D10_MAX_DEPTH                                                      1.0
CONSTANT: D3D10_MAX_MAXANISOTROPY                                              16
CONSTANT: D3D10_MAX_MULTISAMPLE_SAMPLE_COUNT                                   32
CONSTANT: D3D10_MAX_POSITION_VALUE                                             3.402823466e+34
CONSTANT: D3D10_MAX_TEXTURE_DIMENSION_2_TO_EXP                                 17
CONSTANT: D3D10_MIN_BORDER_COLOR_COMPONENT                                     0.0
CONSTANT: D3D10_MIN_DEPTH                                                      0.0
CONSTANT: D3D10_MIN_MAXANISOTROPY                                              0
CONSTANT: D3D10_MIP_LOD_BIAS_MAX                                               15.99
CONSTANT: D3D10_MIP_LOD_BIAS_MIN                                               -16.0
CONSTANT: D3D10_MIP_LOD_FRACTIONAL_BIT_COUNT                                   6
CONSTANT: D3D10_MIP_LOD_RANGE_BIT_COUNT                                        8
CONSTANT: D3D10_MULTISAMPLE_ANTIALIAS_LINE_WIDTH                               1.4
CONSTANT: D3D10_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT                     0
CONSTANT: D3D10_PIXEL_ADDRESS_RANGE_BIT_COUNT                                  13
CONSTANT: D3D10_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT                      15
CONSTANT: D3D10_PS_FRONTFACING_DEFAULT_VALUE                                   0xffffffff
CONSTANT: D3D10_PS_FRONTFACING_FALSE_VALUE                                     0
CONSTANT: D3D10_PS_FRONTFACING_TRUE_VALUE                                      0xffffffff
CONSTANT: D3D10_PS_INPUT_REGISTER_COMPONENTS                                   4
CONSTANT: D3D10_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT                          32
CONSTANT: D3D10_PS_INPUT_REGISTER_COUNT                                        32
CONSTANT: D3D10_PS_INPUT_REGISTER_READS_PER_INST                               2
CONSTANT: D3D10_PS_INPUT_REGISTER_READ_PORTS                                   1
CONSTANT: D3D10_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT                    0.0
CONSTANT: D3D10_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS                            1
CONSTANT: D3D10_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT                   32
CONSTANT: D3D10_PS_OUTPUT_DEPTH_REGISTER_COUNT                                 1
CONSTANT: D3D10_PS_OUTPUT_REGISTER_COMPONENTS                                  4
CONSTANT: D3D10_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT                         32
CONSTANT: D3D10_PS_OUTPUT_REGISTER_COUNT                                       8
CONSTANT: D3D10_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT                           0.5
CONSTANT: D3D10_REQ_BLEND_OBJECT_COUNT_PER_CONTEXT                             4096
CONSTANT: D3D10_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP                       27
CONSTANT: D3D10_REQ_CONSTANT_BUFFER_ELEMENT_COUNT                              4096
CONSTANT: D3D10_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_CONTEXT                     4096
CONSTANT: D3D10_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP                           32
CONSTANT: D3D10_REQ_DRAW_VERTEX_COUNT_2_TO_EXP                                 32
CONSTANT: D3D10_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION                8192
CONSTANT: D3D10_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT                 1024
CONSTANT: D3D10_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT                    4096
CONSTANT: D3D10_REQ_MAXANISOTROPY                                              16
CONSTANT: D3D10_REQ_MIP_LEVELS                                                 14
CONSTANT: D3D10_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES                      2048
CONSTANT: D3D10_REQ_RASTERIZER_OBJECT_COUNT_PER_CONTEXT                        4096
CONSTANT: D3D10_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH                              8192
CONSTANT: D3D10_REQ_RESOURCE_SIZE_IN_MEGABYTES                                 128
CONSTANT: D3D10_REQ_RESOURCE_VIEW_COUNT_PER_CONTEXT_2_TO_EXP                   20
CONSTANT: D3D10_REQ_SAMPLER_OBJECT_COUNT_PER_CONTEXT                           4096
CONSTANT: D3D10_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION                             512
CONSTANT: D3D10_REQ_TEXTURE1D_U_DIMENSION                                      8192
CONSTANT: D3D10_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION                             512
CONSTANT: D3D10_REQ_TEXTURE2D_U_OR_V_DIMENSION                                 8192
CONSTANT: D3D10_REQ_TEXTURE3D_U_V_OR_W_DIMENSION                               2048
CONSTANT: D3D10_REQ_TEXTURECUBE_DIMENSION                                      8192
CONSTANT: D3D10_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL                   0
CONSTANT: D3D10_SHADER_MAJOR_VERSION                                           4
CONSTANT: D3D10_SHADER_MINOR_VERSION                                           0
CONSTANT: D3D10_SHIFT_INSTRUCTION_PAD_VALUE                                    0
CONSTANT: D3D10_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT                        5
CONSTANT: D3D10_SIMULTANEOUS_RENDER_TARGET_COUNT                               8
CONSTANT: D3D10_SO_BUFFER_MAX_STRIDE_IN_BYTES                                  2048
CONSTANT: D3D10_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES                            256
CONSTANT: D3D10_SO_BUFFER_SLOT_COUNT                                           4
CONSTANT: D3D10_SO_DDI_REGISTER_INDEX_DENOTING_GAP                             0xffffffff
CONSTANT: D3D10_SO_MULTIPLE_BUFFER_ELEMENTS_PER_BUFFER                         1
CONSTANT: D3D10_SO_SINGLE_BUFFER_COMPONENT_LIMIT                               64
CONSTANT: D3D10_SRGB_GAMMA                                                     2.2
CONSTANT: D3D10_SRGB_TO_FLOAT_DENOMINATOR_1                                    12.92
CONSTANT: D3D10_SRGB_TO_FLOAT_DENOMINATOR_2                                    1.055
CONSTANT: D3D10_SRGB_TO_FLOAT_EXPONENT                                         2.4
CONSTANT: D3D10_SRGB_TO_FLOAT_OFFSET                                           0.055
CONSTANT: D3D10_SRGB_TO_FLOAT_THRESHOLD                                        0.04045
CONSTANT: D3D10_SRGB_TO_FLOAT_TOLERANCE_IN_ULP                                 0.5
CONSTANT: D3D10_STANDARD_COMPONENT_BIT_COUNT                                   32
CONSTANT: D3D10_STANDARD_COMPONENT_BIT_COUNT_DOUBLED                           64
CONSTANT: D3D10_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE               4
CONSTANT: D3D10_STANDARD_PIXEL_COMPONENT_COUNT                                 128
CONSTANT: D3D10_STANDARD_PIXEL_ELEMENT_COUNT                                   32
CONSTANT: D3D10_STANDARD_VECTOR_SIZE                                           4
CONSTANT: D3D10_STANDARD_VERTEX_ELEMENT_COUNT                                  16
CONSTANT: D3D10_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT                          64
CONSTANT: D3D10_SUBPIXEL_FRACTIONAL_BIT_COUNT                                  8
CONSTANT: D3D10_SUBTEXEL_FRACTIONAL_BIT_COUNT                                  6
CONSTANT: D3D10_TEXEL_ADDRESS_RANGE_BIT_COUNT                                  18
CONSTANT: D3D10_UNBOUND_MEMORY_ACCESS_RESULT                                   0
CONSTANT: D3D10_VIEWPORT_AND_SCISSORRECT_MAX_INDEX                             15
CONSTANT: D3D10_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE             16
CONSTANT: D3D10_VIEWPORT_BOUNDS_MAX                                            16383
CONSTANT: D3D10_VIEWPORT_BOUNDS_MIN                                            -16384
CONSTANT: D3D10_VS_INPUT_REGISTER_COMPONENTS                                   4
CONSTANT: D3D10_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT                          32
CONSTANT: D3D10_VS_INPUT_REGISTER_COUNT                                        16
CONSTANT: D3D10_VS_INPUT_REGISTER_READS_PER_INST                               2
CONSTANT: D3D10_VS_INPUT_REGISTER_READ_PORTS                                   1
CONSTANT: D3D10_VS_OUTPUT_REGISTER_COMPONENTS                                  4
CONSTANT: D3D10_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT                         32
CONSTANT: D3D10_VS_OUTPUT_REGISTER_COUNT                                       16
CONSTANT: D3D10_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT                          10
CONSTANT: D3D10_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP                          25
CONSTANT: D3D10_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP                                25
CONSTANT: D3D_MAJOR_VERSION                                                    10
CONSTANT: D3D_MINOR_VERSION                                                    0
CONSTANT: D3D_SPEC_DATE_DAY                                                    8
CONSTANT: D3D_SPEC_DATE_MONTH                                                  8
CONSTANT: D3D_SPEC_DATE_YEAR                                                   2006
CONSTANT: D3D_SPEC_VERSION                                                     1.050005

CONSTANT: D3D10_1_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT 16
CONSTANT: D3D10_1_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT     16

CONSTANT: _FACD3D10      0x879
CONSTANT: _FACD3D10DEBUG 0x87A

CONSTANT: D3D10_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS 0x88790001
CONSTANT: D3D10_ERROR_FILE_NOT_FOUND                0x88790002

CONSTANT: D3D10_INPUT_PER_VERTEX_DATA   0
CONSTANT: D3D10_INPUT_PER_INSTANCE_DATA 1
TYPEDEF: int D3D10_INPUT_CLASSIFICATION

CONSTANT: D3D10_APPEND_ALIGNED_ELEMENT 0xffffffff

STRUCT: D3D10_INPUT_ELEMENT_DESC
    { SemanticName         LPCSTR                     }
    { SemanticIndex        UINT                       }
    { Format               DXGI_FORMAT                }
    { InputSlot            UINT                       }
    { AlignedByteOffset    UINT                       }
    { InputSlotClass       D3D10_INPUT_CLASSIFICATION }
    { InstanceDataStepRate UINT                       } ;

CONSTANT: D3D10_FILL_WIREFRAME 2
CONSTANT: D3D10_FILL_SOLID     3
TYPEDEF: int D3D10_FILL_MODE

CONSTANT: D3D10_PRIMITIVE_TOPOLOGY_UNDEFINED         0
CONSTANT: D3D10_PRIMITIVE_TOPOLOGY_POINTLIST         1
CONSTANT: D3D10_PRIMITIVE_TOPOLOGY_LINELIST          2
CONSTANT: D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP         3
CONSTANT: D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST      4
CONSTANT: D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP     5
CONSTANT: D3D10_PRIMITIVE_TOPOLOGY_LINELIST_ADJ      10
CONSTANT: D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ     11
CONSTANT: D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ  12
CONSTANT: D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ 13
TYPEDEF: int D3D10_PRIMITIVE_TOPOLOGY

CONSTANT: D3D10_PRIMITIVE_UNDEFINED    0
CONSTANT: D3D10_PRIMITIVE_POINT        1
CONSTANT: D3D10_PRIMITIVE_LINE         2
CONSTANT: D3D10_PRIMITIVE_TRIANGLE     3
CONSTANT: D3D10_PRIMITIVE_LINE_ADJ     6
CONSTANT: D3D10_PRIMITIVE_TRIANGLE_ADJ 7
TYPEDEF: int D3D10_PRIMITIVE

CONSTANT: D3D10_CULL_NONE  1
CONSTANT: D3D10_CULL_FRONT 2
CONSTANT: D3D10_CULL_BACK  3
TYPEDEF: int D3D10_CULL_MODE

STRUCT: D3D10_SO_DECLARATION_ENTRY
    { SemanticName   LPCSTR }
    { SemanticIndex  UINT   }
    { StartComponent BYTE   }
    { ComponentCount BYTE   }
    { OutputSlot     BYTE   } ;

STRUCT: D3D10_VIEWPORT
    { TopLeftX INT   }
    { TopLeftY INT   }
    { Width    UINT  }
    { Height   UINT  }
    { MinDepth FLOAT }
    { MaxDepth FLOAT } ;

CONSTANT: D3D10_RESOURCE_DIMENSION_UNKNOWN   0
CONSTANT: D3D10_RESOURCE_DIMENSION_BUFFER    1
CONSTANT: D3D10_RESOURCE_DIMENSION_TEXTURE1D 2
CONSTANT: D3D10_RESOURCE_DIMENSION_TEXTURE2D 3
CONSTANT: D3D10_RESOURCE_DIMENSION_TEXTURE3D 4
TYPEDEF: int D3D10_RESOURCE_DIMENSION

CONSTANT: D3D10_SRV_DIMENSION_UNKNOWN          0
CONSTANT: D3D10_SRV_DIMENSION_BUFFER           1
CONSTANT: D3D10_SRV_DIMENSION_TEXTURE1D        2
CONSTANT: D3D10_SRV_DIMENSION_TEXTURE1DARRAY   3
CONSTANT: D3D10_SRV_DIMENSION_TEXTURE2D        4
CONSTANT: D3D10_SRV_DIMENSION_TEXTURE2DARRAY   5
CONSTANT: D3D10_SRV_DIMENSION_TEXTURE2DMS      6
CONSTANT: D3D10_SRV_DIMENSION_TEXTURE2DMSARRAY 7
CONSTANT: D3D10_SRV_DIMENSION_TEXTURE3D        8
CONSTANT: D3D10_SRV_DIMENSION_TEXTURECUBE      9
TYPEDEF: int D3D10_SRV_DIMENSION

CONSTANT: D3D10_DSV_DIMENSION_UNKNOWN          0
CONSTANT: D3D10_DSV_DIMENSION_TEXTURE1D        1
CONSTANT: D3D10_DSV_DIMENSION_TEXTURE1DARRAY   2
CONSTANT: D3D10_DSV_DIMENSION_TEXTURE2D        3
CONSTANT: D3D10_DSV_DIMENSION_TEXTURE2DARRAY   4
CONSTANT: D3D10_DSV_DIMENSION_TEXTURE2DMS      5
CONSTANT: D3D10_DSV_DIMENSION_TEXTURE2DMSARRAY 6
TYPEDEF: int D3D10_DSV_DIMENSION

CONSTANT: D3D10_RTV_DIMENSION_UNKNOWN          0
CONSTANT: D3D10_RTV_DIMENSION_BUFFER           1
CONSTANT: D3D10_RTV_DIMENSION_TEXTURE1D        2
CONSTANT: D3D10_RTV_DIMENSION_TEXTURE1DARRAY   3
CONSTANT: D3D10_RTV_DIMENSION_TEXTURE2D        4
CONSTANT: D3D10_RTV_DIMENSION_TEXTURE2DARRAY   5
CONSTANT: D3D10_RTV_DIMENSION_TEXTURE2DMS      6
CONSTANT: D3D10_RTV_DIMENSION_TEXTURE2DMSARRAY 7
CONSTANT: D3D10_RTV_DIMENSION_TEXTURE3D        8
TYPEDEF: int D3D10_RTV_DIMENSION

CONSTANT: D3D10_USAGE_DEFAULT   0
CONSTANT: D3D10_USAGE_IMMUTABLE 1
CONSTANT: D3D10_USAGE_DYNAMIC   2
CONSTANT: D3D10_USAGE_STAGING   3
TYPEDEF: int D3D10_USAGE

CONSTANT: D3D10_BIND_VERTEX_BUFFER   0x1
CONSTANT: D3D10_BIND_INDEX_BUFFER    0x2
CONSTANT: D3D10_BIND_CONSTANT_BUFFER 0x4
CONSTANT: D3D10_BIND_SHADER_RESOURCE 0x8
CONSTANT: D3D10_BIND_STREAM_OUTPUT   0x10
CONSTANT: D3D10_BIND_RENDER_TARGET   0x20
CONSTANT: D3D10_BIND_DEPTH_STENCIL   0x40
TYPEDEF: int D3D10_BIND_FLAG

CONSTANT: D3D10_CPU_ACCESS_WRITE 0x10000
CONSTANT: D3D10_CPU_ACCESS_READ  0x20000
TYPEDEF: int D3D10_CPU_ACCESS_FLAG

CONSTANT: D3D10_RESOURCE_MISC_GENERATE_MIPS     0x1
CONSTANT: D3D10_RESOURCE_MISC_SHARED            0x2
CONSTANT: D3D10_RESOURCE_MISC_TEXTURECUBE       0x4
CONSTANT: D3D10_RESOURCE_MISC_SHARED_KEYEDMUTEX 0x10
CONSTANT: D3D10_RESOURCE_MISC_GDI_COMPATIBLE    0x20
TYPEDEF: int D3D10_RESOURCE_MISC_FLAG

CONSTANT: D3D10_MAP_READ               1
CONSTANT: D3D10_MAP_WRITE              2
CONSTANT: D3D10_MAP_READ_WRITE         3
CONSTANT: D3D10_MAP_WRITE_DISCARD      4
CONSTANT: D3D10_MAP_WRITE_NO_OVERWRITE 5
TYPEDEF: int D3D10_MAP

CONSTANT: D3D10_MAP_FLAG_DO_NOT_WAIT 0x100000
TYPEDEF: int D3D10_MAP_FLAG

CONSTANT: D3D10_RAISE_FLAG_DRIVER_INTERNAL_ERROR 0x1
TYPEDEF: int D3D10_RAISE_FLAG

CONSTANT: D3D10_CLEAR_DEPTH   0x1
CONSTANT: D3D10_CLEAR_STENCIL 0x2
TYPEDEF: int D3D10_CLEAR_FLAG

TYPEDEF: RECT D3D10_RECT

STRUCT: D3D10_BOX
    { left   UINT }
    { top    UINT }
    { front  UINT }
    { right  UINT }
    { bottom UINT }
    { back   UINT } ;

C-TYPE: ID3D10Device
COM-INTERFACE: ID3D10DeviceChild IUnknown {9B7E4C00-342C-4106-A19F-4F2704F689F0}
    void GetDevice ( ID3D10Device** ppDevice )
    HRESULT GetPrivateData ( LPGUID guid, UINT* pDataSize, void* pData )
    HRESULT SetPrivateData ( LPGUID guid, UINT DataSize, void* pData )
    HRESULT SetPrivateDataInterface ( LPGUID guid, IUnknown* pData ) ;

CONSTANT: D3D10_COMPARISON_NEVER         1
CONSTANT: D3D10_COMPARISON_LESS          2
CONSTANT: D3D10_COMPARISON_EQUAL         3
CONSTANT: D3D10_COMPARISON_LESS_EQUAL    4
CONSTANT: D3D10_COMPARISON_GREATER       5
CONSTANT: D3D10_COMPARISON_NOT_EQUAL     6
CONSTANT: D3D10_COMPARISON_GREATER_EQUAL 7
CONSTANT: D3D10_COMPARISON_ALWAYS        8
TYPEDEF: int D3D10_COMPARISON_FUNC

CONSTANT: D3D10_DEPTH_WRITE_MASK_ZERO 0
CONSTANT: D3D10_DEPTH_WRITE_MASK_ALL  1
TYPEDEF: int D3D10_DEPTH_WRITE_MASK

CONSTANT: D3D10_STENCIL_OP_KEEP     1
CONSTANT: D3D10_STENCIL_OP_ZERO     2
CONSTANT: D3D10_STENCIL_OP_REPLACE  3
CONSTANT: D3D10_STENCIL_OP_INCR_SAT 4
CONSTANT: D3D10_STENCIL_OP_DECR_SAT 5
CONSTANT: D3D10_STENCIL_OP_INVERT   6
CONSTANT: D3D10_STENCIL_OP_INCR     7
CONSTANT: D3D10_STENCIL_OP_DECR     8
TYPEDEF: int D3D10_STENCIL_OP

STRUCT: D3D10_DEPTH_STENCILOP_DESC
    { StencilFailOp      D3D10_STENCIL_OP      }
    { StencilDepthFailOp D3D10_STENCIL_OP      }
    { StencilPassOp      D3D10_STENCIL_OP      }
    { StencilFunc        D3D10_COMPARISON_FUNC } ;

STRUCT: D3D10_DEPTH_STENCIL_DESC
    { DepthEnable      BOOL                       }
    { DepthWriteMask   D3D10_DEPTH_WRITE_MASK     }
    { DepthFunc        D3D10_COMPARISON_FUNC      }
    { StencilEnable    BOOL                       }
    { StencilReadMask  BYTE                       }
    { StencilWriteMask BYTE                       }
    { FrontFace        D3D10_DEPTH_STENCILOP_DESC }
    { BackFace         D3D10_DEPTH_STENCILOP_DESC } ;

COM-INTERFACE: ID3D10DepthStencilState ID3D10DeviceChild {2B4B1CC8-A4AD-41f8-8322-CA86FC3EC675}
    void GetDesc ( D3D10_DEPTH_STENCIL_DESC* pDesc ) ;

CONSTANT: D3D10_BLEND_ZERO             1
CONSTANT: D3D10_BLEND_ONE              2
CONSTANT: D3D10_BLEND_SRC_COLOR        3
CONSTANT: D3D10_BLEND_INV_SRC_COLOR    4
CONSTANT: D3D10_BLEND_SRC_ALPHA        5
CONSTANT: D3D10_BLEND_INV_SRC_ALPHA    6
CONSTANT: D3D10_BLEND_DEST_ALPHA       7
CONSTANT: D3D10_BLEND_INV_DEST_ALPHA   8
CONSTANT: D3D10_BLEND_DEST_COLOR       9
CONSTANT: D3D10_BLEND_INV_DEST_COLOR   10
CONSTANT: D3D10_BLEND_SRC_ALPHA_SAT    11
CONSTANT: D3D10_BLEND_BLEND_FACTOR     14
CONSTANT: D3D10_BLEND_INV_BLEND_FACTOR 15
CONSTANT: D3D10_BLEND_SRC1_COLOR       16
CONSTANT: D3D10_BLEND_INV_SRC1_COLOR   17
CONSTANT: D3D10_BLEND_SRC1_ALPHA       18
CONSTANT: D3D10_BLEND_INV_SRC1_ALPHA   19
TYPEDEF: int D3D10_BLEND

CONSTANT: D3D10_BLEND_OP_ADD          1
CONSTANT: D3D10_BLEND_OP_SUBTRACT     2
CONSTANT: D3D10_BLEND_OP_REV_SUBTRACT 3
CONSTANT: D3D10_BLEND_OP_MIN          4
CONSTANT: D3D10_BLEND_OP_MAX          5
TYPEDEF: int D3D10_BLEND_OP

CONSTANT: D3D10_COLOR_WRITE_ENABLE_RED   1
CONSTANT: D3D10_COLOR_WRITE_ENABLE_GREEN 2
CONSTANT: D3D10_COLOR_WRITE_ENABLE_BLUE  4
CONSTANT: D3D10_COLOR_WRITE_ENABLE_ALPHA 8
CONSTANT: D3D10_COLOR_WRITE_ENABLE_ALL   15
TYPEDEF: int D3D10_COLOR_WRITE_ENABLE

STRUCT: D3D10_BLEND_DESC
    { AlphaToCoverageEnable BOOL           }
    { BlendEnable           BOOL[8]        }
    { SrcBlend              D3D10_BLEND    }
    { DestBlend             D3D10_BLEND    }
    { BlendOp               D3D10_BLEND_OP }
    { SrcBlendAlpha         D3D10_BLEND    }
    { DestBlendAlpha        D3D10_BLEND    }
    { BlendOpAlpha          D3D10_BLEND_OP }
    { RenderTargetWriteMask BYTE[8]        } ;

COM-INTERFACE: ID3D10BlendState ID3D10DeviceChild {EDAD8D19-8A35-4d6d-8566-2EA276CDE161}
    void GetDesc ( D3D10_BLEND_DESC* pDesc ) ;

STRUCT: D3D10_RASTERIZER_DESC
    { FillMode              D3D10_FILL_MODE }
    { CullMode              D3D10_CULL_MODE }
    { FrontCounterClockwise BOOL            }
    { DepthBias             INT             }
    { DepthBiasClamp        FLOAT           }
    { SlopeScaledDepthBias  FLOAT           }
    { DepthClipEnable       BOOL            }
    { ScissorEnable         BOOL            }
    { MultisampleEnable     BOOL            }
    { AntialiasedLineEnable BOOL            } ;

COM-INTERFACE: ID3D10RasterizerState ID3D10DeviceChild {A2A07292-89AF-4345-BE2E-C53D9FBB6E9F}
    void GetDesc ( D3D10_RASTERIZER_DESC* pDesc ) ;

STRUCT: D3D10_SUBRESOURCE_DATA
    { pSysMem          void* }
    { SysMemPitch      UINT  }
    { SysMemSlicePitch UINT  } ;


COM-INTERFACE: ID3D10Resource ID3D10DeviceChild {9B7E4C01-342C-4106-A19F-4F2704F689F0}
    void GetType ( D3D10_RESOURCE_DIMENSION* rType )
    void SetEvictionPriority ( UINT EvictionPriority )
    UINT GetEvictionPriority ( ) ;

STRUCT: D3D10_BUFFER_DESC
    { ByteWidth      UINT        }
    { Usage          D3D10_USAGE }
    { BindFlags      UINT        }
    { CPUAccessFlags UINT        }
    { MiscFlags      UINT        } ;

COM-INTERFACE: ID3D10Buffer ID3D10Resource {9B7E4C02-342C-4106-A19F-4F2704F689F0}
    HRESULT Map ( D3D10_MAP MapType, UINT MapFlags, void** ppData )
    void Unmap ( )
    void GetDesc ( D3D10_BUFFER_DESC* pDesc ) ;

STRUCT: D3D10_TEXTURE1D_DESC
    { Width          UINT        }
    { MipLevels      UINT        }
    { ArraySize      UINT        }
    { Format         DXGI_FORMAT }
    { Usage          D3D10_USAGE }
    { BindFlags      UINT        }
    { CPUAccessFlags UINT        }
    { MiscFlags      UINT        } ;

COM-INTERFACE: ID3D10Texture1D ID3D10Resource {9B7E4C03-342C-4106-A19F-4F2704F689F0}
    HRESULT Map ( UINT Subresource, D3D10_MAP MapType, UINT MapFlags, void** ppData )
    void Unmap ( UINT Subresource )
    void GetDesc ( D3D10_TEXTURE1D_DESC* pDesc ) ;

STRUCT: D3D10_TEXTURE2D_DESC
    { Width          UINT             }
    { Height         UINT             }
    { MipLevels      UINT             }
    { ArraySize      UINT             }
    { Format         DXGI_FORMAT      }
    { SampleDesc     DXGI_SAMPLE_DESC }
    { Usage          D3D10_USAGE      }
    { BindFlags      UINT             }
    { CPUAccessFlags UINT             }
    { MiscFlags      UINT             } ;

STRUCT: D3D10_MAPPED_TEXTURE2D
    { pData    void* }
    { RowPitch UINT  } ;

COM-INTERFACE: ID3D10Texture2D ID3D10Resource {9B7E4C04-342C-4106-A19F-4F2704F689F0}
    HRESULT Map ( UINT Subresource, D3D10_MAP MapType, UINT MapFlags, D3D10_MAPPED_TEXTURE2D* pMappedTex2D )
    void Unmap ( UINT Subresource )
    void GetDesc ( D3D10_TEXTURE2D_DESC* pDesc ) ;

STRUCT: D3D10_TEXTURE3D_DESC
    { Width          UINT        }
    { Height         UINT        }
    { Depth          UINT        }
    { MipLevels      UINT        }
    { Format         DXGI_FORMAT }
    { Usage          D3D10_USAGE }
    { BindFlags      UINT        }
    { CPUAccessFlags UINT        }
    { MiscFlags      UINT        } ;

STRUCT: D3D10_MAPPED_TEXTURE3D
    { pData      void* }
    { RowPitch   UINT  }
    { DepthPitch UINT  } ;

COM-INTERFACE: ID3D10Texture3D ID3D10Resource {9B7E4C05-342C-4106-A19F-4F2704F689F0}
    HRESULT Map ( UINT Subresource, D3D10_MAP MapType, UINT MapFlags, D3D10_MAPPED_TEXTURE3D* pMappedTex3D )
    void Unmap ( UINT Subresource )
    void GetDesc ( D3D10_TEXTURE3D_DESC* pDesc ) ;

CONSTANT: D3D10_TEXTURECUBE_FACE_POSITIVE_X 0
CONSTANT: D3D10_TEXTURECUBE_FACE_NEGATIVE_X 1
CONSTANT: D3D10_TEXTURECUBE_FACE_POSITIVE_Y 2
CONSTANT: D3D10_TEXTURECUBE_FACE_NEGATIVE_Y 3
CONSTANT: D3D10_TEXTURECUBE_FACE_POSITIVE_Z 4
CONSTANT: D3D10_TEXTURECUBE_FACE_NEGATIVE_Z 5
TYPEDEF: int D3D10_TEXTURECUBE_FACE

COM-INTERFACE: ID3D10View ID3D10DeviceChild {C902B03F-60A7-49BA-9936-2A3AB37A7E33}
    void GetResource ( ID3D10Resource** ppResource ) ;

UNION-STRUCT: D3D10_BUFFER_SRV_UNION1
    { FirstElement  UINT }
    { ElementOffset UINT } ;

UNION-STRUCT: D3D10_BUFFER_SRV_UNION2
    { NumElements UINT }
    { ElementWith UINT } ;

STRUCT: D3D10_BUFFER_SRV
    { First  D3D10_BUFFER_SRV_UNION1 }
    { Second D3D10_BUFFER_SRV_UNION2 } ;

STRUCT: D3D10_TEX1D_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT } ;

STRUCT: D3D10_TEX1D_ARRAY_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D10_TEX2D_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT } ;

STRUCT: D3D10_TEX2D_ARRAY_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D10_TEX3D_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT } ;

STRUCT: D3D10_TEXCUBE_SRV
    { MostDetailedMip UINT }
    { MipLevels       UINT } ;

STRUCT: D3D10_TEX2DMS_SRV
    { UnusedField_NothingToDefine UINT } ;

STRUCT: D3D10_TEX2DMS_ARRAY_SRV
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

UNION-STRUCT: D3D10_SHADER_RESOURCE_VIEW_DESC_UNION
    { Buffer           D3D10_BUFFER_SRV        }
    { Texture1D        D3D10_TEX1D_SRV         }
    { Texture1DArray   D3D10_TEX1D_ARRAY_SRV   }
    { Texture2D        D3D10_TEX2D_SRV         }
    { Texture2DArray   D3D10_TEX2D_ARRAY_SRV   }
    { Texture2DMS      D3D10_TEX2DMS_SRV       }
    { Texture2DMSArray D3D10_TEX2DMS_ARRAY_SRV }
    { Texture3D        D3D10_TEX3D_SRV         }
    { TextureCube      D3D10_TEXCUBE_SRV       } ;

STRUCT: D3D10_SHADER_RESOURCE_VIEW_DESC
    { Format        DXGI_FORMAT                           }
    { ViewDimension D3D10_SRV_DIMENSION                   }
    { View          D3D10_SHADER_RESOURCE_VIEW_DESC_UNION } ;

COM-INTERFACE: ID3D10ShaderResourceView ID3D10View {9B7E4C07-342C-4106-A19F-4F2704F689F0}
    void GetDesc ( D3D10_SHADER_RESOURCE_VIEW_DESC* pDesc ) ;

UNION-STRUCT: D3D10_BUFFER_RTV_UNION1
    { FirstElement  UINT }
    { ElementOffset UINT } ;

UNION-STRUCT: D3D10_BUFFER_RTV_UNION2
    { NumElements  UINT }
    { ElementWidth UINT } ;

STRUCT: D3D10_BUFFER_RTV
    { First  D3D10_BUFFER_RTV_UNION1 }
    { Second D3D10_BUFFER_RTV_UNION2 } ;

STRUCT: D3D10_TEX1D_RTV
    { MipSlice UINT } ;

STRUCT: D3D10_TEX1D_ARRAY_RTV
    { MipSlice        UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D10_TEX2D_RTV
    { MipSlice UINT } ;

STRUCT: D3D10_TEX2DMS_RTV
    { UnusedField_NothingToDefine UINT } ;

STRUCT: D3D10_TEX2D_ARRAY_RTV
    { MipSlice        UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;
    
STRUCT: D3D10_TEX2DMS_ARRAY_RTV
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D10_TEX3D_RTV
    { MipSlice    UINT }
    { FirstWSlice UINT }
    { WSize       UINT } ;

UNION-STRUCT: D3D10_RENDER_TARGET_VIEW_DESC_UNION
    { Buffer           D3D10_BUFFER_RTV        }
    { Texture1D        D3D10_TEX1D_RTV         }
    { Texture1DArray   D3D10_TEX1D_ARRAY_RTV   }
    { Texture2D        D3D10_TEX2D_RTV         }
    { Texture2DArray   D3D10_TEX2D_ARRAY_RTV   }
    { Texture2DMS      D3D10_TEX2DMS_RTV       }
    { Texture2DMSArray D3D10_TEX2DMS_ARRAY_RTV }
    { Texture3D        D3D10_TEX3D_RTV         } ;

STRUCT: D3D10_RENDER_TARGET_VIEW_DESC
    { Format        DXGI_FORMAT                         }
    { ViewDimension D3D10_RTV_DIMENSION                 }
    { View          D3D10_RENDER_TARGET_VIEW_DESC_UNION } ;

COM-INTERFACE: ID3D10RenderTargetView ID3D10View {9B7E4C08-342C-4106-A19F-4F2704F689F0}
    void GetDesc ( D3D10_RENDER_TARGET_VIEW_DESC* pDesc ) ;

STRUCT: D3D10_TEX1D_DSV
    { MipSlice UINT } ;

STRUCT: D3D10_TEX1D_ARRAY_DSV
    { MipSlice        UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D10_TEX2D_DSV
    { MipSlice UINT } ;

STRUCT: D3D10_TEX2D_ARRAY_DSV
    { MipSlice        UINT }
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

STRUCT: D3D10_TEX2DMS_DSV
    { UnusedField_NothingToDefine UINT } ;

STRUCT: D3D10_TEX2DMS_ARRAY_DSV
    { FirstArraySlice UINT }
    { ArraySize       UINT } ;

UNION-STRUCT: D3D10_DEPTH_STENCIL_VIEW_DESC_UNION
    { Texture1D        D3D10_TEX1D_DSV         }
    { Texture1DArray   D3D10_TEX1D_ARRAY_DSV   }
    { Texture2D        D3D10_TEX2D_DSV         }
    { Texture2DArray   D3D10_TEX2D_ARRAY_DSV   }
    { Texture2DMS      D3D10_TEX2DMS_DSV       }
    { Texture2DMSArray D3D10_TEX2DMS_ARRAY_DSV } ;

STRUCT: D3D10_DEPTH_STENCIL_VIEW_DESC
    { Format        DXGI_FORMAT                         }
    { ViewDimension D3D10_DSV_DIMENSION                 }
    { Union         D3D10_DEPTH_STENCIL_VIEW_DESC_UNION } ;

COM-INTERFACE: ID3D10DepthStencilView ID3D10View {9B7E4C09-342C-4106-A19F-4F2704F689F0}
    void GetDesc ( D3D10_DEPTH_STENCIL_VIEW_DESC* pDesc ) ;

COM-INTERFACE: ID3D10VertexShader ID3D10DeviceChild {9B7E4C0A-342C-4106-A19F-4F2704F689F0} ;

COM-INTERFACE: ID3D10GeometryShader ID3D10DeviceChild {16BE88-54CD-4040-AB44-20461BC81F68} ;

COM-INTERFACE: ID3D10PixelShader ID3D10DeviceChild {68B601-9D00-4cde-8346-8E7F675819B6} ;

COM-INTERFACE: ID3D10InputLayout ID3D10DeviceChild {7E4C0B-342C-4106-A19F-4F2704F689F0} ;

CONSTANT: D3D10_FILTER_MIN_MAG_MIP_POINT                          0
CONSTANT: D3D10_FILTER_MIN_MAG_POINT_MIP_LINEAR                   0x1
CONSTANT: D3D10_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT             0x4
CONSTANT: D3D10_FILTER_MIN_POINT_MAG_MIP_LINEAR                   0x5
CONSTANT: D3D10_FILTER_MIN_LINEAR_MAG_MIP_POINT                   0x10
CONSTANT: D3D10_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR            0x11
CONSTANT: D3D10_FILTER_MIN_MAG_LINEAR_MIP_POINT                   0x14
CONSTANT: D3D10_FILTER_MIN_MAG_MIP_LINEAR                         0x15
CONSTANT: D3D10_FILTER_ANISOTROPIC                                0x55
CONSTANT: D3D10_FILTER_COMPARISON_MIN_MAG_MIP_POINT               0x80
CONSTANT: D3D10_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR        0x81
CONSTANT: D3D10_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT  0x84
CONSTANT: D3D10_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR        0x85
CONSTANT: D3D10_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT        0x90
CONSTANT: D3D10_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR 0x91
CONSTANT: D3D10_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT        0x94
CONSTANT: D3D10_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR              0x95
CONSTANT: D3D10_FILTER_COMPARISON_ANISOTROPIC                     0xd5
CONSTANT: D3D10_FILTER_TEXT_1BIT                                  0x80000000
TYPEDEF: int D3D10_FILTER

CONSTANT: D3D10_FILTER_TYPE_POINT  0
CONSTANT: D3D10_FILTER_TYPE_LINEAR 1
TYPEDEF: int D3D10_FILTER_TYPE

CONSTANT: D3D10_FILTER_TYPE_MASK          0x3
CONSTANT: D3D10_MIN_FILTER_SHIFT          4
CONSTANT: D3D10_MAG_FILTER_SHIFT          2
CONSTANT: D3D10_MIP_FILTER_SHIFT          0
CONSTANT: D3D10_COMPARISON_FILTERING_BIT  0x80
CONSTANT: D3D10_ANISOTROPIC_FILTERING_BIT 0x40
CONSTANT: D3D10_TEXT_1BIT_BIT             0x80000000

CONSTANT: D3D10_TEXTURE_ADDRESS_WRAP        1
CONSTANT: D3D10_TEXTURE_ADDRESS_MIRROR      2
CONSTANT: D3D10_TEXTURE_ADDRESS_CLAMP       3
CONSTANT: D3D10_TEXTURE_ADDRESS_BORDER      4
CONSTANT: D3D10_TEXTURE_ADDRESS_MIRROR_ONCE 5
TYPEDEF: int D3D10_TEXTURE_ADDRESS_MODE

STRUCT: D3D10_SAMPLER_DESC
    { Filter         D3D10_FILTER               }
    { AddressU       D3D10_TEXTURE_ADDRESS_MODE }
    { AddressV       D3D10_TEXTURE_ADDRESS_MODE }
    { AddressW       D3D10_TEXTURE_ADDRESS_MODE }
    { MipLODBias     FLOAT                      }
    { MaxAnisotropy  UINT                       }
    { ComparisonFunc D3D10_COMPARISON_FUNC      }
    { BorderColor    FLOAT[4]                   }
    { MinLOD         FLOAT                      }
    { MaxLOD         FLOAT                      } ;
TYPEDEF: D3D10_SAMPLER_DESC D3D10SAMPLER_DESC

COM-INTERFACE: ID3D10SamplerState ID3D10DeviceChild {9B7E4C0C-342C-4106-A19F-4F2704F689F0}
    void GetDesc ( D3D10SAMPLER_DESC* pDesc ) ;

CONSTANT: D3D10_FORMAT_SUPPORT_BUFFER                   0x1
CONSTANT: D3D10_FORMAT_SUPPORT_IA_VERTEX_BUFFER         0x2
CONSTANT: D3D10_FORMAT_SUPPORT_IA_INDEX_BUFFER          0x4
CONSTANT: D3D10_FORMAT_SUPPORT_SO_BUFFER                0x8
CONSTANT: D3D10_FORMAT_SUPPORT_TEXTURE1D                0x10
CONSTANT: D3D10_FORMAT_SUPPORT_TEXTURE2D                0x20
CONSTANT: D3D10_FORMAT_SUPPORT_TEXTURE3D                0x40
CONSTANT: D3D10_FORMAT_SUPPORT_TEXTURECUBE              0x80
CONSTANT: D3D10_FORMAT_SUPPORT_SHADER_LOAD              0x100
CONSTANT: D3D10_FORMAT_SUPPORT_SHADER_SAMPLE            0x200
CONSTANT: D3D10_FORMAT_SUPPORT_SHADER_SAMPLE_COMPARISON 0x400
CONSTANT: D3D10_FORMAT_SUPPORT_SHADER_SAMPLE_MONO_TEXT  0x800
CONSTANT: D3D10_FORMAT_SUPPORT_MIP                      0x1000
CONSTANT: D3D10_FORMAT_SUPPORT_MIP_AUTOGEN              0x2000
CONSTANT: D3D10_FORMAT_SUPPORT_RENDER_TARGET            0x4000
CONSTANT: D3D10_FORMAT_SUPPORT_BLENDABLE                0x8000
CONSTANT: D3D10_FORMAT_SUPPORT_DEPTH_STENCIL            0x10000
CONSTANT: D3D10_FORMAT_SUPPORT_CPU_LOCKABLE             0x20000
CONSTANT: D3D10_FORMAT_SUPPORT_MULTISAMPLE_RESOLVE      0x40000
CONSTANT: D3D10_FORMAT_SUPPORT_DISPLAY                  0x80000
CONSTANT: D3D10_FORMAT_SUPPORT_CAST_WITHIN_BIT_LAYOUT   0x100000
CONSTANT: D3D10_FORMAT_SUPPORT_MULTISAMPLE_RENDERTARGET 0x200000
CONSTANT: D3D10_FORMAT_SUPPORT_MULTISAMPLE_LOAD         0x400000
CONSTANT: D3D10_FORMAT_SUPPORT_SHADER_GATHER            0x800000
CONSTANT: D3D10_FORMAT_SUPPORT_BACK_BUFFER_CAST         0x100000
TYPEDEF: int D3D10_FORMAT_SUPPORT

COM-INTERFACE: ID3D10Asynchronous ID3D10DeviceChild {9B7E4C0D-342C-4106-A19F-4F2704F689F0}
    void Begin ( )
    void End ( )
    HRESULT GetData ( void* pData, UINT DataSize, UINT GetDataFlags )
    UINT GetDataSize ( ) ;

CONSTANT: D3D10_ASYNC_GETDATA_DONOTFLUSH 1
TYPEDEF: int D3D10_ASYNC_GETDATA_FLAG

CONSTANT: D3D10_QUERY_EVENT                 0
CONSTANT: D3D10_QUERY_OCCLUSION             1
CONSTANT: D3D10_QUERY_TIMESTAMP             2
CONSTANT: D3D10_QUERY_TIMESTAMP_DISJOINT    3
CONSTANT: D3D10_QUERY_PIPELINE_STATISTICS   4
CONSTANT: D3D10_QUERY_OCCLUSION_PREDICATE   5
CONSTANT: D3D10_QUERY_SO_STATISTICS         6
CONSTANT: D3D10_QUERY_SO_OVERFLOW_PREDICATE 7
TYPEDEF: int D3D10_QUERY

CONSTANT: D3D10_QUERY_MISC_PREDICATEHINT 1
TYPEDEF: int D3D10_QUERY_MISC_FLAG

STRUCT: D3D10_QUERY_DESC
    { Query     D3D10_QUERY }
    { MiscFlags UINT        } ;

COM-INTERFACE: ID3D10Query ID3D10Asynchronous {9B7E4C0E-342C-4106-A19F-4F2704F689F0}
    void GetDesc ( D3D10_QUERY_DESC* pDesc ) ;

COM-INTERFACE: ID3D10Predicate ID3D10Query {9B7E4C10-342C-4106-A19F-4F2704F689F0} ;

STRUCT: D3D10_QUERY_DATA_TIMESTAMP_DISJOINT
    { Frequency UINT64 }
    { Disjoint  BOOL   } ;

STRUCT: D3D10_QUERY_DATA_PIPELINE_STATISTICS
    { IAVertices    UINT64 }
    { IAPrimitives  UINT64 }
    { VSInvocations UINT64 }
    { GSInvocations UINT64 }
    { GSPrimitives  UINT64 }
    { CInvocations  UINT64 }
    { CPrimitives   UINT64 }
    { PSInvocations UINT64 } ;

STRUCT: D3D10_QUERY_DATA_SO_STATISTICS
    { NumPrimitivesWritten    UINT64 }
    { PrimitivesStorageNeeded UINT64 } ;

CONSTANT: D3D10_COUNTER_GPU_IDLE                              0
CONSTANT: D3D10_COUNTER_VERTEX_PROCESSING                     1
CONSTANT: D3D10_COUNTER_GEOMETRY_PROCESSING                   2
CONSTANT: D3D10_COUNTER_PIXEL_PROCESSING                      3
CONSTANT: D3D10_COUNTER_OTHER_GPU_PROCESSING                  4
CONSTANT: D3D10_COUNTER_HOST_ADAPTER_BANDWIDTH_UTILIZATION    5
CONSTANT: D3D10_COUNTER_LOCAL_VIDMEM_BANDWIDTH_UTILIZATION    6
CONSTANT: D3D10_COUNTER_VERTEX_THROUGHPUT_UTILIZATION         7
CONSTANT: D3D10_COUNTER_TRIANGLE_SETUP_THROUGHPUT_UTILIZATION 8
CONSTANT: D3D10_COUNTER_FILLRATE_THROUGHPUT_UTILIZATION       9
CONSTANT: D3D10_COUNTER_VS_MEMORY_LIMITED                     10
CONSTANT: D3D10_COUNTER_VS_COMPUTATION_LIMITED                11
CONSTANT: D3D10_COUNTER_GS_MEMORY_LIMITED                     12
CONSTANT: D3D10_COUNTER_GS_COMPUTATION_LIMITED                13
CONSTANT: D3D10_COUNTER_PS_MEMORY_LIMITED                     14
CONSTANT: D3D10_COUNTER_PS_COMPUTATION_LIMITED                15
CONSTANT: D3D10_COUNTER_POST_TRANSFORM_CACHE_HIT_RATE         16
CONSTANT: D3D10_COUNTER_TEXTURE_CACHE_HIT_RATE                17
CONSTANT: D3D10_COUNTER_DEVICE_DEPENDENT_0                    0x40000000
TYPEDEF: int D3D10_COUNTER

CONSTANT: D3D10_COUNTER_TYPE_FLOAT32 0
CONSTANT: D3D10_COUNTER_TYPE_UINT16  1
CONSTANT: D3D10_COUNTER_TYPE_UINT32  2
CONSTANT: D3D10_COUNTER_TYPE_UINT64  3
TYPEDEF: int D3D10_COUNTER_TYPE

STRUCT: D3D10_COUNTER_DESC
    { Counter   D3D10_COUNTER }
    { MiscFlags UINT          } ;

STRUCT: D3D10_COUNTER_INFO
    { LastDeviceDependentCounter D3D10_COUNTER }
    { NumSimultaneousCounters    UINT          }
    { NumDetectableParallelUnits BYTE          } ;

COM-INTERFACE: ID3D10Counter ID3D10Asynchronous {9B7E4C11-342C-4106-A19F-4F2704F689F0}
    void GetDesc ( D3D10_COUNTER_DESC* pDesc ) ;

COM-INTERFACE: ID3D10Device IUnknown {9B7E4C0F-342C-4106-A19F-4F2704F689F0}
    void VSSetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D10Buffer** ppConstantBuffers )
    void PSSetShaderResources ( UINT StartSlot, UINT NumViews, ID3D10ShaderResourceView** ppShaderResourceView )
    void PSSetShader ( ID3D10PixelShader* pPixelShader )
    void PSSetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D10SamplerState** ppSamplers )
    void VSSetShader ( ID3D10VertexShader* pVertexShader )
    void DrawIndexed ( UINT IndexCount, UINT StartIndexLocation, INT BaseVertexLocation )
    void Draw ( UINT VertexCount, UINT StartVertexLocation )
    void PSSetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D10Buffer** ppConstantBuffers )
    void IASetInputLayout ( ID3D10InputLayout* pInputLayout )
    void IASetVertexBuffers ( UINT StartSlot, UINT NumBuffers, ID3D10Buffer** ppVertexBuffers, UINT* pStrides, UINT* pOffsets )
    void IASetIndexBuffer ( ID3D10Buffer* pIndexBuffer, DXGI_FORMAT Format, UINT Offset )
    void DrawIndexedInstanced ( UINT IndexCountPerInstance, UINT InstanceCount, UINT StartIndexLocation, INT BaseVertexLocation, UINT StartInstanceLocation )
    void DrawInstanced ( UINT VertexCountPerInstance, UINT InstanceCount, UINT StartVertexLocation, UINT StartInstanceLocation )
    void GSSetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D10Buffer** ppConstantBuffers )
    void GSSetShader ( ID3D10GeometryShader* pShader )
    void IASetPrimitiveTopology ( D3D10_PRIMITIVE_TOPOLOGY Topology )
    void VSSetShaderResources ( UINT StartSlot, UINT NumViews, ID3D10ShaderResourceView** ppShaderResourceViews )
    void VSSetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D10SamplerState** ppSamplers )
    void SetPredication ( ID3D10Predicate* pPredicate, BOOL PredicateValue )
    void GSSetShaderResources ( UINT StartSlot, UINT NumViews, ID3D10ShaderResourceView** ppShaderResourceViews )
    void GSSetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D10SamplerState** ppSamplers )
    void OMSetRenderTargets ( UINT NumViews, ID3D10RenderTargetView** ppRenderTargetViews, ID3D10DepthStencilView* pDepthStencilView )
    void OMSetBlendState ( ID3D10BlendState* pBlendState, FLOAT[4] BlendFactor, UINT SampleMask )
    void OMSetDepthStencilState ( ID3D10DepthStencilState* pDepthStencilState, UINT StencilRef )
    void SOSetTargets ( UINT NumBuffers, ID3D10Buffer** ppSOTargets, UINT* pOffsets )
    void DrawAuto ( )
    void RSSetState ( ID3D10RasterizerState* pRasterizerState )
    void RSSetViewports ( UINT NumViewports, D3D10_VIEWPORT* pViewports )
    void RSSetScissorRects ( UINT NumRects, D3D10_RECT* pRects )
    void CopySubresourceRegion ( ID3D10Resource* pDstResource, UINT DstSubresource, UINT DstX, UINT DstY, UINT DstZ, ID3D10Resource* pSrcResource, UINT SrcSubresource, D3D10_BOX* pSrcBox )
    void CopyResource ( ID3D10Resource* pDstResource, ID3D10Resource* pSrcResource )
    void UpdateSubresource ( ID3D10Resource* pDstResource, UINT DstSubresource, D3D10_BOX* pDstBox, void* pSrcData, UINT SrcRowPitch, UINT SrcDepthPitch )
    void ClearRenderTargetView ( ID3D10RenderTargetView* pRenderTargetView, FLOAT[4] ColorRGBA )
    void ClearDepthStencilView ( ID3D10DepthStencilView* pDepthStencilView, UINT ClearFlags, FLOAT Depth, BYTE Stencil )
    void GenerateMips ( ID3D10ShaderResourceView* pShaderResourceView )
    void ResolveSubresource ( ID3D10Resource* pDstResource, UINT DstSubresource, ID3D10Resource* pSrcResource, UINT SrcSubresource, DXGI_FORMAT Format )
    void VSGetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D10Buffer** ppConstantBuffers )
    void PSGetShaderResources ( UINT StartSlot, UINT NumViews, ID3D10ShaderResourceView** ppShaderResourceViews )
    void PSGetShader ( ID3D10PixelShader** ppPixelShader )
    void PSGetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D10SamplerState** ppSamplers )
    void VSGetShader ( ID3D10VertexShader** ppVertexShader )
    void PSGetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D10Buffer** ppConstantBuffers )
    void IAGetInputLayout ( ID3D10InputLayout** ppInputLayout )
    void IAGetVertexBuffers ( UINT StartSlot, UINT NumBuffers, ID3D10Buffer** ppVertexBuffers, UINT* pStrides, UINT* pOffsets )
    void IAGetIndexBuffer ( ID3D10Buffer** pIndexBuffer, DXGI_FORMAT* Format, UINT* Offset )
    void GSGetConstantBuffers ( UINT StartSlot, UINT NumBuffers, ID3D10Buffer** ppConstantBuffers )
    void GSGetShader ( ID3D10GeometryShader** ppGeometryShader )
    void IAGetPrimitiveTopology ( D3D10_PRIMITIVE_TOPOLOGY* pTopology )
    void VSGetShaderResources ( UINT StartSlot, UINT NumViews, ID3D10ShaderResourceView** ppShaderResourceViews )
    void VSGetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D10SamplerState** ppSamplers )
    void GetPredication ( ID3D10Predicate** ppPredicate, BOOL* pPredicateValue )
    void GSGetShaderResources ( UINT StartSlot, UINT NumViews, ID3D10ShaderResourceView** ppShaderResourceViews )
    void GSGetSamplers ( UINT StartSlot, UINT NumSamplers, ID3D10SamplerState** ppSamplers )
    void OMGetRenderTargets ( UINT NumViews, ID3D10RenderTargetView** ppRenderTargetViews, ID3D10DepthStencilView** ppDepthStencilView )
    void OMGetBlendState ( ID3D10BlendState** ppBlendState, FLOAT[4] BlendFactor, UINT* pSampleMask )
    void OMGetDepthStencilState ( ID3D10DepthStencilState** ppDepthStencilState, UINT* pStencilRef )
    void SOGetTargets ( UINT NumBuffers, ID3D10Buffer** ppSOTargets, UINT* pOffsets )
    void RSGetState ( ID3D10RasterizerState** ppRasterizerState )
    void RSGetViewports ( UINT* NumViewports, D3D10_VIEWPORT* pViewports )
    void RSGetScissorRects ( UINT* NumRects, D3D10_RECT* pRects )
    HRESULT GetDeviceRemovedReason ( )
    HRESULT SetExceptionMode ( UINT RaiseFlags )
    UINT GetExceptionMode ( )
    HRESULT GetPrivateData ( REFGUID guid, UINT* pDataSize, void* pData )
    HRESULT SetPrivateData ( REFGUID guid, UINT DataSize, void* pData )
    HRESULT SetPrivateDataInterface ( REFGUID guid, IUnknown* pData )
    void ClearState ( )
    void Flush ( )
    HRESULT CreateBuffer ( D3D10_BUFFER_DESC* pDesc, D3D10_SUBRESOURCE_DATA* pInitialData, ID3D10Buffer** ppBuffer )
    HRESULT CreateTexture1D ( D3D10_TEXTURE1D_DESC* pDesc, D3D10_SUBRESOURCE_DATA* pInitialData, ID3D10Texture1D** ppTexture1D )
    HRESULT CreateTexture2D ( D3D10_TEXTURE2D_DESC* pDesc, D3D10_SUBRESOURCE_DATA* pInitialData, ID3D10Texture2D** ppTexture2D )
    HRESULT CreateTexture3D ( D3D10_TEXTURE3D_DESC* pDesc, D3D10_SUBRESOURCE_DATA* pInitialData, ID3D10Texture3D** ppTexture3D )
    HRESULT CreateShaderResourceView ( ID3D10Resource* pResource, D3D10_SHADER_RESOURCE_VIEW_DESC* pDesc, ID3D10ShaderResourceView** ppSRView )
    HRESULT CreateRenderTargetView ( ID3D10Resource* pResource, D3D10_RENDER_TARGET_VIEW_DESC* pDesc, ID3D10RenderTargetView** ppRTView )
    HRESULT CreateDepthStencilView ( ID3D10Resource* pResource, D3D10_DEPTH_STENCIL_VIEW_DESC* pDesc, ID3D10DepthStencilView** ppDepthStencilView )
    HRESULT CreateInputLayout ( D3D10_INPUT_ELEMENT_DESC* pInputElementDescs, UINT NumElements, void* pShaderBytecodeWithInputSignature, SIZE_T BytecodeLength, ID3D10InputLayout** ppInputLayout )
    HRESULT CreateVertexShader ( void* pShaderBytecode, SIZE_T BytecodeLength, ID3D10VertexShader** ppVertexShader )
    HRESULT CreateGeometryShader ( void* pShaderBytecode, SIZE_T BytecodeLength, ID3D10GeometryShader** ppGeometryShader )
    HRESULT CreateGeometryShaderWithStreamOutput ( void* pShaderBytecode, SIZE_T BytecodeLength, D3D10_SO_DECLARATION_ENTRY* pSODeclaration, UINT NumEntries, UINT OutputStreamStride, ID3D10GeometryShader** ppGeometryShader )
    HRESULT CreatePixelShader ( void* pShaderBytecode, SIZE_T BytecodeLength, ID3D10PixelShader** ppPixelShader )
    HRESULT CreateBlendState ( D3D10_BLEND_DESC* pBlendStateDesc, ID3D10BlendState** ppBlendState )
    HRESULT CreateDepthStencilState ( D3D10_DEPTH_STENCIL_DESC* pDepthStencilDesc, ID3D10DepthStencilState** ppDepthStencilState )
    HRESULT CreateRasterizerState ( D3D10_RASTERIZER_DESC* pRasterizerDesc, ID3D10RasterizerState** ppRasterizerState )
    HRESULT CreateSamplerState ( D3D10_SAMPLER_DESC* pSamplerDesc, ID3D10SamplerState** ppSamplerState )
    HRESULT CreateQuery ( D3D10_QUERY_DESC* pQueryDesc, ID3D10Query** ppQuery )
    HRESULT CreatePredicate ( D3D10_QUERY_DESC* pPredicateDesc, ID3D10Predicate** ppPredicate )
    HRESULT CreateCounter ( D3D10_COUNTER_DESC* pCounterDesc, ID3D10Counter** ppCounter )
    HRESULT CheckFormatSupport ( DXGI_FORMAT Format, UINT* pFormatSupport )
    HRESULT CheckMultisampleQualityLevels ( DXGI_FORMAT Format, UINT SampleCount, UINT* pNumQualityLevels )
    void CheckCounterInfo ( D3D10_COUNTER_INFO* pCounterInfo )
    HRESULT CheckCounter ( D3D10_COUNTER_DESC* pDesc, D3D10_COUNTER_TYPE* pType, UINT* pActiveCounters, LPSTR szName, UINT* pNameLength, LPSTR szUnits, UINT* pUnitsLength, LPSTR szDescription, UINT* pDescriptionLength )
    UINT GetCreationFlags ( )
    HRESULT OpenSharedResource ( HANDLE hResource, REFIID ReturnedInterface, void** ppResource )
    void SetTextFilterSize ( UINT Width, UINT Height )
    void GetTextFilterSize ( UINT* pWidth, UINT* pHeight ) ;

COM-INTERFACE: ID3D10Multithread IUnknown {9B7E4E00-342C-4106-A19F-4F2704F689F0}
    void Enter ( )
    void Leave ( )
    BOOL SetMultithreadProtected ( BOOL bMTProtect )
    BOOL GetMultithreadProtected ( ) ;

CONSTANT: D3D10_CREATE_DEVICE_SINGLETHREADED                           0x1
CONSTANT: D3D10_CREATE_DEVICE_DEBUG                                    0x2
CONSTANT: D3D10_CREATE_DEVICE_SWITCH_TO_REF                            0x4
CONSTANT: D3D10_CREATE_DEVICE_PREVENT_INTERNAL_THREADING_OPTIMIZATIONS 0x8
CONSTANT: D3D10_CREATE_DEVICE_ALLOW_NULL_FROM_MAP                      0x10
CONSTANT: D3D10_CREATE_DEVICE_BGRA_SUPPORT                             0x20
CONSTANT: D3D10_CREATE_DEVICE_STRICT_VALIDATION                        0x200
TYPEDEF: int D3D10_CREATE_DEVICE_FLAG

CONSTANT: D3D10_SDK_VERSION 29

CONSTANT: D3DX10_ERR_CANNOT_MODIFY_INDEX_BUFFER 0x88760B54
CONSTANT: D3DX10_ERR_INVALID_MESH               0x88760B55
CONSTANT: D3DX10_ERR_CANNOT_ATTR_SORT           0x88760B56
CONSTANT: D3DX10_ERR_SKINNING_NOT_SUPPORTED     0x88760B57
CONSTANT: D3DX10_ERR_TOO_MANY_INFLUENCES        0x88760B58
CONSTANT: D3DX10_ERR_INVALID_DATA               0x88760B59
CONSTANT: D3DX10_ERR_LOADED_MESH_HAS_NO_DATA    0x88760B5A
CONSTANT: D3DX10_ERR_DUPLICATE_NAMED_FRAGMENT   0x88760B5B
CONSTANT: D3DX10_ERR_CANNOT_REMOVE_LAST_ITEM    0x88760B5C
