! Copyright (C) 2005, 2006 Doug Coleman.
! See http://factorcode.org/license.txt for BSD license.
USING: alien alien.c-types alien.syntax kernel windows.types
math multiline classes.struct alien.data arrays literals ;
QUALIFIED-WITH: alien.c-types c
IN: windows.kernel32

: lo-word ( wparam -- lo ) c:short <ref> c:short deref ; inline
: hi-word ( wparam -- hi ) -16 shift lo-word ; inline
: >lo-hi ( WORD -- array ) [ lo-word ] [ hi-word ] bi 2array ; inline

CONSTANT: MAX_PATH 260

CONSTANT: GHND          0x40
CONSTANT: GMEM_FIXED          0
CONSTANT: GMEM_MOVEABLE       2
CONSTANT: GMEM_ZEROINIT 0x40
CONSTANT: GPTR          0x40

CONSTANT: GENERIC_READ    0x80000000
CONSTANT: GENERIC_WRITE   0x40000000
CONSTANT: GENERIC_EXECUTE 0x20000000
CONSTANT: GENERIC_ALL     0x10000000

CONSTANT: CREATE_NEW        1
CONSTANT: CREATE_ALWAYS     2
CONSTANT: OPEN_EXISTING     3
CONSTANT: OPEN_ALWAYS       4
CONSTANT: TRUNCATE_EXISTING 5
              
CONSTANT: FILE_LIST_DIRECTORY       0x00000001
CONSTANT: FILE_READ_DAT             0x00000001
CONSTANT: FILE_ADD_FILE             0x00000002
CONSTANT: FILE_WRITE_DATA           0x00000002
CONSTANT: FILE_ADD_SUBDIRECTORY     0x00000004
CONSTANT: FILE_APPEND_DATA          0x00000004
CONSTANT: FILE_CREATE_PIPE_INSTANCE 0x00000004
CONSTANT: FILE_READ_EA              0x00000008
CONSTANT: FILE_READ_PROPERTIES      0x00000008
CONSTANT: FILE_WRITE_EA             0x00000010
CONSTANT: FILE_WRITE_PROPERTIES     0x00000010
CONSTANT: FILE_EXECUTE              0x00000020
CONSTANT: FILE_TRAVERSE             0x00000020
CONSTANT: FILE_DELETE_CHILD         0x00000040
CONSTANT: FILE_READ_ATTRIBUTES      0x00000080
CONSTANT: FILE_WRITE_ATTRIBUTES     0x00000100

CONSTANT: FILE_SHARE_READ        1
CONSTANT: FILE_SHARE_WRITE       2
CONSTANT: FILE_SHARE_DELETE      4
CONSTANT: FILE_SHARE_VALID_FLAGS 7

CONSTANT: FILE_FLAG_WRITE_THROUGH       0x80000000
CONSTANT: FILE_FLAG_OVERLAPPED          0x40000000
CONSTANT: FILE_FLAG_NO_BUFFERING        0x20000000
CONSTANT: FILE_FLAG_RANDOM_ACCESS       0x10000000
CONSTANT: FILE_FLAG_SEQUENTIAL_SCAN     0x08000000
CONSTANT: FILE_FLAG_DELETE_ON_CLOSE     0x04000000
CONSTANT: FILE_FLAG_BACKUP_SEMANTICS    0x02000000
CONSTANT: FILE_FLAG_POSIX_SEMANTICS     0x01000000
CONSTANT: FILE_FLAG_OPEN_REPARSE_POINT  0x00200000
CONSTANT: FILE_FLAG_OPEN_NO_RECALL      0x00100000
CONSTANT: FILE_FLAG_FIRST_PIPE_INSTANCE 0x00080000

CONSTANT: FILE_ATTRIBUTE_READONLY            0x00000001
CONSTANT: FILE_ATTRIBUTE_HIDDEN              0x00000002
CONSTANT: FILE_ATTRIBUTE_SYSTEM              0x00000004
CONSTANT: FILE_ATTRIBUTE_DIRECTORY           0x00000010
CONSTANT: FILE_ATTRIBUTE_ARCHIVE             0x00000020
CONSTANT: FILE_ATTRIBUTE_DEVICE              0x00000040
CONSTANT: FILE_ATTRIBUTE_NORMAL              0x00000080
CONSTANT: FILE_ATTRIBUTE_TEMPORARY           0x00000100
CONSTANT: FILE_ATTRIBUTE_SPARSE_FILE         0x00000200
CONSTANT: FILE_ATTRIBUTE_REPARSE_POINT       0x00000400
CONSTANT: FILE_ATTRIBUTE_COMPRESSED          0x00000800
CONSTANT: FILE_ATTRIBUTE_OFFLINE             0x00001000
CONSTANT: FILE_ATTRIBUTE_NOT_CONTENT_INDEXED 0x00002000
CONSTANT: FILE_ATTRIBUTE_ENCRYPTED           0x00004000

CONSTANT: FILE_NOTIFY_CHANGE_FILE        0x001
CONSTANT: FILE_NOTIFY_CHANGE_DIR_NAME    0x002
CONSTANT: FILE_NOTIFY_CHANGE_ATTRIBUTES  0x004
CONSTANT: FILE_NOTIFY_CHANGE_SIZE        0x008
CONSTANT: FILE_NOTIFY_CHANGE_LAST_WRITE  0x010
CONSTANT: FILE_NOTIFY_CHANGE_LAST_ACCESS 0x020
CONSTANT: FILE_NOTIFY_CHANGE_CREATION    0x040
CONSTANT: FILE_NOTIFY_CHANGE_EA          0x080
CONSTANT: FILE_NOTIFY_CHANGE_SECURITY    0x100
CONSTANT: FILE_NOTIFY_CHANGE_FILE_NAME   0x200
CONSTANT: FILE_NOTIFY_CHANGE_ALL         0x3ff

CONSTANT: FILE_ACTION_ADDED 1
CONSTANT: FILE_ACTION_REMOVED 2
CONSTANT: FILE_ACTION_MODIFIED 3
CONSTANT: FILE_ACTION_RENAMED_OLD_NAME 4
CONSTANT: FILE_ACTION_RENAMED_NEW_NAME 5

CONSTANT: DONT_RESOLVE_DLL_REFERENCES 1

STRUCT: FILE_NOTIFY_INFORMATION
    { NextEntryOffset DWORD }
    { Action DWORD }
    { FileNameLength DWORD }
    { FileName WCHAR[1] } ;

TYPEDEF: FILE_NOTIFY_INFORMATION* PFILE_NOTIFY_INFORMATION

CONSTANT: STD_INPUT_HANDLE  -10
CONSTANT: STD_OUTPUT_HANDLE -11
CONSTANT: STD_ERROR_HANDLE  -12

: INVALID_HANDLE_VALUE ( -- alien ) -1 <alien> ; inline
CONSTANT: INVALID_FILE_SIZE 0xFFFFFFFF
CONSTANT: INVALID_SET_FILE_POINTER 0xffffffff

CONSTANT: FILE_BEGIN 0
CONSTANT: FILE_CURRENT 1
CONSTANT: FILE_END 2

CONSTANT: OF_READ 0
CONSTANT: OF_READWRITE    2
CONSTANT: OF_WRITE    1
CONSTANT: OF_SHARE_COMPAT    0
CONSTANT: OF_SHARE_DENY_NONE    64
CONSTANT: OF_SHARE_DENY_READ    48
CONSTANT: OF_SHARE_DENY_WRITE    32
CONSTANT: OF_SHARE_EXCLUSIVE    16
CONSTANT: OF_CANCEL    2048
CONSTANT: OF_CREATE    4096
CONSTANT: OF_DELETE    512
CONSTANT: OF_EXIST    16384
CONSTANT: OF_PARSE    256
CONSTANT: OF_PROMPT    8192
CONSTANT: OF_REOPEN    32768
CONSTANT: OF_VERIFY    1024

CONSTANT: INFINITE 0xFFFFFFFF

! From C:\cygwin\usr\include\w32api\winbase.h
CONSTANT: FILE_TYPE_UNKNOWN 0
CONSTANT: FILE_TYPE_DISK 1
CONSTANT: FILE_TYPE_CHAR 2
CONSTANT: FILE_TYPE_PIPE 3
CONSTANT: FILE_TYPE_REMOTE 0x8000

CONSTANT: TIME_ZONE_ID_UNKNOWN 0
CONSTANT: TIME_ZONE_ID_STANDARD 1
CONSTANT: TIME_ZONE_ID_DAYLIGHT 2
CONSTANT: TIME_ZONE_ID_INVALID 0xFFFFFFFF

CONSTANT: PF_XMMI64_INSTRUCTIONS_AVAILABLE 10
CONSTANT: PF_SSE3_INSTRUCTIONS_AVAILABLE 13

CONSTANT: MAX_COMPUTERNAME_LENGTH 15
CONSTANT: UNLEN 256

CONSTANT: PROCESS_TERMINATE 0x1
CONSTANT: PROCESS_CREATE_THREAD 0x2
CONSTANT: PROCESS_VM_OPERATION 0x8
CONSTANT: PROCESS_VM_READ 0x10
CONSTANT: PROCESS_VM_WRITE 0x20
CONSTANT: PROCESS_DUP_HANDLE 0x40
CONSTANT: PROCESS_CREATE_PROCESS 0x80
CONSTANT: PROCESS_SET_QUOTA 0x100
CONSTANT: PROCESS_SET_INFORMATION 0x200
CONSTANT: PROCESS_QUERY_INFORMATION 0x400

CONSTANT: MEM_COMMIT 0x1000
CONSTANT: MEM_RELEASE  0x8000

CONSTANT: PAGE_NOACCESS    1
CONSTANT: PAGE_READONLY    2
CONSTANT: PAGE_READWRITE 4
CONSTANT: PAGE_WRITECOPY 8
CONSTANT: PAGE_EXECUTE 0x10
CONSTANT: PAGE_EXECUTE_READ 0x20
CONSTANT: PAGE_EXECUTE_READWRITE 0x40
CONSTANT: PAGE_EXECUTE_WRITECOPY 0x80
CONSTANT: PAGE_GUARD 0x100
CONSTANT: PAGE_NOCACHE 0x200

CONSTANT: SEC_BASED 0x00200000
CONSTANT: SEC_NO_CHANGE 0x00400000
CONSTANT: SEC_FILE 0x00800000
CONSTANT: SEC_IMAGE 0x01000000
CONSTANT: SEC_VLM 0x02000000
CONSTANT: SEC_RESERVE 0x04000000
CONSTANT: SEC_COMMIT 0x08000000
CONSTANT: SEC_NOCACHE 0x10000000
ALIAS: MEM_IMAGE SEC_IMAGE

CONSTANT: FILE_MAP_ALL_ACCESS 0xf001f
CONSTANT: FILE_MAP_READ   4
CONSTANT: FILE_MAP_WRITE  2
CONSTANT: FILE_MAP_COPY   1

CONSTANT: THREAD_MODE_BACKGROUND_BEGIN 0x10000
CONSTANT: THREAD_MODE_BACKGROUND_END   0x20000
CONSTANT: THREAD_PRIORITY_ABOVE_NORMAL 1
CONSTANT: THREAD_PRIORITY_BELOW_NORMAL -1
CONSTANT: THREAD_PRIORITY_HIGHEST 2
CONSTANT: THREAD_PRIORITY_IDLE -15
CONSTANT: THREAD_PRIORITY_LOWEST -2
CONSTANT: THREAD_PRIORITY_NORMAL 0
CONSTANT: THREAD_PRIORITY_TIME_CRITICAL 15

ENUM: COMPUTER_NAME_FORMAT
    ComputerNameNetBIOS
    ComputerNameDnsHostname
    ComputerNameDnsDomain
    ComputerNameDnsFullyQualified
    ComputerNamePhysicalNetBIOS
    ComputerNamePhysicalDnsHostname
    ComputerNamePhysicalDnsDomain
    ComputerNamePhysicalDnsFullyQualified
    ComputerNameMax ;

STRUCT: OVERLAPPED
    { internal UINT_PTR }
    { internal-high UINT_PTR }
    { offset DWORD }
    { offset-high DWORD }
    { event HANDLE } ;

STRUCT: SYSTEMTIME
    { wYear WORD }
    { wMonth WORD }
    { wDayOfWeek WORD }
    { wDay WORD }
    { wHour WORD }
    { wMinute WORD }
    { wSecond WORD }
    { wMilliseconds WORD } ;

STRUCT: TIME_ZONE_INFORMATION
    { Bias LONG }
    { StandardName WCHAR[32] }
    { StandardDate SYSTEMTIME }
    { StandardBias LONG }
    { DaylightName WCHAR[32] }
    { DaylightDate SYSTEMTIME }
    { DaylightBias LONG } ;

STRUCT: FILETIME
    { dwLowDateTime DWORD }
    { dwHighDateTime DWORD } ;

STRUCT: STARTUPINFO
    { cb DWORD }
    { lpReserved LPTSTR }
    { lpDesktop LPTSTR }
    { lpTitle LPTSTR }
    { dwX DWORD }
    { dwY DWORD }
    { dwXSize DWORD }
    { dwYSize DWORD }
    { dwXCountChars DWORD }
    { dwYCountChars DWORD }
    { dwFillAttribute DWORD }
    { dwFlags DWORD }
    { wShowWindow WORD }
    { cbReserved2 WORD }
    { lpReserved2 LPBYTE }
    { hStdInput HANDLE }
    { hStdOutput HANDLE }
    { hStdError HANDLE } ;

TYPEDEF: void* LPSTARTUPINFO

STRUCT: PROCESS_INFORMATION
    { hProcess HANDLE }
    { hThread HANDLE }
    { dwProcessId DWORD }
    { dwThreadId DWORD } ;

STRUCT: SYSTEM_INFO
    { dwOemId DWORD }
    { dwPageSize DWORD }
    { lpMinimumApplicationAddress LPVOID }
    { lpMaximumApplicationAddress LPVOID }
    { dwActiveProcessorMask DWORD_PTR }
    { dwNumberOfProcessors DWORD }
    { dwProcessorType DWORD }
    { dwAllocationGranularity DWORD }
    { wProcessorLevel WORD }
    { wProcessorRevision WORD } ;

TYPEDEF: void* LPSYSTEM_INFO

STRUCT: MEMORYSTATUS
    { dwLength DWORD }
    { dwMemoryLoad DWORD }
    { dwTotalPhys SIZE_T }
    { dwAvailPhys SIZE_T }
    { dwTotalPageFile SIZE_T }
    { dwAvailPageFile SIZE_T }
    { dwTotalVirtual SIZE_T }
    { dwAvailVirtual SIZE_T } ;

TYPEDEF: void* LPMEMORYSTATUS

STRUCT: MEMORYSTATUSEX
    { dwLength DWORD }
    { dwMemoryLoad DWORD }
    { ullTotalPhys DWORDLONG }
    { ullAvailPhys DWORDLONG }
    { ullTotalPageFile DWORDLONG }
    { ullAvailPageFile DWORDLONG }
    { ullTotalVirtual DWORDLONG }
    { ullAvailVirtual DWORDLONG }
    { ullAvailExtendedVirtual DWORDLONG } ;

TYPEDEF: void* LPMEMORYSTATUSEX

STRUCT: OSVERSIONINFO
    { dwOSVersionInfoSize DWORD }
    { dwMajorVersion DWORD }
    { dwMinorVersion DWORD }
    { dwBuildNumber DWORD }
    { dwPlatformId DWORD }
    { szCSDVersion WCHAR[128] } ;

TYPEDEF: void* LPOSVERSIONINFO

STRUCT: MEMORY_BASIC_INFORMATION
  { BaseAddress void* }
  { AllocationBase void* }
  { AllocationProtect DWORD }
  { RegionSize SIZE_T }
  { state DWORD }
  { protect DWORD }
  { type DWORD } ;

STRUCT: GUID
    { Data1 ULONG }
    { Data2 WORD }
    { Data3 WORD }
    { Data4 UCHAR[8] } ;

/*
    fBinary  :1;
    fParity  :1;
    fOutxCtsFlow  :1;
    fOutxDsrFlow  :1;
    fDtrControl  :2;
    fDsrSensitivity  :1;
    fTXContinueOnXoff  :1;
    fOutX  :1;
    fInX  :1;
    fErrorChar  :1;
    fNull  :1;
    fRtsControl  :2;
    fAbortOnError  :1;
    fDummy2  :17;
*/

CONSTANT: SP_SERIALCOMM   0x1
CONSTANT: BAUD_075        0x1
CONSTANT: BAUD_110        0x2
CONSTANT: BAUD_134_5      0x4
CONSTANT: BAUD_150        0x8
CONSTANT: BAUD_300        0x10
CONSTANT: BAUD_600        0x20
CONSTANT: BAUD_1200       0x40
CONSTANT: BAUD_1800       0x80
CONSTANT: BAUD_2400       0x100
CONSTANT: BAUD_4800       0x200
CONSTANT: BAUD_7200       0x400
CONSTANT: BAUD_9600       0x800
CONSTANT: BAUD_14400      0x1000
CONSTANT: BAUD_19200      0x2000
CONSTANT: BAUD_38400      0x4000
CONSTANT: BAUD_56K        0x8000
CONSTANT: BAUD_57600      0x40000
CONSTANT: BAUD_115200     0x20000
CONSTANT: BAUD_128K       0x10000
CONSTANT: BAUD_USER       0x10000000
CONSTANT: PST_FAX     0x21
CONSTANT: PST_LAT     0x101
CONSTANT: PST_MODEM       0x6
CONSTANT: PST_NETWORK_BRIDGE  0x100
CONSTANT: PST_PARALLELPORT    0x2
CONSTANT: PST_RS232       0x1
CONSTANT: PST_RS422       0x3
CONSTANT: PST_RS423       0x4
CONSTANT: PST_RS449       0x5
CONSTANT: PST_SCANNER     0x22
CONSTANT: PST_TCPIP_TELNET    0x102
CONSTANT: PST_UNSPECIFIED 0
CONSTANT: PST_X25     0x103
CONSTANT: PCF_16BITMODE   0x200
CONSTANT: PCF_DTRDSR      0x1
CONSTANT: PCF_INTTIMEOUTS 0x80
CONSTANT: PCF_PARITY_CHECK    0x8
CONSTANT: PCF_RLSD        0x4
CONSTANT: PCF_RTSCTS      0x2
CONSTANT: PCF_SETXCHAR    0x20
CONSTANT: PCF_SPECIALCHARS    0x100
CONSTANT: PCF_TOTALTIMEOUTS   0x40
CONSTANT: PCF_XONXOFF     0x10
CONSTANT: SP_BAUD     0x2
CONSTANT: SP_DATABITS     0x4
CONSTANT: SP_HANDSHAKING  0x10
CONSTANT: SP_PARITY       0x1
CONSTANT: SP_PARITY_CHECK 0x20
CONSTANT: SP_RLSD     0x40
CONSTANT: SP_STOPBITS     0x8
CONSTANT: DATABITS_5      1
CONSTANT: DATABITS_6      2
CONSTANT: DATABITS_7      4
CONSTANT: DATABITS_8      8
CONSTANT: DATABITS_16     16
CONSTANT: DATABITS_16X    32
CONSTANT: STOPBITS_10     1
CONSTANT: STOPBITS_15     2
CONSTANT: STOPBITS_20     4
CONSTANT: PARITY_NONE     256
CONSTANT: PARITY_ODD      512
CONSTANT: PARITY_EVEN     1024
CONSTANT: PARITY_MARK     2048
CONSTANT: PARITY_SPACE    4096
CONSTANT: COMMPROP_INITIALIZED    0xe73cf52e

CONSTANT: CBR_110         110
CONSTANT: CBR_300         300
CONSTANT: CBR_600         600
CONSTANT: CBR_1200            1200
CONSTANT: CBR_2400            2400
CONSTANT: CBR_4800            4800
CONSTANT: CBR_9600            9600
CONSTANT: CBR_14400           14400
CONSTANT: CBR_19200           19200
CONSTANT: CBR_38400           38400
CONSTANT: CBR_56000           56000
CONSTANT: CBR_57600           57600
CONSTANT: CBR_115200          115200
CONSTANT: CBR_128000          128000
CONSTANT: CBR_256000          256000
CONSTANT: DTR_CONTROL_DISABLE     0
CONSTANT: DTR_CONTROL_ENABLE      1
CONSTANT: DTR_CONTROL_HANDSHAKE   2
CONSTANT: RTS_CONTROL_DISABLE     0
CONSTANT: RTS_CONTROL_ENABLE      1
CONSTANT: RTS_CONTROL_HANDSHAKE   2
CONSTANT: RTS_CONTROL_TOGGLE      3
CONSTANT: EVENPARITY          2
CONSTANT: MARKPARITY          3
CONSTANT: NOPARITY            0
CONSTANT: ODDPARITY           1
CONSTANT: SPACEPARITY         4
CONSTANT: ONESTOPBIT          0
CONSTANT: ONE5STOPBITS        1
CONSTANT: TWOSTOPBITS         2

! Flowcontrol bit mask in DCB
CONSTANT: FM_fBinary          0x1
CONSTANT: FM_fParity          0x2
CONSTANT: FM_fOutxCtsFlow     0x4
CONSTANT: FM_fOutxDsrFlow     0x8
CONSTANT: FM_fDtrControl      0x30
CONSTANT: FM_fDsrSensitivity      0x40
CONSTANT: FM_fTXContinueOnXoff    0x80
CONSTANT: FM_fOutX            0x100
CONSTANT: FM_fInX         0x200
CONSTANT: FM_fErrorChar       0x400
CONSTANT: FM_fNull            0x800
CONSTANT: FM_fRtsControl      0x3000
CONSTANT: FM_fAbortOnError        0x4000
CONSTANT: FM_fDummy2          0xffff8000

CONSTANT: BM_fCtsHold     0x1
CONSTANT: BM_fDsrHold     0x2
CONSTANT: BM_fRlsdHold    0x4
CONSTANT: BM_fXoffHold    0x8
CONSTANT: BM_fXoffSent    0x10
CONSTANT: BM_fEof     0x20
CONSTANT: BM_fTxim        0x40
CONSTANT: BM_AllBits      0x7f

! PurgeComm bit mask
CONSTANT: PURGE_TXABORT   0x1
CONSTANT: PURGE_RXABORT   0x2
CONSTANT: PURGE_TXCLEAR   0x4
CONSTANT: PURGE_RXCLEAR   0x8

! GetCommModemStatus bit mask
CONSTANT: MS_CTS_ON       0x10
CONSTANT: MS_DSR_ON       0x20
CONSTANT: MS_RING_ON      0x40
CONSTANT: MS_RLSD_ON      0x80

! EscapeCommFunction operations
CONSTANT: SETXOFF     0x1
CONSTANT: SETXON      0x2
CONSTANT: SETRTS      0x3
CONSTANT: CLRRTS      0x4
CONSTANT: SETDTR      0x5
CONSTANT: CLRDTR      0x6
CONSTANT: SETBREAK        0x8
CONSTANT: CLRBREAK        0x9

! ClearCommError bit mask
CONSTANT: CE_RXOVER       0x1
CONSTANT: CE_OVERRUN      0x2
CONSTANT: CE_RXPARITY     0x4
CONSTANT: CE_FRAME        0x8
CONSTANT: CE_BREAK        0x10
CONSTANT: CE_TXFULL       0x100
! LPT only
CONSTANT: CE_PTO        0x200
CONSTANT: CE_IOE        0x400
CONSTANT: CE_DNS        0x800
CONSTANT: CE_OOP        0x1000
! LPT only
CONSTANT: CE_MODE     0x8000

! GetCommMask bits
CONSTANT: EV_RXCHAR       0x1
CONSTANT: EV_RXFLAG       0x2
CONSTANT: EV_TXEMPTY      0x4
CONSTANT: EV_CTS      0x8
CONSTANT: EV_DSR      0x10
CONSTANT: EV_RLSD     0x20
CONSTANT: EV_BREAK        0x40
CONSTANT: EV_ERR      0x80
CONSTANT: EV_RING     0x100
CONSTANT: EV_PERR     0x200
CONSTANT: EV_RX80FULL     0x400
CONSTANT: EV_EVENT1       0x800
CONSTANT: EV_EVENT2       0x1000

STRUCT: DCB
    { DCBlength DWORD }
    { BaudRate DWORD }
    { flags DWORD }
    { wReserved WORD  }
    { XonLim WORD  }
    { XoffLim WORD  }
    { ByteSize BYTE  }
    { Parity BYTE  }
    { StopBits BYTE  }
    { XonChar char  }
    { XoffChar char  }
    { ErrorChar char  }
    { EofChar char  }
    { EvtChar char  }
    { wReserved1 WORD  } ;
TYPEDEF: DCB* PDCB
TYPEDEF: DCB* LPDCB

STRUCT: COMMCONFIG
    { dwSize DWORD }
    { wVersion WORD }
    { wReserved WORD }
    { dcb DCB }
    { dwProviderSubType DWORD }
    { dwProviderOffset DWORD }
    { dwProviderSize DWORD }
    { wcProviderData { WCHAR 1 } } ;
TYPEDEF: COMMCONFIG* LPCOMMCONFIG

STRUCT: COMMPROP
    { wPacketLength WORD }
    { wPacketVersion WORD }
    { dwServiceMask DWORD }
    { dwReserved1 DWORD }
    { dwMaxTxQueue DWORD }
    { dwMaxRxQueue DWORD }
    { dwMaxBaud DWORD }
    { dwProvSubType DWORD }
    { dwProvCapabilities DWORD }
    { dwSettableParams DWORD }
    { dwSettableBaud DWORD }
    { wSettableData WORD  }
    { wSettableStopParity WORD  }
    { dwCurrentTxQueue DWORD }
    { dwCurrentRxQueue DWORD }
    { dwProvSpec1 DWORD }
    { dwProvSpec2 DWORD }
    { wcProvChar { WCHAR 1 } } ;
TYPEDEF: COMMPROP* LPCOMMPROP


CONSTANT: SE_CREATE_TOKEN_NAME "SeCreateTokenPrivilege"
CONSTANT: SE_ASSIGNPRIMARYTOKEN_NAME "SeAssignPrimaryTokenPrivilege"
CONSTANT: SE_LOCK_MEMORY_NAME "SeLockMemoryPrivilege"
CONSTANT: SE_INCREASE_QUOTA_NAME "SeIncreaseQuotaPrivilege"
CONSTANT: SE_UNSOLICITED_INPUT_NAME "SeUnsolicitedInputPrivilege"
CONSTANT: SE_MACHINE_ACCOUNT_NAME "SeMachineAccountPrivilege"
CONSTANT: SE_TCB_NAME "SeTcbPrivilege"
CONSTANT: SE_SECURITY_NAME "SeSecurityPrivilege"
CONSTANT: SE_TAKE_OWNERSHIP_NAME "SeTakeOwnershipPrivilege"
CONSTANT: SE_LOAD_DRIVER_NAME "SeLoadDriverPrivilege"
CONSTANT: SE_SYSTEM_PROFILE_NAME "SeSystemProfilePrivilege"
CONSTANT: SE_SYSTEMTIME_NAME "SeSystemtimePrivilege"
CONSTANT: SE_PROF_SINGLE_PROCESS_NAME "SeProfileSingleProcessPrivilege"
CONSTANT: SE_INC_BASE_PRIORITY_NAME "SeIncreaseBasePriorityPrivilege"
CONSTANT: SE_CREATE_PAGEFILE_NAME "SeCreatePagefilePrivilege"
CONSTANT: SE_CREATE_PERMANENT_NAME "SeCreatePermanentPrivilege"
CONSTANT: SE_BACKUP_NAME "SeBackupPrivilege"
CONSTANT: SE_RESTORE_NAME "SeRestorePrivilege"
CONSTANT: SE_SHUTDOWN_NAME "SeShutdownPrivilege"
CONSTANT: SE_DEBUG_NAME "SeDebugPrivilege"
CONSTANT: SE_AUDIT_NAME "SeAuditPrivilege"
CONSTANT: SE_SYSTEM_ENVIRONMENT_NAME "SeSystemEnvironmentPrivilege"
CONSTANT: SE_CHANGE_NOTIFY_NAME "SeChangeNotifyPrivilege"
CONSTANT: SE_REMOTE_SHUTDOWN_NAME "SeRemoteShutdownPrivilege"
CONSTANT: SE_UNDOCK_NAME "SeUndockPrivilege"
CONSTANT: SE_ENABLE_DELEGATION_NAME "SeEnableDelegationPrivilege"
CONSTANT: SE_MANAGE_VOLUME_NAME "SeManageVolumePrivilege"
CONSTANT: SE_IMPERSONATE_NAME "SeImpersonatePrivilege"
CONSTANT: SE_CREATE_GLOBAL_NAME "SeCreateGlobalPrivilege"

CONSTANT: SE_GROUP_MANDATORY 0x00000001
CONSTANT: SE_GROUP_ENABLED_BY_DEFAULT 0x00000002
CONSTANT: SE_GROUP_ENABLED 0x00000004
CONSTANT: SE_GROUP_OWNER 0x00000008
CONSTANT: SE_GROUP_USE_FOR_DENY_ONLY 0x00000010
CONSTANT: SE_GROUP_LOGON_ID 0xC0000000
CONSTANT: SE_GROUP_RESOURCE 0x20000000

CONSTANT: SE_PRIVILEGE_ENABLED_BY_DEFAULT 0x00000001
CONSTANT: SE_PRIVILEGE_ENABLED 0x00000002
CONSTANT: SE_PRIVILEGE_REMOVE 0x00000004
CONSTANT: SE_PRIVILEGE_USED_FOR_ACCESS 0x80000000

CONSTANT: PRIVILEGE_SET_ALL_NECESSARY 1

CONSTANT: SE_OWNER_DEFAULTED 0x00000001
CONSTANT: SE_GROUP_DEFAULTED 0x00000002
CONSTANT: SE_DACL_PRESENT 0x00000004
CONSTANT: SE_DACL_DEFAULTED 0x00000008
CONSTANT: SE_SACL_PRESENT 0x00000010
CONSTANT: SE_SACL_DEFAULTED 0x00000020
CONSTANT: SE_DACL_AUTO_INHERIT_REQ 0x00000100
CONSTANT: SE_SACL_AUTO_INHERIT_REQ 0x00000200
CONSTANT: SE_DACL_AUTO_INHERITED 0x00000400
CONSTANT: SE_SACL_AUTO_INHERITED 0x00000800
CONSTANT: SE_DACL_PROTECTED  0x00001000
CONSTANT: SE_SACL_PROTECTED  0x00002000
CONSTANT: SE_SELF_RELATIVE 0x00008000

CONSTANT: ANYSIZE_ARRAY 1

CONSTANT: MAXIMUM_WAIT_OBJECTS 64
CONSTANT: MAXIMUM_SUSPEND_COUNT 0x7f
CONSTANT: WAIT_OBJECT_0 0
CONSTANT: WAIT_ABANDONED_0 128
CONSTANT: WAIT_TIMEOUT 258
CONSTANT: WAIT_IO_COMPLETION 0xc0
CONSTANT: WAIT_FAILED 0xffffffff

STRUCT: LUID
    { LowPart DWORD }
    { HighPart LONG } ;
TYPEDEF: LUID* PLUID

STRUCT: LUID_AND_ATTRIBUTES
    { Luid LUID }
    { Attributes DWORD } ;
TYPEDEF: LUID_AND_ATTRIBUTES* PLUID_AND_ATTRIBUTES

STRUCT: TOKEN_PRIVILEGES
    { PrivilegeCount DWORD }
    { Privileges LUID_AND_ATTRIBUTES* } ;
TYPEDEF: TOKEN_PRIVILEGES* PTOKEN_PRIVILEGES

STRUCT: WIN32_FILE_ATTRIBUTE_DATA
    { dwFileAttributes DWORD }
    { ftCreationTime FILETIME }
    { ftLastAccessTime FILETIME }
    { ftLastWriteTime FILETIME }
    { nFileSizeHigh DWORD }
    { nFileSizeLow DWORD } ;
TYPEDEF: WIN32_FILE_ATTRIBUTE_DATA* LPWIN32_FILE_ATTRIBUTE_DATA

STRUCT: BY_HANDLE_FILE_INFORMATION
  { dwFileAttributes DWORD }
  { ftCreationTime FILETIME }
  { ftLastAccessTime FILETIME }
  { ftLastWriteTime FILETIME }
  { dwVolumeSerialNumber DWORD }
  { nFileSizeHigh DWORD }
  { nFileSizeLow DWORD }
  { nNumberOfLinks DWORD }
  { nFileIndexHigh DWORD }
  { nFileIndexLow DWORD } ;
TYPEDEF: BY_HANDLE_FILE_INFORMATION* LPBY_HANDLE_FILE_INFORMATION

CONSTANT: OFS_MAXPATHNAME 128

STRUCT: OFSTRUCT
    { cBytes BYTE }
    { fFixedDisk BYTE }
    { nErrCode WORD }
    { Reserved1 WORD }
    { Reserved2 WORD }
    { szPathName { CHAR 128 } } ;
    ! { szPathName { CHAR OFS_MAXPATHNAME } } ;

TYPEDEF: OFSTRUCT* LPOFSTRUCT

STRUCT: WIN32_FIND_DATA
    { dwFileAttributes DWORD }
    { ftCreationTime FILETIME }
    { ftLastAccessTime FILETIME }
    { ftLastWriteTime FILETIME }
    { nFileSizeHigh DWORD }
    { nFileSizeLow DWORD }
    { dwReserved0 DWORD }
    { dwReserved1 DWORD }
    { cFileName { TCHAR MAX_PATH } }
    { cAlternateFileName TCHAR[14] } ;

TYPEDEF: WIN32_FIND_DATA* PWIN32_FIND_DATA
TYPEDEF: WIN32_FIND_DATA* LPWIN32_FIND_DATA
TYPEDEF: void* POVERLAPPED
TYPEDEF: void* LPOVERLAPPED
TYPEDEF: void* LPSECURITY_ATTRIBUTES
TYPEDEF: void* LPPROCESS_INFORMATION

TYPEDEF: SYSTEMTIME* PSYSTEMTIME
TYPEDEF: PSYSTEMTIME LPSYSTEMTIME

TYPEDEF: TIME_ZONE_INFORMATION* PTIME_ZONE_INFORMATION
TYPEDEF: PTIME_ZONE_INFORMATION LPTIME_ZONE_INFORMATION

TYPEDEF: FILETIME* PFILETIME
TYPEDEF: PFILETIME LPFILETIME

TYPEDEF: int GET_FILEEX_INFO_LEVELS

STRUCT: SECURITY_ATTRIBUTES
    { nLength DWORD }
    { lpSecurityDescriptor LPVOID }
    { bInheritHandle BOOL } ;

CONSTANT: HANDLE_FLAG_INHERIT 1
CONSTANT: HANDLE_FLAG_PROTECT_FROM_CLOSE 2

CONSTANT: STARTF_USESHOWWINDOW    0x00000001
CONSTANT: STARTF_USESIZE          0x00000002
CONSTANT: STARTF_USEPOSITION      0x00000004
CONSTANT: STARTF_USECOUNTCHARS    0x00000008
CONSTANT: STARTF_USEFILLATTRIBUTE 0x00000010
CONSTANT: STARTF_RUNFULLSCREEN    0x00000020
CONSTANT: STARTF_FORCEONFEEDBACK  0x00000040
CONSTANT: STARTF_FORCEOFFFEEDBACK 0x00000080
CONSTANT: STARTF_USESTDHANDLES    0x00000100
CONSTANT: STARTF_USEHOTKEY        0x00000200

CONSTANT: PIPE_ACCESS_INBOUND  1
CONSTANT: PIPE_ACCESS_OUTBOUND 2
CONSTANT: PIPE_ACCESS_DUPLEX   3

CONSTANT: PIPE_TYPE_BYTE    0
CONSTANT: PIPE_TYPE_MESSAGE 4

CONSTANT: PIPE_READMODE_BYTE    0
CONSTANT: PIPE_READMODE_MESSAGE 2

CONSTANT: PIPE_WAIT   0
CONSTANT: PIPE_NOWAIT 1

CONSTANT: PIPE_UNLIMITED_INSTANCES 255

CONSTANT: EXCEPTION_NONCONTINUABLE          0x1
CONSTANT: STATUS_GUARD_PAGE_VIOLATION       0x80000001
CONSTANT: STATUS_DATATYPE_MISALIGNMENT      0x80000002
CONSTANT: STATUS_BREAKPOINT                 0x80000003
CONSTANT: STATUS_SINGLE_STEP                0x80000004
CONSTANT: STATUS_ACCESS_VIOLATION           0xC0000005
CONSTANT: STATUS_IN_PAGE_ERROR              0xC0000006
CONSTANT: STATUS_INVALID_HANDLE             0xC0000008
CONSTANT: STATUS_NO_MEMORY                  0xC0000017
CONSTANT: STATUS_ILLEGAL_INSTRUCTION        0xC000001D
CONSTANT: STATUS_NONCONTINUABLE_EXCEPTION   0xC0000025
CONSTANT: STATUS_INVALID_DISPOSITION        0xC0000026
CONSTANT: STATUS_ARRAY_BOUNDS_EXCEEDED      0xC000008C
CONSTANT: STATUS_FLOAT_DENORMAL_OPERAND     0xC000008D
CONSTANT: STATUS_FLOAT_DIVIDE_BY_ZERO       0xC000008E
CONSTANT: STATUS_FLOAT_INEXACT_RESULT       0xC000008F
CONSTANT: STATUS_FLOAT_INVALID_OPERATION    0xC0000090
CONSTANT: STATUS_FLOAT_OVERFLOW             0xC0000091
CONSTANT: STATUS_FLOAT_STACK_CHECK          0xC0000092
CONSTANT: STATUS_FLOAT_UNDERFLOW            0xC0000093
CONSTANT: STATUS_INTEGER_DIVIDE_BY_ZERO     0xC0000094
CONSTANT: STATUS_INTEGER_OVERFLOW           0xC0000095
CONSTANT: STATUS_PRIVILEGED_INSTRUCTION     0xC0000096
CONSTANT: STATUS_STACK_OVERFLOW             0xC00000FD
CONSTANT: STATUS_CONTROL_C_EXIT             0xC000013A
CONSTANT: STATUS_FLOAT_MULTIPLE_FAULTS      0xC00002B4
CONSTANT: STATUS_FLOAT_MULTIPLE_TRAPS       0xC00002B5

STRUCT: COORD
{ X SHORT }
{ Y SHORT } ;

STRUCT: SMALL_RECT
{ Left SHORT }
{ Top SHORT }
{ Right SHORT }
{ Bottom SHORT } ;

STRUCT: CONSOLE_SCREEN_BUFFER_INFO
{ dwSize COORD }
{ dwCursorPosition COORD }
{ wAttributes WORD }
{ srWindow SMALL_RECT }
{ dwMaximumWindowSize COORD } ;

STRUCT: PROCESSENTRY32
    { dwSize DWORD }
    { cntUsage DWORD }
    { th32ProcessID DWORD }
    { th32DefaultHeapID ULONG_PTR }
    { th32ModuleID DWORD }
    { cntThreads DWORD }
    { th32ParentProcessID DWORD }
    { pcPriClassBase LONG }
    { dwFlags DWORD }
    { szExeFile TCHAR[MAX_PATH] } ;

TYPEDEF: PROCESSENTRY32* PPROCESSENTRY32
TYPEDEF: PROCESSENTRY32* LPPROCESSENTRY32

! Resource IDs
: MAKEINTRESOURCE ( int -- resource ) 0xffff bitand <alien> ; inline

: RT_CURSOR       ( -- id )  1 MAKEINTRESOURCE ; inline
: RT_BITMAP       ( -- id )  2 MAKEINTRESOURCE ; inline
: RT_ICON         ( -- id )  3 MAKEINTRESOURCE ; inline
: RT_MENU         ( -- id )  4 MAKEINTRESOURCE ; inline
: RT_DIALOG       ( -- id )  5 MAKEINTRESOURCE ; inline
: RT_STRING       ( -- id )  6 MAKEINTRESOURCE ; inline
: RT_FONTDIR      ( -- id )  7 MAKEINTRESOURCE ; inline
: RT_FONT         ( -- id )  8 MAKEINTRESOURCE ; inline
: RT_ACCELERATOR  ( -- id )  9 MAKEINTRESOURCE ; inline
: RT_RCDATA       ( -- id ) 10 MAKEINTRESOURCE ; inline
: RT_MESSAGETABLE ( -- id ) 11 MAKEINTRESOURCE ; inline
: RT_GROUP_CURSOR ( -- id ) 12 MAKEINTRESOURCE ; inline
: RT_GROUP_ICON   ( -- id ) 14 MAKEINTRESOURCE ; inline
: RT_VERSION      ( -- id ) 16 MAKEINTRESOURCE ; inline
: RT_DLGINCLUDE   ( -- id ) 17 MAKEINTRESOURCE ; inline
: RT_PLUGPLAY     ( -- id ) 19 MAKEINTRESOURCE ; inline
: RT_VXD          ( -- id ) 20 MAKEINTRESOURCE ; inline
: RT_ANICURSOR    ( -- id ) 21 MAKEINTRESOURCE ; inline
: RT_ANIICON      ( -- id ) 22 MAKEINTRESOURCE ; inline
: RT_MANIFEST     ( -- id ) 24 MAKEINTRESOURCE ; inline

LIBRARY: kernel32
! FUNCTION: _hread
! FUNCTION: _hwrite
! FUNCTION: _lclose
! FUNCTION: _lcreat
! FUNCTION: _llseek
! FUNCTION: _lopen
! FUNCTION: _lread
! FUNCTION: _lwrite
! FUNCTION: ActivateActCtx
! FUNCTION: AddAtomA
! FUNCTION: AddAtomW
! FUNCTION: AddConsoleAliasA
! FUNCTION: AddConsoleAliasW
! FUNCTION: AddLocalAlternateComputerNameA
! FUNCTION: AddLocalAlternateComputerNameW
! FUNCTION: AddRefActCtx
! FUNCTION: AddVectoredExceptionHandler
! FUNCTION: AllocateUserPhysicalPages
FUNCTION: BOOL AllocConsole ( ) ;
! FUNCTION: AreFileApisANSI
! FUNCTION: AssignProcessToJobObject
! FUNCTION: AttachConsole
! FUNCTION: BackupRead
! FUNCTION: BackupSeek
! FUNCTION: BackupWrite
! FUNCTION: BaseCheckAppcompatCache
! FUNCTION: BaseCleanupAppcompatCache
! FUNCTION: BaseCleanupAppcompatCacheSupport
! FUNCTION: BaseDumpAppcompatCache
! FUNCTION: BaseFlushAppcompatCache
! FUNCTION: BaseInitAppcompatCache
! FUNCTION: BaseInitAppcompatCacheSupport
! FUNCTION: BasepCheckWinSaferRestrictions
! FUNCTION: BaseProcessInitPostImport
! FUNCTION: BaseQueryModuleData
! FUNCTION: BaseUpdateAppcompatCache
! FUNCTION: Beep
! FUNCTION: BeginUpdateResourceA
FUNCTION: HANDLE BeginUpdateResourceW ( LPCTSTR pFileName, BOOL bDeleteExistingResources ) ;
ALIAS: BeginUpdateResource BeginUpdateResourceW
! FUNCTION: BindIoCompletionCallback
! FUNCTION: BuildCommDCBA
! FUNCTION: BuildCommDCBAndTimeoutsA
! FUNCTION: BuildCommDCBAndTimeoutsW
! FUNCTION: BuildCommDCBW
! FUNCTION: CallNamedPipeA
! FUNCTION: CallNamedPipeW
! FUNCTION: CancelDeviceWakeupRequest
FUNCTION: BOOL CancelIo ( HANDLE h ) ;
! FUNCTION: CancelTimerQueueTimer
! FUNCTION: CancelWaitableTimer
! FUNCTION: ChangeTimerQueueTimer
! FUNCTION: CheckNameLegalDOS8Dot3A
! FUNCTION: CheckNameLegalDOS8Dot3W
! FUNCTION: CheckRemoteDebuggerPresent
! FUNCTION: ClearCommBreak
! FUNCTION: ClearCommError
! FUNCTION: CloseConsoleHandle
FUNCTION: BOOL CloseHandle ( HANDLE h ) ;
! FUNCTION: CloseProfileUserMapping
! FUNCTION: CmdBatNotification
! FUNCTION: CommConfigDialogA
! FUNCTION: CommConfigDialogW
! FUNCTION: CompareFileTime
! FUNCTION: CompareStringA
! FUNCTION: CompareStringW
FUNCTION: BOOL ConnectNamedPipe ( HANDLE hNamedPipe, LPOVERLAPPED lpOverlapped ) ;
! FUNCTION: ConsoleMenuControl
! FUNCTION: ContinueDebugEvent
! FUNCTION: ConvertDefaultLocale
! FUNCTION: ConvertFiberToThread
! FUNCTION: ConvertThreadToFiber
! FUNCTION: CopyFileA
! FUNCTION: CopyFileExA
! FUNCTION: CopyFileExW
FUNCTION: BOOL CopyFileW ( LPCTSTR lpExistingFileName, LPCTSTR lpNewFileName, BOOL bFailIfExists ) ;
ALIAS: CopyFile CopyFileW
! FUNCTION: CopyLZFile
! FUNCTION: CreateActCtxA
! FUNCTION: CreateActCtxW
! FUNCTION: CreateConsoleScreenBuffer
! FUNCTION: CreateDirectoryA
! FUNCTION: CreateDirectoryExA
! FUNCTION: CreateDirectoryExW
FUNCTION: BOOL CreateDirectoryW ( LPCTSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttribytes ) ;
ALIAS: CreateDirectory CreateDirectoryW

! FUNCTION: CreateEventA
! FUNCTION: CreateEventW
! FUNCTION: CreateFiber
! FUNCTION: CreateFiberEx


FUNCTION: HANDLE CreateFileW ( LPCTSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttribures, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile ) ;
ALIAS: CreateFile CreateFileW

FUNCTION: HANDLE  CreateFileMappingW ( HANDLE hFile,
                                       LPSECURITY_ATTRIBUTES lpAttributes,
                                       DWORD flProtect,
                                       DWORD dwMaximumSizeHigh,
                                       DWORD dwMaximumSizeLow,
                                       LPCTSTR lpName ) ;
ALIAS: CreateFileMapping CreateFileMappingW

! FUNCTION: CreateHardLinkA
! FUNCTION: CreateHardLinkW
! FUNCTION: HANDLE CreateIoCompletionPort ( HANDLE hFileHandle, HANDLE hExistingCompletionPort, ULONG_PTR uCompletionKey, DWORD dwNumberofConcurrentThreads ) ;
FUNCTION: HANDLE CreateIoCompletionPort ( HANDLE hFileHandle, HANDLE hExistingCompletionPort, void* uCompletionKey, DWORD dwNumberofConcurrentThreads ) ;
! FUNCTION: CreateJobObjectA
! FUNCTION: CreateJobObjectW
! FUNCTION: CreateJobSet
! FUNCTION: CreateMailslotA
! FUNCTION: CreateMailslotW
! FUNCTION: CreateMemoryResourceNotification
! FUNCTION: CreateMutexA
! FUNCTION: CreateMutexW
! FUNCTION: CreateNamedPipeA
FUNCTION: HANDLE CreateNamedPipeW ( LPCTSTR lpName, DWORD dwOpenMode, DWORD dwPipeMode, DWORD nMaxInstances, DWORD nOutBufferSize, DWORD nInBufferSize, DWORD nDefaultTimeOut, LPSECURITY_ATTRIBUTES lpSecurityAttributes ) ;
ALIAS: CreateNamedPipe CreateNamedPipeW

! FUNCTION: CreateNlsSecurityDescriptor
FUNCTION: BOOL CreatePipe ( PHANDLE hReadPipe, PHANDLE hWritePipe, LPSECURITY_ATTRIBUTES lpPipeAttributes, DWORD nSize ) ;

CONSTANT: DEBUG_PROCESS                   0x00000001
CONSTANT: DEBUG_ONLY_THIS_PROCESS         0x00000002
CONSTANT: CREATE_SUSPENDED                0x00000004
CONSTANT: DETACHED_PROCESS                0x00000008
CONSTANT: CREATE_NEW_CONSOLE              0x00000010
CONSTANT: NORMAL_PRIORITY_CLASS           0x00000020
CONSTANT: IDLE_PRIORITY_CLASS             0x00000040
CONSTANT: HIGH_PRIORITY_CLASS             0x00000080
CONSTANT: REALTIME_PRIORITY_CLASS         0x00000100
CONSTANT: CREATE_NEW_PROCESS_GROUP        0x00000200
CONSTANT: CREATE_UNICODE_ENVIRONMENT      0x00000400
CONSTANT: CREATE_SEPARATE_WOW_VDM         0x00000800
CONSTANT: CREATE_SHARED_WOW_VDM           0x00001000
CONSTANT: CREATE_FORCEDOS                 0x00002000
CONSTANT: BELOW_NORMAL_PRIORITY_CLASS     0x00004000
CONSTANT: ABOVE_NORMAL_PRIORITY_CLASS     0x00008000
CONSTANT: CREATE_BREAKAWAY_FROM_JOB       0x01000000
CONSTANT: CREATE_WITH_USERPROFILE         0x02000000
CONSTANT: CREATE_DEFAULT_ERROR_MODE       0x04000000
CONSTANT: CREATE_NO_WINDOW                0x08000000
CONSTANT: PROFILE_USER                    0x10000000
CONSTANT: PROFILE_KERNEL                  0x20000000
CONSTANT: PROFILE_SERVER                  0x40000000

FUNCTION: BOOL CreateProcessW ( LPCTSTR lpApplicationname,
                                LPTSTR lpCommandLine,
                                LPSECURITY_ATTRIBUTES lpProcessAttributes,
                                LPSECURITY_ATTRIBUTES lpThreadAttributes,
                                BOOL bInheritHandles,
                                DWORD dwCreationFlags,
                                LPVOID lpEnvironment,
                                LPCTSTR lpCurrentDirectory,
                                LPSTARTUPINFO lpStartupInfo,
                                LPPROCESS_INFORMATION lpProcessInformation ) ;
ALIAS: CreateProcess CreateProcessW
! FUNCTION: CreateProcessInternalA
! FUNCTION: CreateProcessInternalW
! FUNCTION: CreateProcessInternalWSecure
FUNCTION: HANDLE CreateRemoteThread ( HANDLE hProcess,
                                      LPSECURITY_ATTRIBUTES lpThreadAttributes,
                                      SIZE_T dwStackSize,
                                      LPVOID lpStartAddress,
                                      LPVOID lpParameter,
                                      DWORD dwCreationFlags,
                                      LPDWORD lpThreadId ) ; 
! FUNCTION: CreateSemaphoreA
! FUNCTION: CreateSemaphoreW
! FUNCTION: CreateSocketHandle
! FUNCTION: CreateTapePartition
! FUNCTION: CreateThread
! FUNCTION: CreateTimerQueue
! FUNCTION: CreateTimerQueueTimer

CONSTANT: TH32CS_INHERIT 0x80000000
CONSTANT: TH32CS_SNAPHEAPLIST 1
CONSTANT: TH32CS_SNAPMODULE 8
CONSTANT: TH32CS_SNAPMODULE32 0x10
CONSTANT: TH32CS_SNAPPROCESS 2
CONSTANT: TH32CS_SNAPTHREAD 4
CONSTANT: TH32CS_SNAPALL flags{ TH32CS_SNAPHEAPLIST TH32CS_SNAPMODULE TH32CS_SNAPPROCESS TH32CS_SNAPTHREAD }

FUNCTION: HANDLE CreateToolhelp32Snapshot ( DWORD dwFlags, DWORD th32ProcessID ) ;
! FUNCTION: CreateVirtualBuffer
! FUNCTION: CreateWaitableTimerA
! FUNCTION: CreateWaitableTimerW
! FUNCTION: DeactivateActCtx
! FUNCTION: DebugActiveProcess
! FUNCTION: DebugActiveProcessStop
! FUNCTION: DebugBreak
! FUNCTION: DebugBreakProcess
! FUNCTION: DebugSetProcessKillOnExit
! FUNCTION: DecodePointer
! FUNCTION: DecodeSystemPointer
! FUNCTION: DefineDosDeviceA
! FUNCTION: DefineDosDeviceW
! FUNCTION: DelayLoadFailureHook
! FUNCTION: DeleteAtom
! FUNCTION: DeleteCriticalSection
! FUNCTION: DeleteFiber
! FUNCTION: DeleteFileA
FUNCTION: BOOL DeleteFileW ( LPCTSTR lpFileName ) ;
ALIAS: DeleteFile DeleteFileW
! FUNCTION: DeleteTimerQueue
! FUNCTION: DeleteTimerQueueEx
! FUNCTION: DeleteTimerQueueTimer
! FUNCTION: DeleteVolumeMountPointA
! FUNCTION: DeleteVolumeMountPointW
! FUNCTION: DeviceIoControl
! FUNCTION: DisableThreadLibraryCalls
! FUNCTION: DisconnectNamedPipe
! FUNCTION: DnsHostnameToComputerNameA
! FUNCTION: DnsHostnameToComputerNameW
! FUNCTION: DosDateTimeToFileTime
! FUNCTION: DosPathToSessionPathA
! FUNCTION: DosPathToSessionPathW
! FUNCTION: DuplicateConsoleHandle

FUNCTION: BOOL DuplicateHandle (
    HANDLE hSourceProcessHandle,
    HANDLE hSourceHandle,
    HANDLE hTargetProcessHandle,
    LPHANDLE lpTargetHandle,
    DWORD dwDesiredAccess,
    BOOL bInheritHandle,
    DWORD dwOptions ) ;

CONSTANT: DUPLICATE_CLOSE_SOURCE 1
CONSTANT: DUPLICATE_SAME_ACCESS 2

! FUNCTION: EncodePointer
! FUNCTION: EncodeSystemPointer
! FUNCTION: EndUpdateResourceA
FUNCTION: BOOL EndUpdateResourceW ( HANDLE hUpdate, BOOL fDiscard ) ;
ALIAS: EndUpdateResource EndUpdateResourceW
! FUNCTION: EnterCriticalSection
! FUNCTION: EnumCalendarInfoA
! FUNCTION: EnumCalendarInfoExA
! FUNCTION: EnumCalendarInfoExW
! FUNCTION: EnumCalendarInfoW
! FUNCTION: EnumDateFormatsA
! FUNCTION: EnumDateFormatsExA
! FUNCTION: EnumDateFormatsExW
! FUNCTION: EnumDateFormatsW
! FUNCTION: EnumerateLocalComputerNamesA
! FUNCTION: EnumerateLocalComputerNamesW
! FUNCTION: EnumLanguageGroupLocalesA
! FUNCTION: EnumLanguageGroupLocalesW
! FUNCTION: EnumResourceLanguagesA
! FUNCTION: EnumResourceLanguagesW
! FUNCTION: EnumResourceNamesA
! FUNCTION: EnumResourceNamesW
! FUNCTION: EnumResourceTypesA
! FUNCTION: EnumResourceTypesW
! FUNCTION: EnumSystemCodePagesA
! FUNCTION: EnumSystemCodePagesW
! FUNCTION: EnumSystemGeoID
! FUNCTION: EnumSystemLanguageGroupsA
! FUNCTION: EnumSystemLanguageGroupsW
! FUNCTION: EnumSystemLocalesA
! FUNCTION: EnumSystemLocalesW
! FUNCTION: EnumTimeFormatsA
! FUNCTION: EnumTimeFormatsW
! FUNCTION: EnumUILanguagesA
! FUNCTION: EnumUILanguagesW
! FUNCTION: EraseTape
! FUNCTION: EscapeCommFunction
! FUNCTION: ExitProcess
! FUNCTION: ExitThread
! FUNCTION: ExitVDM
! FUNCTION: ExpandEnvironmentStringsA
! FUNCTION: ExpandEnvironmentStringsW
! FUNCTION: ExpungeConsoleCommandHistoryA
! FUNCTION: ExpungeConsoleCommandHistoryW
! FUNCTION: ExtendVirtualBuffer
! FUNCTION: FatalAppExitA
! FUNCTION: FatalAppExitW
! FUNCTION: FatalExit
! FUNCTION: FileTimeToDosDateTime
! FUNCTION: FileTimeToLocalFileTime
! FUNCTION: FileTimeToSystemTime
! FUNCTION: FillConsoleOutputAttribute
! FUNCTION: FillConsoleOutputCharacterA
! FUNCTION: FillConsoleOutputCharacterW
! FUNCTION: FindActCtxSectionGuid
! FUNCTION: FindActCtxSectionStringA
! FUNCTION: FindActCtxSectionStringW
! FUNCTION: FindAtomA
! FUNCTION: FindAtomW
FUNCTION: BOOL FindClose ( HANDLE hFindFile ) ;
FUNCTION: BOOL FindCloseChangeNotification ( HANDLE hChangeHandle ) ;
FUNCTION: HANDLE FindFirstChangeNotificationW ( LPCTSTR lpPathName,
                                        BOOL bWatchSubtree,
                                        DWORD dwNotifyFilter ) ;
ALIAS: FindFirstChangeNotification FindFirstChangeNotificationW
! FUNCTION: FindFirstFileA
! FUNCTION: FindFirstFileExA
! FUNCTION: FindFirstFileExW
FUNCTION: HANDLE FindFirstFileW ( LPCTSTR lpFileName, LPWIN32_FIND_DATA lpFindFileData ) ;
ALIAS: FindFirstFile FindFirstFileW
! FUNCTION: FindFirstVolumeA
! FUNCTION: FindFirstVolumeMountPointA

FUNCTION: HANDLE FindFirstVolumeMountPointW (
    LPTSTR lpszRootPathName,
    LPTSTR lpszVolumeMountPoint,
    DWORD cchBufferLength
) ;
ALIAS: FindFirstVolumeMountPoint FindFirstVolumeMountPointW

FUNCTION: HANDLE FindFirstVolumeW ( LPTSTR lpszVolumeName, DWORD cchBufferLength ) ;
ALIAS: FindFirstVolume FindFirstVolumeW

FUNCTION: BOOL FindNextChangeNotification ( HANDLE hChangeHandle ) ;

! FUNCTION: FindNextFileA
FUNCTION: BOOL FindNextFileW ( HANDLE hFindFile, LPWIN32_FIND_DATA lpFindFileData ) ;
ALIAS: FindNextFile FindNextFileW

! FUNCTION: FindNextVolumeA
! FUNCTION: FindNextVolumeMountPointA

FUNCTION: BOOL FindNextVolumeMountPointW (
    HANDLE hFindVolumeMountPoint,
    LPTSTR lpszVolumeMountPoint,
    DWORD cchBufferLength
) ;
ALIAS: FindNextVolumeMountPoint FindNextVolumeMountPointW

FUNCTION: BOOL FindNextVolumeW ( HANDLE hFindVolume, LPTSTR lpszVolumeName, DWORD cchBufferLength ) ;
ALIAS: FindNextVolume FindNextVolumeW

! FUNCTION: FindResourceA
! FUNCTION: FindResourceExA
! FUNCTION: FindResourceExW
! FUNCTION: FindResourceW
FUNCTION: BOOL FindVolumeClose ( HANDLE hFindVolume ) ;
FUNCTION: BOOL FindVolumeMountPointClose ( HANDLE hFindVolumeMountPoint ) ;
! FUNCTION: FlushConsoleInputBuffer
! FUNCTION: FlushFileBuffers
! FUNCTION: FlushInstructionCache
! FUNCTION: FlushViewOfFile
! FUNCTION: FoldStringA
! FUNCTION: FoldStringW
! FUNCTION: FormatMessageA
FUNCTION: DWORD FormatMessageW (
        DWORD dwFlags,
        LPCVOID lpSource,
        DWORD dwMessageId,
        DWORD dwLanguageId,
        LPTSTR lpBuffer,
        DWORD nSize,
        void* Arguments
    ) ;

ALIAS: FormatMessage FormatMessageW


FUNCTION: BOOL FreeConsole ( ) ;
! FUNCTION: FreeEnvironmentStringsA
FUNCTION: BOOL FreeEnvironmentStringsW ( LPTCH lpszEnvironmentBlock ) ;
ALIAS: FreeEnvironmentStrings FreeEnvironmentStringsW
FUNCTION: BOOL FreeLibrary ( HMODULE hModule ) ;
! FUNCTION: FreeLibraryAndExitThread
! FUNCTION: FreeResource
! FUNCTION: FreeUserPhysicalPages
! FUNCTION: FreeVirtualBuffer
! FUNCTION: GenerateConsoleCtrlEvent
! FUNCTION: GetACP
! FUNCTION: GetAtomNameA
! FUNCTION: GetAtomNameW
! FUNCTION: GetBinaryType
! FUNCTION: GetBinaryTypeA
! FUNCTION: GetBinaryTypeW
! FUNCTION: GetCalendarInfoA
! FUNCTION: GetCalendarInfoW
! FUNCTION: GetCommandLineA
! FUNCTION: GetCommandLineW
FUNCTION: BOOL GetCommConfig ( HANDLE hCommDev, LPCOMMCONFIG lpCC, LPDWORD lpdwSize ) ;
FUNCTION: BOOL GetCommMask ( HANDLE hFile, LPDWORD lpEvtMask ) ;
FUNCTION: BOOL GetCommModemStatus ( HANDLE hFile, LPDWORD lpModemStat ) ;
FUNCTION: BOOL GetCommProperties ( HANDLE hFile, LPCOMMPROP lpCommProp ) ;
FUNCTION: BOOL GetCommState ( HANDLE hFile, LPDCB lpDCB ) ;
! FUNCTION: GetCommTimeouts
! FUNCTION: GetComPlusPackageInstallStatus
! FUNCTION: GetCompressedFileSizeA
FUNCTION: DWORD GetCompressedFileSizeW ( LPCTSTR lpFileName, LPDWORD lpFileSizeHigh ) ;
ALIAS: GetCompressedFileSize GetCompressedFileSizeW
FUNCTION: BOOL GetComputerNameW ( LPTSTR lpBuffer, LPDWORD lpnSize ) ;
ALIAS: GetComputerName GetComputerNameW
FUNCTION: BOOL GetComputerNameExW ( COMPUTER_NAME_FORMAT NameType, LPTSTR lpBuffer, LPDWORD lpnSize ) ;
ALIAS: GetComputerNameEx GetComputerNameExW
! FUNCTION: GetConsoleAliasA
! FUNCTION: GetConsoleAliasesA
! FUNCTION: GetConsoleAliasesLengthA
! FUNCTION: GetConsoleAliasesLengthW
! FUNCTION: GetConsoleAliasesW
! FUNCTION: GetConsoleAliasExesA
! FUNCTION: GetConsoleAliasExesLengthA
! FUNCTION: GetConsoleAliasExesLengthW
! FUNCTION: GetConsoleAliasExesW
! FUNCTION: GetConsoleAliasW
! FUNCTION: GetConsoleCharType
! FUNCTION: GetConsoleCommandHistoryA
! FUNCTION: GetConsoleCommandHistoryLengthA
! FUNCTION: GetConsoleCommandHistoryLengthW
! FUNCTION: GetConsoleCommandHistoryW
! FUNCTION: GetConsoleCP
! FUNCTION: GetConsoleCursorInfo
! FUNCTION: GetConsoleCursorMode
! FUNCTION: GetConsoleDisplayMode
! FUNCTION: GetConsoleFontInfo
! FUNCTION: GetConsoleFontSize
! FUNCTION: GetConsoleHardwareState
! FUNCTION: GetConsoleInputExeNameA
! FUNCTION: GetConsoleInputExeNameW
! FUNCTION: GetConsoleInputWaitHandle
! FUNCTION: GetConsoleKeyboardLayoutNameA
! FUNCTION: GetConsoleKeyboardLayoutNameW
! FUNCTION: GetConsoleMode
! FUNCTION: GetConsoleNlsMode
! FUNCTION: GetConsoleOutputCP
! FUNCTION: GetConsoleProcessList
FUNCTION: BOOL GetConsoleScreenBufferInfo ( HANDLE hConsoleOutput, CONSOLE_SCREEN_BUFFER_INFO* lpConsoleScreenBufferInfo ) ;
! FUNCTION: GetConsoleSelectionInfo
FUNCTION: DWORD GetConsoleTitleW ( LPWSTR lpConsoleTitle, DWORD nSize ) ;
ALIAS: GetConsoleTitle GetConsoleTitleW
FUNCTION: HWND GetConsoleWindow ( ) ;
! FUNCTION: GetCPFileNameFromRegistry
! FUNCTION: GetCPInfo
! FUNCTION: GetCPInfoExA
! FUNCTION: GetCPInfoExW
! FUNCTION: GetCurrencyFormatA
! FUNCTION: GetCurrencyFormatW
! FUNCTION: GetCurrentActCtx
! FUNCTION: GetCurrentConsoleFont
! FUNCTION: GetCurrentDirectoryA
FUNCTION: BOOL GetCurrentDirectoryW ( DWORD len, LPTSTR buf ) ;
ALIAS: GetCurrentDirectory GetCurrentDirectoryW
FUNCTION: HANDLE GetCurrentProcess ( ) ;
FUNCTION: DWORD GetCurrentProcessId ( ) ;
FUNCTION: HANDLE GetCurrentThread ( ) ;
! FUNCTION: GetCurrentThreadId
! FUNCTION: GetDateFormatA
! FUNCTION: GetDateFormatW
! FUNCTION: GetDefaultCommConfigA
FUNCTION: BOOL GetDefaultCommConfigW ( LPCTSTR lpszName, LPCOMMCONFIG lpCC, LPDWORD lpdwSize ) ;
ALIAS: GetDefaultCommConfig GetDefaultCommConfigW
! FUNCTION: GetDefaultSortkeySize
! FUNCTION: GetDevicePowerState
! FUNCTION: GetDiskFreeSpaceA
! FUNCTION: GetDiskFreeSpaceExA
FUNCTION: BOOL GetDiskFreeSpaceExW ( LPCTSTR lpDirectoryName, PULARGE_INTEGER pFreeBytesAvailable, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes ) ;
ALIAS: GetDiskFreeSpaceEx GetDiskFreeSpaceExW
! FUNCTION: GetDiskFreeSpaceW
! FUNCTION: GetDllDirectoryA
! FUNCTION: GetDllDirectoryW
! FUNCTION: GetDriveTypeA
FUNCTION: UINT GetDriveTypeW ( LPCTSTR lpRootPathName ) ;
ALIAS: GetDriveType GetDriveTypeW
FUNCTION: void* GetEnvironmentStringsW ( ) ;
! FUNCTION: GetEnvironmentStringsA
ALIAS: GetEnvironmentStrings GetEnvironmentStringsW
! FUNCTION: GetEnvironmentVariableA
FUNCTION: DWORD GetEnvironmentVariableW ( LPCTSTR lpName, LPTSTR lpBuffer, DWORD nSize ) ;
ALIAS: GetEnvironmentVariable GetEnvironmentVariableW
FUNCTION: BOOL GetExitCodeProcess ( HANDLE hProcess, LPDWORD lpExitCode ) ;
! FUNCTION: GetExitCodeThread
! FUNCTION: GetExpandedNameA
! FUNCTION: GetExpandedNameW
! FUNCTION: GetFileAttributesA
FUNCTION: DWORD GetFileAttributesW ( LPCTSTR lpFileName ) ;
! FUNCTION: GetFileAttributesExA

CONSTANT: GetFileExInfoStandard 0


FUNCTION: BOOL GetFileAttributesExW ( LPCTSTR lpFileName, GET_FILEEX_INFO_LEVELS fInfoLevelId, LPVOID lpFileInformation ) ;

ALIAS: GetFileAttributesEx GetFileAttributesExW

FUNCTION: BOOL GetFileInformationByHandle ( HANDLE hFile, LPBY_HANDLE_FILE_INFORMATION lpFileInformation ) ;
FUNCTION: DWORD GetFileSize ( HANDLE hFile, LPDWORD lpFileSizeHigh ) ;
FUNCTION: BOOL GetFileSizeEx ( HANDLE hFile, PLARGE_INTEGER lpFileSize ) ;
FUNCTION: BOOL GetFileTime ( HANDLE hFile, LPFILETIME lpCreationTime, LPFILETIME lpLastAccessTime, LPFILETIME lpLastWriteTime ) ;
FUNCTION: DWORD GetFileType ( HANDLE hFile ) ;
! FUNCTION: GetFirmwareEnvironmentVariableA
! FUNCTION: GetFirmwareEnvironmentVariableW
! FUNCTION: GetFullPathNameA
FUNCTION: DWORD GetFullPathNameW ( LPCTSTR lpFileName, DWORD nBufferLength, LPTSTR lpBuffer, LPTSTR* lpFilePart ) ;
ALIAS: GetFullPathName GetFullPathNameW

! FUNCTION: GetGeoInfoA
! FUNCTION: GetGeoInfoW
! FUNCTION: GetHandleContext
FUNCTION: BOOL GetHandleInformation ( HANDLE hObject, LPDWORD lpdwFlags ) ;
! FUNCTION: GetLargestConsoleWindowSize
FUNCTION: DWORD GetLastError ( ) ;
! FUNCTION: GetLinguistLangSize
! FUNCTION: GetLocaleInfoA
! FUNCTION: GetLocaleInfoW
! FUNCTION: GetLocalTime
FUNCTION: DWORD GetLogicalDrives ( ) ;
! FUNCTION: GetLogicalDriveStringsA
! FUNCTION: GetLogicalDriveStringsW
! FUNCTION: GetLongPathNameA
! FUNCTION: GetLongPathNameW
! FUNCTION: GetMailslotInfo
! FUNCTION: GetModuleFileNameA
FUNCTION: DWORD GetModuleFileNameW ( HMODULE hModule, LPTSTR lpFilename, DWORD nSize ) ;
ALIAS: GetModuleFileName GetModuleFileNameW
FUNCTION: HMODULE GetModuleHandleW ( LPCWSTR lpModuleName ) ;
ALIAS: GetModuleHandle GetModuleHandleW
! FUNCTION: GetModuleHandleExA
! FUNCTION: GetModuleHandleExW
! FUNCTION: GetNamedPipeHandleStateA
! FUNCTION: GetNamedPipeHandleStateW
! FUNCTION: GetNamedPipeInfo
! FUNCTION: GetNativeSystemInfo
! FUNCTION: GetNextVDMCommand
! FUNCTION: GetNlsSectionName
! FUNCTION: GetNumaAvailableMemory
! FUNCTION: GetNumaAvailableMemoryNode
! FUNCTION: GetNumaHighestNodeNumber
! FUNCTION: GetNumaNodeProcessorMask
! FUNCTION: GetNumaProcessorMap
! FUNCTION: GetNumaProcessorNode
! FUNCTION: GetNumberFormatA
! FUNCTION: GetNumberFormatW
! FUNCTION: GetNumberOfConsoleFonts
! FUNCTION: GetNumberOfConsoleInputEvents
! FUNCTION: GetNumberOfConsoleMouseButtons
! FUNCTION: GetOEMCP
FUNCTION: BOOL GetOverlappedResult ( HANDLE hFile, LPOVERLAPPED lpOverlapped, LPDWORD lpNumberOfBytesTransferred, BOOL bWait ) ;
FUNCTION: DWORD GetPriorityClass ( HANDLE hProcess ) ;
! FUNCTION: GetPrivateProfileIntA
! FUNCTION: GetPrivateProfileIntW
! FUNCTION: GetPrivateProfileSectionA
! FUNCTION: GetPrivateProfileSectionNamesA
! FUNCTION: GetPrivateProfileSectionNamesW
! FUNCTION: GetPrivateProfileSectionW
! FUNCTION: GetPrivateProfileStringA
! FUNCTION: GetPrivateProfileStringW
! FUNCTION: GetPrivateProfileStructA
! FUNCTION: GetPrivateProfileStructW
FUNCTION: LPVOID GetProcAddress ( HMODULE hModule, c-string lpProcName ) ;
! FUNCTION: GetProcessAffinityMask
! FUNCTION: GetProcessHandleCount
! FUNCTION: GetProcessHeap
! FUNCTION: GetProcessHeaps
! FUNCTION: GetProcessId
! FUNCTION: GetProcessIoCounters
! FUNCTION: GetProcessPriorityBoost
! FUNCTION: GetProcessShutdownParameters
! FUNCTION: GetProcessTimes
! FUNCTION: GetProcessVersion
! FUNCTION: GetProcessWorkingSetSize
! FUNCTION: GetProfileIntA
! FUNCTION: GetProfileIntW
! FUNCTION: GetProfileSectionA
! FUNCTION: GetProfileSectionW
! FUNCTION: GetProfileStringA
! FUNCTION: GetProfileStringW
FUNCTION: BOOL GetQueuedCompletionStatus ( HANDLE hCompletionPort, LPDWORD lpNumberOfBytes, void* lpCompletionKey, LPOVERLAPPED lpOverlapped, DWORD dwMilliseconds ) ;
! FUNCTION: GetShortPathNameA
! FUNCTION: GetShortPathNameW
! FUNCTION: GetStartupInfoA
! FUNCTION: GetStartupInfoW
FUNCTION: HANDLE GetStdHandle ( DWORD nStdHandle ) ;
! FUNCTION: GetStringTypeA
! FUNCTION: GetStringTypeExA
! FUNCTION: GetStringTypeExW
! FUNCTION: GetStringTypeW
! FUNCTION: GetSystemDefaultLangID
! FUNCTION: GetSystemDefaultLCID
! FUNCTION: GetSystemDefaultUILanguage
! FUNCTION: GetSystemDirectoryA
FUNCTION: UINT GetSystemDirectoryW ( LPTSTR lpBuffer, UINT uSize ) ;
ALIAS: GetSystemDirectory GetSystemDirectoryW
FUNCTION: void GetSystemInfo ( LPSYSTEM_INFO lpSystemInfo ) ;
! FUNCTION: GetSystemPowerStatus
! FUNCTION: GetSystemRegistryQuota
FUNCTION: void GetSystemTime ( LPSYSTEMTIME lpSystemTime ) ;
! FUNCTION: GetSystemTimeAdjustment
FUNCTION: void GetSystemTimeAsFileTime ( LPFILETIME lpSystemTimeAsFileTime ) ;
! FUNCTION: GetSystemTimes
! FUNCTION: GetSystemWindowsDirectoryA
FUNCTION: UINT GetSystemWindowsDirectoryW ( LPTSTR lpBuffer, UINT uSize ) ;
ALIAS: GetSystemWindowsDirectory GetSystemWindowsDirectoryW
! FUNCTION: GetSystemWow64DirectoryA
! FUNCTION: GetSystemWow64DirectoryW
! FUNCTION: GetTapeParameters
! FUNCTION: GetTapePosition
! FUNCTION: GetTapeStatus
! FUNCTION: GetTempFileNameA
! FUNCTION: GetTempFileNameW
! FUNCTION: GetTempPathA
FUNCTION: DWORD GetTempPathW ( DWORD nBufferLength, LPWSTR lpBuffer ) ;
ALIAS: GetTempPath GetTempPathW
! FUNCTION: GetThreadContext
! FUNCTION: GetThreadIOPendingFlag
! FUNCTION: GetThreadLocale
FUNCTION: int GetThreadPriority ( HANDLE hThread ) ;
FUNCTION: BOOL GetThreadPriorityBoost ( HANDLE hThread, PBOOL pDisablePriorityBoost ) ;
! FUNCTION: GetThreadSelectorEntry
! FUNCTION: GetThreadTimes
! FUNCTION: GetTickCount
! FUNCTION: GetTimeFormatA
! FUNCTION: GetTimeFormatW
FUNCTION: DWORD GetTimeZoneInformation ( LPTIME_ZONE_INFORMATION lpTimeZoneInformation ) ;
! FUNCTION: GetUserDefaultLangID
! FUNCTION: GetUserDefaultLCID
! FUNCTION: GetUserDefaultUILanguage
! FUNCTION: GetUserGeoID
! FUNCTION: GetVDMCurrentDirectories
FUNCTION: DWORD GetVersion ( ) ;
FUNCTION: BOOL GetVersionExW ( LPOSVERSIONINFO lpVersionInfo ) ;
ALIAS: GetVersionEx GetVersionExW
! FUNCTION: GetVolumeInformationA
FUNCTION: BOOL GetVolumeInformationW (
    LPCTSTR lpRootPathName,
    LPTSTR lpVolumNameBuffer,
    DWORD nVolumeNameSize,
    LPDWORD lpVolumeSerialNumber,
    LPDWORD lpMaximumComponentLength,
    LPDWORD lpFileSystemFlags,
    LPCTSTR lpFileSystemNameBuffer,
    DWORD nFileSystemNameSize
) ;
ALIAS: GetVolumeInformation GetVolumeInformationW
! FUNCTION: GetVolumeNameForVolumeMountPointA
! FUNCTION: GetVolumeNameForVolumeMountPointW
! FUNCTION: GetVolumePathNameA
! FUNCTION: GetVolumePathNamesForVolumeNameA
FUNCTION: BOOL GetVolumePathNamesForVolumeNameW ( LPCTSTR lpszVolumeName, LPTSTR lpszVolumePathNames, DWORD cchBufferLength, PDWORD lpcchReturnLength ) ;
ALIAS: GetVolumePathNamesForVolumeName GetVolumePathNamesForVolumeNameW

! FUNCTION: GetVolumePathNameW
! FUNCTION: GetWindowsDirectoryA
FUNCTION: UINT GetWindowsDirectoryW ( LPTSTR lpBuffer, UINT uSize ) ;
ALIAS: GetWindowsDirectory GetWindowsDirectoryW
! FUNCTION: GetWriteWatch
! FUNCTION: GlobalAddAtomA
! FUNCTION: GlobalAddAtomW
FUNCTION: HGLOBAL GlobalAlloc ( UINT uFlags, SIZE_T dwBytes ) ;
! FUNCTION: GlobalCompact
! FUNCTION: GlobalDeleteAtom
! FUNCTION: GlobalFindAtomA
! FUNCTION: GlobalFindAtomW
! FUNCTION: GlobalFix
! FUNCTION: GlobalFlags
! FUNCTION: GlobalFree
! FUNCTION: GlobalGetAtomNameA
! FUNCTION: GlobalGetAtomNameW
! FUNCTION: GlobalHandle
FUNCTION: LPVOID GlobalLock ( HGLOBAL hMem ) ;
FUNCTION: void GlobalMemoryStatus ( LPMEMORYSTATUS lpBuffer ) ;
FUNCTION: BOOL GlobalMemoryStatusEx ( LPMEMORYSTATUSEX lpBuffer ) ;
! FUNCTION: GlobalReAlloc
! FUNCTION: GlobalSize
! FUNCTION: GlobalUnfix
FUNCTION: BOOL GlobalUnlock ( HGLOBAL hMem ) ;
! FUNCTION: GlobalUnWire
! FUNCTION: GlobalWire
! FUNCTION: Heap32First
! FUNCTION: Heap32ListFirst
! FUNCTION: Heap32ListNext
! FUNCTION: Heap32Next
FUNCTION: LPVOID HeapAlloc ( HANDLE hHeap, DWORD dwFlags, SIZE_T dwBytes ) ;
! FUNCTION: HeapCompact
! FUNCTION: HeapCreate
! FUNCTION: HeapCreateTagsW
! FUNCTION: HeapDestroy
! FUNCTION: HeapExtend
FUNCTION: BOOL HeapFree ( HANDLE hHeap, DWORD dwFlags, LPVOID lpMem ) ;
! FUNCTION: HeapLock
! FUNCTION: HeapQueryInformation
! FUNCTION: HeapQueryTagW
! FUNCTION: HeapReAlloc
! FUNCTION: HeapSetInformation
! FUNCTION: HeapSize
! FUNCTION: HeapSummary
! FUNCTION: HeapUnlock
! FUNCTION: HeapUsage
! FUNCTION: HeapValidate
! FUNCTION: HeapWalk
! FUNCTION: InitAtomTable
! FUNCTION: InitializeCriticalSection
! FUNCTION: InitializeCriticalSectionAndSpinCount
! FUNCTION: InitializeSListHead
! FUNCTION: InterlockedCompareExchange
! FUNCTION: InterlockedDecrement
! FUNCTION: InterlockedExchange
! FUNCTION: InterlockedExchangeAdd
! FUNCTION: InterlockedFlushSList
! FUNCTION: InterlockedIncrement
! FUNCTION: InterlockedPopEntrySList
! FUNCTION: InterlockedPushEntrySList
! FUNCTION: InvalidateConsoleDIBits
! FUNCTION: IsBadCodePtr
! FUNCTION: IsBadHugeReadPtr
! FUNCTION: IsBadHugeWritePtr
! FUNCTION: IsBadReadPtr
! FUNCTION: IsBadStringPtrA
! FUNCTION: IsBadStringPtrW
! FUNCTION: IsBadWritePtr
! FUNCTION: IsDBCSLeadByte
! FUNCTION: IsDBCSLeadByteEx
! FUNCTION: IsDebuggerPresent
! FUNCTION: IsProcessInJob
FUNCTION: BOOL IsProcessorFeaturePresent ( DWORD ProcessorFeature ) ;
! FUNCTION: IsSystemResumeAutomatic
! FUNCTION: IsValidCodePage
! FUNCTION: IsValidLanguageGroup
! FUNCTION: IsValidLocale
! FUNCTION: IsValidUILanguage
! FUNCTION: IsWow64Process
! FUNCTION: LCMapStringA
! FUNCTION: LCMapStringW
! FUNCTION: LeaveCriticalSection
! FUNCTION: LoadLibraryA
! FUNCTION: LoadLibraryExA
FUNCTION: HMODULE LoadLibraryExW ( LPCTSTR lpFile, HANDLE hFile, DWORD flags ) ;
ALIAS: LoadLibraryEx LoadLibraryExW
! FUNCTION: LoadLibraryW
! FUNCTION: LoadModule
! FUNCTION: LoadResource
FUNCTION: HLOCAL LocalAlloc ( UINT uFlags, SIZE_T uBytes ) ;
! FUNCTION: LocalCompact
! FUNCTION: LocalFileTimeToFileTime
! FUNCTION: LocalFlags
FUNCTION: HLOCAL LocalFree ( HLOCAL hMem ) ;
! FUNCTION: LocalHandle
! FUNCTION: LocalLock
! FUNCTION: LocalReAlloc
! FUNCTION: LocalShrink
! FUNCTION: LocalSize
! FUNCTION: LocalUnlock
! FUNCTION: LockFile
! FUNCTION: LockFileEx
! FUNCTION: LockResource
! FUNCTION: lstrcat
! FUNCTION: lstrcatA
! FUNCTION: lstrcatW
! FUNCTION: lstrcmp
! FUNCTION: lstrcmpA
! FUNCTION: lstrcmpi
! FUNCTION: lstrcmpiA
! FUNCTION: lstrcmpiW
! FUNCTION: lstrcmpW
! FUNCTION: lstrcpy
! FUNCTION: lstrcpyA
! FUNCTION: lstrcpyn
! FUNCTION: lstrcpynA
! FUNCTION: lstrcpynW
! FUNCTION: lstrcpyW
! FUNCTION: lstrlen
! FUNCTION: lstrlenA
! FUNCTION: lstrlenW
! FUNCTION: LZClose
! FUNCTION: LZCloseFile
! FUNCTION: LZCopy
! FUNCTION: LZCreateFileW
! FUNCTION: LZDone
! FUNCTION: LZInit
! FUNCTION: LZOpenFileA
! FUNCTION: LZOpenFileW
! FUNCTION: LZRead
! FUNCTION: LZSeek
! FUNCTION: LZStart
! FUNCTION: MapUserPhysicalPages
! FUNCTION: MapUserPhysicalPagesScatter
FUNCTION: LPVOID MapViewOfFile ( HANDLE hFileMappingObject,
                                 DWORD dwDesiredAccess,
                                 DWORD dwFileOffsetHigh,
                                 DWORD dwFileOffsetLow,
                                 SIZE_T dwNumberOfBytesToMap ) ;

FUNCTION: LPVOID MapViewOfFileEx ( HANDLE hFileMappingObject,
                                 DWORD dwDesiredAccess,
                                 DWORD dwFileOffsetHigh,
                                 DWORD dwFileOffsetLow,
                                 SIZE_T dwNumberOfBytesToMap,
                                 LPVOID lpBaseAddress ) ;

! FUNCTION: Module32First
! FUNCTION: Module32FirstW
! FUNCTION: Module32Next
! FUNCTION: Module32NextW
! FUNCTION: MoveFileA
! FUNCTION: MoveFileExA
! FUNCTION: MoveFileExW
FUNCTION: BOOL MoveFileW ( LPCTSTR lpExistingFileName, LPCTSTR lpNewFileName ) ;
ALIAS: MoveFile MoveFileW
! FUNCTION: MoveFileWithProgressA
! FUNCTION: MoveFileWithProgressW
! FUNCTION: MulDiv
! FUNCTION: MultiByteToWideChar
! FUNCTION: NlsConvertIntegerToString
! FUNCTION: NlsGetCacheUpdateCount
! FUNCTION: NlsResetProcessLocale
! FUNCTION: NumaVirtualQueryNode
! FUNCTION: OpenConsoleW
! FUNCTION: OpenDataFile
! FUNCTION: OpenEventA
! FUNCTION: OpenEventW
! WARNING: OpenFile is limited to paths of 128 chars in length.  Do not use!
! FUNCTION: HFILE OpenFile ( LPCTSTR lpFileName, LPOFSTRUCT lpReOpenBuff, UINT uStyle ) ;
FUNCTION: HANDLE OpenFileMappingW ( DWORD dwDesiredAccess,
                                    BOOL bInheritHandle,
                                    LPCTSTR lpName ) ;
ALIAS: OpenFileMapping OpenFileMappingW
! FUNCTION: OpenJobObjectA
! FUNCTION: OpenJobObjectW
! FUNCTION: OpenMutexA
! FUNCTION: OpenMutexW 
FUNCTION: HANDLE OpenProcess ( DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwProcessId ) ;
! FUNCTION: OpenProfileUserMapping
! FUNCTION: OpenSemaphoreA
! FUNCTION: OpenSemaphoreW
! FUNCTION: OpenThread
! FUNCTION: OpenWaitableTimerA
! FUNCTION: OpenWaitableTimerW
! FUNCTION: OutputDebugStringA
! FUNCTION: OutputDebugStringW
! FUNCTION: PeekConsoleInputA
! FUNCTION: PeekConsoleInputW
! FUNCTION: PeekNamedPipe
! FUNCTION: PostQueuedCompletionStatus
! FUNCTION: PrepareTape
! FUNCTION: PrivCopyFileExW
! FUNCTION: PrivMoveFileIdentityW
! FUNCTION: Process32First
FUNCTION: BOOL Process32FirstW ( HANDLE hSnapshot, LPPROCESSENTRY32 lppe ) ;
ALIAS: Process32First Process32FirstW
! FUNCTION: Process32Next
FUNCTION: BOOL Process32NextW ( HANDLE hSnapshot, LPPROCESSENTRY32 lppe ) ;
ALIAS: Process32Next Process32NextW
! FUNCTION: ProcessIdToSessionId
! FUNCTION: PulseEvent
! FUNCTION: PurgeComm
! FUNCTION: QueryActCtxW
! FUNCTION: QueryDepthSList
! FUNCTION: QueryDosDeviceA
! FUNCTION: QueryDosDeviceW
! FUNCTION: QueryInformationJobObject
! FUNCTION: QueryMemoryResourceNotification
FUNCTION: BOOL QueryPerformanceCounter ( LARGE_INTEGER* lpPerformanceCount ) ;
FUNCTION: BOOL QueryPerformanceFrequency ( LARGE_INTEGER* lpFrequency ) ;
! FUNCTION: QueryWin31IniFilesMappedToRegistry
! FUNCTION: QueueUserAPC
! FUNCTION: QueueUserWorkItem
! FUNCTION: RaiseException
! FUNCTION: ReadConsoleA
! FUNCTION: ReadConsoleInputA
! FUNCTION: ReadConsoleInputExA
! FUNCTION: ReadConsoleInputExW
! FUNCTION: ReadConsoleInputW
! FUNCTION: ReadConsoleOutputA
! FUNCTION: ReadConsoleOutputAttribute
! FUNCTION: ReadConsoleOutputCharacterA
! FUNCTION: ReadConsoleOutputCharacterW
! FUNCTION: ReadConsoleOutputW
! FUNCTION: ReadConsoleW
FUNCTION: BOOL ReadDirectoryChangesW ( HANDLE hDirectory, LPVOID lpBuffer, DWORD nBufferLength, BOOL bWatchSubtree, DWORD dwNotifyFilter, LPDWORD lpBytesReturned, LPOVERLAPPED lpOverlapped, void* lpCompletionRoutine ) ;
FUNCTION: BOOL ReadFile ( HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead, void* lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped ) ;
! FUNCTION: BOOL ReadFile ( HANDLE hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped ) ;
FUNCTION: BOOL ReadFileEx ( HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead, LPOVERLAPPED lpOverlapped, LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine ) ;
! FUNCTION: ReadFileScatter
FUNCTION: BOOL ReadProcessMemory ( HANDLE hProcess, void* lpBaseAddress, void* lpBuffer, long nSize, long* lpNumberOfBytesRead )  ;
! FUNCTION: RegisterConsoleIME
! FUNCTION: RegisterConsoleOS2
! FUNCTION: RegisterConsoleVDM
! FUNCTION: RegisterWaitForInputIdle
! FUNCTION: RegisterWaitForSingleObject
! FUNCTION: RegisterWaitForSingleObjectEx
! FUNCTION: RegisterWowBaseHandlers
! FUNCTION: RegisterWowExec
! FUNCTION: ReleaseActCtx
! FUNCTION: ReleaseMutex
! FUNCTION: ReleaseSemaphore
! FUNCTION: RemoveDirectoryA
FUNCTION: BOOL RemoveDirectoryW ( LPCTSTR lpPathName ) ;
ALIAS: RemoveDirectory RemoveDirectoryW
! FUNCTION: RemoveLocalAlternateComputerNameA
! FUNCTION: RemoveLocalAlternateComputerNameW
! FUNCTION: RemoveVectoredExceptionHandler
! FUNCTION: ReplaceFile
! FUNCTION: ReplaceFileA
! FUNCTION: ReplaceFileW
! FUNCTION: RequestDeviceWakeup
! FUNCTION: RequestWakeupLatency
! FUNCTION: ResetEvent
! FUNCTION: ResetWriteWatch
! FUNCTION: RestoreLastError
! FUNCTION: ResumeThread
! FUNCTION: RtlCaptureContext
! FUNCTION: RtlCaptureStackBackTrace
! FUNCTION: RtlFillMemory
! FUNCTION: RtlMoveMemory
! FUNCTION: RtlUnwind
! FUNCTION: RtlZeroMemory
! FUNCTION: ScrollConsoleScreenBufferA
! FUNCTION: ScrollConsoleScreenBufferW
! FUNCTION: SearchPathA
! FUNCTION: SearchPathW
! FUNCTION: SetCalendarInfoA
! FUNCTION: SetCalendarInfoW
! FUNCTION: SetClientTimeZoneInformation
FUNCTION: BOOL SetCommBreak ( HANDLE hFile ) ;
FUNCTION: BOOL SetCommConfig ( HANDLE hCommDev, LPCOMMCONFIG lpCC, DWORD dwSize ) ;
FUNCTION: BOOL SetCommMask ( HANDLE hFile, DWORD dwEvtMask ) ;
FUNCTION: BOOL SetCommState ( HANDLE hFile, LPDCB lpDCB ) ;
! FUNCTION: SetCommTimeouts
! FUNCTION: SetComPlusPackageInstallStatus
! FUNCTION: SetComputerNameA
! FUNCTION: SetComputerNameExA
! FUNCTION: SetComputerNameExW
! FUNCTION: SetComputerNameW
! FUNCTION: SetConsoleActiveScreenBuffer
! FUNCTION: SetConsoleCommandHistoryMode
! FUNCTION: SetConsoleCP
! FUNCTION: SetConsoleCtrlHandler
! FUNCTION: SetConsoleCursor
! FUNCTION: SetConsoleCursorInfo
! FUNCTION: SetConsoleCursorMode
! FUNCTION: SetConsoleCursorPosition
! FUNCTION: SetConsoleDisplayMode
! FUNCTION: SetConsoleFont
! FUNCTION: SetConsoleHardwareState
! FUNCTION: SetConsoleIcon
! FUNCTION: SetConsoleInputExeNameA
! FUNCTION: SetConsoleInputExeNameW
! FUNCTION: SetConsoleKeyShortcuts
! FUNCTION: SetConsoleLocalEUDC
! FUNCTION: SetConsoleMaximumWindowSize
! FUNCTION: SetConsoleMenuClose
! FUNCTION: SetConsoleMode
! FUNCTION: SetConsoleNlsMode
! FUNCTION: SetConsoleNumberOfCommandsA
! FUNCTION: SetConsoleNumberOfCommandsW
! FUNCTION: SetConsoleOS2OemFormat
! FUNCTION: SetConsoleOutputCP
! FUNCTION: SetConsolePalette
! FUNCTION: SetConsoleScreenBufferSize
FUNCTION: BOOL SetConsoleTextAttribute ( HANDLE hConsoleOutput, WORD wAttributes ) ;
FUNCTION: BOOL SetConsoleTitleW ( LPCWSTR lpConsoleTitle ) ;
ALIAS: SetConsoleTitle SetConsoleTitleW
! FUNCTION: SetConsoleWindowInfo
! FUNCTION: SetCPGlobal
! FUNCTION: SetCriticalSectionSpinCount
! FUNCTION: SetCurrentDirectoryA
FUNCTION: BOOL SetCurrentDirectoryW ( LPCWSTR lpDirectory ) ;
ALIAS: SetCurrentDirectory SetCurrentDirectoryW
! FUNCTION: SetDefaultCommConfigA
FUNCTION: BOOL SetDefaultCommConfigW ( LPCTSTR lpszName, LPCOMMCONFIG lpCC, LPDWORD lpdwSize ) ;
ALIAS: SetDefaultCommConfig SetDefaultCommConfigW
! FUNCTION: SetDllDirectoryA
! FUNCTION: SetDllDirectoryW
FUNCTION: BOOL SetEndOfFile ( HANDLE hFile ) ;
! FUNCTION: SetEnvironmentVariableA
FUNCTION: BOOL SetEnvironmentVariableW ( LPCTSTR key, LPCTSTR value ) ;
ALIAS: SetEnvironmentVariable SetEnvironmentVariableW
! FUNCTION: SetErrorMode
! FUNCTION: SetEvent
! FUNCTION: SetFileApisToANSI
! FUNCTION: SetFileApisToOEM
! FUNCTION: SetFileAttributesA
FUNCTION: BOOL SetFileAttributesW ( LPCTSTR lpFileName, DWORD dwFileAttributes ) ;
ALIAS: SetFileAttributes SetFileAttributesW
FUNCTION: DWORD SetFilePointer ( HANDLE hFile, LONG lDistanceToMove, PLONG lpDistanceToMoveHigh, DWORD dwMoveMethod ) ;
FUNCTION: DWORD SetFilePointerEx ( HANDLE hFile, LARGE_INTEGER lDistanceToMove, PLARGE_INTEGER lpDistanceToMoveHigh, DWORD dwMoveMethod ) ;
! FUNCTION: SetFileShortNameA
! FUNCTION: SetFileShortNameW
FUNCTION: BOOL SetFileTime ( HANDLE hFile, FILETIME* lpCreationTime, FILETIME* lpLastAccessTime, FILETIME* lpLastWriteTime ) ;
! FUNCTION: SetFileValidData
! FUNCTION: SetFirmwareEnvironmentVariableA
! FUNCTION: SetFirmwareEnvironmentVariableW
! FUNCTION: SetHandleContext
! FUNCTION: SetHandleCount
FUNCTION: BOOL SetHandleInformation ( HANDLE hObject, DWORD dwMask, DWORD dwFlags ) ;
! FUNCTION: SetInformationJobObject
! FUNCTION: SetLastConsoleEventActive
! FUNCTION: SetLastError
! FUNCTION: SetLocaleInfoA
! FUNCTION: SetLocaleInfoW
! FUNCTION: SetLocalPrimaryComputerNameA
! FUNCTION: SetLocalPrimaryComputerNameW
! FUNCTION: SetLocalTime
! FUNCTION: SetMailslotInfo
! FUNCTION: SetMessageWaitingIndicator
! FUNCTION: SetNamedPipeHandleState
FUNCTION: BOOL SetPriorityClass ( HANDLE hProcess, DWORD dwPriorityClass ) ;
! FUNCTION: SetProcessAffinityMask
FUNCTION: BOOL SetProcessPriorityBoost ( HANDLE hProcess, BOOL disablePriorityBoost ) ;
! FUNCTION: SetProcessShutdownParameters
! FUNCTION: SetProcessWorkingSetSize
! FUNCTION: SetStdHandle
! FUNCTION: SetSystemPowerState
FUNCTION: BOOL SetSystemTime ( SYSTEMTIME* lpSystemTime ) ;
! FUNCTION: SetSystemTimeAdjustment
! FUNCTION: SetTapeParameters
! FUNCTION: SetTapePosition
! FUNCTION: SetTermsrvAppInstallMode
! FUNCTION: SetThreadAffinityMask
! FUNCTION: SetThreadContext
! FUNCTION: SetThreadExecutionState
! FUNCTION: SetThreadIdealProcessor
! FUNCTION: SetThreadLocale
FUNCTION: BOOL SetThreadPriority ( HANDLE hThread, int nPriority ) ;
FUNCTION: BOOL SetThreadPriorityBoost ( HANDLE hThread, BOOL disablePriorityBoost ) ;
! FUNCTION: SetThreadUILanguage
! FUNCTION: SetTimerQueueTimer
! FUNCTION: SetTimeZoneInformation
! FUNCTION: SetUnhandledExceptionFilter
! FUNCTION: SetupComm
! FUNCTION: SetUserGeoID
! FUNCTION: SetVDMCurrentDirectories
! FUNCTION: SetVolumeLabelA
! FUNCTION: SetVolumeLabelW
! FUNCTION: SetVolumeMountPointA
! FUNCTION: SetVolumeMountPointW
! FUNCTION: SetWaitableTimer
! FUNCTION: ShowConsoleCursor
! FUNCTION: SignalObjectAndWait
! FUNCTION: SizeofResource
! FUNCTION: Sleep
FUNCTION: DWORD SleepEx ( DWORD dwMilliSeconds, BOOL bAlertable ) ;
! FUNCTION: SuspendThread
! FUNCTION: SwitchToFiber
! FUNCTION: SwitchToThread
FUNCTION: BOOL SystemTimeToFileTime ( SYSTEMTIME* lpSystemTime, LPFILETIME lpFileTime ) ;
! FUNCTION: SystemTimeToTzSpecificLocalTime
! FUNCTION: TerminateJobObject
FUNCTION: BOOL TerminateProcess ( HANDLE hProcess, DWORD uExit ) ;
! FUNCTION: TerminateThread
! FUNCTION: TermsrvAppInstallMode
! FUNCTION: Thread32First
! FUNCTION: Thread32Next
! FUNCTION: TlsAlloc
! FUNCTION: TlsFree
! FUNCTION: TlsGetValue
! FUNCTION: TlsSetValue
! FUNCTION: Toolhelp32ReadProcessMemory
! FUNCTION: TransactNamedPipe
! FUNCTION: TransmitCommChar
! FUNCTION: TrimVirtualBuffer
! FUNCTION: TryEnterCriticalSection
! FUNCTION: TzSpecificLocalTimeToSystemTime
! FUNCTION: UnhandledExceptionFilter
! FUNCTION: UnlockFile
! FUNCTION: UnlockFileEx
FUNCTION: BOOL UnmapViewOfFile ( LPCVOID lpBaseAddress ) ;
! FUNCTION: UnregisterConsoleIME
! FUNCTION: UnregisterWait
! FUNCTION: UnregisterWaitEx
! FUNCTION: UpdateResourceA
FUNCTION: BOOL UpdateResourceW ( HANDLE hUpdate, LPCTSTR lpType, LPCTSTR lpName, WORD wLanguage, LPVOID lpData, DWORD cbData ) ;
ALIAS: UpdateResource UpdateResourceW
! FUNCTION: UTRegister
! FUNCTION: UTUnRegister
! FUNCTION: ValidateLCType
! FUNCTION: ValidateLocale
! FUNCTION: VDMConsoleOperation
! FUNCTION: VDMOperationStarted
! FUNCTION: VerifyConsoleIoHandle
! FUNCTION: VerifyVersionInfoA
! FUNCTION: VerifyVersionInfoW
! FUNCTION: VerLanguageNameA
! FUNCTION: VerLanguageNameW
! FUNCTION: VerSetConditionMask
! FUNCTION: VirtualAlloc
FUNCTION: HANDLE VirtualAllocEx ( HANDLE hProcess, void* lpAddress, long dwSize, DWORD flAllocationType, DWORD flProtect ) ;
! FUNCTION: VirtualBufferExceptionHandler
! FUNCTION: VirtualFree
FUNCTION: BOOL VirtualFreeEx ( HANDLE hProcess, void* lpAddress, long dwSize, DWORD dwFreeType ) ;
! FUNCTION: VirtualLock
! FUNCTION: VirtualProtect
! FUNCTION: VirtualProtectEx
! FUNCTION: VirtualQuery
FUNCTION: BOOL VirtualQueryEx ( HANDLE hProcess, void* lpAddress, MEMORY_BASIC_INFORMATION* lpBuffer, SIZE_T dwLength ) ;
! FUNCTION: VirtualUnlock
! FUNCTION: WaitCommEvent
! FUNCTION: WaitForDebugEvent
FUNCTION: DWORD WaitForMultipleObjects ( DWORD nCount, HANDLE* lpHandles, BOOL bWaitAll, DWORD dwMilliseconds ) ;
! FUNCTION: WaitForMultipleObjectsEx
FUNCTION: BOOL WaitForSingleObject ( HANDLE hHandle, DWORD dwMilliseconds ) ;
! FUNCTION: WaitForSingleObjectEx
! FUNCTION: WaitNamedPipeA
! FUNCTION: WaitNamedPipeW
! FUNCTION: WideCharToMultiByte
! FUNCTION: WinExec
! FUNCTION: WriteConsoleA
! FUNCTION: WriteConsoleInputA
! FUNCTION: WriteConsoleInputVDMA
! FUNCTION: WriteConsoleInputVDMW
! FUNCTION: WriteConsoleInputW
! FUNCTION: WriteConsoleOutputA
! FUNCTION: WriteConsoleOutputAttribute
! FUNCTION: WriteConsoleOutputCharacterA
! FUNCTION: WriteConsoleOutputCharacterW
! FUNCTION: WriteConsoleOutputW
! FUNCTION: WriteConsoleW
FUNCTION: BOOL WriteFile ( HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToWrite, void* lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped ) ;
FUNCTION: BOOL WriteFileEx ( HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPOVERLAPPED lpOverlapped, LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine ) ;
! FUNCTION: WriteFileGather
! FUNCTION: WritePrivateProfileSectionA
! FUNCTION: WritePrivateProfileSectionW
! FUNCTION: WritePrivateProfileStringA
! FUNCTION: WritePrivateProfileStringW
! FUNCTION: WritePrivateProfileStructA
! FUNCTION: WritePrivateProfileStructW
FUNCTION: BOOL WriteProcessMemory ( HANDLE hProcess, void* lpBaseAddress, void* lpBuffer, long nSize, long* lpNumberOfBytesWritten )  ;
! FUNCTION: WriteProfileSectionA
! FUNCTION: WriteProfileSectionW
! FUNCTION: WriteProfileStringA
! FUNCTION: WriteProfileStringW
! FUNCTION: WriteTapemark
! FUNCTION: WTSGetActiveConsoleSessionId
! FUNCTION: ZombifyActCtx

: with-global-lock ( HGLOBAL quot -- )
    swap [ GlobalLock swap call ] keep GlobalUnlock drop ; inline
