## Syntax Tokens

Provide by custom [tmLanguage file](https://github.com/sumneko/vscode-lua/blob/master/syntaxes/lua.tmLanguage.json)

Preview in `Dark+` of VSCode

| token                                          | preview                                                                                                                              |
| :----                                          | :----                                                                                                                                |
| `keyword.local.lua`                            | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/keyword.local.lua.jpg?raw=true)                            |
| `keyword.control.lua`                          | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/keyword.control.lua.jpg?raw=true)                          |
| `entity.name.class.lua`                        | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/entity.name.class.lua.jpg?raw=true)                        |
| `entity.name.function.lua`                     | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/entity.name.function.lua.jpg?raw=true)                     |
| `punctuation.definition.parameters.begin.lua`  | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/punctuation.definition.parameters.begin.lua.jpg?raw=true)  |
| `punctuation.definition.parameters.finish.lua` | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/punctuation.definition.parameters.finish.lua.jpg?raw=true) |
| `variable.parameter.function.lua`              | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/variable.parameter.function.lua.jpg?raw=true)              |
| `punctuation.separator.arguments.lua`          | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/punctuation.separator.arguments.lua.jpg?raw=true)          |
| `constant.numeric.integer.lua`                 | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/constant.numeric.integer.lua.jpg?raw=true)                 |
| `constant.numeric.float.lua`                   | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/constant.numeric.float.lua.jpg?raw=true)                   |
| `constant.numeric.integer.hexadecimal.lua`     | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/constant.numeric.integer.hexadecimal.lua.jpg?raw=true)     |
| `constant.numeric.float.hexadecimal.lua`       | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/constant.numeric.float.hexadecimal.lua.jpg?raw=true)       |
| `punctuation.definition.string.begin.lua`      | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/punctuation.definition.string.begin.lua.jpg?raw=true)      |
| `punctuation.definition.string.end.lua`        | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/punctuation.definition.string.end.lua.jpg?raw=true)        |
| `string.quoted.single.lua`                     | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/string.quoted.single.lua.jpg?raw=true)                     |
| `string.quoted.double.lua`                     | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/string.quoted.double.lua.jpg?raw=true)                     |
| `string.quoted.other.multiline.lua`            | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/string.quoted.other.multiline.lua.jpg?raw=true)            |
| `constant.character.escape.lua`                | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/constant.character.escape.lua.jpg?raw=true)                |
| `constant.character.escape.byte.lua`           | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/constant.character.escape.byte.lua.jpg?raw=true)           |
| `constant.character.escape.unicode.lua`        | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/constant.character.escape.unicode.lua.jpg?raw=true)        |
| `invalid.illegal.character.escape.lua`         | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/invalid.illegal.character.escape.lua.jpg?raw=true)         |
| `punctuation.definition.comment.lua`           | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/punctuation.definition.comment.lua.jpg?raw=true)           |
| `comment.line.double-dash.lua`                 | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/comment.line.double-dash.lua.jpg?raw=true)                 |
| `punctuation.definition.comment.begin.lua`     | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/punctuation.definition.comment.begin.lua.jpg?raw=true)     |
| `punctuation.definition.comment.end.lua`       | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/punctuation.definition.comment.end.lua.jpg?raw=true)       |
| `comment.block.lua`                            | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/comment.block.lua.jpg?raw=true)                            |
| `keyword.control.goto.lua`                     | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/keyword.control.goto.lua.jpg?raw=true)                     |
| `string.tag.lua`                               | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/string.tag.lua.jpg?raw=true)                               |
| `punctuation.section.embedded.begin.lua`       | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/punctuation.section.embedded.begin.lua.jpg?raw=true)       |
| `punctuation.section.embedded.end.lua`         | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/punctuation.section.embedded.end.lua.jpg?raw=true)         |
| `variable.language.self.lua`                   | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/variable.language.self.lua.jpg?raw=true)                   |
| `support.function.lua`                         | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/support.function.lua.jpg?raw=true)                         |
| `support.function.library.lua`                 | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/support.function.library.lua.jpg?raw=true)                 |
| `keyword.operator.lua`                         | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/keyword.operator.lua.jpg?raw=true)                         |
| `variable.other.lua`                           | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/variable.other.lua.jpg?raw=true)                           |

## Semantic Tokens

Preview in `Dark+` of VSCode

| semantic token          | fallen syntax token        | preview                                                                                                       |
| :----                   | :----                      | :----                                                                                                         |
| `namespace.static`      | `support.function.lua`     | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/namespace.static.jpg?raw=true)      |
| `namespace.readonly`    | `constant.language.lua`    | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/namespace.readonly.jpg?raw=true)    |
| `namespace.deprecated`  | `entity.name.label`        | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/namespace.deprecated.jpg?raw=true)  |
| `parameter.declaration` | `variable.parameter`       | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/parameter.declaration.jpg?raw=true) |
| `property.declaration`  | `entity.other.attribute`   | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/property.declaration.jpg?raw=true)  |
| `variable`              | `variable.other.lua`       | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/variable.jpg?raw=true)              |
| `interface.declaration` | `entity.name.function.lua` | ![avatar](https://github.com/sumneko/vscode-lua/blob/master/images/tokens/interface.declaration.jpg?raw=true) |
