/*
 * Decompiled with CFR 0.152.
 */
package com.mergebase.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Java2Json {
    private int pos;
    private char[] json;
    private static final Long ZERO = Long.valueOf("0");
    private static final int MAP = 0;
    private static final int LIST = 1;
    private static final int STRING = 2;
    private static final int NUMBER = 3;
    private static final int BOOLEAN = 5;
    private static final int NULL = 6;
    private static final int MODE_WHITESPACE = -1;
    private static final int MODE_NORMAL = 0;
    private static final int MODE_BACKSLASH = 1;

    public static void main(String[] stringArray) throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder stringBuilder = new StringBuilder(1024);
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string).append('\n');
        }
        Object object = Java2Json.parse(stringBuilder.toString());
        System.out.write(Java2Json.format(object).getBytes("UTF-8"));
    }

    private Java2Json(int n, char[] cArray) {
        this.pos = n;
        this.json = cArray;
    }

    public static Map parseToMap(String string) {
        return (Map)Java2Json.parse(string);
    }

    public static List parseToList(String string) {
        return (List)Java2Json.parse(string);
    }

    public static Object parse(String string) {
        String string2 = string = string != null ? string.trim() : "";
        if (string.length() > 0 && string.charAt(0) == '\ufeff') {
            string = string.substring(1).trim();
        }
        char[] cArray = string.toCharArray();
        Java2Json java2Json = new Java2Json(0, cArray);
        try {
            int n = Java2Json.nextObject(java2Json);
            Object object = Java2Json.parseObject(n, java2Json);
            Java2Json.finalWhitespace(java2Json);
            return object;
        }
        catch (RuntimeException runtimeException) {
            int n = cArray.length - java2Json.pos;
            if (java2Json.pos > 10) {
                // empty if block
            }
            throw runtimeException;
        }
    }

    public static String format(Object object) {
        return Java2Json.format(false, object);
    }

    public static String format(boolean bl, Object object) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        Java2Json.prettyPrint(bl, object, 0, stringBuilder);
        String string = stringBuilder.toString();
        if (object instanceof Map) {
            return "{" + string + "}";
        }
        if (object instanceof Collection || object instanceof Object[]) {
            return "[" + string + "]";
        }
        return string;
    }

    private static Object parseObject(int n, Java2Json java2Json) {
        switch (n) {
            case 0: {
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                while (Java2Json.hasNextItem(java2Json, '}')) {
                    String string = Java2Json.nextString(java2Json);
                    Java2Json.nextChar(java2Json, ':');
                    n = Java2Json.nextObject(java2Json);
                    Object object = Java2Json.parseObject(n, java2Json);
                    linkedHashMap.put(string, object);
                }
                return linkedHashMap;
            }
            case 1: {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (Java2Json.hasNextItem(java2Json, ']')) {
                    n = Java2Json.nextObject(java2Json);
                    Object object = Java2Json.parseObject(n, java2Json);
                    arrayList.add(object);
                }
                return arrayList;
            }
            case 2: {
                return Java2Json.nextString(java2Json);
            }
            case 3: {
                return Java2Json.nextNumber(java2Json);
            }
            case 5: {
                return Java2Json.nextBoolean(java2Json);
            }
            case 6: {
                return Java2Json.nextNull(java2Json);
            }
        }
        throw new RuntimeException("invalid type: " + n);
    }

    private static boolean hasNextItem(Java2Json java2Json, char c) {
        char c2;
        char c3 = java2Json.json[java2Json.pos - 1];
        boolean bl = c == '}';
        boolean bl2 = Java2Json.nextChar(java2Json, ',', false);
        if (!bl2) {
            --java2Json.pos;
        }
        if ((c2 = java2Json.json[java2Json.pos]) == c) {
            ++java2Json.pos;
            return false;
        }
        if (bl2) {
            return true;
        }
        if (bl && c3 == '{') {
            return true;
        }
        if (!bl && c3 == '[') {
            return true;
        }
        throw new RuntimeException("expected whitespace or comma or " + c + " but found: " + c2);
    }

    private static int nextObject(Java2Json java2Json) {
        for (int i = java2Json.pos; i < java2Json.json.length; ++i) {
            ++java2Json.pos;
            char c = java2Json.json[i];
            if (Java2Json.isWhitespace(c)) continue;
            if (c == '\"') {
                --java2Json.pos;
                return 2;
            }
            if (c == '{') {
                return 0;
            }
            if (c == '[') {
                return 1;
            }
            if (c == '-' || c >= '0' && c <= '9') {
                --java2Json.pos;
                return 3;
            }
            if (c == 'n') {
                --java2Json.pos;
                return 6;
            }
            if (c == 't' || c == 'f') {
                --java2Json.pos;
                return 5;
            }
            throw new RuntimeException("Expected whitespace or JSON literal, but got: " + c);
        }
        return -1;
    }

    private static void finalWhitespace(Java2Json java2Json) {
        for (int i = java2Json.pos; i < java2Json.json.length; ++i) {
            ++java2Json.pos;
            char c = java2Json.json[i];
            if (Java2Json.isWhitespace(c)) continue;
            throw new RuntimeException("Expected whitespace or EOF but got: " + c);
        }
    }

    private static boolean nextChar(Java2Json java2Json, char c) {
        return Java2Json.nextChar(java2Json, c, true);
    }

    private static boolean nextChar(Java2Json java2Json, char c, boolean bl) {
        for (int i = java2Json.pos; i < java2Json.json.length; ++i) {
            ++java2Json.pos;
            char c2 = java2Json.json[i];
            if (Java2Json.isWhitespace(c2)) continue;
            if (c2 == c) {
                return true;
            }
            if (bl) {
                throw new RuntimeException("Expected whitespace or " + c + " but got: " + c2);
            }
            return false;
        }
        throw new RuntimeException("Never found " + c);
    }

    private static Object nextNull(Java2Json java2Json) {
        char c = java2Json.json[java2Json.pos++];
        try {
            if (c == 'n' && (c = java2Json.json[java2Json.pos++]) == 'u' && (c = java2Json.json[java2Json.pos++]) == 'l' && (c = java2Json.json[java2Json.pos++]) == 'l') {
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException("expected null literal but ran of out string to parse");
        }
        throw new RuntimeException("expected null literal but ran into bad character: " + c);
    }

    private static Boolean nextBoolean(Java2Json java2Json) {
        char c = java2Json.json[java2Json.pos++];
        try {
            if (c == 't') {
                if ((c = java2Json.json[java2Json.pos++]) == 'r' && (c = java2Json.json[java2Json.pos++]) == 'u' && (c = java2Json.json[java2Json.pos++]) == 'e') {
                    return Boolean.TRUE;
                }
            } else if (c == 'f' && (c = java2Json.json[java2Json.pos++]) == 'a' && (c = java2Json.json[java2Json.pos++]) == 'l' && (c = java2Json.json[java2Json.pos++]) == 's' && (c = java2Json.json[java2Json.pos++]) == 'e') {
                return Boolean.FALSE;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException("expected true/false literal but ran of out string to parse");
        }
        throw new RuntimeException("expected true/false literal but ran into bad character: " + c);
    }

    private static Number nextNumber(Java2Json java2Json) {
        boolean bl;
        String string;
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = java2Json.pos; i < java2Json.json.length; ++i) {
            ++java2Json.pos;
            c = java2Json.json[i];
            if (Java2Json.isWhitespace(c) || c == ',' || c == '}' || c == ']') {
                --java2Json.pos;
                break;
            }
            if (c != '-' && c != '+' && c != 'e' && c != 'E' && c != '.' && (c < '0' || c > '9')) {
                throw new RuntimeException("expected number but got: " + c);
            }
            stringBuilder.append(c);
        }
        char c2 = c = (string = stringBuilder.toString()).length() > 0 ? (char)string.charAt(0) : (char)'_';
        if (c == '+') {
            throw new RuntimeException("number literal cannot start with plus: " + string);
        }
        if ("-".equals(string)) {
            throw new RuntimeException("number literal cannot be negative sign by itself");
        }
        boolean bl2 = bl = c == '-';
        if (bl) {
            string = string.substring(1);
        }
        if ("0".equals(string)) {
            return ZERO;
        }
        if (string.startsWith(".")) {
            throw new RuntimeException("number literal cannot start with decimal point: " + string);
        }
        if (!string.startsWith("0.") && !string.startsWith("0e") && !string.startsWith("0E") && string.startsWith("0")) {
            throw new RuntimeException("number literal cannot have leading zero: " + string);
        }
        if (Java2Json.contains(string, ".e") || Java2Json.contains(string, ".E")) {
            throw new RuntimeException("number literal invalid exponential: " + string);
        }
        if (string.endsWith("e") || string.endsWith("E") || string.endsWith("+") || string.endsWith("-") || string.endsWith(".")) {
            throw new RuntimeException("number literal cannot end with [eE+-.] " + string);
        }
        int[] nArray = Java2Json.charCounts(string);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = n3 + n2;
        if (n5 > 0) {
            boolean bl3;
            if (n5 > 1) {
                throw new RuntimeException("invalid number literal - too many plusses/minuses: " + string);
            }
            boolean bl4 = false;
            boolean bl5 = bl3 = n2 > 0 && (Java2Json.contains(string, "e-") || Java2Json.contains(string, "E-"));
            if (!bl3) {
                boolean bl6 = bl4 = n3 > 0 && (Java2Json.contains(string, "e+") || Java2Json.contains(string, "E+"));
            }
            if (!bl4 && !bl3) {
                throw new RuntimeException("invalid number literal: " + string);
            }
        }
        if (n > 1 || n4 > 1) {
            throw new RuntimeException("invalid number literal: " + string);
        }
        if (bl) {
            string = "-" + string;
        }
        if (n == 1 || n4 == 1) {
            return new Double(string);
        }
        try {
            return new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new Double(string);
        }
    }

    private static int[] charCounts(String string) {
        int[] nArray = new int[]{0, 0, 0, 0};
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '.': {
                    nArray[0] = nArray[0] + 1;
                    continue block6;
                }
                case '-': {
                    nArray[1] = nArray[1] + 1;
                    continue block6;
                }
                case '+': {
                    nArray[2] = nArray[2] + 1;
                    continue block6;
                }
                case 'E': 
                case 'e': {
                    nArray[3] = nArray[3] + 1;
                    continue block6;
                }
            }
        }
        return nArray;
    }

    private static String nextString(Java2Json java2Json) {
        int n = -1;
        StringBuilder stringBuilder = new StringBuilder();
        block18: for (int i = java2Json.pos; i < java2Json.json.length; ++i) {
            ++java2Json.pos;
            char c = java2Json.json[i];
            switch (n) {
                case -1: {
                    if (c == '\"') {
                        n = 0;
                        continue block18;
                    }
                    if (Java2Json.isWhitespace(c)) continue block18;
                    throw new RuntimeException("json expecting double-quote: " + c);
                }
                case 0: {
                    int n2;
                    StringBuilder stringBuilder2;
                    if (c == '\\') {
                        n = 1;
                        continue block18;
                    }
                    if (c == '\"') {
                        return stringBuilder.toString();
                    }
                    if (Character.isISOControl(c)) {
                        stringBuilder2 = new StringBuilder(Integer.toHexString(c));
                        if ("7f".equalsIgnoreCase(stringBuilder2.toString())) {
                            stringBuilder.append(c);
                            continue block18;
                        }
                        for (n2 = stringBuilder2.length(); n2 < 4; ++n2) {
                            stringBuilder2.insert(0, "0");
                        }
                        throw new RuntimeException("control characters in string literal must be escaped: \\u" + stringBuilder2);
                    }
                    if (c == '\b' || c == '\f' || c == '\n' || c == '\r' || c == '\t') {
                        throw new RuntimeException("json string literal invalid character: " + c);
                    }
                    stringBuilder.append(c);
                    continue block18;
                }
                case 1: {
                    int n2;
                    StringBuilder stringBuilder2;
                    switch (c) {
                        case '/': {
                            stringBuilder.append('/');
                            break;
                        }
                        case 'b': {
                            stringBuilder.append('\b');
                            break;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            break;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            break;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            break;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            break;
                        }
                        case '\"': {
                            stringBuilder.append('\"');
                            break;
                        }
                        case '\\': {
                            stringBuilder.append('\\');
                            break;
                        }
                        case 'u': {
                            stringBuilder2 = new StringBuilder();
                            for (n2 = 0; n2 < 4; ++n2) {
                                try {
                                    char c2 = java2Json.json[java2Json.pos++];
                                    if (!Java2Json.isHex(c2)) {
                                        throw new RuntimeException("invalid \\u encoded character (must be hex): " + c2);
                                    }
                                    stringBuilder2.append(c2);
                                    continue;
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    throw new RuntimeException("\\u encoded literal ran out of string to parse");
                                }
                            }
                            stringBuilder.append((char)Integer.parseInt(stringBuilder2.toString(), 16));
                            i += 4;
                            break;
                        }
                        default: {
                            throw new RuntimeException("invalid backslash protected character: " + c);
                        }
                    }
                    n = 0;
                }
            }
        }
        throw new RuntimeException("never found literal string terminator \"");
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    private static boolean contains(String string, String string2) {
        return string.indexOf(string2) >= 0;
    }

    private static StringBuilder prettyPrint(boolean bl, Object list, int n, StringBuilder stringBuilder) {
        Iterator<Object> iterator;
        List<Object> list2;
        Object object;
        if (list instanceof Object[]) {
            object = (Object[])list;
            list2 = Arrays.asList(object);
        } else {
            list2 = list;
        }
        if (list2 instanceof Map) {
            object = (Map)((Object)list2);
            iterator = object.entrySet().iterator();
        } else if (list2 instanceof Collection) {
            object = list2;
            iterator = object.iterator();
        } else {
            iterator = Collections.singleton(list2).iterator();
        }
        while (iterator.hasNext()) {
            Object object2;
            object = iterator.next();
            Object object3 = object;
            if (object3 instanceof Object[]) {
                object2 = (Object[])object3;
                object3 = Arrays.asList(object2);
            }
            if (bl) {
                stringBuilder.append('\n');
                Java2Json.indent(stringBuilder, n);
            }
            if (object instanceof Map.Entry) {
                object2 = (Map.Entry)object;
                String string = (String)object2.getKey();
                stringBuilder.append('\"');
                Java2Json.jsonSafe(string, stringBuilder);
                stringBuilder.append('\"').append(':');
                object3 = object2.getValue();
                if (object3 instanceof Object[]) {
                    Object[] objectArray = (Object[])object3;
                    object3 = Arrays.asList(objectArray);
                }
            }
            if (object3 == null || object3 instanceof Boolean || object3 instanceof Number) {
                Java2Json.jsonSafe(object3, stringBuilder);
            } else if (object3 instanceof Collection) {
                int n2;
                stringBuilder.append('[');
                int n3 = stringBuilder.length();
                Java2Json.prettyPrint(bl, object3, n + 1, stringBuilder);
                if (bl && n3 < (n2 = stringBuilder.length())) {
                    stringBuilder.append('\n');
                    Java2Json.indent(stringBuilder, n);
                }
                stringBuilder.append(']');
            } else if (object3 instanceof Map) {
                int n4;
                stringBuilder.append('{');
                int n5 = stringBuilder.length();
                Java2Json.prettyPrint(bl, object3, n + 1, stringBuilder);
                if (bl && n5 < (n4 = stringBuilder.length())) {
                    stringBuilder.append('\n');
                    Java2Json.indent(stringBuilder, n);
                }
                stringBuilder.append('}');
            } else if (object3 instanceof String) {
                stringBuilder.append('\"');
                Java2Json.jsonSafe(object3, stringBuilder);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append('\"');
                Java2Json.jsonSafe(object3.toString(), stringBuilder);
                stringBuilder.append('\"');
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(',');
        }
        return stringBuilder;
    }

    private static StringBuilder indent(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        return stringBuilder;
    }

    private static void jsonSafe(Object object, StringBuilder stringBuilder) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (object instanceof Boolean || object instanceof Number) {
            String string = object.toString();
            if ("Infinity".equals(string)) {
                string = "1e99999";
            } else if ("-Infinity".equals(string)) {
                string = "-1e99999";
            }
            stringBuilder.append(string);
            return;
        }
        if (object instanceof Map || object instanceof Collection) {
            throw new RuntimeException("cannot make Map or Collection into json string literal: " + object);
        }
        String string = object instanceof String ? (String)object : object.toString();
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '/': {
                    stringBuilder.append("\\/");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        String string2 = Integer.toHexString(c);
                        stringBuilder.append("\\u");
                        for (int j = string2.length(); j < 4; ++j) {
                            stringBuilder.append('0');
                        }
                        stringBuilder.append(string2);
                        continue block10;
                    }
                    stringBuilder.append(c);
                }
            }
        }
    }
}

