/*
 * Decompiled with CFR 0.152.
 */
package com.leastfixedpoint.json;

import com.leastfixedpoint.json.JSONNull;
import com.leastfixedpoint.json.JSONSyntaxError;
import com.leastfixedpoint.json.JSONValue;
import java.io.EOFException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONReader {
    protected int NO_TOKEN = -2;
    protected int EOF = -1;
    private final StringBuilder buf = new StringBuilder();
    protected LineNumberReader reader;
    protected int _buffer = this.NO_TOKEN;

    public JSONReader(Reader r) {
        this.reader = r instanceof LineNumberReader ? (LineNumberReader)r : new LineNumberReader(r);
    }

    public LineNumberReader getReader() {
        return this.reader;
    }

    public static Object readFrom(Reader r) throws IOException {
        return JSONReader.readFrom(r, true);
    }

    public static Object readFrom(String s) throws IOException {
        return JSONReader.readFrom(new StringReader(s), true);
    }

    public static Object readFrom(String s, boolean ensureSingleValue) throws IOException {
        return JSONReader.readFrom(new StringReader(s), ensureSingleValue);
    }

    protected static Object readFrom(Reader r, boolean ensureSingleValue) throws IOException {
        JSONReader jsonReader = new JSONReader(r);
        Object result = jsonReader.read();
        if (ensureSingleValue) {
            jsonReader.expectEOF();
        }
        return result;
    }

    protected void drop() throws IOException {
        this._buffer = this.NO_TOKEN;
    }

    protected int buffer() throws IOException {
        if (this._buffer == this.NO_TOKEN) {
            this._buffer = this.reader.read();
        }
        return this._buffer;
    }

    protected boolean atEOF() throws IOException {
        return this.buffer() == this.EOF;
    }

    protected char curr() throws IOException {
        if (this.atEOF()) {
            throw new EOFException();
        }
        return (char)this._buffer;
    }

    protected boolean check(char expected) throws IOException {
        return this.buffer() == expected;
    }

    protected boolean checkDrop(char expected) throws IOException {
        if (this.check(expected)) {
            this.drop();
            return true;
        }
        return false;
    }

    protected void skipWhiteSpace() throws IOException {
        while (!this.atEOF()) {
            while (Character.isWhitespace(this.buffer()) || this.buffer() == 65279) {
                this.drop();
            }
            if (!this.checkDrop('/')) break;
            if (this.checkDrop('/')) {
                while (!this.atEOF() && !this.check('\n')) {
                    this.drop();
                }
                continue;
            }
            this.syntaxError("Invalid comment");
            break;
        }
    }

    protected Object valueGuard(Object value) throws JSONSyntaxError {
        if (value instanceof Lexeme) {
            this.unexpectedLexeme((Lexeme)((Object)value));
        }
        return value;
    }

    public Object read() throws IOException {
        return this.valueGuard(this._read());
    }

    public JSONValue readValue() throws IOException {
        return JSONValue.wrap(this.read());
    }

    public void expectEOF() throws IOException {
        this.skipWhiteSpace();
        if (!this.atEOF()) {
            this.syntaxError("Expected, but did not see, end-of-file");
        }
    }

    protected Object readAtom(String atom, Object value) throws IOException {
        for (int i = 0; i < atom.length(); ++i) {
            if (this.checkDrop(atom.charAt(i))) continue;
            if (this.atEOF()) {
                throw new EOFException();
            }
            this.syntaxError("Invalid input parsing '" + atom + "'");
        }
        return value;
    }

    public Object nextLexeme() throws IOException {
        this.skipWhiteSpace();
        switch (this.curr()) {
            case '\"': 
            case '\'': {
                char sep = this.curr();
                this.drop();
                return this.string(sep);
            }
            case '[': {
                this.drop();
                return Lexeme.ARRAY_START;
            }
            case ',': {
                this.drop();
                return Lexeme.COMMA;
            }
            case ']': {
                this.drop();
                return Lexeme.ARRAY_END;
            }
            case '{': {
                this.drop();
                return Lexeme.OBJECT_START;
            }
            case ':': {
                this.drop();
                return Lexeme.COLON;
            }
            case '}': {
                this.drop();
                return Lexeme.OBJECT_END;
            }
            case 't': {
                return this.readAtom("true", Boolean.TRUE);
            }
            case 'f': {
                return this.readAtom("false", Boolean.FALSE);
            }
            case 'n': {
                return this.readAtom("null", (Object)JSONNull.INSTANCE);
            }
        }
        if (!Character.isDigit(this.curr()) && !this.check('-')) {
            this.syntaxError("Invalid character: {" + this.curr() + "}");
        }
        return this.number();
    }

    protected Object _read() throws IOException {
        Object lexeme = this.nextLexeme();
        if (lexeme instanceof Lexeme) {
            switch ((Lexeme)((Object)lexeme)) {
                case ARRAY_START: {
                    return this.array();
                }
                case OBJECT_START: {
                    return this.object();
                }
            }
            return lexeme;
        }
        return lexeme;
    }

    protected Map<String, Object> object() throws IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Object _key = this._read();
        if (_key == Lexeme.OBJECT_END) {
            return ret;
        }
        while (true) {
            if (!(_key instanceof String)) {
                this.expectedMapKey();
            }
            if (this._read() != Lexeme.COLON) {
                this.expectedMapColon();
            }
            ret.put((String)_key, this.read());
            _key = this._read();
            if (_key == Lexeme.OBJECT_END) {
                return ret;
            }
            if (_key != Lexeme.COMMA) {
                this.expectedMapComma();
            }
            _key = this._read();
        }
    }

    protected List<Object> array() throws IOException {
        ArrayList<Object> ret = new ArrayList<Object>();
        Object _value = this._read();
        if (_value == Lexeme.ARRAY_END) {
            return ret;
        }
        while (true) {
            ret.add(this.valueGuard(_value));
            _value = this._read();
            if (_value == Lexeme.ARRAY_END) {
                return ret;
            }
            if (_value != Lexeme.COMMA) {
                this.expectedArrayComma();
            }
            _value = this._read();
        }
    }

    private boolean checkShift(char expected) throws IOException {
        if (this.check(expected)) {
            this.shift();
            return true;
        }
        return false;
    }

    protected Object number() throws IOException {
        this.buf.setLength(0);
        this.checkShift('-');
        this.shiftDigits();
        if (this.checkShift('.')) {
            this.shiftDigits();
        }
        if (this.checkShift('e') || this.checkShift('E')) {
            if (!this.checkShift('+')) {
                this.checkShift('-');
            }
            this.shiftDigits();
        }
        return new BigDecimal(this.buf.toString());
    }

    protected Object string(char sep) throws IOException {
        this.buf.setLength(0);
        while (!this.check(sep)) {
            if (this.checkDrop('\\')) {
                if (this.checkDrop('u')) {
                    this.shiftUnicode();
                    continue;
                }
                int replacement = -1;
                switch (this.curr()) {
                    case '\"': {
                        replacement = 34;
                        break;
                    }
                    case '\\': {
                        replacement = 92;
                        break;
                    }
                    case '/': {
                        replacement = 47;
                        break;
                    }
                    case 'b': {
                        replacement = 8;
                        break;
                    }
                    case 'f': {
                        replacement = 12;
                        break;
                    }
                    case 'n': {
                        replacement = 10;
                        break;
                    }
                    case 'r': {
                        replacement = 13;
                        break;
                    }
                    case 't': {
                        replacement = 9;
                        break;
                    }
                    default: {
                        this.syntaxError("Invalid string escape {" + this.curr() + "}");
                    }
                }
                this.drop();
                this.buf.append((char)replacement);
                continue;
            }
            this.shift();
        }
        this.drop();
        return this.buf.toString();
    }

    private void shift() throws IOException {
        this.buf.append(this.curr());
        this.drop();
    }

    private void shiftDigits() throws IOException {
        while (Character.isDigit(this.buffer())) {
            this.shift();
        }
    }

    private void shiftUnicode() throws IOException {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            switch (this.curr()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + this.curr() - 48;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + this.curr() - 97 + 10;
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + this.curr() - 65 + 10;
                }
            }
            this.drop();
        }
        this.buf.append((char)value);
    }

    void unexpectedLexeme(Lexeme value) throws JSONSyntaxError {
        this.syntaxError("Unexpected lexeme " + value.toString());
    }

    void expectedMapComma() throws JSONSyntaxError {
        this.syntaxError("Expected comma separating map keys or end of map");
    }

    void expectedMapColon() throws JSONSyntaxError {
        this.syntaxError("Expected colon separating key from value");
    }

    void expectedMapKey() throws JSONSyntaxError {
        this.syntaxError("Expected string map key");
    }

    void expectedArrayComma() throws JSONSyntaxError {
        this.syntaxError("Expected comma separating array values or end of array");
    }

    void syntaxError(String message) throws JSONSyntaxError {
        throw new JSONSyntaxError(message, this.reader.getLineNumber());
    }

    public static enum Lexeme {
        OBJECT_START,
        OBJECT_END,
        ARRAY_START,
        ARRAY_END,
        COLON,
        COMMA;

    }
}

