/*
 * Decompiled with CFR 0.152.
 */
package com.leastfixedpoint.json;

import com.leastfixedpoint.json.JSONNull;
import com.leastfixedpoint.json.JSONSerializable;
import com.leastfixedpoint.json.JSONTypeError;
import com.leastfixedpoint.json.JSONWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONValue
implements JSONSerializable {
    protected Object blob;

    public static JSONValue wrap(Object blob) {
        return blob == null ? null : new JSONValue(blob);
    }

    public static Object unwrap(Object value) {
        return value instanceof JSONValue ? ((JSONValue)value).value() : value;
    }

    public static JSONValue newList() {
        return JSONValue.wrap(new ArrayList());
    }

    public static JSONValue newMap() {
        return JSONValue.wrap(new HashMap());
    }

    protected JSONValue(Object blob) {
        this.blob = blob;
    }

    public Object value() {
        return this.blob;
    }

    public String stringValue() throws JSONTypeError {
        if (this.blob instanceof String) {
            return (String)this.blob;
        }
        throw new JSONTypeError(String.class, this.blob);
    }

    public long longValue() throws JSONTypeError {
        if (this.blob instanceof Number) {
            return ((Number)this.blob).longValue();
        }
        throw new JSONTypeError(Number.class, this.blob);
    }

    public double doubleValue() throws JSONTypeError {
        if (this.blob instanceof Number) {
            return ((Number)this.blob).doubleValue();
        }
        throw new JSONTypeError(Number.class, this.blob);
    }

    public BigDecimal bigDecimalValue() throws JSONTypeError {
        if (this.blob instanceof BigDecimal) {
            return (BigDecimal)this.blob;
        }
        if (this.blob instanceof BigInteger) {
            return new BigDecimal((BigInteger)this.blob);
        }
        throw new JSONTypeError(new Class[]{BigDecimal.class, BigInteger.class}, this.blob);
    }

    public boolean booleanValue() throws JSONTypeError {
        if (this.blob instanceof Boolean) {
            return (Boolean)this.blob;
        }
        throw new JSONTypeError(Boolean.class, this.blob);
    }

    public void checkNull() throws JSONTypeError {
        if (this.blob instanceof JSONNull) {
            return;
        }
        throw new JSONTypeError(JSONNull.class, this.blob);
    }

    public List<Object> listValue() throws JSONTypeError {
        if (this.blob instanceof List) {
            return (List)this.blob;
        }
        throw new JSONTypeError(List.class, this.blob);
    }

    public Map<String, Object> mapValue() throws JSONTypeError {
        if (this.blob instanceof Map) {
            return (Map)this.blob;
        }
        throw new JSONTypeError(Map.class, this.blob);
    }

    public JSONValue get(int index) throws JSONTypeError {
        return JSONValue.wrap(this.listValue().get(index));
    }

    public JSONValue set(int index, Object value) throws JSONTypeError {
        this.listValue().set(index, JSONValue.unwrap(value));
        return this;
    }

    public JSONValue add(Object value) throws JSONTypeError {
        this.listValue().add(JSONValue.unwrap(value));
        return this;
    }

    public JSONValue get(String key) throws JSONTypeError {
        return JSONValue.wrap(this.mapValue().get(key));
    }

    public JSONValue put(String key, Object value) throws JSONTypeError {
        this.mapValue().put(key, JSONValue.unwrap(value));
        return this;
    }

    public JSONValue remove(String key) throws JSONTypeError {
        this.mapValue().remove(key);
        return this;
    }

    public boolean containsKey(String key) throws JSONTypeError {
        return this.mapValue().containsKey(key);
    }

    public int size() throws JSONTypeError {
        if (this.blob instanceof Collection) {
            return ((Collection)this.blob).size();
        }
        if (this.blob instanceof Map) {
            return ((Map)this.blob).size();
        }
        throw new JSONTypeError(new Class[]{Collection.class, Map.class}, this.blob);
    }

    @Override
    public void jsonSerialize(JSONWriter w) throws IOException {
        w.write(this.blob);
    }

    public String toString() {
        return this.blob.toString();
    }
}

