/*
 * Decompiled with CFR 0.152.
 */
package com.bfo.json;

import com.bfo.json.Core;
import com.bfo.json.IString;
import com.bfo.json.Json;
import com.bfo.json.SerializerState;
import java.io.IOException;
import java.text.Normalizer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class IMap
extends Core {
    private final Map<String, Json> map = new LinkedHashMap<String, Json>();

    IMap() {
    }

    int size() {
        return this.map.size();
    }

    @Override
    Object value() {
        return this.map;
    }

    @Override
    Map<String, Json> mapValue() {
        return this.map;
    }

    @Override
    String type() {
        return "map";
    }

    Json put(String key, Json value) {
        return this.map.put(key, value);
    }

    Json remove(String key) {
        return this.map.remove(key);
    }

    Json get(String key) {
        return this.map.get(key);
    }

    @Override
    void write(Appendable sb, SerializerState state) throws IOException {
        sb.append("{");
        if (state.prefix != null) {
            state.prefix.append("  ");
            sb.append(state.prefix);
        }
        boolean first = true;
        Set<Map.Entry<String, Json>> set = this.map.entrySet();
        if (state.options.isSorted()) {
            set = new TreeMap<String, Json>(this.map).entrySet();
        }
        for (Map.Entry<String, Json> e : set) {
            Json ovalue;
            Json value;
            String key = e.getKey();
            if (state.options.isNFC()) {
                key = Normalizer.normalize(key, Normalizer.Form.NFC);
            }
            if ((value = state.filter.enter(key, ovalue = e.getValue())) != null) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                    if (state.prefix != null) {
                        sb.append(state.prefix);
                    }
                }
                IString.write(key, sb);
                sb.append(':');
                value.getCore().write(sb, state);
            }
            state.filter.exit(key, ovalue);
        }
        if (state.prefix != null) {
            state.prefix.setLength(state.prefix.length() - 2);
            sb.append(state.prefix);
        }
        sb.append("}");
    }
}

