/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;

public final class ServerImplUtils {
    private ServerImplUtils() {
    }

    public static RaftServerProxy newRaftServer(RaftPeerId id, RaftGroup group, RaftStorage.StartupOption option, StateMachine.Registry stateMachineRegistry, ThreadGroup threadGroup, RaftProperties properties, Parameters parameters) throws IOException {
        RaftServer.LOG.debug("newRaftServer: {}, {}", (Object)id, (Object)group);
        if (group != null && !group.getPeers().isEmpty()) {
            Objects.requireNonNull(id, () -> "RaftPeerId " + id + " is not in RaftGroup " + group);
            Objects.requireNonNull(group.getPeer(id), () -> "RaftPeerId " + id + " is not in RaftGroup " + group);
        }
        RaftServerProxy proxy = ServerImplUtils.newRaftServer(id, stateMachineRegistry, threadGroup, properties, parameters);
        proxy.initGroups(group, option);
        return proxy;
    }

    private static RaftServerProxy newRaftServer(RaftPeerId id, StateMachine.Registry stateMachineRegistry, ThreadGroup threadGroup, RaftProperties properties, Parameters parameters) throws IOException {
        RaftServerProxy proxy;
        TimeDuration sleepTime = TimeDuration.valueOf((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        try {
            proxy = (RaftServerProxy)JavaUtils.attemptRepeatedly(() -> new RaftServerProxy(id, stateMachineRegistry, properties, parameters, threadGroup), (int)5, (TimeDuration)sleepTime, (String)"new RaftServerProxy", (Logger)RaftServer.LOG);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)("Interrupted when creating RaftServer " + id), (InterruptedException)e);
        }
        return proxy;
    }

    public static RaftConfiguration newRaftConfiguration(List<RaftPeer> conf, List<RaftPeer> listener, long index, List<RaftPeer> oldConf, List<RaftPeer> oldListener) {
        RaftConfigurationImpl.Builder b = RaftConfigurationImpl.newBuilder().setConf(conf, listener).setLogEntryIndex(index);
        if (!oldConf.isEmpty() || !oldListener.isEmpty()) {
            b.setOldConf(oldConf, oldListener);
        }
        return b.build();
    }

    static long effectiveCommitIndex(long leaderCommitIndex, TermIndex followerPrevious, int numAppendEntries) {
        long previous = followerPrevious != null ? followerPrevious.getIndex() : 0L;
        return Math.min(leaderCommitIndex, previous + (long)numAppendEntries);
    }

    static void assertGroup(RaftGroupMemberId serverMemberId, RaftClientRequest request) throws GroupMismatchException {
        ServerImplUtils.assertGroup(serverMemberId, request.getRequestorId(), request.getRaftGroupId());
    }

    static void assertGroup(RaftGroupMemberId localMemberId, Object remoteId, RaftGroupId remoteGroupId) throws GroupMismatchException {
        RaftGroupId localGroupId = localMemberId.getGroupId();
        if (!localGroupId.equals((Object)remoteGroupId)) {
            throw new GroupMismatchException(localMemberId + ": The group (" + remoteGroupId + ") of remote " + remoteId + " does not match the group (" + localGroupId + ") of local " + localMemberId.getPeerId());
        }
    }

    static void assertEntries(RaftProtos.AppendEntriesRequestProto proto, TermIndex previous, ServerState state) {
        List entries = proto.getEntriesList();
        if (entries != null && !entries.isEmpty()) {
            long index0 = ((RaftProtos.LogEntryProto)entries.get(0)).getIndex();
            if (index0 != state.getSnapshotIndex() + 1L) {
                long expected = previous == null || previous.getTerm() == 0L ? 0L : previous.getIndex() + 1L;
                Preconditions.assertTrue((index0 == expected ? 1 : 0) != 0, (String)"Unexpected Index: previous is %s but entries[%s].getIndex() == %s != %s", (Object[])new Object[]{previous, 0, index0, expected});
            }
            long leaderTerm = proto.getLeaderTerm();
            for (int i = 0; i < entries.size(); ++i) {
                RaftProtos.LogEntryProto entry = (RaftProtos.LogEntryProto)entries.get(i);
                long entryTerm = entry.getTerm();
                Preconditions.assertTrue((entryTerm <= leaderTerm ? 1 : 0) != 0, (String)"Unexpected Term: entries[%s].getTerm() == %s > leaderTerm == %s", (Object[])new Object[]{i, entryTerm, leaderTerm});
                long indexI = entry.getIndex();
                long expected = index0 + (long)i;
                Preconditions.assertTrue((indexI == expected ? 1 : 0) != 0, (String)"Unexpected Index: entries[0].getIndex() == %s but entries[%s].getIndex() == %s != %s", (Object[])new Object[]{index0, i, indexI, expected});
            }
        }
    }

    static class NavigableIndices {
        private final NavigableMap<Long, ConsecutiveIndices> map = new TreeMap<Long, ConsecutiveIndices>();

        NavigableIndices() {
        }

        boolean contains(TermIndex ti) {
            Long term = this.getTerm(ti.getIndex());
            return term != null && term.longValue() == ti.getTerm();
        }

        synchronized Long getTerm(long index) {
            if (this.map.isEmpty()) {
                return null;
            }
            Map.Entry<Long, ConsecutiveIndices> floorEntry = this.map.floorEntry(index);
            if (floorEntry == null) {
                return null;
            }
            return floorEntry.getValue().getTerm(index);
        }

        synchronized boolean append(List<ConsecutiveIndices> entriesTermIndices) {
            for (int i = 0; i < entriesTermIndices.size(); ++i) {
                ConsecutiveIndices indices = entriesTermIndices.get(i);
                ConsecutiveIndices previous = this.map.put(indices.startIndex, indices);
                if (previous == null) continue;
                this.map.put(previous.startIndex, previous);
                for (int j = 0; j < i; ++j) {
                    this.map.remove(entriesTermIndices.get(j).startIndex);
                }
                return false;
            }
            return true;
        }

        synchronized void removeExisting(List<ConsecutiveIndices> entriesTermIndices) {
            for (ConsecutiveIndices indices : entriesTermIndices) {
                ConsecutiveIndices removed = (ConsecutiveIndices)this.map.remove(indices.startIndex);
                Preconditions.assertSame((Object)indices, (Object)removed, (String)"removed");
            }
        }
    }

    static class ConsecutiveIndices {
        private final long term;
        private final long startIndex;
        private final int count;

        static List<ConsecutiveIndices> convert(List<RaftProtos.LogEntryProto> entries) {
            if (entries == null || entries.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ConsecutiveIndices> indices = null;
            RaftProtos.LogEntryProto previous = entries.get(0);
            long startIndex = previous.getIndex();
            int count = 1;
            for (int i = 1; i < entries.size(); ++i) {
                RaftProtos.LogEntryProto current = entries.get(i);
                Preconditions.assertSame((long)(previous.getIndex() + 1L), (long)current.getIndex(), (String)"index");
                if (current.getTerm() == previous.getTerm()) {
                    ++count;
                } else {
                    Preconditions.assertTrue((previous.getTerm() < current.getTerm() ? 1 : 0) != 0, (Object)"term");
                    if (indices == null) {
                        indices = new ArrayList<ConsecutiveIndices>();
                    }
                    indices.add(new ConsecutiveIndices(previous.getTerm(), startIndex, count));
                    startIndex = current.getIndex();
                    count = 1;
                }
                previous = current;
            }
            ConsecutiveIndices last = new ConsecutiveIndices(previous.getTerm(), startIndex, count);
            if (indices == null) {
                return Collections.singletonList(last);
            }
            indices.add(last);
            return indices;
        }

        ConsecutiveIndices(long term, long startIndex, int count) {
            Preconditions.assertTrue((count > 0 ? 1 : 0) != 0, () -> "count = " + count + " <= 0 ");
            this.term = term;
            this.startIndex = startIndex;
            this.count = count;
        }

        long getNextIndex() {
            return this.startIndex + (long)this.count;
        }

        Long getTerm(long index) {
            long diff = index - this.startIndex;
            return diff < 0L || diff >= (long)this.count ? null : Long.valueOf(this.term);
        }
    }
}

