/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index.impl;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class StateProgressIndex
extends ProgressIndex {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(StateProgressIndex.class) + ProgressIndex.LOCK_SIZE;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final long version;
    private final Map<String, Binary> state;
    private final ProgressIndex innerProgressIndex;

    public StateProgressIndex(long version, Map<String, Binary> state, ProgressIndex innerProgressIndex) {
        this.version = version;
        this.state = new HashMap<String, Binary>(state);
        this.innerProgressIndex = innerProgressIndex;
    }

    public long getVersion() {
        return this.version;
    }

    public ProgressIndex getInnerProgressIndex() {
        return this.innerProgressIndex == null ? MinimumProgressIndex.INSTANCE : this.innerProgressIndex;
    }

    public Map<String, Binary> getState() {
        return ImmutableMap.copyOf(this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.STATE_PROGRESS_INDEX.serialize(byteBuffer);
            ReadWriteIOUtils.write((long)this.version, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)this.state.size(), (ByteBuffer)byteBuffer);
            for (Map.Entry<String, Binary> entry : this.state.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (ByteBuffer)byteBuffer);
                ReadWriteIOUtils.write((Binary)entry.getValue(), (ByteBuffer)byteBuffer);
            }
            this.innerProgressIndex.serialize(byteBuffer);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream stream) throws IOException {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.STATE_PROGRESS_INDEX.serialize(stream);
            ReadWriteIOUtils.write((long)this.version, (OutputStream)stream);
            ReadWriteIOUtils.write((int)this.state.size(), (OutputStream)stream);
            for (Map.Entry<String, Binary> entry : this.state.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)stream);
                ReadWriteIOUtils.write((Binary)entry.getValue(), (OutputStream)stream);
            }
            this.innerProgressIndex.serialize(stream);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isAfter(@Nonnull ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (progressIndex instanceof MinimumProgressIndex) {
                boolean bl = this.innerProgressIndex.isAfter(progressIndex);
                return bl;
            }
            if (progressIndex instanceof HybridProgressIndex) {
                boolean bl = ((HybridProgressIndex)progressIndex).isGivenProgressIndexAfterSelf(this.innerProgressIndex);
                return bl;
            }
            if (!(progressIndex instanceof StateProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.innerProgressIndex.isAfter(((StateProgressIndex)progressIndex).innerProgressIndex) && this.version > ((StateProgressIndex)progressIndex).version;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            boolean bl = progressIndex instanceof StateProgressIndex && this.innerProgressIndex.equals(((StateProgressIndex)progressIndex).innerProgressIndex) && this.version == ((StateProgressIndex)progressIndex).version;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StateProgressIndex)) {
            return false;
        }
        return this.equals((StateProgressIndex)obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.innerProgressIndex, this.version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressIndex updateToMinimumEqualOrIsAfterProgressIndex(ProgressIndex progressIndex) {
        this.lock.writeLock().lock();
        try {
            long version = this.version;
            Map<String, Binary> state = new HashMap<String, Binary>(this.state);
            ProgressIndex innerProgressIndex = this.innerProgressIndex;
            innerProgressIndex = innerProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex(progressIndex instanceof StateProgressIndex ? ((StateProgressIndex)progressIndex).innerProgressIndex : progressIndex);
            if (progressIndex instanceof StateProgressIndex && version <= ((StateProgressIndex)progressIndex).version) {
                version = ((StateProgressIndex)progressIndex).version;
                state = ((StateProgressIndex)progressIndex).state;
            }
            StateProgressIndex stateProgressIndex = new StateProgressIndex(version, state, innerProgressIndex);
            return stateProgressIndex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ProgressIndexType getType() {
        return ProgressIndexType.STATE_PROGRESS_INDEX;
    }

    @Override
    public ProgressIndex.TotalOrderSumTuple getTotalOrderSumTuple() {
        return this.innerProgressIndex.getTotalOrderSumTuple();
    }

    public static StateProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        long version = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        HashMap<String, Binary> state = new HashMap<String, Binary>();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            Binary value = ReadWriteIOUtils.readBinary((ByteBuffer)byteBuffer);
            state.put(key, value);
        }
        ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(byteBuffer);
        return new StateProgressIndex(version, state, progressIndex);
    }

    public static StateProgressIndex deserializeFrom(InputStream stream) throws IOException {
        long version = ReadWriteIOUtils.readLong((InputStream)stream);
        HashMap<String, Binary> state = new HashMap<String, Binary>();
        int size = ReadWriteIOUtils.readInt((InputStream)stream);
        for (int i = 0; i < size; ++i) {
            String key = ReadWriteIOUtils.readString((InputStream)stream);
            Binary value = ReadWriteIOUtils.readBinary((InputStream)stream);
            state.put(key, value);
        }
        ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(stream);
        return new StateProgressIndex(version, state, progressIndex);
    }

    public String toString() {
        return "StateProgressIndex{version=" + this.version + ", state=" + this.state + ", innerProgressIndex=" + this.innerProgressIndex + '}';
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.innerProgressIndex.ramBytesUsed() + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY * (long)this.state.size() + this.state.entrySet().stream().map(entry -> RamUsageEstimator.sizeOf((String)((String)entry.getKey())) + ((Binary)entry.getValue()).ramBytesUsed()).reduce(0L, Long::sum);
    }
}

