/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.memory;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.memory.IMemoryBlock;
import org.apache.iotdb.commons.memory.MemoryBlockType;
import org.apache.iotdb.commons.memory.MemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicLongMemoryBlock
extends IMemoryBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicLongMemoryBlock.class);
    protected final AtomicLong usedMemoryInBytes = new AtomicLong(0L);

    public AtomicLongMemoryBlock(String name, MemoryManager memoryManager, long maxMemorySizeInByte) {
        this.name = name;
        this.memoryManager = memoryManager;
        this.totalMemorySizeInBytes = maxMemorySizeInByte;
        this.memoryBlockType = MemoryBlockType.NONE;
    }

    public AtomicLongMemoryBlock(String name, MemoryManager memoryManager, long maxMemorySizeInByte, MemoryBlockType memoryBlockType) {
        this.name = name;
        this.memoryManager = memoryManager;
        this.totalMemorySizeInBytes = maxMemorySizeInByte;
        this.memoryBlockType = memoryBlockType;
    }

    @Override
    public long forceAllocateWithoutLimitation(long sizeInByte) {
        return this.usedMemoryInBytes.addAndGet(sizeInByte);
    }

    @Override
    public boolean allocate(long sizeInByte) {
        AtomicBoolean result = new AtomicBoolean(false);
        this.usedMemoryInBytes.updateAndGet(memCost -> {
            if (memCost + sizeInByte > this.totalMemorySizeInBytes) {
                return memCost;
            }
            result.set(true);
            return memCost + sizeInByte;
        });
        return result.get();
    }

    @Override
    public boolean allocateIfSufficient(long sizeInByte, double maxRatio) {
        AtomicBoolean result = new AtomicBoolean(false);
        this.usedMemoryInBytes.updateAndGet(memCost -> {
            if ((double)(memCost + sizeInByte) > (double)this.totalMemorySizeInBytes * maxRatio) {
                return memCost;
            }
            result.set(true);
            return memCost + sizeInByte;
        });
        return result.get();
    }

    @Override
    public boolean allocateUntilAvailable(long sizeInByte, long retryIntervalInMillis) throws InterruptedException {
        long originSize = this.usedMemoryInBytes.get();
        while (true) {
            boolean canUpdate;
            boolean bl = canUpdate = originSize + sizeInByte <= this.totalMemorySizeInBytes;
            if (canUpdate && this.usedMemoryInBytes.compareAndSet(originSize, originSize + sizeInByte)) break;
            Thread.sleep(TimeUnit.MILLISECONDS.toMillis(retryIntervalInMillis));
            originSize = this.usedMemoryInBytes.get();
        }
        return true;
    }

    @Override
    public long release(long sizeInByte) {
        return this.usedMemoryInBytes.updateAndGet(memCost -> {
            if (sizeInByte > memCost) {
                LOGGER.warn("The memory cost to be released is larger than the memory cost of memory block {}", (Object)this);
                return 0L;
            }
            return memCost - sizeInByte;
        });
    }

    @Override
    public void setUsedMemoryInBytes(long usedMemoryInBytes) {
        this.usedMemoryInBytes.set(usedMemoryInBytes);
    }

    @Override
    public long getUsedMemoryInBytes() {
        return this.usedMemoryInBytes.get();
    }

    @Override
    public long getFreeMemoryInBytes() {
        return this.totalMemorySizeInBytes - this.usedMemoryInBytes.get();
    }

    public String toString() {
        return "IoTDBMemoryBlock{name=" + this.name + ", isReleased=" + this.isReleased + ", memoryBlockType=" + (Object)((Object)this.memoryBlockType) + ", totalMemorySizeInBytes=" + this.totalMemorySizeInBytes + ", usedMemoryInBytes=" + this.usedMemoryInBytes + '}';
    }

    @Override
    public void close() throws Exception {
        if (this.memoryManager != null) {
            this.memoryManager.release(this);
        }
    }
}

