/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubscriptionStatement;

public class DropSubscription
extends SubscriptionStatement {
    private final String subscriptionId;
    private final boolean ifExistsCondition;

    public DropSubscription(String subscriptionId, boolean ifExistsCondition) {
        this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscription id can not be null");
        this.ifExistsCondition = ifExistsCondition;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean hasIfExistsCondition() {
        return this.ifExistsCondition;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropSubscription(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subscriptionId, this.ifExistsCondition);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropSubscription that = (DropSubscription)obj;
        return Objects.equals(this.subscriptionId, that.subscriptionId) && Objects.equals(this.ifExistsCondition, that.ifExistsCondition);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subscriptionId", (Object)this.subscriptionId).add("ifExistsCondition", this.ifExistsCondition).toString();
    }
}

