/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CallRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=710");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=712");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=711");
    private final RequestHeader requestHeader;
    private final CallMethodRequest[] methodsToCall;

    public CallRequest(RequestHeader requestHeader, CallMethodRequest[] methodsToCall) {
        this.requestHeader = requestHeader;
        this.methodsToCall = methodsToCall;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public CallMethodRequest[] getMethodsToCall() {
        return this.methodsToCall;
    }

    protected CallRequest(CallRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((CallRequestBuilder)b).requestHeader;
        this.methodsToCall = ((CallRequestBuilder)b).methodsToCall;
    }

    public static CallRequestBuilder<?, ?> builder() {
        return new CallRequestBuilderImpl();
    }

    public CallRequestBuilder<?, ?> toBuilder() {
        return new CallRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallRequest)) {
            return false;
        }
        CallRequest other = (CallRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getMethodsToCall(), other.getMethodsToCall());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMethodsToCall());
        return result;
    }

    @Override
    public String toString() {
        return "CallRequest(requestHeader=" + this.getRequestHeader() + ", methodsToCall=" + Arrays.deepToString(this.getMethodsToCall()) + ")";
    }

    private static final class CallRequestBuilderImpl
    extends CallRequestBuilder<CallRequest, CallRequestBuilderImpl> {
        private CallRequestBuilderImpl() {
        }

        @Override
        protected CallRequestBuilderImpl self() {
            return this;
        }

        @Override
        public CallRequest build() {
            return new CallRequest(this);
        }
    }

    public static abstract class CallRequestBuilder<C extends CallRequest, B extends CallRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private CallMethodRequest[] methodsToCall;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CallRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CallRequest instance, CallRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.methodsToCall(instance.methodsToCall);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B methodsToCall(CallMethodRequest[] methodsToCall) {
            this.methodsToCall = methodsToCall;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CallRequest.CallRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", methodsToCall=" + Arrays.deepToString(this.methodsToCall) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CallRequest> {
        @Override
        public Class<CallRequest> getType() {
            return CallRequest.class;
        }

        @Override
        public CallRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            CallMethodRequest[] methodsToCall = (CallMethodRequest[])decoder.readStructArray("MethodsToCall", CallMethodRequest.TYPE_ID);
            return new CallRequest(requestHeader, methodsToCall);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CallRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStructArray("MethodsToCall", (Object[])value.getMethodsToCall(), CallMethodRequest.TYPE_ID);
        }
    }
}

