/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.match.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.library.match.model.Point;
import org.apache.iotdb.library.match.model.SectionNext;

public class Section {
    private double sign;
    private List<Point> points;
    private List<Double> tangents;
    private List<SectionNext> next;
    private int id;

    public double getSign() {
        return this.sign;
    }

    public void setSign(double sign) {
        this.sign = sign;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public List<Double> getTangents() {
        return this.tangents;
    }

    public void setTangents(List<Double> tangents) {
        this.tangents = tangents;
    }

    public List<SectionNext> getNext() {
        return this.next;
    }

    public void setNext(List<SectionNext> next) {
        this.next = next;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Section(double sign) {
        this.sign = sign;
        this.points = new ArrayList<Point>();
        this.tangents = new ArrayList<Double>();
        this.next = new ArrayList<SectionNext>();
    }

    public void concat(Section section) {
        for (Point point : section.getPoints()) {
            this.points.add(point);
        }
        for (Double tangent : section.getTangents()) {
            this.tangents.add(tangent);
        }
    }

    public Section translateXCopy(double offsetX, double offsetOrigX) {
        Section ns = new Section(this.sign);
        ns.setTangents(this.tangents);
        ns.setId(this.getId());
        for (Point point : this.getPoints()) {
            ns.getPoints().add(point.translateXCopy(offsetX, offsetOrigX));
        }
        return ns;
    }

    public Section copy() {
        Section ns = new Section(this.sign);
        ns.setTangents(this.tangents);
        ns.setId(this.getId());
        for (Point point : this.getPoints()) {
            ns.getPoints().add(point.copy());
        }
        return ns;
    }

    public double size() {
        return this.getPoints().get(this.getPoints().size() - 1).getX() - this.getPoints().get(0).getX();
    }

    public double sizeEucl() {
        return Math.sqrt(Math.pow(this.getPoints().get(this.getPoints().size() - 1).getX() - this.getPoints().get(0).getX(), 2.0) + Math.pow(this.getPoints().get(this.getPoints().size() - 1).getY() - this.getPoints().get(0).getY(), 2.0));
    }
}

