/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <string.h>
#include <plc4c/driver_s7_static.h>

#include "syntax_id_type.h"

// Code generated by code-generation. DO NOT EDIT.


// Create an empty NULL-struct
static const plc4c_s7_read_write_syntax_id_type plc4c_s7_read_write_syntax_id_type_null_const;

plc4c_s7_read_write_syntax_id_type plc4c_s7_read_write_syntax_id_type_null() {
  return plc4c_s7_read_write_syntax_id_type_null_const;
}

// Parse function.
plc4c_return_code plc4c_s7_read_write_syntax_id_type_parse(plc4x_spi_context ctx, plc4c_spi_read_buffer* readBuffer, plc4c_s7_read_write_syntax_id_type* _message) {
    plc4c_return_code _res = OK;

    uint8_t value;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &value);
    *_message = plc4c_s7_read_write_syntax_id_type_for_value(value);

    return _res;
}

plc4c_return_code plc4c_s7_read_write_syntax_id_type_serialize(plc4x_spi_context ctx, plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_syntax_id_type* _message) {
    plc4c_return_code _res = OK;

    _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, *_message);

    return _res;
}

plc4c_s7_read_write_syntax_id_type plc4c_s7_read_write_syntax_id_type_for_value(uint8_t value) {
    for(int i = 0; i < plc4c_s7_read_write_syntax_id_type_num_values(); i++) {
        if(plc4c_s7_read_write_syntax_id_type_value_for_index(i) == value) {
            return plc4c_s7_read_write_syntax_id_type_value_for_index(i);
        }
    }
    return -1;
}

plc4c_s7_read_write_syntax_id_type plc4c_s7_read_write_syntax_id_type_value_of(char* value_string) {
    if(strcmp(value_string, "S7ANY") == 0) {
        return plc4c_s7_read_write_syntax_id_type_S7ANY;
    }
    if(strcmp(value_string, "PBC_ID") == 0) {
        return plc4c_s7_read_write_syntax_id_type_PBC_ID;
    }
    if(strcmp(value_string, "ALARM_LOCKFREESET") == 0) {
        return plc4c_s7_read_write_syntax_id_type_ALARM_LOCKFREESET;
    }
    if(strcmp(value_string, "ALARM_INDSET") == 0) {
        return plc4c_s7_read_write_syntax_id_type_ALARM_INDSET;
    }
    if(strcmp(value_string, "ALARM_ACKSET") == 0) {
        return plc4c_s7_read_write_syntax_id_type_ALARM_ACKSET;
    }
    if(strcmp(value_string, "ALARM_QUERYREQSET") == 0) {
        return plc4c_s7_read_write_syntax_id_type_ALARM_QUERYREQSET;
    }
    if(strcmp(value_string, "NOTIFY_INDSET") == 0) {
        return plc4c_s7_read_write_syntax_id_type_NOTIFY_INDSET;
    }
    if(strcmp(value_string, "NCK") == 0) {
        return plc4c_s7_read_write_syntax_id_type_NCK;
    }
    if(strcmp(value_string, "NCK_METRIC") == 0) {
        return plc4c_s7_read_write_syntax_id_type_NCK_METRIC;
    }
    if(strcmp(value_string, "NCK_INCH") == 0) {
        return plc4c_s7_read_write_syntax_id_type_NCK_INCH;
    }
    if(strcmp(value_string, "DRIVEESANY") == 0) {
        return plc4c_s7_read_write_syntax_id_type_DRIVEESANY;
    }
    if(strcmp(value_string, "SYM1200") == 0) {
        return plc4c_s7_read_write_syntax_id_type_SYM1200;
    }
    if(strcmp(value_string, "DBREAD") == 0) {
        return plc4c_s7_read_write_syntax_id_type_DBREAD;
    }
    return -1;
}

int plc4c_s7_read_write_syntax_id_type_num_values() {
  return 13;
}

plc4c_s7_read_write_syntax_id_type plc4c_s7_read_write_syntax_id_type_value_for_index(int index) {
    switch(index) {
      case 0: {
        return plc4c_s7_read_write_syntax_id_type_S7ANY;
      }
      case 1: {
        return plc4c_s7_read_write_syntax_id_type_PBC_ID;
      }
      case 2: {
        return plc4c_s7_read_write_syntax_id_type_ALARM_LOCKFREESET;
      }
      case 3: {
        return plc4c_s7_read_write_syntax_id_type_ALARM_INDSET;
      }
      case 4: {
        return plc4c_s7_read_write_syntax_id_type_ALARM_ACKSET;
      }
      case 5: {
        return plc4c_s7_read_write_syntax_id_type_ALARM_QUERYREQSET;
      }
      case 6: {
        return plc4c_s7_read_write_syntax_id_type_NOTIFY_INDSET;
      }
      case 7: {
        return plc4c_s7_read_write_syntax_id_type_NCK;
      }
      case 8: {
        return plc4c_s7_read_write_syntax_id_type_NCK_METRIC;
      }
      case 9: {
        return plc4c_s7_read_write_syntax_id_type_NCK_INCH;
      }
      case 10: {
        return plc4c_s7_read_write_syntax_id_type_DRIVEESANY;
      }
      case 11: {
        return plc4c_s7_read_write_syntax_id_type_SYM1200;
      }
      case 12: {
        return plc4c_s7_read_write_syntax_id_type_DBREAD;
      }
      default: {
        return -1;
      }
    }
}

uint16_t plc4c_s7_read_write_syntax_id_type_length_in_bytes(plc4x_spi_context ctx, plc4c_s7_read_write_syntax_id_type* _message) {
    return plc4c_s7_read_write_syntax_id_type_length_in_bits(ctx, _message) / 8;
}

uint16_t plc4c_s7_read_write_syntax_id_type_length_in_bits(plc4x_spi_context ctx, plc4c_s7_read_write_syntax_id_type* _message) {
    return 8;
}
