/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"context"
	"strconv"
	"strings"

	"github.com/pkg/errors"

	. "github.com/apache/plc4x/plc4go/protocols/bacnetip/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

type BacnetipXmlParserHelper struct {
}

// Temporary imports to silent compiler warnings (TODO: migrate from static to emission based imports)
func init() {
	_ = strconv.ParseUint
	_ = strconv.ParseInt
	_ = strings.Join
	_ = utils.Dump
}

func (m BacnetipXmlParserHelper) Parse(typeName string, xmlString string, parserArguments ...string) (any, error) {
	switch typeName {
	case "BACnetAuthenticationStatusTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAuthenticationStatusTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetLiftGroupModeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLiftGroupModeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetValueSource":
		return BACnetValueSourceParseWithBuffer[BACnetValueSource](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "NLMUpdateKeyUpdateKeyEntry":
		return NLMUpdateKeyUpdateKeyEntryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetOpeningTag":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumberArgument := uint8(parsedUint0)
		return BACnetOpeningTagParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumberArgument)
	case "BACnetPriorityArray":
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[0])
		parsedUint1, err := strconv.ParseUint(parserArguments[1], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint1)
		// TODO: find a way to parse the sub types
		var arrayIndexArgument BACnetTagPayloadUnsignedInteger
		return BACnetPriorityArrayParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), objectTypeArgument, tagNumber, arrayIndexArgument)
	case "BACnetNameValue":
		return BACnetNameValueParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "SecurityResponseCodeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return SecurityResponseCodeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetPropertyReferenceEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetPropertyReferenceEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetSpecialEvent":
		return BACnetSpecialEventParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetRouterEntry":
		return BACnetRouterEntryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetTagPayloadReal":
		return BACnetTagPayloadRealParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetFaultParameterFaultExtendedParameters":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetFaultParameterFaultExtendedParametersParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetNotificationParametersExtendedParameters":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetNotificationParametersExtendedParametersParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetLoggingTypeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLoggingTypeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilterParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetTimeValue":
		return BACnetTimeValueParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetTagPayloadOctetString":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 32)
		if err != nil {
			return nil, err
		}
		actualLength := uint32(parsedUint0)
		return BACnetTagPayloadOctetStringParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), actualLength)
	case "BACnetEscalatorOperationDirectionTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetEscalatorOperationDirectionTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "NPDUControl":
		return NPDUControlParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetFaultParameterFaultStateListOfFaultValues":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetFaultParameterFaultStateListOfFaultValuesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetTimeStampEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetTimeStampEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetTimerStateTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetTimerStateTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetDateRangeEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetDateRangeEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetEventParameterChangeOfTimerAlarmValue":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventParameterChangeOfTimerAlarmValueParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetUnconfirmedServiceRequest":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 16)
		if err != nil {
			return nil, err
		}
		serviceRequestLength := uint16(parsedUint0)
		return BACnetUnconfirmedServiceRequestParseWithBuffer[BACnetUnconfirmedServiceRequest](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), serviceRequestLength)
	case "BACnetAddressEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetAddressEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetObjectTypeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetObjectTypeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetDaysOfWeekTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetDaysOfWeekTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetReadAccessResultListOfResults":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[1])
		return BACnetReadAccessResultListOfResultsParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, objectTypeArgument)
	case "BACnetRouterEntryStatusTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetRouterEntryStatusTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetAccessRuleTimeRangeSpecifierTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAccessRuleTimeRangeSpecifierTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetObjectTypesSupportedTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetObjectTypesSupportedTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BVLCBroadcastDistributionTableEntry":
		return BVLCBroadcastDistributionTableEntryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetBackupStateTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetBackupStateTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValues":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValuesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetDestination":
		return BACnetDestinationParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecification":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetDeviceStatusTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetDeviceStatusTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetPrescale":
		return BACnetPrescaleParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ErrorEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return ErrorEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetAuthenticationPolicyListEntry":
		return BACnetAuthenticationPolicyListEntryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "APDU":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 16)
		if err != nil {
			return nil, err
		}
		apduLength := uint16(parsedUint0)
		return APDUParseWithBuffer[APDU](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), apduLength)
	case "BACnetEventNotificationSubscription":
		return BACnetEventNotificationSubscriptionParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetSegmentationTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetSegmentationTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetSecurityKeySet":
		return BACnetSecurityKeySetParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetNetworkSecurityPolicy":
		return BACnetNetworkSecurityPolicyParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetHostNPortEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetHostNPortEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetPropertyIdentifierTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetPropertyIdentifierTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetRecipientEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetRecipientEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetConfirmedServiceRequest":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 32)
		if err != nil {
			return nil, err
		}
		serviceRequestLength := uint32(parsedUint0)
		return BACnetConfirmedServiceRequestParseWithBuffer[BACnetConfirmedServiceRequest](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), serviceRequestLength)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferences":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetTagPayloadUnsignedInteger":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 32)
		if err != nil {
			return nil, err
		}
		actualLength := uint32(parsedUint0)
		return BACnetTagPayloadUnsignedIntegerParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), actualLength)
	case "BACnetAccessUserTypeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAccessUserTypeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetRestartReasonTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetRestartReasonTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetTagPayloadBitString":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 32)
		if err != nil {
			return nil, err
		}
		actualLength := uint32(parsedUint0)
		return BACnetTagPayloadBitStringParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), actualLength)
	case "BACnetClientCOV":
		return BACnetClientCOVParseWithBuffer[BACnetClientCOV](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetSetpointReference":
		return BACnetSetpointReferenceParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetObjectPropertyReferenceEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetObjectPropertyReferenceEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetEscalatorFaultTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetEscalatorFaultTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetEventStateTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetEventStateTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetTagHeader":
		return BACnetTagHeaderParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetTagPayloadBoolean":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 32)
		if err != nil {
			return nil, err
		}
		actualLength := uint32(parsedUint0)
		return BACnetTagPayloadBooleanParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), actualLength)
	case "BACnetFaultTypeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetFaultTypeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "VTCloseErrorListOfVTSessionIdentifiers":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return VTCloseErrorListOfVTSessionIdentifiersParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecifications":
		return BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetIPModeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetIPModeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetAccumulatorRecord":
		return BACnetAccumulatorRecordParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetDailySchedule":
		return BACnetDailyScheduleParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetLogDataLogDataEntry":
		return BACnetLogDataLogDataEntryParseWithBuffer[BACnetLogDataLogDataEntry](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetOptionalBinaryPV":
		return BACnetOptionalBinaryPVParseWithBuffer[BACnetOptionalBinaryPV](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetBDTEntry":
		return BACnetBDTEntryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetEngineeringUnitsTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetEngineeringUnitsTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "ListOfCovNotifications":
		return ListOfCovNotificationsParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetAssignedAccessRights":
		return BACnetAssignedAccessRightsParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetConfirmedServiceRequestCreateObjectObjectSpecifier":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetConfirmedServiceRequestCreateObjectObjectSpecifierParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetAuthenticationPolicy":
		return BACnetAuthenticationPolicyParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetPropertyAccessResult":
		return BACnetPropertyAccessResultParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsList":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsListParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "NPDU":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 16)
		if err != nil {
			return nil, err
		}
		npduLength := uint16(parsedUint0)
		return NPDUParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), npduLength)
	case "BACnetProgramStateTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetProgramStateTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetDoorSecuredStatusTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetDoorSecuredStatusTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "ErrorClassTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return ErrorClassTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetSpecialEventListOfTimeValues":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetSpecialEventListOfTimeValuesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetFaultParameterFaultOutOfRangeMaxNormalValue":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetFaultParameterFaultOutOfRangeMaxNormalValueParseWithBuffer[BACnetFaultParameterFaultOutOfRangeMaxNormalValue](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetAccessRuleLocationSpecifierTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAccessRuleLocationSpecifierTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesEntry":
		return BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesEntryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetAuthenticationFactorFormat":
		return BACnetAuthenticationFactorFormatParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetMaintenanceTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetMaintenanceTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetNotificationParametersChangeOfDiscreteValueNewValue":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetNotificationParametersChangeOfDiscreteValueNewValueParseWithBuffer[BACnetNotificationParametersChangeOfDiscreteValueNewValue](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetReadAccessPropertyReadResult":
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[0])
		propertyIdentifierArgument, _ := BACnetPropertyIdentifierByName(parserArguments[1])
		// TODO: find a way to parse the sub types
		var arrayIndexArgument BACnetTagPayloadUnsignedInteger
		return BACnetReadAccessPropertyReadResultParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetActionCommand":
		return BACnetActionCommandParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetFaultParameterFaultExtendedParametersEntry":
		return BACnetFaultParameterFaultExtendedParametersEntryParseWithBuffer[BACnetFaultParameterFaultExtendedParametersEntry](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetTagPayloadDate":
		return BACnetTagPayloadDateParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetEventParameterExtendedParameters":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventParameterExtendedParametersParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetEventParameterAccessEventListOfAccessEvents":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventParameterAccessEventListOfAccessEventsParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetReadAccessProperty":
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[0])
		return BACnetReadAccessPropertyParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), objectTypeArgument)
	case "BACnetLifeSafetyOperationTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLifeSafetyOperationTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetWeekNDayTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetWeekNDayTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetEventTransitionBitsTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetEventTransitionBitsTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetLogData":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetLogDataParseWithBuffer[BACnetLogData](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetFaultParameterFaultCharacterStringListOfFaultValues":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetFaultParameterFaultCharacterStringListOfFaultValuesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetLockStatusTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLockStatusTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetDeviceObjectPropertyReferenceEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetDeviceObjectPropertyReferenceEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetPropertyStates":
		return BACnetPropertyStatesParseWithBuffer[BACnetPropertyStates](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetReadAccessResult":
		return BACnetReadAccessResultParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetResultFlagsTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetResultFlagsTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetAccessCredentialDisableReasonTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAccessCredentialDisableReasonTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetLightingInProgressTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLightingInProgressTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetLifeSafetyStateTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLifeSafetyStateTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetVTSession":
		return BACnetVTSessionParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetEventTimestampsEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventTimestampsEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetSecurityLevelTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetSecurityLevelTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetLogRecordLogDatum":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetLogRecordLogDatumParseWithBuffer[BACnetLogRecordLogDatum](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetDateTimeEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetDateTimeEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetTimerTransitionTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetTimerTransitionTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetLogMultipleRecord":
		return BACnetLogMultipleRecordParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetProgramRequestTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetProgramRequestTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetDateRange":
		return BACnetDateRangeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetEventParameter":
		return BACnetEventParameterParseWithBuffer[BACnetEventParameter](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetLiftFaultTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLiftFaultTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetPropertyStatesEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetPropertyStatesEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetGroupChannelValueList":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetGroupChannelValueListParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetFileAccessMethodTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetFileAccessMethodTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetTagPayloadCharacterString":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 32)
		if err != nil {
			return nil, err
		}
		actualLength := uint32(parsedUint0)
		return BACnetTagPayloadCharacterStringParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), actualLength)
	case "BACnetEventLogRecordLogDatum":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventLogRecordLogDatumParseWithBuffer[BACnetEventLogRecordLogDatum](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetStatusFlagsTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetStatusFlagsTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetNodeTypeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetNodeTypeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetOptionalCharacterString":
		return BACnetOptionalCharacterStringParseWithBuffer[BACnetOptionalCharacterString](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetAddress":
		return BACnetAddressParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetEventParameterChangeOfLifeSavetyListOfAlarmValues":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventParameterChangeOfLifeSavetyListOfAlarmValuesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsReference":
		return BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsReferenceParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetApplicationTag":
		return BACnetApplicationTagParseWithBuffer[BACnetApplicationTag](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetEventParameterChangeOfBitstringListOfBitstringValues":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventParameterChangeOfBitstringListOfBitstringValuesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetShedLevel":
		return BACnetShedLevelParseWithBuffer[BACnetShedLevel](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetActionTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetActionTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetCredentialAuthenticationFactor":
		return BACnetCredentialAuthenticationFactorParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetAssignedLandingCallsLandingCallsListEntry":
		return BACnetAssignedLandingCallsLandingCallsListEntryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetPropertyValue":
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[0])
		return BACnetPropertyValueParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), objectTypeArgument)
	case "BACnetCOVSubscription":
		return BACnetCOVSubscriptionParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetFaultParameterFaultLifeSafetyListOfFaultValues":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetFaultParameterFaultLifeSafetyListOfFaultValuesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetRelationshipTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetRelationshipTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetRecipientProcessEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetRecipientProcessEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetAccessRule":
		return BACnetAccessRuleParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetHostNPort":
		return BACnetHostNPortParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetShedStateTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetShedStateTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetAccessEventTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAccessEventTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetServiceAck":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 32)
		if err != nil {
			return nil, err
		}
		serviceAckLength := uint32(parsedUint0)
		return BACnetServiceAckParseWithBuffer[BACnetServiceAck](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), serviceAckLength)
	case "BACnetAccessCredentialDisableTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAccessCredentialDisableTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetLiftCarCallList":
		return BACnetLiftCarCallListParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetLightingTransitionTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLightingTransitionTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "NLMUpdateKeyUpdateControlFlags":
		return NLMUpdateKeyUpdateControlFlagsParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetAssignedLandingCalls":
		return BACnetAssignedLandingCallsParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetNotifyTypeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetNotifyTypeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetAuthorizationExemptionTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAuthorizationExemptionTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetLandingDoorStatusLandingDoorsList":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetLandingDoorStatusLandingDoorsListParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDeviceTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDeviceTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetAuthenticationFactorTypeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAuthenticationFactorTypeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetAccessAuthenticationFactorDisableTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAccessAuthenticationFactorDisableTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetAuthorizationModeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAuthorizationModeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestConfirmedTextMessageMessagePriorityTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetConfirmedServiceRequestConfirmedTextMessageMessagePriorityTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetDoorStatusTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetDoorStatusTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetVendorIdTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetVendorIdTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetEventTimestamps":
		return BACnetEventTimestampsParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetNameValueCollection":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetNameValueCollectionParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetTagPayloadEnumerated":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 32)
		if err != nil {
			return nil, err
		}
		actualLength := uint32(parsedUint0)
		return BACnetTagPayloadEnumeratedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), actualLength)
	case "BACnetLimitEnableTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLimitEnableTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetDoorAlarmStateTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetDoorAlarmStateTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetServicesSupportedTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetServicesSupportedTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetWriteStatusTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetWriteStatusTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetRecipientProcess":
		return BACnetRecipientProcessParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetReadAccessSpecification":
		return BACnetReadAccessSpecificationParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetAuthenticationPolicyList":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetAuthenticationPolicyListParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetLandingDoorStatus":
		return BACnetLandingDoorStatusParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetLiftCarCallListFloorList":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetLiftCarCallListFloorListParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetAccessThreatLevel":
		return BACnetAccessThreatLevelParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetCalendarEntryEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetCalendarEntryEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetRecipient":
		return BACnetRecipientParseWithBuffer[BACnetRecipient](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetLiftCarDriveStatusTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLiftCarDriveStatusTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetUnconfirmedServiceRequestWhoHasObject":
		return BACnetUnconfirmedServiceRequestWhoHasObjectParseWithBuffer[BACnetUnconfirmedServiceRequestWhoHasObject](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetTagPayloadSignedInteger":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 32)
		if err != nil {
			return nil, err
		}
		actualLength := uint32(parsedUint0)
		return BACnetTagPayloadSignedIntegerParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), actualLength)
	case "BACnetSecurityPolicyTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetSecurityPolicyTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord":
		return BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecordParseWithBuffer[BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BVLC":
		return BVLCParseWithBuffer[BVLC](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ConfirmedEventNotificationRequest":
		return ConfirmedEventNotificationRequestParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetLandingDoorStatusLandingDoorsListEntry":
		return BACnetLandingDoorStatusLandingDoorsListEntryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetLiftCarDirectionTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLiftCarDirectionTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestConfirmedTextMessageMessageClass":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetConfirmedServiceRequestConfirmedTextMessageMessageClassParseWithBuffer[BACnetConfirmedServiceRequestConfirmedTextMessageMessageClass](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetAddressBinding":
		return BACnetAddressBindingParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetLandingCallStatusCommand":
		return BACnetLandingCallStatusCommandParseWithBuffer[BACnetLandingCallStatusCommand](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ListOfCovNotificationsValue":
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[0])
		return ListOfCovNotificationsValueParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), objectTypeArgument)
	case "BACnetLandingCallStatus":
		return BACnetLandingCallStatusParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetEventParameterChangeOfStateListOfValues":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventParameterChangeOfStateListOfValuesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetPortPermission":
		return BACnetPortPermissionParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetConfirmedServiceRequestReadRangeRange":
		return BACnetConfirmedServiceRequestReadRangeRangeParseWithBuffer[BACnetConfirmedServiceRequestReadRangeRange](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetError":
		errorChoice, _ := BACnetConfirmedServiceChoiceByName(parserArguments[0])
		return BACnetErrorParseWithBuffer[BACnetError](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), errorChoice)
	case "BACnetDeviceObjectReferenceEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetDeviceObjectReferenceEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetOptionalUnsigned":
		return BACnetOptionalUnsignedParseWithBuffer[BACnetOptionalUnsigned](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetHostAddress":
		return BACnetHostAddressParseWithBuffer[BACnetHostAddress](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "ListOfCovNotificationsList":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return ListOfCovNotificationsListParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetEventSummariesList":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventSummariesListParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetVTClassTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetVTClassTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetDeviceObjectPropertyReference":
		return BACnetDeviceObjectPropertyReferenceParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisableTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisableTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetProcessIdSelection":
		return BACnetProcessIdSelectionParseWithBuffer[BACnetProcessIdSelection](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetAssignedLandingCallsLandingCallsList":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetAssignedLandingCallsLandingCallsListParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetTagPayloadDouble":
		return BACnetTagPayloadDoubleParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetAccumulatorRecordAccumulatorStatusTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAccumulatorRecordAccumulatorStatusTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetTimerStateChangeValue":
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[0])
		return BACnetTimerStateChangeValueParseWithBuffer[BACnetTimerStateChangeValue](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), objectTypeArgument)
	case "BACnetSpecialEventPeriod":
		return BACnetSpecialEventPeriodParseWithBuffer[BACnetSpecialEventPeriod](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetKeyIdentifier":
		return BACnetKeyIdentifierParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetNetworkNumberQualityTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetNetworkNumberQualityTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetLogStatusTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLogStatusTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetAbortReasonTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 32)
		if err != nil {
			return nil, err
		}
		actualLength := uint32(parsedUint0)
		return BACnetAbortReasonTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), actualLength)
	case "BACnetProgramErrorTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetProgramErrorTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "Error":
		return ErrorParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetPropertyReference":
		return BACnetPropertyReferenceParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetContextTag":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumberArgument := uint8(parsedUint0)
		dataType, _ := BACnetDataTypeByName(parserArguments[1])
		return BACnetContextTagParseWithBuffer[BACnetContextTag](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumberArgument, dataType)
	case "BACnetUnconfirmedServiceChoiceTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetUnconfirmedServiceChoiceTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BVLCResultCodeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BVLCResultCodeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetFaultParameter":
		return BACnetFaultParameterParseWithBuffer[BACnetFaultParameter](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetEventParameterChangeOfValueCivCriteria":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventParameterChangeOfValueCivCriteriaParseWithBuffer[BACnetEventParameterChangeOfValueCivCriteria](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetPriorityValue":
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[0])
		return BACnetPriorityValueParseWithBuffer[BACnetPriorityValue](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), objectTypeArgument)
	case "BACnetLogRecord":
		return BACnetLogRecordParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetCalendarEntry":
		return BACnetCalendarEntryParseWithBuffer[BACnetCalendarEntry](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetAccessPassbackModeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAccessPassbackModeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetDeviceObjectReference":
		return BACnetDeviceObjectReferenceParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BVLCForeignDeviceTableEntry":
		return BVLCForeignDeviceTableEntryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "NLM":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 16)
		if err != nil {
			return nil, err
		}
		apduLength := uint16(parsedUint0)
		return NLMParseWithBuffer[NLM](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), apduLength)
	case "BACnetWeekNDay":
		return BACnetWeekNDayParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "NLMInitializeRoutingTablePortMapping":
		return NLMInitializeRoutingTablePortMappingParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "NPDUNetworkPriorityTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return NPDUNetworkPriorityTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetReliabilityTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetReliabilityTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetDoorValueTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetDoorValueTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetScale":
		return BACnetScaleParseWithBuffer[BACnetScale](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetNotificationParametersChangeOfValueNewValue":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetNotificationParametersChangeOfValueNewValueParseWithBuffer[BACnetNotificationParametersChangeOfValueNewValue](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "ErrorCodeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return ErrorCodeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BacnetConstants":
		return BacnetConstantsParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetPolarityTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetPolarityTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetServiceAckAtomicReadFileStreamOrRecord":
		return BACnetServiceAckAtomicReadFileStreamOrRecordParseWithBuffer[BACnetServiceAckAtomicReadFileStreamOrRecord](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetChannelValue":
		return BACnetChannelValueParseWithBuffer[BACnetChannelValue](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetConstructedData":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[1])
		propertyIdentifierArgument, _ := BACnetPropertyIdentifierByName(parserArguments[2])
		// TODO: find a way to parse the sub types
		var arrayIndexArgument BACnetTagPayloadUnsignedInteger
		return BACnetConstructedDataParseWithBuffer[BACnetConstructedData](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetEventTypeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetEventTypeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetObjectPropertyReference":
		return BACnetObjectPropertyReferenceParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetBinaryLightingPVTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetBinaryLightingPVTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetOptionalREAL":
		return BACnetOptionalREALParseWithBuffer[BACnetOptionalREAL](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetTagPayloadTime":
		return BACnetTagPayloadTimeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetAuthenticationFactorEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetAuthenticationFactorEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetEventSummary":
		return BACnetEventSummaryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetAccessZoneOccupancyStateTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetAccessZoneOccupancyStateTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetPropertyAccessResultAccessResult":
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[0])
		propertyIdentifierArgument, _ := BACnetPropertyIdentifierByName(parserArguments[1])
		// TODO: find a way to parse the sub types
		var propertyArrayIndexArgument BACnetTagPayloadUnsignedInteger
		return BACnetPropertyAccessResultAccessResultParseWithBuffer[BACnetPropertyAccessResultAccessResult](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), objectTypeArgument, propertyIdentifierArgument, propertyArrayIndexArgument)
	case "BACnetNetworkPortCommandTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetNetworkPortCommandTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetGroupChannelValue":
		return BACnetGroupChannelValueParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetRejectReasonTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 32)
		if err != nil {
			return nil, err
		}
		actualLength := uint32(parsedUint0)
		return BACnetRejectReasonTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), actualLength)
	case "BACnetEscalatorModeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetEscalatorModeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetTagPayloadObjectIdentifier":
		return BACnetTagPayloadObjectIdentifierParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetPropertyWriteDefinition":
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[0])
		return BACnetPropertyWriteDefinitionParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), objectTypeArgument)
	case "BACnetEventLogRecord":
		return BACnetEventLogRecordParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetBinaryPVTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetBinaryPVTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetEventPriorities":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventPrioritiesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetDateTime":
		return BACnetDateTimeParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetLightingOperationTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLightingOperationTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetFaultParameterFaultOutOfRangeMinNormalValue":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetFaultParameterFaultOutOfRangeMinNormalValueParseWithBuffer[BACnetFaultParameterFaultOutOfRangeMinNormalValue](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetEventParameterChangeOfCharacterStringListOfAlarmValues":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetEventParameterChangeOfCharacterStringListOfAlarmValuesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetSecurityKeySetKeyIds":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetSecurityKeySetKeyIdsParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetVMACEntry":
		return BACnetVMACEntryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetTimeStamp":
		return BACnetTimeStampParseWithBuffer[BACnetTimeStamp](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetNotificationParameters":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[1])
		return BACnetNotificationParametersParseWithBuffer[BACnetNotificationParameters](context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, objectTypeArgument)
	case "BACnetClosingTag":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumberArgument := uint8(parsedUint0)
		return BACnetClosingTagParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumberArgument)
	case "BACnetTimeStampsEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetTimeStampsEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry":
		return BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetHostAddressEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetHostAddressEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetNetworkTypeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetNetworkTypeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetConstructedDataElement":
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[0])
		propertyIdentifierArgument, _ := BACnetPropertyIdentifierByName(parserArguments[1])
		// TODO: find a way to parse the sub types
		var arrayIndexArgument BACnetTagPayloadUnsignedInteger
		return BACnetConstructedDataElementParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetPropertyValues":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		objectTypeArgument, _ := BACnetObjectTypeByName(parserArguments[1])
		return BACnetPropertyValuesParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, objectTypeArgument)
	case "BACnetProtocolLevelTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetProtocolLevelTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetCOVMultipleSubscription":
		return BACnetCOVMultipleSubscriptionParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetActionList":
		return BACnetActionListParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetLightingCommand":
		return BACnetLightingCommandParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "SubscribeCOVPropertyMultipleErrorFirstFailedSubscription":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return SubscribeCOVPropertyMultipleErrorFirstFailedSubscriptionParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetAuthenticationFactor":
		return BACnetAuthenticationFactorParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetWriteAccessSpecification":
		return BACnetWriteAccessSpecificationParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)))
	case "BACnetLightingCommandEnclosed":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		return BACnetLightingCommandEnclosedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber)
	case "BACnetLiftCarDoorCommandTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLiftCarDoorCommandTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetLiftCarModeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLiftCarModeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetSilencedStateTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetSilencedStateTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	case "BACnetLifeSafetyModeTagged":
		parsedUint0, err := strconv.ParseUint(parserArguments[0], 10, 8)
		if err != nil {
			return nil, err
		}
		tagNumber := uint8(parsedUint0)
		tagClass, _ := TagClassByName(parserArguments[1])
		return BACnetLifeSafetyModeTaggedParseWithBuffer(context.Background(), utils.NewXmlReadBuffer(strings.NewReader(xmlString)), tagNumber, tagClass)
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
