/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataCredentials is the corresponding interface of BACnetConstructedDataCredentials
type BACnetConstructedDataCredentials interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetCredentials returns Credentials (property field)
	GetCredentials() []BACnetDeviceObjectReference
	// IsBACnetConstructedDataCredentials is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataCredentials()
	// CreateBuilder creates a BACnetConstructedDataCredentialsBuilder
	CreateBACnetConstructedDataCredentialsBuilder() BACnetConstructedDataCredentialsBuilder
}

// _BACnetConstructedDataCredentials is the data-structure of this message
type _BACnetConstructedDataCredentials struct {
	BACnetConstructedDataContract
	Credentials []BACnetDeviceObjectReference
}

var _ BACnetConstructedDataCredentials = (*_BACnetConstructedDataCredentials)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataCredentials)(nil)

// NewBACnetConstructedDataCredentials factory function for _BACnetConstructedDataCredentials
func NewBACnetConstructedDataCredentials(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, credentials []BACnetDeviceObjectReference, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataCredentials {
	_result := &_BACnetConstructedDataCredentials{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		Credentials:                   credentials,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataCredentialsBuilder is a builder for BACnetConstructedDataCredentials
type BACnetConstructedDataCredentialsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(credentials []BACnetDeviceObjectReference) BACnetConstructedDataCredentialsBuilder
	// WithCredentials adds Credentials (property field)
	WithCredentials(...BACnetDeviceObjectReference) BACnetConstructedDataCredentialsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataCredentials or returns an error if something is wrong
	Build() (BACnetConstructedDataCredentials, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataCredentials
}

// NewBACnetConstructedDataCredentialsBuilder() creates a BACnetConstructedDataCredentialsBuilder
func NewBACnetConstructedDataCredentialsBuilder() BACnetConstructedDataCredentialsBuilder {
	return &_BACnetConstructedDataCredentialsBuilder{_BACnetConstructedDataCredentials: new(_BACnetConstructedDataCredentials)}
}

type _BACnetConstructedDataCredentialsBuilder struct {
	*_BACnetConstructedDataCredentials

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataCredentialsBuilder) = (*_BACnetConstructedDataCredentialsBuilder)(nil)

func (b *_BACnetConstructedDataCredentialsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataCredentials
}

func (b *_BACnetConstructedDataCredentialsBuilder) WithMandatoryFields(credentials []BACnetDeviceObjectReference) BACnetConstructedDataCredentialsBuilder {
	return b.WithCredentials(credentials...)
}

func (b *_BACnetConstructedDataCredentialsBuilder) WithCredentials(credentials ...BACnetDeviceObjectReference) BACnetConstructedDataCredentialsBuilder {
	b.Credentials = credentials
	return b
}

func (b *_BACnetConstructedDataCredentialsBuilder) Build() (BACnetConstructedDataCredentials, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataCredentials.deepCopy(), nil
}

func (b *_BACnetConstructedDataCredentialsBuilder) MustBuild() BACnetConstructedDataCredentials {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataCredentialsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataCredentialsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataCredentialsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataCredentialsBuilder().(*_BACnetConstructedDataCredentialsBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataCredentialsBuilder creates a BACnetConstructedDataCredentialsBuilder
func (b *_BACnetConstructedDataCredentials) CreateBACnetConstructedDataCredentialsBuilder() BACnetConstructedDataCredentialsBuilder {
	if b == nil {
		return NewBACnetConstructedDataCredentialsBuilder()
	}
	return &_BACnetConstructedDataCredentialsBuilder{_BACnetConstructedDataCredentials: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataCredentials) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataCredentials) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_CREDENTIALS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataCredentials) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataCredentials) GetCredentials() []BACnetDeviceObjectReference {
	return m.Credentials
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataCredentials(structType any) BACnetConstructedDataCredentials {
	if casted, ok := structType.(BACnetConstructedDataCredentials); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataCredentials); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataCredentials) GetTypeName() string {
	return "BACnetConstructedDataCredentials"
}

func (m *_BACnetConstructedDataCredentials) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.Credentials) > 0 {
		for _, element := range m.Credentials {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataCredentials) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataCredentials) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataCredentials BACnetConstructedDataCredentials, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataCredentials"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataCredentials")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	credentials, err := ReadTerminatedArrayField[BACnetDeviceObjectReference](ctx, "credentials", ReadComplex[BACnetDeviceObjectReference](BACnetDeviceObjectReferenceParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'credentials' field"))
	}
	m.Credentials = credentials

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataCredentials"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataCredentials")
	}

	return m, nil
}

func (m *_BACnetConstructedDataCredentials) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataCredentials) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataCredentials"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataCredentials")
		}

		if err := WriteComplexTypeArrayField(ctx, "credentials", m.GetCredentials(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'credentials' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataCredentials"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataCredentials")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataCredentials) IsBACnetConstructedDataCredentials() {}

func (m *_BACnetConstructedDataCredentials) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataCredentials) deepCopy() *_BACnetConstructedDataCredentials {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataCredentialsCopy := &_BACnetConstructedDataCredentials{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetDeviceObjectReference, BACnetDeviceObjectReference](m.Credentials),
	}
	_BACnetConstructedDataCredentialsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataCredentialsCopy
}

func (m *_BACnetConstructedDataCredentials) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
