/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataUpdateTime is the corresponding interface of BACnetConstructedDataUpdateTime
type BACnetConstructedDataUpdateTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetUpdateTime returns UpdateTime (property field)
	GetUpdateTime() BACnetDateTime
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDateTime
	// IsBACnetConstructedDataUpdateTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataUpdateTime()
	// CreateBuilder creates a BACnetConstructedDataUpdateTimeBuilder
	CreateBACnetConstructedDataUpdateTimeBuilder() BACnetConstructedDataUpdateTimeBuilder
}

// _BACnetConstructedDataUpdateTime is the data-structure of this message
type _BACnetConstructedDataUpdateTime struct {
	BACnetConstructedDataContract
	UpdateTime BACnetDateTime
}

var _ BACnetConstructedDataUpdateTime = (*_BACnetConstructedDataUpdateTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataUpdateTime)(nil)

// NewBACnetConstructedDataUpdateTime factory function for _BACnetConstructedDataUpdateTime
func NewBACnetConstructedDataUpdateTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, updateTime BACnetDateTime, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataUpdateTime {
	if updateTime == nil {
		panic("updateTime of type BACnetDateTime for BACnetConstructedDataUpdateTime must not be nil")
	}
	_result := &_BACnetConstructedDataUpdateTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		UpdateTime:                    updateTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataUpdateTimeBuilder is a builder for BACnetConstructedDataUpdateTime
type BACnetConstructedDataUpdateTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(updateTime BACnetDateTime) BACnetConstructedDataUpdateTimeBuilder
	// WithUpdateTime adds UpdateTime (property field)
	WithUpdateTime(BACnetDateTime) BACnetConstructedDataUpdateTimeBuilder
	// WithUpdateTimeBuilder adds UpdateTime (property field) which is build by the builder
	WithUpdateTimeBuilder(func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataUpdateTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataUpdateTime or returns an error if something is wrong
	Build() (BACnetConstructedDataUpdateTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataUpdateTime
}

// NewBACnetConstructedDataUpdateTimeBuilder() creates a BACnetConstructedDataUpdateTimeBuilder
func NewBACnetConstructedDataUpdateTimeBuilder() BACnetConstructedDataUpdateTimeBuilder {
	return &_BACnetConstructedDataUpdateTimeBuilder{_BACnetConstructedDataUpdateTime: new(_BACnetConstructedDataUpdateTime)}
}

type _BACnetConstructedDataUpdateTimeBuilder struct {
	*_BACnetConstructedDataUpdateTime

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataUpdateTimeBuilder) = (*_BACnetConstructedDataUpdateTimeBuilder)(nil)

func (b *_BACnetConstructedDataUpdateTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataUpdateTime
}

func (b *_BACnetConstructedDataUpdateTimeBuilder) WithMandatoryFields(updateTime BACnetDateTime) BACnetConstructedDataUpdateTimeBuilder {
	return b.WithUpdateTime(updateTime)
}

func (b *_BACnetConstructedDataUpdateTimeBuilder) WithUpdateTime(updateTime BACnetDateTime) BACnetConstructedDataUpdateTimeBuilder {
	b.UpdateTime = updateTime
	return b
}

func (b *_BACnetConstructedDataUpdateTimeBuilder) WithUpdateTimeBuilder(builderSupplier func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataUpdateTimeBuilder {
	builder := builderSupplier(b.UpdateTime.CreateBACnetDateTimeBuilder())
	var err error
	b.UpdateTime, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDateTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataUpdateTimeBuilder) Build() (BACnetConstructedDataUpdateTime, error) {
	if b.UpdateTime == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'updateTime' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataUpdateTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataUpdateTimeBuilder) MustBuild() BACnetConstructedDataUpdateTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataUpdateTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataUpdateTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataUpdateTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataUpdateTimeBuilder().(*_BACnetConstructedDataUpdateTimeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataUpdateTimeBuilder creates a BACnetConstructedDataUpdateTimeBuilder
func (b *_BACnetConstructedDataUpdateTime) CreateBACnetConstructedDataUpdateTimeBuilder() BACnetConstructedDataUpdateTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataUpdateTimeBuilder()
	}
	return &_BACnetConstructedDataUpdateTimeBuilder{_BACnetConstructedDataUpdateTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataUpdateTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataUpdateTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_UPDATE_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataUpdateTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataUpdateTime) GetUpdateTime() BACnetDateTime {
	return m.UpdateTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataUpdateTime) GetActualValue() BACnetDateTime {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDateTime(m.GetUpdateTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataUpdateTime(structType any) BACnetConstructedDataUpdateTime {
	if casted, ok := structType.(BACnetConstructedDataUpdateTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataUpdateTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataUpdateTime) GetTypeName() string {
	return "BACnetConstructedDataUpdateTime"
}

func (m *_BACnetConstructedDataUpdateTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (updateTime)
	lengthInBits += m.UpdateTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataUpdateTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataUpdateTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataUpdateTime BACnetConstructedDataUpdateTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataUpdateTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataUpdateTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	updateTime, err := ReadSimpleField[BACnetDateTime](ctx, "updateTime", ReadComplex[BACnetDateTime](BACnetDateTimeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'updateTime' field"))
	}
	m.UpdateTime = updateTime

	actualValue, err := ReadVirtualField[BACnetDateTime](ctx, "actualValue", (*BACnetDateTime)(nil), updateTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataUpdateTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataUpdateTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataUpdateTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataUpdateTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataUpdateTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataUpdateTime")
		}

		if err := WriteSimpleField[BACnetDateTime](ctx, "updateTime", m.GetUpdateTime(), WriteComplex[BACnetDateTime](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'updateTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataUpdateTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataUpdateTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataUpdateTime) IsBACnetConstructedDataUpdateTime() {}

func (m *_BACnetConstructedDataUpdateTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataUpdateTime) deepCopy() *_BACnetConstructedDataUpdateTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataUpdateTimeCopy := &_BACnetConstructedDataUpdateTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDateTime](m.UpdateTime),
	}
	_BACnetConstructedDataUpdateTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataUpdateTimeCopy
}

func (m *_BACnetConstructedDataUpdateTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
