/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// InterfaceOptions1PowerUpSettings is the corresponding interface of InterfaceOptions1PowerUpSettings
type InterfaceOptions1PowerUpSettings interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetInterfaceOptions1 returns InterfaceOptions1 (property field)
	GetInterfaceOptions1() InterfaceOptions1
	// IsInterfaceOptions1PowerUpSettings is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsInterfaceOptions1PowerUpSettings()
	// CreateBuilder creates a InterfaceOptions1PowerUpSettingsBuilder
	CreateInterfaceOptions1PowerUpSettingsBuilder() InterfaceOptions1PowerUpSettingsBuilder
}

// _InterfaceOptions1PowerUpSettings is the data-structure of this message
type _InterfaceOptions1PowerUpSettings struct {
	InterfaceOptions1 InterfaceOptions1
}

var _ InterfaceOptions1PowerUpSettings = (*_InterfaceOptions1PowerUpSettings)(nil)

// NewInterfaceOptions1PowerUpSettings factory function for _InterfaceOptions1PowerUpSettings
func NewInterfaceOptions1PowerUpSettings(interfaceOptions1 InterfaceOptions1) *_InterfaceOptions1PowerUpSettings {
	if interfaceOptions1 == nil {
		panic("interfaceOptions1 of type InterfaceOptions1 for InterfaceOptions1PowerUpSettings must not be nil")
	}
	return &_InterfaceOptions1PowerUpSettings{InterfaceOptions1: interfaceOptions1}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// InterfaceOptions1PowerUpSettingsBuilder is a builder for InterfaceOptions1PowerUpSettings
type InterfaceOptions1PowerUpSettingsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(interfaceOptions1 InterfaceOptions1) InterfaceOptions1PowerUpSettingsBuilder
	// WithInterfaceOptions1 adds InterfaceOptions1 (property field)
	WithInterfaceOptions1(InterfaceOptions1) InterfaceOptions1PowerUpSettingsBuilder
	// WithInterfaceOptions1Builder adds InterfaceOptions1 (property field) which is build by the builder
	WithInterfaceOptions1Builder(func(InterfaceOptions1Builder) InterfaceOptions1Builder) InterfaceOptions1PowerUpSettingsBuilder
	// Build builds the InterfaceOptions1PowerUpSettings or returns an error if something is wrong
	Build() (InterfaceOptions1PowerUpSettings, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() InterfaceOptions1PowerUpSettings
}

// NewInterfaceOptions1PowerUpSettingsBuilder() creates a InterfaceOptions1PowerUpSettingsBuilder
func NewInterfaceOptions1PowerUpSettingsBuilder() InterfaceOptions1PowerUpSettingsBuilder {
	return &_InterfaceOptions1PowerUpSettingsBuilder{_InterfaceOptions1PowerUpSettings: new(_InterfaceOptions1PowerUpSettings)}
}

type _InterfaceOptions1PowerUpSettingsBuilder struct {
	*_InterfaceOptions1PowerUpSettings

	collectedErr []error
}

var _ (InterfaceOptions1PowerUpSettingsBuilder) = (*_InterfaceOptions1PowerUpSettingsBuilder)(nil)

func (b *_InterfaceOptions1PowerUpSettingsBuilder) WithMandatoryFields(interfaceOptions1 InterfaceOptions1) InterfaceOptions1PowerUpSettingsBuilder {
	return b.WithInterfaceOptions1(interfaceOptions1)
}

func (b *_InterfaceOptions1PowerUpSettingsBuilder) WithInterfaceOptions1(interfaceOptions1 InterfaceOptions1) InterfaceOptions1PowerUpSettingsBuilder {
	b.InterfaceOptions1 = interfaceOptions1
	return b
}

func (b *_InterfaceOptions1PowerUpSettingsBuilder) WithInterfaceOptions1Builder(builderSupplier func(InterfaceOptions1Builder) InterfaceOptions1Builder) InterfaceOptions1PowerUpSettingsBuilder {
	builder := builderSupplier(b.InterfaceOptions1.CreateInterfaceOptions1Builder())
	var err error
	b.InterfaceOptions1, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "InterfaceOptions1Builder failed"))
	}
	return b
}

func (b *_InterfaceOptions1PowerUpSettingsBuilder) Build() (InterfaceOptions1PowerUpSettings, error) {
	if b.InterfaceOptions1 == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'interfaceOptions1' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._InterfaceOptions1PowerUpSettings.deepCopy(), nil
}

func (b *_InterfaceOptions1PowerUpSettingsBuilder) MustBuild() InterfaceOptions1PowerUpSettings {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_InterfaceOptions1PowerUpSettingsBuilder) DeepCopy() any {
	_copy := b.CreateInterfaceOptions1PowerUpSettingsBuilder().(*_InterfaceOptions1PowerUpSettingsBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateInterfaceOptions1PowerUpSettingsBuilder creates a InterfaceOptions1PowerUpSettingsBuilder
func (b *_InterfaceOptions1PowerUpSettings) CreateInterfaceOptions1PowerUpSettingsBuilder() InterfaceOptions1PowerUpSettingsBuilder {
	if b == nil {
		return NewInterfaceOptions1PowerUpSettingsBuilder()
	}
	return &_InterfaceOptions1PowerUpSettingsBuilder{_InterfaceOptions1PowerUpSettings: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_InterfaceOptions1PowerUpSettings) GetInterfaceOptions1() InterfaceOptions1 {
	return m.InterfaceOptions1
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastInterfaceOptions1PowerUpSettings(structType any) InterfaceOptions1PowerUpSettings {
	if casted, ok := structType.(InterfaceOptions1PowerUpSettings); ok {
		return casted
	}
	if casted, ok := structType.(*InterfaceOptions1PowerUpSettings); ok {
		return *casted
	}
	return nil
}

func (m *_InterfaceOptions1PowerUpSettings) GetTypeName() string {
	return "InterfaceOptions1PowerUpSettings"
}

func (m *_InterfaceOptions1PowerUpSettings) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (interfaceOptions1)
	lengthInBits += m.InterfaceOptions1.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_InterfaceOptions1PowerUpSettings) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func InterfaceOptions1PowerUpSettingsParse(ctx context.Context, theBytes []byte) (InterfaceOptions1PowerUpSettings, error) {
	return InterfaceOptions1PowerUpSettingsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func InterfaceOptions1PowerUpSettingsParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (InterfaceOptions1PowerUpSettings, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (InterfaceOptions1PowerUpSettings, error) {
		return InterfaceOptions1PowerUpSettingsParseWithBuffer(ctx, readBuffer)
	}
}

func InterfaceOptions1PowerUpSettingsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (InterfaceOptions1PowerUpSettings, error) {
	v, err := (&_InterfaceOptions1PowerUpSettings{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_InterfaceOptions1PowerUpSettings) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__interfaceOptions1PowerUpSettings InterfaceOptions1PowerUpSettings, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("InterfaceOptions1PowerUpSettings"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for InterfaceOptions1PowerUpSettings")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	interfaceOptions1, err := ReadSimpleField[InterfaceOptions1](ctx, "interfaceOptions1", ReadComplex[InterfaceOptions1](InterfaceOptions1ParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'interfaceOptions1' field"))
	}
	m.InterfaceOptions1 = interfaceOptions1

	if closeErr := readBuffer.CloseContext("InterfaceOptions1PowerUpSettings"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for InterfaceOptions1PowerUpSettings")
	}

	return m, nil
}

func (m *_InterfaceOptions1PowerUpSettings) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_InterfaceOptions1PowerUpSettings) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("InterfaceOptions1PowerUpSettings"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for InterfaceOptions1PowerUpSettings")
	}

	if err := WriteSimpleField[InterfaceOptions1](ctx, "interfaceOptions1", m.GetInterfaceOptions1(), WriteComplex[InterfaceOptions1](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'interfaceOptions1' field")
	}

	if popErr := writeBuffer.PopContext("InterfaceOptions1PowerUpSettings"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for InterfaceOptions1PowerUpSettings")
	}
	return nil
}

func (m *_InterfaceOptions1PowerUpSettings) IsInterfaceOptions1PowerUpSettings() {}

func (m *_InterfaceOptions1PowerUpSettings) DeepCopy() any {
	return m.deepCopy()
}

func (m *_InterfaceOptions1PowerUpSettings) deepCopy() *_InterfaceOptions1PowerUpSettings {
	if m == nil {
		return nil
	}
	_InterfaceOptions1PowerUpSettingsCopy := &_InterfaceOptions1PowerUpSettings{
		utils.DeepCopy[InterfaceOptions1](m.InterfaceOptions1),
	}
	return _InterfaceOptions1PowerUpSettingsCopy
}

func (m *_InterfaceOptions1PowerUpSettings) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
