/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApplicationConfigurationDataType is the corresponding interface of ApplicationConfigurationDataType
type ApplicationConfigurationDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetConfigurationVersion returns ConfigurationVersion (property field)
	GetConfigurationVersion() uint32
	// GetConfigurationProperties returns ConfigurationProperties (property field)
	GetConfigurationProperties() []KeyValuePair
	// GetApplicationIdentity returns ApplicationIdentity (property field)
	GetApplicationIdentity() ApplicationIdentityDataType
	// GetCertificateGroups returns CertificateGroups (property field)
	GetCertificateGroups() []CertificateGroupDataType
	// GetServerEndpoints returns ServerEndpoints (property field)
	GetServerEndpoints() []ServerEndpointDataType
	// GetClientEndpoints returns ClientEndpoints (property field)
	GetClientEndpoints() []EndpointDataType
	// GetSecuritySettings returns SecuritySettings (property field)
	GetSecuritySettings() []SecuritySettingsDataType
	// GetUserTokenSettings returns UserTokenSettings (property field)
	GetUserTokenSettings() []UserTokenSettingsDataType
	// GetAuthorizationServices returns AuthorizationServices (property field)
	GetAuthorizationServices() []AuthorizationServiceConfigurationDataType
	// IsApplicationConfigurationDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApplicationConfigurationDataType()
	// CreateBuilder creates a ApplicationConfigurationDataTypeBuilder
	CreateApplicationConfigurationDataTypeBuilder() ApplicationConfigurationDataTypeBuilder
}

// _ApplicationConfigurationDataType is the data-structure of this message
type _ApplicationConfigurationDataType struct {
	ExtensionObjectDefinitionContract
	ConfigurationVersion    uint32
	ConfigurationProperties []KeyValuePair
	ApplicationIdentity     ApplicationIdentityDataType
	CertificateGroups       []CertificateGroupDataType
	ServerEndpoints         []ServerEndpointDataType
	ClientEndpoints         []EndpointDataType
	SecuritySettings        []SecuritySettingsDataType
	UserTokenSettings       []UserTokenSettingsDataType
	AuthorizationServices   []AuthorizationServiceConfigurationDataType
}

var _ ApplicationConfigurationDataType = (*_ApplicationConfigurationDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ApplicationConfigurationDataType)(nil)

// NewApplicationConfigurationDataType factory function for _ApplicationConfigurationDataType
func NewApplicationConfigurationDataType(configurationVersion uint32, configurationProperties []KeyValuePair, applicationIdentity ApplicationIdentityDataType, certificateGroups []CertificateGroupDataType, serverEndpoints []ServerEndpointDataType, clientEndpoints []EndpointDataType, securitySettings []SecuritySettingsDataType, userTokenSettings []UserTokenSettingsDataType, authorizationServices []AuthorizationServiceConfigurationDataType) *_ApplicationConfigurationDataType {
	if applicationIdentity == nil {
		panic("applicationIdentity of type ApplicationIdentityDataType for ApplicationConfigurationDataType must not be nil")
	}
	_result := &_ApplicationConfigurationDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ConfigurationVersion:              configurationVersion,
		ConfigurationProperties:           configurationProperties,
		ApplicationIdentity:               applicationIdentity,
		CertificateGroups:                 certificateGroups,
		ServerEndpoints:                   serverEndpoints,
		ClientEndpoints:                   clientEndpoints,
		SecuritySettings:                  securitySettings,
		UserTokenSettings:                 userTokenSettings,
		AuthorizationServices:             authorizationServices,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApplicationConfigurationDataTypeBuilder is a builder for ApplicationConfigurationDataType
type ApplicationConfigurationDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(configurationVersion uint32, configurationProperties []KeyValuePair, applicationIdentity ApplicationIdentityDataType, certificateGroups []CertificateGroupDataType, serverEndpoints []ServerEndpointDataType, clientEndpoints []EndpointDataType, securitySettings []SecuritySettingsDataType, userTokenSettings []UserTokenSettingsDataType, authorizationServices []AuthorizationServiceConfigurationDataType) ApplicationConfigurationDataTypeBuilder
	// WithConfigurationVersion adds ConfigurationVersion (property field)
	WithConfigurationVersion(uint32) ApplicationConfigurationDataTypeBuilder
	// WithConfigurationProperties adds ConfigurationProperties (property field)
	WithConfigurationProperties(...KeyValuePair) ApplicationConfigurationDataTypeBuilder
	// WithApplicationIdentity adds ApplicationIdentity (property field)
	WithApplicationIdentity(ApplicationIdentityDataType) ApplicationConfigurationDataTypeBuilder
	// WithApplicationIdentityBuilder adds ApplicationIdentity (property field) which is build by the builder
	WithApplicationIdentityBuilder(func(ApplicationIdentityDataTypeBuilder) ApplicationIdentityDataTypeBuilder) ApplicationConfigurationDataTypeBuilder
	// WithCertificateGroups adds CertificateGroups (property field)
	WithCertificateGroups(...CertificateGroupDataType) ApplicationConfigurationDataTypeBuilder
	// WithServerEndpoints adds ServerEndpoints (property field)
	WithServerEndpoints(...ServerEndpointDataType) ApplicationConfigurationDataTypeBuilder
	// WithClientEndpoints adds ClientEndpoints (property field)
	WithClientEndpoints(...EndpointDataType) ApplicationConfigurationDataTypeBuilder
	// WithSecuritySettings adds SecuritySettings (property field)
	WithSecuritySettings(...SecuritySettingsDataType) ApplicationConfigurationDataTypeBuilder
	// WithUserTokenSettings adds UserTokenSettings (property field)
	WithUserTokenSettings(...UserTokenSettingsDataType) ApplicationConfigurationDataTypeBuilder
	// WithAuthorizationServices adds AuthorizationServices (property field)
	WithAuthorizationServices(...AuthorizationServiceConfigurationDataType) ApplicationConfigurationDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ApplicationConfigurationDataType or returns an error if something is wrong
	Build() (ApplicationConfigurationDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApplicationConfigurationDataType
}

// NewApplicationConfigurationDataTypeBuilder() creates a ApplicationConfigurationDataTypeBuilder
func NewApplicationConfigurationDataTypeBuilder() ApplicationConfigurationDataTypeBuilder {
	return &_ApplicationConfigurationDataTypeBuilder{_ApplicationConfigurationDataType: new(_ApplicationConfigurationDataType)}
}

type _ApplicationConfigurationDataTypeBuilder struct {
	*_ApplicationConfigurationDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (ApplicationConfigurationDataTypeBuilder) = (*_ApplicationConfigurationDataTypeBuilder)(nil)

func (b *_ApplicationConfigurationDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ApplicationConfigurationDataType
}

func (b *_ApplicationConfigurationDataTypeBuilder) WithMandatoryFields(configurationVersion uint32, configurationProperties []KeyValuePair, applicationIdentity ApplicationIdentityDataType, certificateGroups []CertificateGroupDataType, serverEndpoints []ServerEndpointDataType, clientEndpoints []EndpointDataType, securitySettings []SecuritySettingsDataType, userTokenSettings []UserTokenSettingsDataType, authorizationServices []AuthorizationServiceConfigurationDataType) ApplicationConfigurationDataTypeBuilder {
	return b.WithConfigurationVersion(configurationVersion).WithConfigurationProperties(configurationProperties...).WithApplicationIdentity(applicationIdentity).WithCertificateGroups(certificateGroups...).WithServerEndpoints(serverEndpoints...).WithClientEndpoints(clientEndpoints...).WithSecuritySettings(securitySettings...).WithUserTokenSettings(userTokenSettings...).WithAuthorizationServices(authorizationServices...)
}

func (b *_ApplicationConfigurationDataTypeBuilder) WithConfigurationVersion(configurationVersion uint32) ApplicationConfigurationDataTypeBuilder {
	b.ConfigurationVersion = configurationVersion
	return b
}

func (b *_ApplicationConfigurationDataTypeBuilder) WithConfigurationProperties(configurationProperties ...KeyValuePair) ApplicationConfigurationDataTypeBuilder {
	b.ConfigurationProperties = configurationProperties
	return b
}

func (b *_ApplicationConfigurationDataTypeBuilder) WithApplicationIdentity(applicationIdentity ApplicationIdentityDataType) ApplicationConfigurationDataTypeBuilder {
	b.ApplicationIdentity = applicationIdentity
	return b
}

func (b *_ApplicationConfigurationDataTypeBuilder) WithApplicationIdentityBuilder(builderSupplier func(ApplicationIdentityDataTypeBuilder) ApplicationIdentityDataTypeBuilder) ApplicationConfigurationDataTypeBuilder {
	builder := builderSupplier(b.ApplicationIdentity.CreateApplicationIdentityDataTypeBuilder())
	var err error
	b.ApplicationIdentity, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "ApplicationIdentityDataTypeBuilder failed"))
	}
	return b
}

func (b *_ApplicationConfigurationDataTypeBuilder) WithCertificateGroups(certificateGroups ...CertificateGroupDataType) ApplicationConfigurationDataTypeBuilder {
	b.CertificateGroups = certificateGroups
	return b
}

func (b *_ApplicationConfigurationDataTypeBuilder) WithServerEndpoints(serverEndpoints ...ServerEndpointDataType) ApplicationConfigurationDataTypeBuilder {
	b.ServerEndpoints = serverEndpoints
	return b
}

func (b *_ApplicationConfigurationDataTypeBuilder) WithClientEndpoints(clientEndpoints ...EndpointDataType) ApplicationConfigurationDataTypeBuilder {
	b.ClientEndpoints = clientEndpoints
	return b
}

func (b *_ApplicationConfigurationDataTypeBuilder) WithSecuritySettings(securitySettings ...SecuritySettingsDataType) ApplicationConfigurationDataTypeBuilder {
	b.SecuritySettings = securitySettings
	return b
}

func (b *_ApplicationConfigurationDataTypeBuilder) WithUserTokenSettings(userTokenSettings ...UserTokenSettingsDataType) ApplicationConfigurationDataTypeBuilder {
	b.UserTokenSettings = userTokenSettings
	return b
}

func (b *_ApplicationConfigurationDataTypeBuilder) WithAuthorizationServices(authorizationServices ...AuthorizationServiceConfigurationDataType) ApplicationConfigurationDataTypeBuilder {
	b.AuthorizationServices = authorizationServices
	return b
}

func (b *_ApplicationConfigurationDataTypeBuilder) Build() (ApplicationConfigurationDataType, error) {
	if b.ApplicationIdentity == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'applicationIdentity' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApplicationConfigurationDataType.deepCopy(), nil
}

func (b *_ApplicationConfigurationDataTypeBuilder) MustBuild() ApplicationConfigurationDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApplicationConfigurationDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ApplicationConfigurationDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ApplicationConfigurationDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateApplicationConfigurationDataTypeBuilder().(*_ApplicationConfigurationDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApplicationConfigurationDataTypeBuilder creates a ApplicationConfigurationDataTypeBuilder
func (b *_ApplicationConfigurationDataType) CreateApplicationConfigurationDataTypeBuilder() ApplicationConfigurationDataTypeBuilder {
	if b == nil {
		return NewApplicationConfigurationDataTypeBuilder()
	}
	return &_ApplicationConfigurationDataTypeBuilder{_ApplicationConfigurationDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApplicationConfigurationDataType) GetExtensionId() int32 {
	return int32(15551)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApplicationConfigurationDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ApplicationConfigurationDataType) GetConfigurationVersion() uint32 {
	return m.ConfigurationVersion
}

func (m *_ApplicationConfigurationDataType) GetConfigurationProperties() []KeyValuePair {
	return m.ConfigurationProperties
}

func (m *_ApplicationConfigurationDataType) GetApplicationIdentity() ApplicationIdentityDataType {
	return m.ApplicationIdentity
}

func (m *_ApplicationConfigurationDataType) GetCertificateGroups() []CertificateGroupDataType {
	return m.CertificateGroups
}

func (m *_ApplicationConfigurationDataType) GetServerEndpoints() []ServerEndpointDataType {
	return m.ServerEndpoints
}

func (m *_ApplicationConfigurationDataType) GetClientEndpoints() []EndpointDataType {
	return m.ClientEndpoints
}

func (m *_ApplicationConfigurationDataType) GetSecuritySettings() []SecuritySettingsDataType {
	return m.SecuritySettings
}

func (m *_ApplicationConfigurationDataType) GetUserTokenSettings() []UserTokenSettingsDataType {
	return m.UserTokenSettings
}

func (m *_ApplicationConfigurationDataType) GetAuthorizationServices() []AuthorizationServiceConfigurationDataType {
	return m.AuthorizationServices
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastApplicationConfigurationDataType(structType any) ApplicationConfigurationDataType {
	if casted, ok := structType.(ApplicationConfigurationDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ApplicationConfigurationDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ApplicationConfigurationDataType) GetTypeName() string {
	return "ApplicationConfigurationDataType"
}

func (m *_ApplicationConfigurationDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (configurationVersion)
	lengthInBits += 32

	// Implicit Field (noOfConfigurationProperties)
	lengthInBits += 32

	// Array field
	if len(m.ConfigurationProperties) > 0 {
		for _curItem, element := range m.ConfigurationProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ConfigurationProperties), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (applicationIdentity)
	lengthInBits += m.ApplicationIdentity.GetLengthInBits(ctx)

	// Implicit Field (noOfCertificateGroups)
	lengthInBits += 32

	// Array field
	if len(m.CertificateGroups) > 0 {
		for _curItem, element := range m.CertificateGroups {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.CertificateGroups), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfServerEndpoints)
	lengthInBits += 32

	// Array field
	if len(m.ServerEndpoints) > 0 {
		for _curItem, element := range m.ServerEndpoints {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ServerEndpoints), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfClientEndpoints)
	lengthInBits += 32

	// Array field
	if len(m.ClientEndpoints) > 0 {
		for _curItem, element := range m.ClientEndpoints {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ClientEndpoints), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfSecuritySettings)
	lengthInBits += 32

	// Array field
	if len(m.SecuritySettings) > 0 {
		for _curItem, element := range m.SecuritySettings {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.SecuritySettings), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfUserTokenSettings)
	lengthInBits += 32

	// Array field
	if len(m.UserTokenSettings) > 0 {
		for _curItem, element := range m.UserTokenSettings {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.UserTokenSettings), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfAuthorizationServices)
	lengthInBits += 32

	// Array field
	if len(m.AuthorizationServices) > 0 {
		for _curItem, element := range m.AuthorizationServices {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.AuthorizationServices), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_ApplicationConfigurationDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApplicationConfigurationDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__applicationConfigurationDataType ApplicationConfigurationDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApplicationConfigurationDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApplicationConfigurationDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	configurationVersion, err := ReadSimpleField(ctx, "configurationVersion", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'configurationVersion' field"))
	}
	m.ConfigurationVersion = configurationVersion

	noOfConfigurationProperties, err := ReadImplicitField[int32](ctx, "noOfConfigurationProperties", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfConfigurationProperties' field"))
	}
	_ = noOfConfigurationProperties

	configurationProperties, err := ReadCountArrayField[KeyValuePair](ctx, "configurationProperties", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfConfigurationProperties))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'configurationProperties' field"))
	}
	m.ConfigurationProperties = configurationProperties

	applicationIdentity, err := ReadSimpleField[ApplicationIdentityDataType](ctx, "applicationIdentity", ReadComplex[ApplicationIdentityDataType](ExtensionObjectDefinitionParseWithBufferProducer[ApplicationIdentityDataType]((int32)(int32(15558))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'applicationIdentity' field"))
	}
	m.ApplicationIdentity = applicationIdentity

	noOfCertificateGroups, err := ReadImplicitField[int32](ctx, "noOfCertificateGroups", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfCertificateGroups' field"))
	}
	_ = noOfCertificateGroups

	certificateGroups, err := ReadCountArrayField[CertificateGroupDataType](ctx, "certificateGroups", ReadComplex[CertificateGroupDataType](ExtensionObjectDefinitionParseWithBufferProducer[CertificateGroupDataType]((int32)(int32(15438))), readBuffer), uint64(noOfCertificateGroups))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'certificateGroups' field"))
	}
	m.CertificateGroups = certificateGroups

	noOfServerEndpoints, err := ReadImplicitField[int32](ctx, "noOfServerEndpoints", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfServerEndpoints' field"))
	}
	_ = noOfServerEndpoints

	serverEndpoints, err := ReadCountArrayField[ServerEndpointDataType](ctx, "serverEndpoints", ReadComplex[ServerEndpointDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServerEndpointDataType]((int32)(int32(15560))), readBuffer), uint64(noOfServerEndpoints))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverEndpoints' field"))
	}
	m.ServerEndpoints = serverEndpoints

	noOfClientEndpoints, err := ReadImplicitField[int32](ctx, "noOfClientEndpoints", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfClientEndpoints' field"))
	}
	_ = noOfClientEndpoints

	clientEndpoints, err := ReadCountArrayField[EndpointDataType](ctx, "clientEndpoints", ReadComplex[EndpointDataType](ExtensionObjectDefinitionParseWithBufferProducer[EndpointDataType]((int32)(int32(15559))), readBuffer), uint64(noOfClientEndpoints))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'clientEndpoints' field"))
	}
	m.ClientEndpoints = clientEndpoints

	noOfSecuritySettings, err := ReadImplicitField[int32](ctx, "noOfSecuritySettings", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfSecuritySettings' field"))
	}
	_ = noOfSecuritySettings

	securitySettings, err := ReadCountArrayField[SecuritySettingsDataType](ctx, "securitySettings", ReadComplex[SecuritySettingsDataType](ExtensionObjectDefinitionParseWithBufferProducer[SecuritySettingsDataType]((int32)(int32(15561))), readBuffer), uint64(noOfSecuritySettings))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securitySettings' field"))
	}
	m.SecuritySettings = securitySettings

	noOfUserTokenSettings, err := ReadImplicitField[int32](ctx, "noOfUserTokenSettings", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfUserTokenSettings' field"))
	}
	_ = noOfUserTokenSettings

	userTokenSettings, err := ReadCountArrayField[UserTokenSettingsDataType](ctx, "userTokenSettings", ReadComplex[UserTokenSettingsDataType](ExtensionObjectDefinitionParseWithBufferProducer[UserTokenSettingsDataType]((int32)(int32(15562))), readBuffer), uint64(noOfUserTokenSettings))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userTokenSettings' field"))
	}
	m.UserTokenSettings = userTokenSettings

	noOfAuthorizationServices, err := ReadImplicitField[int32](ctx, "noOfAuthorizationServices", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfAuthorizationServices' field"))
	}
	_ = noOfAuthorizationServices

	authorizationServices, err := ReadCountArrayField[AuthorizationServiceConfigurationDataType](ctx, "authorizationServices", ReadComplex[AuthorizationServiceConfigurationDataType](ExtensionObjectDefinitionParseWithBufferProducer[AuthorizationServiceConfigurationDataType]((int32)(int32(19447))), readBuffer), uint64(noOfAuthorizationServices))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'authorizationServices' field"))
	}
	m.AuthorizationServices = authorizationServices

	if closeErr := readBuffer.CloseContext("ApplicationConfigurationDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApplicationConfigurationDataType")
	}

	return m, nil
}

func (m *_ApplicationConfigurationDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApplicationConfigurationDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApplicationConfigurationDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApplicationConfigurationDataType")
		}

		if err := WriteSimpleField[uint32](ctx, "configurationVersion", m.GetConfigurationVersion(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'configurationVersion' field")
		}
		noOfConfigurationProperties := int32(utils.InlineIf(bool((m.GetConfigurationProperties()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetConfigurationProperties()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfConfigurationProperties", noOfConfigurationProperties, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfConfigurationProperties' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "configurationProperties", m.GetConfigurationProperties(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'configurationProperties' field")
		}

		if err := WriteSimpleField[ApplicationIdentityDataType](ctx, "applicationIdentity", m.GetApplicationIdentity(), WriteComplex[ApplicationIdentityDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'applicationIdentity' field")
		}
		noOfCertificateGroups := int32(utils.InlineIf(bool((m.GetCertificateGroups()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetCertificateGroups()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfCertificateGroups", noOfCertificateGroups, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfCertificateGroups' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "certificateGroups", m.GetCertificateGroups(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'certificateGroups' field")
		}
		noOfServerEndpoints := int32(utils.InlineIf(bool((m.GetServerEndpoints()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetServerEndpoints()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfServerEndpoints", noOfServerEndpoints, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfServerEndpoints' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "serverEndpoints", m.GetServerEndpoints(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'serverEndpoints' field")
		}
		noOfClientEndpoints := int32(utils.InlineIf(bool((m.GetClientEndpoints()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetClientEndpoints()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfClientEndpoints", noOfClientEndpoints, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfClientEndpoints' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "clientEndpoints", m.GetClientEndpoints(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'clientEndpoints' field")
		}
		noOfSecuritySettings := int32(utils.InlineIf(bool((m.GetSecuritySettings()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetSecuritySettings()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfSecuritySettings", noOfSecuritySettings, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfSecuritySettings' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "securitySettings", m.GetSecuritySettings(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'securitySettings' field")
		}
		noOfUserTokenSettings := int32(utils.InlineIf(bool((m.GetUserTokenSettings()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetUserTokenSettings()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfUserTokenSettings", noOfUserTokenSettings, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfUserTokenSettings' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "userTokenSettings", m.GetUserTokenSettings(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'userTokenSettings' field")
		}
		noOfAuthorizationServices := int32(utils.InlineIf(bool((m.GetAuthorizationServices()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetAuthorizationServices()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfAuthorizationServices", noOfAuthorizationServices, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfAuthorizationServices' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "authorizationServices", m.GetAuthorizationServices(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'authorizationServices' field")
		}

		if popErr := writeBuffer.PopContext("ApplicationConfigurationDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApplicationConfigurationDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApplicationConfigurationDataType) IsApplicationConfigurationDataType() {}

func (m *_ApplicationConfigurationDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApplicationConfigurationDataType) deepCopy() *_ApplicationConfigurationDataType {
	if m == nil {
		return nil
	}
	_ApplicationConfigurationDataTypeCopy := &_ApplicationConfigurationDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.ConfigurationVersion,
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.ConfigurationProperties),
		utils.DeepCopy[ApplicationIdentityDataType](m.ApplicationIdentity),
		utils.DeepCopySlice[CertificateGroupDataType, CertificateGroupDataType](m.CertificateGroups),
		utils.DeepCopySlice[ServerEndpointDataType, ServerEndpointDataType](m.ServerEndpoints),
		utils.DeepCopySlice[EndpointDataType, EndpointDataType](m.ClientEndpoints),
		utils.DeepCopySlice[SecuritySettingsDataType, SecuritySettingsDataType](m.SecuritySettings),
		utils.DeepCopySlice[UserTokenSettingsDataType, UserTokenSettingsDataType](m.UserTokenSettings),
		utils.DeepCopySlice[AuthorizationServiceConfigurationDataType, AuthorizationServiceConfigurationDataType](m.AuthorizationServices),
	}
	_ApplicationConfigurationDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ApplicationConfigurationDataTypeCopy
}

func (m *_ApplicationConfigurationDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
