/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DataTypeDefinition is the corresponding interface of DataTypeDefinition
type DataTypeDefinition interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// IsDataTypeDefinition is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDataTypeDefinition()
	// CreateBuilder creates a DataTypeDefinitionBuilder
	CreateDataTypeDefinitionBuilder() DataTypeDefinitionBuilder
}

// _DataTypeDefinition is the data-structure of this message
type _DataTypeDefinition struct {
	ExtensionObjectDefinitionContract
}

var _ DataTypeDefinition = (*_DataTypeDefinition)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_DataTypeDefinition)(nil)

// NewDataTypeDefinition factory function for _DataTypeDefinition
func NewDataTypeDefinition() *_DataTypeDefinition {
	_result := &_DataTypeDefinition{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DataTypeDefinitionBuilder is a builder for DataTypeDefinition
type DataTypeDefinitionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() DataTypeDefinitionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the DataTypeDefinition or returns an error if something is wrong
	Build() (DataTypeDefinition, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DataTypeDefinition
}

// NewDataTypeDefinitionBuilder() creates a DataTypeDefinitionBuilder
func NewDataTypeDefinitionBuilder() DataTypeDefinitionBuilder {
	return &_DataTypeDefinitionBuilder{_DataTypeDefinition: new(_DataTypeDefinition)}
}

type _DataTypeDefinitionBuilder struct {
	*_DataTypeDefinition

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (DataTypeDefinitionBuilder) = (*_DataTypeDefinitionBuilder)(nil)

func (b *_DataTypeDefinitionBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._DataTypeDefinition
}

func (b *_DataTypeDefinitionBuilder) WithMandatoryFields() DataTypeDefinitionBuilder {
	return b
}

func (b *_DataTypeDefinitionBuilder) Build() (DataTypeDefinition, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._DataTypeDefinition.deepCopy(), nil
}

func (b *_DataTypeDefinitionBuilder) MustBuild() DataTypeDefinition {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DataTypeDefinitionBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_DataTypeDefinitionBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_DataTypeDefinitionBuilder) DeepCopy() any {
	_copy := b.CreateDataTypeDefinitionBuilder().(*_DataTypeDefinitionBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateDataTypeDefinitionBuilder creates a DataTypeDefinitionBuilder
func (b *_DataTypeDefinition) CreateDataTypeDefinitionBuilder() DataTypeDefinitionBuilder {
	if b == nil {
		return NewDataTypeDefinitionBuilder()
	}
	return &_DataTypeDefinitionBuilder{_DataTypeDefinition: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DataTypeDefinition) GetExtensionId() int32 {
	return int32(99)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DataTypeDefinition) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

// Deprecated: use the interface for direct cast
func CastDataTypeDefinition(structType any) DataTypeDefinition {
	if casted, ok := structType.(DataTypeDefinition); ok {
		return casted
	}
	if casted, ok := structType.(*DataTypeDefinition); ok {
		return *casted
	}
	return nil
}

func (m *_DataTypeDefinition) GetTypeName() string {
	return "DataTypeDefinition"
}

func (m *_DataTypeDefinition) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_DataTypeDefinition) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_DataTypeDefinition) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__dataTypeDefinition DataTypeDefinition, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DataTypeDefinition"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DataTypeDefinition")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("DataTypeDefinition"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DataTypeDefinition")
	}

	return m, nil
}

func (m *_DataTypeDefinition) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DataTypeDefinition) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DataTypeDefinition"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DataTypeDefinition")
		}

		if popErr := writeBuffer.PopContext("DataTypeDefinition"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DataTypeDefinition")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DataTypeDefinition) IsDataTypeDefinition() {}

func (m *_DataTypeDefinition) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DataTypeDefinition) deepCopy() *_DataTypeDefinition {
	if m == nil {
		return nil
	}
	_DataTypeDefinitionCopy := &_DataTypeDefinition{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
	}
	_DataTypeDefinitionCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _DataTypeDefinitionCopy
}

func (m *_DataTypeDefinition) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
