/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MessageType is an enum
type MessageType string

type IMessageType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	MessageType_HELLO       MessageType = "HEL"
	MessageType_ACKNOWLEDGE MessageType = "ACK"
	MessageType_ERROR       MessageType = "ERR"
	MessageType_OPEN        MessageType = "OPN"
	MessageType_CLOSE       MessageType = "CLO"
	MessageType_MESSAGE     MessageType = "MSG"
)

var MessageTypeValues []MessageType

func init() {
	_ = errors.New
	MessageTypeValues = []MessageType{
		MessageType_HELLO,
		MessageType_ACKNOWLEDGE,
		MessageType_ERROR,
		MessageType_OPEN,
		MessageType_CLOSE,
		MessageType_MESSAGE,
	}
}

func MessageTypeByValue(value string) (enum MessageType, ok bool) {
	switch value {
	case "ACK":
		return MessageType_ACKNOWLEDGE, true
	case "CLO":
		return MessageType_CLOSE, true
	case "ERR":
		return MessageType_ERROR, true
	case "HEL":
		return MessageType_HELLO, true
	case "MSG":
		return MessageType_MESSAGE, true
	case "OPN":
		return MessageType_OPEN, true
	}
	return "", false
}

func MessageTypeByName(value string) (enum MessageType, ok bool) {
	switch value {
	case "ACKNOWLEDGE":
		return MessageType_ACKNOWLEDGE, true
	case "CLOSE":
		return MessageType_CLOSE, true
	case "ERROR":
		return MessageType_ERROR, true
	case "HELLO":
		return MessageType_HELLO, true
	case "MESSAGE":
		return MessageType_MESSAGE, true
	case "OPEN":
		return MessageType_OPEN, true
	}
	return "", false
}

func MessageTypeKnows(value string) bool {
	for _, typeValue := range MessageTypeValues {
		if string(typeValue) == value {
			return true
		}
	}
	return false
}

func CastMessageType(structType any) MessageType {
	castFunc := func(typ any) MessageType {
		if sMessageType, ok := typ.(MessageType); ok {
			return sMessageType
		}
		return ""
	}
	return castFunc(structType)
}

func (m MessageType) GetLengthInBits(ctx context.Context) uint16 {
	return 0
}

func (m MessageType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func MessageTypeParse(ctx context.Context, theBytes []byte) (MessageType, error) {
	return MessageTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func MessageTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (MessageType, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("MessageType", uint32(24), utils.WithEncoding("UTF-8"))
	if err != nil {
		return "", errors.Wrap(err, "error reading MessageType")
	}
	if enum, ok := MessageTypeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for MessageType")
		return MessageType(val), nil
	} else {
		return enum, nil
	}
}

func (e MessageType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e MessageType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteString("MessageType", uint32(24), string(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()), utils.WithEncoding("UTF-8)"))
}

func (e MessageType) GetValue() string {
	return string(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e MessageType) PLC4XEnumName() string {
	switch e {
	case MessageType_ACKNOWLEDGE:
		return "ACKNOWLEDGE"
	case MessageType_CLOSE:
		return "CLOSE"
	case MessageType_ERROR:
		return "ERROR"
	case MessageType_HELLO:
		return "HELLO"
	case MessageType_MESSAGE:
		return "MESSAGE"
	case MessageType_OPEN:
		return "OPEN"
	}
	return fmt.Sprintf("Unknown(%v)", string(e))
}

func (e MessageType) String() string {
	return e.PLC4XEnumName()
}
