/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NumericNodeId is the corresponding interface of NumericNodeId
type NumericNodeId interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetNamespaceIndex returns NamespaceIndex (property field)
	GetNamespaceIndex() uint16
	// GetIdentifier returns Identifier (property field)
	GetIdentifier() uint32
	// IsNumericNodeId is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNumericNodeId()
	// CreateBuilder creates a NumericNodeIdBuilder
	CreateNumericNodeIdBuilder() NumericNodeIdBuilder
}

// _NumericNodeId is the data-structure of this message
type _NumericNodeId struct {
	NamespaceIndex uint16
	Identifier     uint32
}

var _ NumericNodeId = (*_NumericNodeId)(nil)

// NewNumericNodeId factory function for _NumericNodeId
func NewNumericNodeId(namespaceIndex uint16, identifier uint32) *_NumericNodeId {
	return &_NumericNodeId{NamespaceIndex: namespaceIndex, Identifier: identifier}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NumericNodeIdBuilder is a builder for NumericNodeId
type NumericNodeIdBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(namespaceIndex uint16, identifier uint32) NumericNodeIdBuilder
	// WithNamespaceIndex adds NamespaceIndex (property field)
	WithNamespaceIndex(uint16) NumericNodeIdBuilder
	// WithIdentifier adds Identifier (property field)
	WithIdentifier(uint32) NumericNodeIdBuilder
	// Build builds the NumericNodeId or returns an error if something is wrong
	Build() (NumericNodeId, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NumericNodeId
}

// NewNumericNodeIdBuilder() creates a NumericNodeIdBuilder
func NewNumericNodeIdBuilder() NumericNodeIdBuilder {
	return &_NumericNodeIdBuilder{_NumericNodeId: new(_NumericNodeId)}
}

type _NumericNodeIdBuilder struct {
	*_NumericNodeId

	collectedErr []error
}

var _ (NumericNodeIdBuilder) = (*_NumericNodeIdBuilder)(nil)

func (b *_NumericNodeIdBuilder) WithMandatoryFields(namespaceIndex uint16, identifier uint32) NumericNodeIdBuilder {
	return b.WithNamespaceIndex(namespaceIndex).WithIdentifier(identifier)
}

func (b *_NumericNodeIdBuilder) WithNamespaceIndex(namespaceIndex uint16) NumericNodeIdBuilder {
	b.NamespaceIndex = namespaceIndex
	return b
}

func (b *_NumericNodeIdBuilder) WithIdentifier(identifier uint32) NumericNodeIdBuilder {
	b.Identifier = identifier
	return b
}

func (b *_NumericNodeIdBuilder) Build() (NumericNodeId, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._NumericNodeId.deepCopy(), nil
}

func (b *_NumericNodeIdBuilder) MustBuild() NumericNodeId {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NumericNodeIdBuilder) DeepCopy() any {
	_copy := b.CreateNumericNodeIdBuilder().(*_NumericNodeIdBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateNumericNodeIdBuilder creates a NumericNodeIdBuilder
func (b *_NumericNodeId) CreateNumericNodeIdBuilder() NumericNodeIdBuilder {
	if b == nil {
		return NewNumericNodeIdBuilder()
	}
	return &_NumericNodeIdBuilder{_NumericNodeId: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NumericNodeId) GetNamespaceIndex() uint16 {
	return m.NamespaceIndex
}

func (m *_NumericNodeId) GetIdentifier() uint32 {
	return m.Identifier
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNumericNodeId(structType any) NumericNodeId {
	if casted, ok := structType.(NumericNodeId); ok {
		return casted
	}
	if casted, ok := structType.(*NumericNodeId); ok {
		return *casted
	}
	return nil
}

func (m *_NumericNodeId) GetTypeName() string {
	return "NumericNodeId"
}

func (m *_NumericNodeId) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (namespaceIndex)
	lengthInBits += 16

	// Simple field (identifier)
	lengthInBits += 32

	return lengthInBits
}

func (m *_NumericNodeId) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func NumericNodeIdParse(ctx context.Context, theBytes []byte) (NumericNodeId, error) {
	return NumericNodeIdParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func NumericNodeIdParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (NumericNodeId, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (NumericNodeId, error) {
		return NumericNodeIdParseWithBuffer(ctx, readBuffer)
	}
}

func NumericNodeIdParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (NumericNodeId, error) {
	v, err := (&_NumericNodeId{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_NumericNodeId) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__numericNodeId NumericNodeId, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NumericNodeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NumericNodeId")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	namespaceIndex, err := ReadSimpleField(ctx, "namespaceIndex", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'namespaceIndex' field"))
	}
	m.NamespaceIndex = namespaceIndex

	identifier, err := ReadSimpleField(ctx, "identifier", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'identifier' field"))
	}
	m.Identifier = identifier

	if closeErr := readBuffer.CloseContext("NumericNodeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NumericNodeId")
	}

	return m, nil
}

func (m *_NumericNodeId) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NumericNodeId) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("NumericNodeId"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for NumericNodeId")
	}

	if err := WriteSimpleField[uint16](ctx, "namespaceIndex", m.GetNamespaceIndex(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
		return errors.Wrap(err, "Error serializing 'namespaceIndex' field")
	}

	if err := WriteSimpleField[uint32](ctx, "identifier", m.GetIdentifier(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
		return errors.Wrap(err, "Error serializing 'identifier' field")
	}

	if popErr := writeBuffer.PopContext("NumericNodeId"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for NumericNodeId")
	}
	return nil
}

func (m *_NumericNodeId) IsNumericNodeId() {}

func (m *_NumericNodeId) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NumericNodeId) deepCopy() *_NumericNodeId {
	if m == nil {
		return nil
	}
	_NumericNodeIdCopy := &_NumericNodeId{
		m.NamespaceIndex,
		m.Identifier,
	}
	return _NumericNodeIdCopy
}

func (m *_NumericNodeId) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
