/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetValueSourceAddress extends BACnetValueSource implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetAddressEnclosed address;

  public BACnetValueSourceAddress(BACnetTagHeader peekedTagHeader, BACnetAddressEnclosed address) {
    super(peekedTagHeader);
    this.address = address;
  }

  public BACnetAddressEnclosed getAddress() {
    return address;
  }

  @Override
  protected void serializeBACnetValueSourceChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetValueSourceAddress");

    // Simple Field (address)
    writeSimpleField("address", address, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetValueSourceAddress");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetValueSourceAddress _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (address)
    lengthInBits += address.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetValueSourceBuilder staticParseBACnetValueSourceBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("BACnetValueSourceAddress");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetAddressEnclosed address =
        readSimpleField(
            "address",
            readComplex(
                () -> BACnetAddressEnclosed.staticParse(readBuffer, (short) (2)), readBuffer));

    readBuffer.closeContext("BACnetValueSourceAddress");
    // Create the instance
    return new BACnetValueSourceAddressBuilderImpl(address);
  }

  public static class BACnetValueSourceAddressBuilderImpl
      implements BACnetValueSource.BACnetValueSourceBuilder {
    private final BACnetAddressEnclosed address;

    public BACnetValueSourceAddressBuilderImpl(BACnetAddressEnclosed address) {
      this.address = address;
    }

    public BACnetValueSourceAddress build(BACnetTagHeader peekedTagHeader) {
      BACnetValueSourceAddress bACnetValueSourceAddress =
          new BACnetValueSourceAddress(peekedTagHeader, address);
      return bACnetValueSourceAddress;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetValueSourceAddress)) {
      return false;
    }
    BACnetValueSourceAddress that = (BACnetValueSourceAddress) o;
    return (getAddress() == that.getAddress()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getAddress());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
