/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum LightingCommandTypeContainer {
  LightingCommandOff((short) 0x01, (byte) 1, LightingCommandType.OFF),
  LightingCommandOn((short) 0x79, (byte) 1, LightingCommandType.ON),
  LightingCommandRampToLevel_Instantaneous(
      (short) 0x02, (byte) 1, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_4Second((short) 0x0A, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_8Second((short) 0x12, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_12Second((short) 0x1A, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_20Second((short) 0x22, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_30Second((short) 0x2A, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_40Second((short) 0x32, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_60Second((short) 0x3A, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_90Second((short) 0x42, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_120Second((short) 0x4A, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_180Second((short) 0x52, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_300Second((short) 0x5A, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_420Second((short) 0x62, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_600Second((short) 0x6A, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_900Second((short) 0x72, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandRampToLevel_1020Second((short) 0x7A, (byte) 2, LightingCommandType.RAMP_TO_LEVEL),
  LightingCommandTerminateRamp((short) 0x09, (byte) 1, LightingCommandType.TERMINATE_RAMP),
  LightingCommandLabel_0Bytes((short) 0xA0, (byte) 0, LightingCommandType.LABEL),
  LightingCommandLabel_1Bytes((short) 0xA1, (byte) 1, LightingCommandType.LABEL),
  LightingCommandLabel_2Bytes((short) 0xA2, (byte) 2, LightingCommandType.LABEL),
  LightingCommandLabel_3Bytes((short) 0xA3, (byte) 3, LightingCommandType.LABEL),
  LightingCommandLabel_4Bytes((short) 0xA4, (byte) 4, LightingCommandType.LABEL),
  LightingCommandLabel_5Bytes((short) 0xA5, (byte) 5, LightingCommandType.LABEL),
  LightingCommandLabel_6Bytes((short) 0xA6, (byte) 6, LightingCommandType.LABEL),
  LightingCommandLabel_7Bytes((short) 0xA7, (byte) 7, LightingCommandType.LABEL),
  LightingCommandLabel_8Bytes((short) 0xA8, (byte) 8, LightingCommandType.LABEL),
  LightingCommandLabel_9Bytes((short) 0xA9, (byte) 9, LightingCommandType.LABEL),
  LightingCommandLabel_10Bytes((short) 0xAA, (byte) 10, LightingCommandType.LABEL),
  LightingCommandLabel_11Bytes((short) 0xAB, (byte) 11, LightingCommandType.LABEL),
  LightingCommandLabel_12Bytes((short) 0xAC, (byte) 12, LightingCommandType.LABEL),
  LightingCommandLabel_13Bytes((short) 0xAD, (byte) 13, LightingCommandType.LABEL),
  LightingCommandLabel_14Bytes((short) 0xAE, (byte) 14, LightingCommandType.LABEL),
  LightingCommandLabel_15Bytes((short) 0xAF, (byte) 15, LightingCommandType.LABEL),
  LightingCommandLabel_16Bytes((short) 0xB0, (byte) 16, LightingCommandType.LABEL),
  LightingCommandLabel_17Bytes((short) 0xB1, (byte) 17, LightingCommandType.LABEL),
  LightingCommandLabel_18Bytes((short) 0xB2, (byte) 18, LightingCommandType.LABEL),
  LightingCommandLabel_19Bytes((short) 0xB3, (byte) 19, LightingCommandType.LABEL),
  LightingCommandLabel_20Bytes((short) 0xB4, (byte) 20, LightingCommandType.LABEL),
  LightingCommandLabel_21Bytes((short) 0xB5, (byte) 21, LightingCommandType.LABEL),
  LightingCommandLabel_22Bytes((short) 0xB6, (byte) 22, LightingCommandType.LABEL),
  LightingCommandLabel_23Bytes((short) 0xB7, (byte) 23, LightingCommandType.LABEL),
  LightingCommandLabel_24Bytes((short) 0xB8, (byte) 24, LightingCommandType.LABEL),
  LightingCommandLabel_25Bytes((short) 0xB9, (byte) 25, LightingCommandType.LABEL),
  LightingCommandLabel_26Bytes((short) 0xBA, (byte) 26, LightingCommandType.LABEL),
  LightingCommandLabel_27Bytes((short) 0xBB, (byte) 27, LightingCommandType.LABEL),
  LightingCommandLabel_28Bytes((short) 0xBC, (byte) 28, LightingCommandType.LABEL),
  LightingCommandLabel_29Bytes((short) 0xBD, (byte) 29, LightingCommandType.LABEL),
  LightingCommandLabel_30Bytes((short) 0xBE, (byte) 30, LightingCommandType.LABEL),
  LightingCommandLabel_32Bytes((short) 0xBF, (byte) 31, LightingCommandType.LABEL);
  private static final Map<Short, LightingCommandTypeContainer> map;

  static {
    map = new HashMap<>();
    for (LightingCommandTypeContainer value : LightingCommandTypeContainer.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;
  private final byte numBytes;
  private final LightingCommandType commandType;

  LightingCommandTypeContainer(short value, byte numBytes, LightingCommandType commandType) {
    this.value = value;
    this.numBytes = numBytes;
    this.commandType = commandType;
  }

  public short getValue() {
    return value;
  }

  public byte getNumBytes() {
    return numBytes;
  }

  public static LightingCommandTypeContainer firstEnumForFieldNumBytes(byte fieldValue) {
    for (LightingCommandTypeContainer _val : LightingCommandTypeContainer.values()) {
      if (_val.getNumBytes() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<LightingCommandTypeContainer> enumsForFieldNumBytes(byte fieldValue) {
    List<LightingCommandTypeContainer> _values = new ArrayList<>();
    for (LightingCommandTypeContainer _val : LightingCommandTypeContainer.values()) {
      if (_val.getNumBytes() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public LightingCommandType getCommandType() {
    return commandType;
  }

  public static LightingCommandTypeContainer firstEnumForFieldCommandType(
      LightingCommandType fieldValue) {
    for (LightingCommandTypeContainer _val : LightingCommandTypeContainer.values()) {
      if (_val.getCommandType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<LightingCommandTypeContainer> enumsForFieldCommandType(
      LightingCommandType fieldValue) {
    List<LightingCommandTypeContainer> _values = new ArrayList<>();
    for (LightingCommandTypeContainer _val : LightingCommandTypeContainer.values()) {
      if (_val.getCommandType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static LightingCommandTypeContainer enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
