/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DeleteEventDetails extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 694;
  }

  // Properties.
  protected final NodeId nodeId;
  protected final List<PascalByteString> eventIds;

  public DeleteEventDetails(NodeId nodeId, List<PascalByteString> eventIds) {
    super();
    this.nodeId = nodeId;
    this.eventIds = eventIds;
  }

  public NodeId getNodeId() {
    return nodeId;
  }

  public List<PascalByteString> getEventIds() {
    return eventIds;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DeleteEventDetails");

    // Simple Field (nodeId)
    writeSimpleField("nodeId", nodeId, writeComplex(writeBuffer));

    // Implicit Field (noOfEventIds) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfEventIds = (int) ((((getEventIds()) == (null)) ? -(1) : COUNT(getEventIds())));
    writeImplicitField("noOfEventIds", noOfEventIds, writeSignedInt(writeBuffer, 32));

    // Array Field (eventIds)
    writeComplexTypeArrayField("eventIds", eventIds, writeBuffer);

    writeBuffer.popContext("DeleteEventDetails");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DeleteEventDetails _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (nodeId)
    lengthInBits += nodeId.getLengthInBits();

    // Implicit Field (noOfEventIds)
    lengthInBits += 32;

    // Array field
    if (eventIds != null) {
      int i = 0;
      for (PascalByteString element : eventIds) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= eventIds.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("DeleteEventDetails");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NodeId nodeId =
        readSimpleField("nodeId", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    int noOfEventIds = readImplicitField("noOfEventIds", readSignedInt(readBuffer, 32));

    List<PascalByteString> eventIds =
        readCountArrayField(
            "eventIds",
            readComplex(() -> PascalByteString.staticParse(readBuffer), readBuffer),
            noOfEventIds);

    readBuffer.closeContext("DeleteEventDetails");
    // Create the instance
    return new DeleteEventDetailsBuilderImpl(nodeId, eventIds);
  }

  public static class DeleteEventDetailsBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId nodeId;
    private final List<PascalByteString> eventIds;

    public DeleteEventDetailsBuilderImpl(NodeId nodeId, List<PascalByteString> eventIds) {
      this.nodeId = nodeId;
      this.eventIds = eventIds;
    }

    public DeleteEventDetails build() {
      DeleteEventDetails deleteEventDetails = new DeleteEventDetails(nodeId, eventIds);
      return deleteEventDetails;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DeleteEventDetails)) {
      return false;
    }
    DeleteEventDetails that = (DeleteEventDetails) o;
    return (getNodeId() == that.getNodeId())
        && (getEventIds() == that.getEventIds())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getNodeId(), getEventIds());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
