/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class EndpointDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15559;
  }

  // Properties.
  protected final PascalString name;
  protected final List<KeyValuePair> recordProperties;
  protected final List<PascalString> discoveryUrls;
  protected final PascalString networkName;
  protected final int port;

  public EndpointDataType(
      PascalString name,
      List<KeyValuePair> recordProperties,
      List<PascalString> discoveryUrls,
      PascalString networkName,
      int port) {
    super();
    this.name = name;
    this.recordProperties = recordProperties;
    this.discoveryUrls = discoveryUrls;
    this.networkName = networkName;
    this.port = port;
  }

  public PascalString getName() {
    return name;
  }

  public List<KeyValuePair> getRecordProperties() {
    return recordProperties;
  }

  public List<PascalString> getDiscoveryUrls() {
    return discoveryUrls;
  }

  public PascalString getNetworkName() {
    return networkName;
  }

  public int getPort() {
    return port;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("EndpointDataType");

    // Simple Field (name)
    writeSimpleField("name", name, writeComplex(writeBuffer));

    // Implicit Field (noOfRecordProperties) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfRecordProperties =
        (int) ((((getRecordProperties()) == (null)) ? -(1) : COUNT(getRecordProperties())));
    writeImplicitField(
        "noOfRecordProperties", noOfRecordProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (recordProperties)
    writeComplexTypeArrayField("recordProperties", recordProperties, writeBuffer);

    // Implicit Field (noOfDiscoveryUrls) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDiscoveryUrls =
        (int) ((((getDiscoveryUrls()) == (null)) ? -(1) : COUNT(getDiscoveryUrls())));
    writeImplicitField("noOfDiscoveryUrls", noOfDiscoveryUrls, writeSignedInt(writeBuffer, 32));

    // Array Field (discoveryUrls)
    writeComplexTypeArrayField("discoveryUrls", discoveryUrls, writeBuffer);

    // Simple Field (networkName)
    writeSimpleField("networkName", networkName, writeComplex(writeBuffer));

    // Simple Field (port)
    writeSimpleField("port", port, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("EndpointDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    EndpointDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Implicit Field (noOfRecordProperties)
    lengthInBits += 32;

    // Array field
    if (recordProperties != null) {
      int i = 0;
      for (KeyValuePair element : recordProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= recordProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfDiscoveryUrls)
    lengthInBits += 32;

    // Array field
    if (discoveryUrls != null) {
      int i = 0;
      for (PascalString element : discoveryUrls) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= discoveryUrls.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (networkName)
    lengthInBits += networkName.getLengthInBits();

    // Simple field (port)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("EndpointDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfRecordProperties =
        readImplicitField("noOfRecordProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> recordProperties =
        readCountArrayField(
            "recordProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfRecordProperties);

    int noOfDiscoveryUrls = readImplicitField("noOfDiscoveryUrls", readSignedInt(readBuffer, 32));

    List<PascalString> discoveryUrls =
        readCountArrayField(
            "discoveryUrls",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfDiscoveryUrls);

    PascalString networkName =
        readSimpleField(
            "networkName", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int port = readSimpleField("port", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("EndpointDataType");
    // Create the instance
    return new EndpointDataTypeBuilderImpl(
        name, recordProperties, discoveryUrls, networkName, port);
  }

  public static class EndpointDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final List<KeyValuePair> recordProperties;
    private final List<PascalString> discoveryUrls;
    private final PascalString networkName;
    private final int port;

    public EndpointDataTypeBuilderImpl(
        PascalString name,
        List<KeyValuePair> recordProperties,
        List<PascalString> discoveryUrls,
        PascalString networkName,
        int port) {
      this.name = name;
      this.recordProperties = recordProperties;
      this.discoveryUrls = discoveryUrls;
      this.networkName = networkName;
      this.port = port;
    }

    public EndpointDataType build() {
      EndpointDataType endpointDataType =
          new EndpointDataType(name, recordProperties, discoveryUrls, networkName, port);
      return endpointDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof EndpointDataType)) {
      return false;
    }
    EndpointDataType that = (EndpointDataType) o;
    return (getName() == that.getName())
        && (getRecordProperties() == that.getRecordProperties())
        && (getDiscoveryUrls() == that.getDiscoveryUrls())
        && (getNetworkName() == that.getNetworkName())
        && (getPort() == that.getPort())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getRecordProperties(),
        getDiscoveryUrls(),
        getNetworkName(),
        getPort());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
