/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HistoryModifiedData extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 11219;
  }

  // Properties.
  protected final List<DataValue> dataValues;
  protected final List<ModificationInfo> modificationInfos;

  public HistoryModifiedData(List<DataValue> dataValues, List<ModificationInfo> modificationInfos) {
    super();
    this.dataValues = dataValues;
    this.modificationInfos = modificationInfos;
  }

  public List<DataValue> getDataValues() {
    return dataValues;
  }

  public List<ModificationInfo> getModificationInfos() {
    return modificationInfos;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("HistoryModifiedData");

    // Implicit Field (noOfDataValues) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDataValues = (int) ((((getDataValues()) == (null)) ? -(1) : COUNT(getDataValues())));
    writeImplicitField("noOfDataValues", noOfDataValues, writeSignedInt(writeBuffer, 32));

    // Array Field (dataValues)
    writeComplexTypeArrayField("dataValues", dataValues, writeBuffer);

    // Implicit Field (noOfModificationInfos) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfModificationInfos =
        (int) ((((getModificationInfos()) == (null)) ? -(1) : COUNT(getModificationInfos())));
    writeImplicitField(
        "noOfModificationInfos", noOfModificationInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (modificationInfos)
    writeComplexTypeArrayField("modificationInfos", modificationInfos, writeBuffer);

    writeBuffer.popContext("HistoryModifiedData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    HistoryModifiedData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (noOfDataValues)
    lengthInBits += 32;

    // Array field
    if (dataValues != null) {
      int i = 0;
      for (DataValue element : dataValues) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= dataValues.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfModificationInfos)
    lengthInBits += 32;

    // Array field
    if (modificationInfos != null) {
      int i = 0;
      for (ModificationInfo element : modificationInfos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= modificationInfos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("HistoryModifiedData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int noOfDataValues = readImplicitField("noOfDataValues", readSignedInt(readBuffer, 32));

    List<DataValue> dataValues =
        readCountArrayField(
            "dataValues",
            readComplex(() -> DataValue.staticParse(readBuffer), readBuffer),
            noOfDataValues);

    int noOfModificationInfos =
        readImplicitField("noOfModificationInfos", readSignedInt(readBuffer, 32));

    List<ModificationInfo> modificationInfos =
        readCountArrayField(
            "modificationInfos",
            readComplex(
                () ->
                    (ModificationInfo)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (11218)),
                readBuffer),
            noOfModificationInfos);

    readBuffer.closeContext("HistoryModifiedData");
    // Create the instance
    return new HistoryModifiedDataBuilderImpl(dataValues, modificationInfos);
  }

  public static class HistoryModifiedDataBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final List<DataValue> dataValues;
    private final List<ModificationInfo> modificationInfos;

    public HistoryModifiedDataBuilderImpl(
        List<DataValue> dataValues, List<ModificationInfo> modificationInfos) {
      this.dataValues = dataValues;
      this.modificationInfos = modificationInfos;
    }

    public HistoryModifiedData build() {
      HistoryModifiedData historyModifiedData =
          new HistoryModifiedData(dataValues, modificationInfos);
      return historyModifiedData;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HistoryModifiedData)) {
      return false;
    }
    HistoryModifiedData that = (HistoryModifiedData) o;
    return (getDataValues() == that.getDataValues())
        && (getModificationInfos() == that.getModificationInfos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getDataValues(), getModificationInfos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
