/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ServerEndpointDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15560;
  }

  // Properties.
  protected final PascalString name;
  protected final List<KeyValuePair> recordProperties;
  protected final List<PascalString> discoveryUrls;
  protected final PascalString networkName;
  protected final int port;
  protected final List<PascalString> endpointUrls;
  protected final List<PascalString> securitySettingNames;
  protected final PascalString transportProfileUri;
  protected final List<PascalString> userTokenSettingNames;
  protected final List<PascalString> reverseConnectUrls;

  public ServerEndpointDataType(
      PascalString name,
      List<KeyValuePair> recordProperties,
      List<PascalString> discoveryUrls,
      PascalString networkName,
      int port,
      List<PascalString> endpointUrls,
      List<PascalString> securitySettingNames,
      PascalString transportProfileUri,
      List<PascalString> userTokenSettingNames,
      List<PascalString> reverseConnectUrls) {
    super();
    this.name = name;
    this.recordProperties = recordProperties;
    this.discoveryUrls = discoveryUrls;
    this.networkName = networkName;
    this.port = port;
    this.endpointUrls = endpointUrls;
    this.securitySettingNames = securitySettingNames;
    this.transportProfileUri = transportProfileUri;
    this.userTokenSettingNames = userTokenSettingNames;
    this.reverseConnectUrls = reverseConnectUrls;
  }

  public PascalString getName() {
    return name;
  }

  public List<KeyValuePair> getRecordProperties() {
    return recordProperties;
  }

  public List<PascalString> getDiscoveryUrls() {
    return discoveryUrls;
  }

  public PascalString getNetworkName() {
    return networkName;
  }

  public int getPort() {
    return port;
  }

  public List<PascalString> getEndpointUrls() {
    return endpointUrls;
  }

  public List<PascalString> getSecuritySettingNames() {
    return securitySettingNames;
  }

  public PascalString getTransportProfileUri() {
    return transportProfileUri;
  }

  public List<PascalString> getUserTokenSettingNames() {
    return userTokenSettingNames;
  }

  public List<PascalString> getReverseConnectUrls() {
    return reverseConnectUrls;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ServerEndpointDataType");

    // Simple Field (name)
    writeSimpleField("name", name, writeComplex(writeBuffer));

    // Implicit Field (noOfRecordProperties) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfRecordProperties =
        (int) ((((getRecordProperties()) == (null)) ? -(1) : COUNT(getRecordProperties())));
    writeImplicitField(
        "noOfRecordProperties", noOfRecordProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (recordProperties)
    writeComplexTypeArrayField("recordProperties", recordProperties, writeBuffer);

    // Implicit Field (noOfDiscoveryUrls) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfDiscoveryUrls =
        (int) ((((getDiscoveryUrls()) == (null)) ? -(1) : COUNT(getDiscoveryUrls())));
    writeImplicitField("noOfDiscoveryUrls", noOfDiscoveryUrls, writeSignedInt(writeBuffer, 32));

    // Array Field (discoveryUrls)
    writeComplexTypeArrayField("discoveryUrls", discoveryUrls, writeBuffer);

    // Simple Field (networkName)
    writeSimpleField("networkName", networkName, writeComplex(writeBuffer));

    // Simple Field (port)
    writeSimpleField("port", port, writeUnsignedInt(writeBuffer, 16));

    // Implicit Field (noOfEndpointUrls) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfEndpointUrls =
        (int) ((((getEndpointUrls()) == (null)) ? -(1) : COUNT(getEndpointUrls())));
    writeImplicitField("noOfEndpointUrls", noOfEndpointUrls, writeSignedInt(writeBuffer, 32));

    // Array Field (endpointUrls)
    writeComplexTypeArrayField("endpointUrls", endpointUrls, writeBuffer);

    // Implicit Field (noOfSecuritySettingNames) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfSecuritySettingNames =
        (int) ((((getSecuritySettingNames()) == (null)) ? -(1) : COUNT(getSecuritySettingNames())));
    writeImplicitField(
        "noOfSecuritySettingNames", noOfSecuritySettingNames, writeSignedInt(writeBuffer, 32));

    // Array Field (securitySettingNames)
    writeComplexTypeArrayField("securitySettingNames", securitySettingNames, writeBuffer);

    // Simple Field (transportProfileUri)
    writeSimpleField("transportProfileUri", transportProfileUri, writeComplex(writeBuffer));

    // Implicit Field (noOfUserTokenSettingNames) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfUserTokenSettingNames =
        (int)
            ((((getUserTokenSettingNames()) == (null)) ? -(1) : COUNT(getUserTokenSettingNames())));
    writeImplicitField(
        "noOfUserTokenSettingNames", noOfUserTokenSettingNames, writeSignedInt(writeBuffer, 32));

    // Array Field (userTokenSettingNames)
    writeComplexTypeArrayField("userTokenSettingNames", userTokenSettingNames, writeBuffer);

    // Implicit Field (noOfReverseConnectUrls) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfReverseConnectUrls =
        (int) ((((getReverseConnectUrls()) == (null)) ? -(1) : COUNT(getReverseConnectUrls())));
    writeImplicitField(
        "noOfReverseConnectUrls", noOfReverseConnectUrls, writeSignedInt(writeBuffer, 32));

    // Array Field (reverseConnectUrls)
    writeComplexTypeArrayField("reverseConnectUrls", reverseConnectUrls, writeBuffer);

    writeBuffer.popContext("ServerEndpointDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ServerEndpointDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Implicit Field (noOfRecordProperties)
    lengthInBits += 32;

    // Array field
    if (recordProperties != null) {
      int i = 0;
      for (KeyValuePair element : recordProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= recordProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfDiscoveryUrls)
    lengthInBits += 32;

    // Array field
    if (discoveryUrls != null) {
      int i = 0;
      for (PascalString element : discoveryUrls) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= discoveryUrls.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (networkName)
    lengthInBits += networkName.getLengthInBits();

    // Simple field (port)
    lengthInBits += 16;

    // Implicit Field (noOfEndpointUrls)
    lengthInBits += 32;

    // Array field
    if (endpointUrls != null) {
      int i = 0;
      for (PascalString element : endpointUrls) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= endpointUrls.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfSecuritySettingNames)
    lengthInBits += 32;

    // Array field
    if (securitySettingNames != null) {
      int i = 0;
      for (PascalString element : securitySettingNames) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= securitySettingNames.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (transportProfileUri)
    lengthInBits += transportProfileUri.getLengthInBits();

    // Implicit Field (noOfUserTokenSettingNames)
    lengthInBits += 32;

    // Array field
    if (userTokenSettingNames != null) {
      int i = 0;
      for (PascalString element : userTokenSettingNames) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= userTokenSettingNames.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfReverseConnectUrls)
    lengthInBits += 32;

    // Array field
    if (reverseConnectUrls != null) {
      int i = 0;
      for (PascalString element : reverseConnectUrls) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= reverseConnectUrls.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ServerEndpointDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfRecordProperties =
        readImplicitField("noOfRecordProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> recordProperties =
        readCountArrayField(
            "recordProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfRecordProperties);

    int noOfDiscoveryUrls = readImplicitField("noOfDiscoveryUrls", readSignedInt(readBuffer, 32));

    List<PascalString> discoveryUrls =
        readCountArrayField(
            "discoveryUrls",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfDiscoveryUrls);

    PascalString networkName =
        readSimpleField(
            "networkName", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int port = readSimpleField("port", readUnsignedInt(readBuffer, 16));

    int noOfEndpointUrls = readImplicitField("noOfEndpointUrls", readSignedInt(readBuffer, 32));

    List<PascalString> endpointUrls =
        readCountArrayField(
            "endpointUrls",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfEndpointUrls);

    int noOfSecuritySettingNames =
        readImplicitField("noOfSecuritySettingNames", readSignedInt(readBuffer, 32));

    List<PascalString> securitySettingNames =
        readCountArrayField(
            "securitySettingNames",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfSecuritySettingNames);

    PascalString transportProfileUri =
        readSimpleField(
            "transportProfileUri",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfUserTokenSettingNames =
        readImplicitField("noOfUserTokenSettingNames", readSignedInt(readBuffer, 32));

    List<PascalString> userTokenSettingNames =
        readCountArrayField(
            "userTokenSettingNames",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfUserTokenSettingNames);

    int noOfReverseConnectUrls =
        readImplicitField("noOfReverseConnectUrls", readSignedInt(readBuffer, 32));

    List<PascalString> reverseConnectUrls =
        readCountArrayField(
            "reverseConnectUrls",
            readComplex(() -> PascalString.staticParse(readBuffer), readBuffer),
            noOfReverseConnectUrls);

    readBuffer.closeContext("ServerEndpointDataType");
    // Create the instance
    return new ServerEndpointDataTypeBuilderImpl(
        name,
        recordProperties,
        discoveryUrls,
        networkName,
        port,
        endpointUrls,
        securitySettingNames,
        transportProfileUri,
        userTokenSettingNames,
        reverseConnectUrls);
  }

  public static class ServerEndpointDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final List<KeyValuePair> recordProperties;
    private final List<PascalString> discoveryUrls;
    private final PascalString networkName;
    private final int port;
    private final List<PascalString> endpointUrls;
    private final List<PascalString> securitySettingNames;
    private final PascalString transportProfileUri;
    private final List<PascalString> userTokenSettingNames;
    private final List<PascalString> reverseConnectUrls;

    public ServerEndpointDataTypeBuilderImpl(
        PascalString name,
        List<KeyValuePair> recordProperties,
        List<PascalString> discoveryUrls,
        PascalString networkName,
        int port,
        List<PascalString> endpointUrls,
        List<PascalString> securitySettingNames,
        PascalString transportProfileUri,
        List<PascalString> userTokenSettingNames,
        List<PascalString> reverseConnectUrls) {
      this.name = name;
      this.recordProperties = recordProperties;
      this.discoveryUrls = discoveryUrls;
      this.networkName = networkName;
      this.port = port;
      this.endpointUrls = endpointUrls;
      this.securitySettingNames = securitySettingNames;
      this.transportProfileUri = transportProfileUri;
      this.userTokenSettingNames = userTokenSettingNames;
      this.reverseConnectUrls = reverseConnectUrls;
    }

    public ServerEndpointDataType build() {
      ServerEndpointDataType serverEndpointDataType =
          new ServerEndpointDataType(
              name,
              recordProperties,
              discoveryUrls,
              networkName,
              port,
              endpointUrls,
              securitySettingNames,
              transportProfileUri,
              userTokenSettingNames,
              reverseConnectUrls);
      return serverEndpointDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ServerEndpointDataType)) {
      return false;
    }
    ServerEndpointDataType that = (ServerEndpointDataType) o;
    return (getName() == that.getName())
        && (getRecordProperties() == that.getRecordProperties())
        && (getDiscoveryUrls() == that.getDiscoveryUrls())
        && (getNetworkName() == that.getNetworkName())
        && (getPort() == that.getPort())
        && (getEndpointUrls() == that.getEndpointUrls())
        && (getSecuritySettingNames() == that.getSecuritySettingNames())
        && (getTransportProfileUri() == that.getTransportProfileUri())
        && (getUserTokenSettingNames() == that.getUserTokenSettingNames())
        && (getReverseConnectUrls() == that.getReverseConnectUrls())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getRecordProperties(),
        getDiscoveryUrls(),
        getNetworkName(),
        getPort(),
        getEndpointUrls(),
        getSecuritySettingNames(),
        getTransportProfileUri(),
        getUserTokenSettingNames(),
        getReverseConnectUrls());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
