/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ViewDescription extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 513;
  }

  // Properties.
  protected final NodeId viewId;
  protected final long timestamp;
  protected final long viewVersion;

  public ViewDescription(NodeId viewId, long timestamp, long viewVersion) {
    super();
    this.viewId = viewId;
    this.timestamp = timestamp;
    this.viewVersion = viewVersion;
  }

  public NodeId getViewId() {
    return viewId;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public long getViewVersion() {
    return viewVersion;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ViewDescription");

    // Simple Field (viewId)
    writeSimpleField("viewId", viewId, writeComplex(writeBuffer));

    // Simple Field (timestamp)
    writeSimpleField("timestamp", timestamp, writeSignedLong(writeBuffer, 64));

    // Simple Field (viewVersion)
    writeSimpleField("viewVersion", viewVersion, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("ViewDescription");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ViewDescription _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (viewId)
    lengthInBits += viewId.getLengthInBits();

    // Simple field (timestamp)
    lengthInBits += 64;

    // Simple field (viewVersion)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ViewDescription");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NodeId viewId =
        readSimpleField("viewId", readComplex(() -> NodeId.staticParse(readBuffer), readBuffer));

    long timestamp = readSimpleField("timestamp", readSignedLong(readBuffer, 64));

    long viewVersion = readSimpleField("viewVersion", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("ViewDescription");
    // Create the instance
    return new ViewDescriptionBuilderImpl(viewId, timestamp, viewVersion);
  }

  public static class ViewDescriptionBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId viewId;
    private final long timestamp;
    private final long viewVersion;

    public ViewDescriptionBuilderImpl(NodeId viewId, long timestamp, long viewVersion) {
      this.viewId = viewId;
      this.timestamp = timestamp;
      this.viewVersion = viewVersion;
    }

    public ViewDescription build() {
      ViewDescription viewDescription = new ViewDescription(viewId, timestamp, viewVersion);
      return viewDescription;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ViewDescription)) {
      return false;
    }
    ViewDescription that = (ViewDescription) o;
    return (getViewId() == that.getViewId())
        && (getTimestamp() == that.getTimestamp())
        && (getViewVersion() == that.getViewVersion())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getViewId(), getTimestamp(), getViewVersion());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
